/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.actions;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.actions.SystemBaseCopyAction;
import org.eclipse.rse.ui.dialogs.SystemRenameSingleDialog;
import org.eclipse.rse.ui.dialogs.SystemSimpleContentElement;
import org.eclipse.swt.widgets.Shell;

public class SystemMoveConnectionAction
extends SystemBaseCopyAction {
    private SystemSimpleContentElement initialSelectionElement = null;

    public SystemMoveConnectionAction(Shell parent) {
        super(parent, SystemResources.ACTION_MOVE_CONNECTION_LABEL, 1);
        this.sr = RSECorePlugin.getTheSystemRegistry();
        this.setHelp("org.eclipse.rse.ui.actn0020");
        this.setDialogHelp("org.eclipse.rse.ui.dmcn0000");
    }

    public boolean updateSelection(IStructuredSelection selection) {
        if (this.sr.getActiveSystemProfiles().length <= 1) {
            return false;
        }
        boolean enable = true;
        ISystemProfile prevProfile = null;
        Iterator e = selection.iterator();
        while (enable && e.hasNext()) {
            Object selectedObject = e.next();
            if (selectedObject instanceof IHost) {
                IHost conn = (IHost)selectedObject;
                if (prevProfile == null) {
                    prevProfile = conn.getSystemProfile();
                } else {
                    boolean bl = enable = prevProfile == conn.getSystemProfile();
                }
                if (!enable) continue;
                prevProfile = conn.getSystemProfile();
                continue;
            }
            enable = false;
        }
        return enable;
    }

    protected String checkForCollision(Shell shell, IProgressMonitor monitor, Object targetContainer, Object oldObject, String oldName) {
        ISystemProfile profile = (ISystemProfile)targetContainer;
        String newName = oldName;
        IHost match = this.sr.getHost(profile, oldName);
        if (match != null) {
            SystemRenameSingleDialog dlg = new SystemRenameSingleDialog(shell, true, (Object)match, null);
            dlg.open();
            newName = !dlg.wasCancelled() ? dlg.getNewName() : null;
        }
        return newName;
    }

    protected boolean doCopy(Object targetContainer, Object oldObject, String newName, IProgressMonitor monitor) throws Exception {
        IHost oldConnection = (IHost)oldObject;
        ISystemProfile targetProfile = (ISystemProfile)targetContainer;
        IHost newConn = this.sr.moveHost(oldConnection, targetProfile, newName, monitor);
        return newConn != null;
    }

    protected SystemSimpleContentElement getTreeModel() {
        return this.getProfileTreeModel(this.getFirstSelectedConnection().getSystemProfile());
    }

    protected SystemSimpleContentElement getTreeInitialSelection() {
        return this.initialSelectionElement;
    }

    protected String getPromptString() {
        return SystemResources.RESID_MOVE_TARGET_PROFILE_PROMPT;
    }

    protected SystemMessage getCopyingMessage() {
        return RSEUIPlugin.getPluginMessage("RSEG1085");
    }

    protected SystemMessage getCopyingMessage(String oldName) {
        return RSEUIPlugin.getPluginMessage("RSEG1084").makeSubstitution((Object)oldName);
    }

    protected Object[] getOldObjects() {
        return this.getSelectedConnections();
    }

    protected String[] getOldNames() {
        IHost[] conns = this.getSelectedConnections();
        String[] names = new String[conns.length];
        int idx = 0;
        while (idx < conns.length) {
            names[idx] = conns[idx].getAliasName();
            ++idx;
        }
        return names;
    }

    protected IHost[] getSelectedConnections() {
        IStructuredSelection selection = this.getSelection();
        IHost[] conns = new IHost[selection.size()];
        Iterator i = selection.iterator();
        int idx = 0;
        while (i.hasNext()) {
            conns[idx++] = (IHost)i.next();
        }
        return conns;
    }

    protected IHost getFirstSelectedConnection() {
        return (IHost)this.getFirstSelection();
    }

    protected SystemSimpleContentElement getProfileTreeModel(ISystemProfile profile) {
        SystemSimpleContentElement veryRootElement = new SystemSimpleContentElement("Profiles", (Object)null, null, null);
        veryRootElement.setRenamable(false);
        veryRootElement.setDeletable(false);
        ISystemProfile[] profiles = RSECorePlugin.getTheSystemRegistry().getActiveSystemProfiles();
        ImageDescriptor image = RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemprofileIcon");
        if (profiles == null) {
            return veryRootElement;
        }
        Vector<SystemSimpleContentElement> veryRootChildren = new Vector<SystemSimpleContentElement>();
        int idx = 0;
        while (idx < profiles.length) {
            if (profiles[idx] != profile) {
                SystemSimpleContentElement profileElement = new SystemSimpleContentElement(profiles[idx].getName(), (Object)profiles[idx], veryRootElement, null);
                profileElement.setRenamable(false);
                profileElement.setDeletable(false);
                profileElement.setImageDescriptor(image);
                veryRootChildren.addElement(profileElement);
                if (this.initialSelectionElement == null) {
                    this.initialSelectionElement = profileElement;
                }
            }
            ++idx;
        }
        veryRootElement.setChildren(veryRootChildren);
        return veryRootElement;
    }
}

