/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui;

import java.net.URL;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.ISystemResourceListener;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.SystemResourceManager;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemProfileManager;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.SystemStartHere;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.core.subsystems.ISubSystemConfigurationProxy;
import org.eclipse.rse.internal.core.model.SystemProfileManager;
import org.eclipse.rse.internal.ui.RSESystemTypeAdapterFactory;
import org.eclipse.rse.internal.ui.SystemResourceListener;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.internal.ui.actions.SystemShowPreferencesPageAction;
import org.eclipse.rse.internal.ui.subsystems.SubSystemConfigurationProxyAdapterFactory;
import org.eclipse.rse.internal.ui.view.SubSystemConfigurationAdapterFactory;
import org.eclipse.rse.internal.ui.view.SystemViewAdapterFactory;
import org.eclipse.rse.internal.ui.view.team.SystemTeamViewResourceAdapterFactory;
import org.eclipse.rse.persistence.IRSEPersistenceManager;
import org.eclipse.rse.services.clientserver.messages.ISystemMessageProvider;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageFile;
import org.eclipse.rse.ui.ISystemViewSupplier;
import org.eclipse.rse.ui.RSESystemTypeAdapter;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.SystemPreferencesManager;
import org.eclipse.rse.ui.internal.model.SystemRegistry;
import org.eclipse.rse.ui.internal.model.SystemRegistryUI;
import org.eclipse.rse.ui.model.ISystemRegistryUI;
import org.osgi.framework.BundleContext;

public class RSEUIPlugin
extends SystemBasePlugin
implements ISystemMessageProvider {
    public static final String PLUGIN_ID = "org.eclipse.rse.ui";
    public static final String HELPPREFIX = "org.eclipse.rse.ui.";
    public static final boolean INCLUDE_LOCAL_YES = true;
    public static final boolean INCLUDE_LOCAL_NO = false;
    private static RSEUIPlugin inst = null;
    private static SystemMessageFile messageFile = null;
    private static SystemMessageFile defaultMessageFile = null;
    private SystemRegistryUI _systemRegistryUI = null;
    private SystemRegistry _systemRegistry = null;
    private Vector viewSuppliers = new Vector();
    private SystemViewAdapterFactory svaf;
    private SystemTeamViewResourceAdapterFactory svraf;
    private SystemShowPreferencesPageAction[] showPrefPageActions = null;
    private boolean loggingSystemMessageLine = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public RSEUIPlugin() {
        if (inst == null) {
            inst = this;
        }
    }

    public static RSEUIPlugin getDefault() {
        return inst;
    }

    public void initializeDefaultPreferences() {
        SystemPreferencesManager.initDefaults();
    }

    public void setLoggingSystemMessageLine(boolean flag) {
        this.loggingSystemMessageLine = flag;
    }

    public boolean getLoggingSystemMessageLine() {
        return this.loggingSystemMessageLine;
    }

    protected void initializeImageRegistry() {
        String path = RSEUIPlugin.getIconPath();
        this.putImageInRegistry("org.eclipse.rse.ui.newprofile_wizBannerIcon", String.valueOf(path) + "full/wizban/newprofile_wiz.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.newconnection_wizBannerIcon", String.valueOf(path) + "full/wizban/newconnection_wiz.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.newfilterpool_wizBannerIcon", String.valueOf(path) + "full/wizban/newfilterpool_wiz.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.newfilter_wizBannerIcon", String.valueOf(path) + "full/wizban/newfilter_wiz.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.newfile_wizBannerIcon", String.valueOf(path) + "full/wizban/newfile_wiz.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.newfolder_wizBannerIcon", String.valueOf(path) + "full/wizban/newfolder_wiz.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.systemprofileIcon", String.valueOf(path) + "full/obj16/systemprofile.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.systemprofile_activeIcon", String.valueOf(path) + "full/obj16/systemprofile_active.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.systemconnectionIcon", String.valueOf(path) + "full/obj16/systemconnection.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.systemconnectionliveIcon", String.valueOf(path) + "full/obj16/systemconnectionlive.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.systemfilterpoolIcon", String.valueOf(path) + "full/obj16/systemfilterpool.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.systemfilterIcon", String.valueOf(path) + "full/obj16/systemfilter.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.systemfilterstringIcon", String.valueOf(path) + "full/obj16/systemfilterstring.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.systemfolderIcon", String.valueOf(path) + "full/obj16/systemfolder.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.systemrootdriveIcon", String.valueOf(path) + "full/obj16/systemrootdrive.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.systemrootdriveopenIcon", String.valueOf(path) + "full/obj16/systemrootdriveopen.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.full/obj16/systemprocess.gifIcon", String.valueOf(path) + "full/obj16/systemprocess.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.newIcon", String.valueOf(path) + "full/ctool16/new.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.newprofile_wizIcon", String.valueOf(path) + "full/ctool16/newprofile_wiz.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.newconnection_wizIcon", String.valueOf(path) + "full/ctool16/newconnection_wiz.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.newfilterpool_wizIcon", String.valueOf(path) + "full/ctool16/newfilterpool_wiz.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.newfilterpoolref_wizIcon", String.valueOf(path) + "full/ctool16/newfilterpoolref_wiz.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.newfilter_wizIcon", String.valueOf(path) + "full/ctool16/newfilter_wiz.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.lockIcon", String.valueOf(path) + "full/elcl16/lock.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.upIcon", String.valueOf(path) + "full/elcl16/up.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.downIcon", String.valueOf(path) + "full/elcl16/down.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.moveIcon", String.valueOf(path) + "full/elcl16/move.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.clearIcon", String.valueOf(path) + "full/elcl16/clear.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.clearallIcon", String.valueOf(path) + "full/elcl16/clearall.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.clearselectedIcon", String.valueOf(path) + "full/elcl16/clearselected.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.deletereferenceIcon", String.valueOf(path) + "full/elcl16/deletereference.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.renameIcon", String.valueOf(path) + "full/elcl16/rename.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.runIcon", String.valueOf(path) + "full/elcl16/run.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.stopIcon", String.valueOf(path) + "full/elcl16/stop.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.makeprofileactiveIcon", String.valueOf(path) + "full/elcl16/makeprofileactive.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.makeprofileinactiveIcon", String.valueOf(path) + "full/elcl16/makeprofileinactive.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.editfilterIcon", String.valueOf(path) + "full/elcl16/editfilter.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.selectprofileIcon", String.valueOf(path) + "full/elcl16/selectprofile.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.selectpoolIcon", String.valueOf(path) + "full/elcl16/selectpool.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.workwithfilterpoolsIcon", String.valueOf(path) + "full/elcl16/workwithfilterpools.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.refresh_navIcon", String.valueOf(path) + "full/elcl16/refresh_nav.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.newfile_wizIcon", String.valueOf(path) + "full/ctool16/newfile_wiz.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.newfolder_wizIcon", String.valueOf(path) + "full/ctool16/newfolder_wiz.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.errorIcon", String.valueOf(path) + "full/obj16/error.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.infoIcon", String.valueOf(path) + "full/obj16/info.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.systeminfoIcon", String.valueOf(path) + "full/obj16/systeminfo.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.systemcancelIcon", String.valueOf(path) + "full/obj16/systemcancel.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.systemhelpIcon", String.valueOf(path) + "full/obj16/systemhelp.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.systememptyIcon", String.valueOf(path) + "full/obj16/systemempty.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.systemokIcon", String.valueOf(path) + "full/obj16/systemok.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.warningIcon", String.valueOf(path) + "full/obj16/warning.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.systemblankIcon", String.valueOf(path) + "full/obj16/systemblank.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.system_searchIcon", String.valueOf(path) + "full/obj16/system_search.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.systemsearchresultIcon", String.valueOf(path) + "full/obj16/systemsearchresult.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.systemshowintableIcon", String.valueOf(path) + "full/elcl16/systemshowintable.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.monitor_viewIcon", String.valueOf(path) + "full/elcl16/monitor_view.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.system_perspIcon", String.valueOf(path) + "full/obj16/system_persp.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.searchremoveselectedIcon", String.valueOf(path) + "full/elcl16/searchremoveselected.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.searchremoveallIcon", String.valueOf(path) + "full/elcl16/searchremoveall.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.arrowup_objIcon", String.valueOf(path) + "full/obj16/arrowup_obj.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.arrowdown_objIcon", String.valueOf(path) + "full/obj16/arrowdown_obj.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.connectorservice_objIcon", String.valueOf(path) + "full/obj16/connectorservice_obj.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.service_objIcon", String.valueOf(path) + "full/obj16/service_obj.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.launcher_config_objIcon", String.valueOf(path) + "full/obj16/launcher_config_obj.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.properties_objIcon", String.valueOf(path) + "full/obj16/properties_obj.gif");
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        messageFile = this.getMessageFile("systemmessages.xml");
        defaultMessageFile = this.getDefaultMessageFile("systemmessages.xml");
        SystemRegistry registry = this.getSystemRegistryInternal();
        RSECorePlugin.getDefault().setSystemRegistry((ISystemRegistry)registry);
        IAdapterManager manager = Platform.getAdapterManager();
        SubSystemConfigurationAdapterFactory ssfaf = new SubSystemConfigurationAdapterFactory();
        ssfaf.registerWithManager(manager);
        RSESystemTypeAdapterFactory rseSysTypeFactory = new RSESystemTypeAdapterFactory();
        rseSysTypeFactory.registerWithManager(manager);
        SubSystemConfigurationProxyAdapterFactory subSystemConfigurationProxyAdapterFactory = new SubSystemConfigurationProxyAdapterFactory();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.rse.core.subsystems.ISubSystemConfigurationProxy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)subSystemConfigurationProxyAdapterFactory, (Class)clazz);
        this.svaf = new SystemViewAdapterFactory();
        this.svaf.registerWithManager(manager);
        this.svraf = new SystemTeamViewResourceAdapterFactory();
        this.svraf.registerWithManager(manager);
        InitRSEJob initJob = new InitRSEJob();
        initJob.schedule();
    }

    public SystemViewAdapterFactory getSystemViewAdapterFactory() {
        return this.svaf;
    }

    public void restart() {
        if (this._systemRegistry != null) {
            int idx;
            this.disconnectAll(false);
            this._systemRegistry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)"dummy", 91, null));
            this.closeViews();
            ISubSystemConfigurationProxy[] proxies = this.getSystemRegistryInternal().getSubSystemConfigurationProxies();
            if (proxies != null) {
                idx = 0;
                while (idx < proxies.length) {
                    proxies[idx].reset();
                    ++idx;
                }
            }
            SystemProfileManager.clearDefault();
            SystemStartHere.getSystemProfileManager();
            this._systemRegistry.reset();
            if (proxies != null) {
                idx = 0;
                while (idx < proxies.length) {
                    proxies[idx].restore();
                    ++idx;
                }
            }
            this._systemRegistry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)this._systemRegistry, 82, null));
            this.openViews();
        }
    }

    public void closeViews() {
        int idx = 0;
        while (idx < this.viewSuppliers.size()) {
            try {
                ((ISystemViewSupplier)this.viewSuppliers.elementAt(idx)).closeViews();
            }
            catch (Exception exception) {}
            ++idx;
        }
    }

    public void openViews() {
        int idx = 0;
        while (idx < this.viewSuppliers.size()) {
            try {
                ((ISystemViewSupplier)this.viewSuppliers.elementAt(idx)).openViews();
            }
            catch (Exception exception) {}
            ++idx;
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.disconnectAll(true);
        SystemResourceManager.endResourceEventListening();
        super.stop(context);
    }

    protected void disconnectAll(boolean doSave) {
        ISubSystemConfigurationProxy[] proxies;
        if (this.isSystemRegistryActive() && (proxies = this.getSystemRegistryInternal().getSubSystemConfigurationProxies()) != null) {
            int idx = 0;
            while (idx < proxies.length) {
                if (proxies[idx].isSubSystemConfigurationActive()) {
                    ISubSystemConfiguration ssf = proxies[idx].getSubSystemConfiguration();
                    try {
                        ssf.disconnectAllSubSystems();
                    }
                    catch (Exception exc) {
                        RSEUIPlugin.logError("Error disconnecting for " + ssf.getId(), exc);
                    }
                    if (doSave) {
                        // empty if block
                    }
                }
                ++idx;
            }
        }
    }

    public boolean isSystemRegistryActive() {
        return this._systemRegistry != null;
    }

    public IRSEPersistenceManager getPersistenceManager() {
        return RSECorePlugin.getThePersistenceManager();
    }

    private SystemRegistry getSystemRegistryInternal() {
        if (this._systemRegistry == null) {
            String logfilePath = this.getStateLocation().toOSString();
            this._systemRegistry = SystemRegistry.getInstance(logfilePath);
            ISubSystemConfigurationProxy[] proxies = RSECorePlugin.getDefault().getSubSystemConfigurationProxies();
            if (proxies != null) {
                this._systemRegistry.setSubSystemConfigurationProxies(proxies);
            }
        }
        return this._systemRegistry;
    }

    private SystemRegistryUI getSystemRegistryUIInternal() {
        if (this._systemRegistryUI == null) {
            this._systemRegistryUI = SystemRegistryUI.getInstance();
        }
        return this._systemRegistryUI;
    }

    public static ISystemRegistryUI getTheSystemRegistryUI() {
        return RSEUIPlugin.getDefault().getSystemRegistryUIInternal();
    }

    public static ISystemProfileManager getTheSystemProfileManager() {
        return SystemProfileManager.getDefault();
    }

    public static boolean isTheSystemRegistryActive() {
        if (inst == null) {
            return false;
        }
        return RSEUIPlugin.getDefault().isSystemRegistryActive();
    }

    public SystemShowPreferencesPageAction[] getShowPreferencePageActions() {
        if (this.showPrefPageActions == null) {
            SystemShowPreferencesPageAction action = new SystemShowPreferencesPageAction();
            action.setPreferencePageID("org.eclipse.rse.ui.preferences.RemoteSystemsPreferencePage");
            action.setText(SystemResources.ACTION_SHOW_PREFERENCEPAGE_LABEL);
            action.setToolTipText(SystemResources.ACTION_SHOW_PREFERENCEPAGE_TOOLTIP);
            action.setHelp("org.eclipse.rse.ui.aprefrse");
            this.showPrefPageActions = new SystemShowPreferencesPageAction[1];
            this.showPrefPageActions[0] = action;
        }
        return this.showPrefPageActions;
    }

    public URL getMessageFileDTD() {
        URL result = this.getBundle().getEntry("/messageFile.dtd");
        return result;
    }

    public SystemMessageFile getMessageFile(String messageFileName) {
        return RSEUIPlugin.loadMessageFile(this.getBundle(), messageFileName);
    }

    public SystemMessageFile getDefaultMessageFile(String messageFileName) {
        return RSEUIPlugin.loadDefaultMessageFile(this.getBundle(), messageFileName);
    }

    public static SystemMessageFile getPluginMessageFile() {
        return messageFile;
    }

    public SystemMessage getMessage(String msgId) {
        return RSEUIPlugin.getPluginMessage(msgId);
    }

    public static SystemMessage getPluginMessage(String msgId) {
        SystemMessage msg = RSEUIPlugin.getMessage(messageFile, msgId);
        if (msg == null) {
            msg = RSEUIPlugin.getMessage(defaultMessageFile, msgId);
        }
        return msg;
    }

    public static SystemMessage getPluginMessage(String msgId, Object[] subsVars) {
        SystemMessage msg = RSEUIPlugin.getMessage(messageFile, msgId);
        if (msg == null) {
            msg = RSEUIPlugin.getMessage(defaultMessageFile, msgId);
        }
        if (msg != null && subsVars != null && subsVars.length > 0 && msg.getNumSubstitutionVariables() > 0) {
            msg.makeSubstitution(subsVars);
        }
        return msg;
    }

    public static SystemMessage getPluginMessage(String msgId, Object subsVar) {
        SystemMessage msg = RSEUIPlugin.getMessage(messageFile, msgId);
        if (msg == null) {
            msg = RSEUIPlugin.getMessage(defaultMessageFile, msgId);
        }
        if (msg != null && subsVar != null && msg.getNumSubstitutionVariables() > 0) {
            msg.makeSubstitution(subsVar);
        }
        return msg;
    }

    public void registerViewSupplier(ISystemViewSupplier vs) {
        this.viewSuppliers.add(vs);
    }

    public void unRegisterViewSupplier(ISystemViewSupplier vs) {
        if (this.viewSuppliers.contains(vs)) {
            this.viewSuppliers.remove(vs);
        }
    }

    public class InitRSEJob
    extends Job {
        public InitRSEJob() {
            super("Initialize RSE");
        }

        public IStatus run(IProgressMonitor monitor) {
            IRSESystemType systemType;
            SystemRegistry registry = RSEUIPlugin.this.getSystemRegistryInternal();
            try {
                SystemStartHere.getSystemProfileManager();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            IProject remoteSystemsProject = SystemResourceManager.getRemoteSystemsProject((boolean)false);
            SystemResourceListener listener = SystemResourceListener.getListener(remoteSystemsProject);
            SystemResourceManager.startResourceEventListening((ISystemResourceListener)listener);
            if (SystemPreferencesManager.getShowLocalConnection() && (systemType = RSECorePlugin.getTheCoreRegistry().getSystemTypeById("org.eclipse.rse.systemtype.local")) != null) {
                RSESystemTypeAdapter adapter;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.rse.ui.RSESystemTypeAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((adapter = (RSESystemTypeAdapter)systemType.getAdapter((Class)clazz)) != null && adapter.isEnabled(systemType)) {
                    SystemProfileManager profileManager = SystemProfileManager.getDefault();
                    ISystemProfile profile = profileManager.getDefaultPrivateSystemProfile();
                    String userName = System.getProperty("user.name");
                    registry.createLocalHost(profile, SystemResources.TERM_LOCAL, userName);
                }
            }
            return Status.OK_STATUS;
        }
    }
}

