/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.core.connection;

import java.util.Properties;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.tests.core.RSECoreTestCase;
import org.eclipse.rse.tests.core.connection.IRSEConnectionManager;
import org.eclipse.rse.tests.core.connection.IRSEConnectionProperties;
import org.eclipse.rse.tests.internal.RSEConnectionManager;

public class RSEBaseConnectionTestCase
extends RSECoreTestCase {
    private final IRSEConnectionManager connectionManager = new RSEConnectionManager();
    private final IRSEConnectionProperties localSystemConnectionProperties;

    public RSEBaseConnectionTestCase() {
        this(null);
    }

    public RSEBaseConnectionTestCase(String name) {
        super(name);
        Properties properties = new Properties();
        properties.setProperty("system_type_id", "org.eclipse.rse.systemtype.local");
        properties.setProperty("address", "localhost");
        properties.setProperty("name", "Local");
        this.localSystemConnectionProperties = this.getConnectionManager().loadConnectionProperties(properties, false);
    }

    protected IRSEConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    protected IHost getLocalSystemConnection() {
        RSEBaseConnectionTestCase.assertNotNull((String)"Local system connection properties are not available!", (Object)this.localSystemConnectionProperties);
        Exception exception = null;
        String cause = null;
        IHost connection = null;
        try {
            connection = this.getConnectionManager().findOrCreateConnection(this.localSystemConnectionProperties);
        }
        catch (Exception e) {
            exception = e;
            cause = exception.getLocalizedMessage();
        }
        RSEBaseConnectionTestCase.assertNull((String)("Failed to find and create local system connection! Possible cause: " + cause), (Object)exception);
        RSEBaseConnectionTestCase.assertNotNull((String)"Failed to find and create local system connection! Cause unknown!", (Object)connection);
        return connection;
    }
}

