/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.dstore.universal.miners;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.eclipse.dstore.core.model.ByteStreamHandler;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.rse.services.clientserver.SystemEncodingUtil;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.clientserver.archiveutils.ISystemArchiveHandler;
import org.eclipse.rse.services.clientserver.archiveutils.VirtualChild;

public class UniversalByteStreamHandler
extends ByteStreamHandler {
    public UniversalByteStreamHandler(DataStore dataStore, DataElement log) {
        super(dataStore, log);
    }

    public void receiveBytes(String remotePath, byte[] buffer, int size, boolean binary) {
        boolean isVirtual = ArchiveHandlerManager.isVirtual((String)remotePath);
        if (!isVirtual) {
            super.receiveBytes(remotePath, buffer, size, binary);
            return;
        }
        remotePath = ArchiveHandlerManager.cleanUpVirtualPath((String)remotePath);
        DataElement status = this.findStatusFor(remotePath);
        String fileName = this._dataStore.mapToLocalPath(remotePath);
        if (fileName != null) {
            String virtualFileName = fileName;
            ArchiveHandlerManager mgr = ArchiveHandlerManager.getInstance();
            VirtualChild child = mgr.getVirtualObject(virtualFileName);
            ISystemArchiveHandler handler = child.getHandler();
            try {
                boolean success;
                File file = child.getExtractedFile();
                fileName = file.getAbsolutePath();
                if (!file.exists()) {
                    File parent = new File(file.getParent());
                    parent.mkdirs();
                }
                File newFile = new File(fileName);
                FileOutputStream fileStream = new FileOutputStream(newFile);
                if (binary) {
                    fileStream.write(buffer, 0, size);
                } else {
                    String bufferString = new String(buffer, 0, size, SystemEncodingUtil.ENCODING_UTF_8);
                    String theOS = System.getProperty("os.name");
                    if (theOS.toLowerCase().startsWith("z")) {
                        bufferString = bufferString.replace('\r', ' ');
                    }
                    OutputStreamWriter writer = new OutputStreamWriter(fileStream);
                    writer.write(bufferString, 0, size);
                    writer.flush();
                }
                fileStream.close();
                if (handler == null) {
                    int virtualIndex = virtualFileName.indexOf("#virtual#/");
                    String filePath = virtualFileName.substring(0, virtualIndex);
                    handler = mgr.getRegisteredHandler(new File(filePath));
                }
                boolean bl = success = handler != null && handler.add(newFile, child.path, child.name);
                if (!success) {
                    if (status == null) {
                        return;
                    }
                    status.setAttribute(3, "RSEF5006");
                    status.setAttribute(4, "failed");
                    this._dataStore.refresh(status.getParent());
                } else {
                    if (status == null) {
                        return;
                    }
                    status.setAttribute(4, "success");
                    this._dataStore.refresh(status.getParent());
                }
            }
            catch (IOException e) {
                this._dataStore.trace((Throwable)e);
                if (status == null) {
                    return;
                }
                status.setAttribute(3, "RSEF5006");
                status.setAttribute(4, "failed");
                this._dataStore.refresh(status.getParent());
            }
            catch (Exception e) {
                this._dataStore.trace((Throwable)e);
                if (status == null) {
                    return;
                }
                status.setAttribute(3, "RSEF5006");
                status.setAttribute(4, "failed");
                this._dataStore.refresh(status.getParent());
            }
        }
    }

    public void receiveAppendedBytes(String remotePath, byte[] buffer, int size, boolean binary) {
        boolean isVirtual = ArchiveHandlerManager.isVirtual((String)remotePath);
        if (!isVirtual) {
            super.receiveAppendedBytes(remotePath, buffer, size, binary);
            return;
        }
        remotePath = ArchiveHandlerManager.cleanUpVirtualPath((String)remotePath);
        DataElement status = this.findStatusFor(remotePath);
        String fileName = this._dataStore.mapToLocalPath(remotePath);
        if (fileName != null) {
            String virtualFileName = fileName;
            ArchiveHandlerManager mgr = ArchiveHandlerManager.getInstance();
            VirtualChild child = mgr.getVirtualObject(virtualFileName);
            if (!child.exists()) {
                return;
            }
            ISystemArchiveHandler handler = child.getHandler();
            try {
                boolean success;
                File file = child.getExtractedFile();
                fileName = file.getAbsolutePath();
                if (!file.exists()) {
                    File parent = new File(file.getParent());
                    parent.mkdirs();
                    File newFile = new File(fileName);
                    FileOutputStream fileStream = new FileOutputStream(newFile);
                    if (binary) {
                        fileStream.write(buffer, 0, size);
                    } else {
                        String bufferString = new String(buffer, 0, size, SystemEncodingUtil.ENCODING_UTF_8);
                        String theOS = System.getProperty("os.name");
                        if (theOS.toLowerCase().startsWith("z")) {
                            bufferString = bufferString.replace('\r', ' ');
                        }
                        OutputStreamWriter writer = new OutputStreamWriter(fileStream);
                        writer.write(bufferString, 0, size);
                        writer.flush();
                    }
                    fileStream.close();
                    if (handler == null) {
                        int virtualIndex = virtualFileName.indexOf("#virtual#/");
                        String filePath = virtualFileName.substring(0, virtualIndex);
                        handler = mgr.getRegisteredHandler(new File(filePath));
                    }
                    success = handler != null && handler.add(newFile, child.path, child.name);
                } else {
                    File oldFile = new File(fileName);
                    File newFile = new File(String.valueOf(fileName) + ".new");
                    newFile.createNewFile();
                    FileInputStream oldFileStream = new FileInputStream(oldFile);
                    FileOutputStream newFileStream = new FileOutputStream(newFile);
                    int maxSize = 5000000;
                    int written = 0;
                    int oldSize = (int)oldFile.length();
                    int bufferSize = oldSize > maxSize ? maxSize : oldSize;
                    byte[] subBuffer = new byte[bufferSize];
                    while (written < oldSize) {
                        int subWritten = 0;
                        while (written < oldSize && subWritten < bufferSize) {
                            int available = oldFileStream.available();
                            available = bufferSize > available ? available : bufferSize;
                            int read = oldFileStream.read(subBuffer, subWritten, available);
                            written += (subWritten += read);
                        }
                        newFileStream.write(subBuffer, 0, subWritten);
                    }
                    oldFileStream.close();
                    if (binary) {
                        newFileStream.write(buffer, 0, size);
                    } else {
                        String bufferString = new String(buffer, 0, size, SystemEncodingUtil.ENCODING_UTF_8);
                        String theOS = System.getProperty("os.name");
                        if (theOS.toLowerCase().startsWith("z")) {
                            bufferString = bufferString.replace('\r', ' ');
                        }
                        OutputStreamWriter writer = new OutputStreamWriter(newFileStream);
                        writer.write(bufferString, 0, size);
                        writer.flush();
                    }
                    newFileStream.close();
                    oldFile.delete();
                    newFile.renameTo(oldFile);
                    if (handler == null) {
                        int virtualIndex = virtualFileName.indexOf("#virtual#/");
                        String filePath = virtualFileName.substring(0, virtualIndex);
                        handler = mgr.getRegisteredHandler(new File(filePath));
                    }
                    boolean bl = success = handler != null && handler.add(newFile, child.path, child.name);
                }
                if (!success) {
                    if (status == null) {
                        return;
                    }
                    status.setAttribute(3, "RSEF5006");
                    status.setAttribute(4, "failed");
                    this._dataStore.refresh(status.getParent());
                } else {
                    if (status == null) {
                        return;
                    }
                    status.setAttribute(4, "success");
                    this._dataStore.refresh(status.getParent());
                }
            }
            catch (IOException e) {
                this._dataStore.trace((Throwable)e);
                if (status == null) {
                    return;
                }
                status.setAttribute(3, "RSEF5006");
                status.setAttribute(4, "failed");
                this._dataStore.refresh(status.getParent());
            }
        }
    }
}

