/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.actions;

import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.internal.ui.actions.SystemSubMenuManager;
import org.eclipse.rse.internal.ui.actions.SystemSubMenuManagerForTesting;
import org.eclipse.rse.internal.ui.view.SystemViewMenuListener;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.swt.widgets.Shell;

public abstract class SystemBaseSubMenuAction
extends SystemBaseAction {
    protected SystemSubMenuManager subMenu = null;
    protected String actionLabel;
    protected String menuID;
    protected boolean createMenuEachTime = true;
    protected boolean populateMenuEachTime = true;
    private boolean dontCascade = false;
    private boolean test;
    private static final IAction[] EMPTY_ACTION_ARRAY = new IAction[0];

    protected SystemBaseSubMenuAction(ResourceBundle rb, String label, String tooltip, ImageDescriptor image, Shell shell) {
        super(label, tooltip, image, shell);
        this.actionLabel = label;
    }

    protected SystemBaseSubMenuAction(String label, Shell shell) {
        super(label, shell);
        this.actionLabel = label;
    }

    protected SystemBaseSubMenuAction(String label, String tooltip, Shell shell) {
        super(label, tooltip, shell);
        this.actionLabel = label;
    }

    protected SystemBaseSubMenuAction(String label, ImageDescriptor image, Shell shell) {
        super(label, image, shell);
        this.actionLabel = label;
    }

    protected SystemBaseSubMenuAction(String label, String tooltip, ImageDescriptor image, Shell shell) {
        super(label, tooltip, image, shell);
        this.actionLabel = label;
    }

    public void setMenuID(String Id) {
        this.menuID = Id;
    }

    public void setCreateMenuEachTime(boolean eachTime) {
        this.createMenuEachTime = eachTime;
    }

    public void setPopulateMenuEachTime(boolean eachTime) {
        this.populateMenuEachTime = eachTime;
    }

    public void setTest(boolean testMode) {
        this.test = testMode;
    }

    public abstract IMenuManager populateSubMenu(IMenuManager var1);

    public IMenuManager getSubMenu() {
        if (this.subMenu == null || this.createMenuEachTime) {
            this.subMenu = this.menuID == null ? (this.test ? new SystemSubMenuManagerForTesting(this, this.actionLabel) : new SystemSubMenuManager(this, this.actionLabel)) : (this.test ? new SystemSubMenuManagerForTesting(this, this.actionLabel, this.menuID) : new SystemSubMenuManager(this, this.actionLabel, this.menuID));
            this.createStandardGroups((IMenuManager)this.subMenu);
            this.subMenu.setTracing(this.traceSelections, this.traceTarget);
            this.populateSubMenu((IMenuManager)this.subMenu);
            if (this.traceSelections) {
                this.issueTraceMessage("*** INSIDE GETSUBMENU for " + this.actionLabel + ". createMenuEachTime = " + this.createMenuEachTime);
            }
            this.subMenu.setToolTipText(this.getToolTipText());
            this.subMenu.addMenuListener(this.createMnemonicsListener(!this.populateMenuEachTime));
        } else if (this.populateMenuEachTime) {
            this.subMenu.removeAll();
            this.createStandardGroups((IMenuManager)this.subMenu);
            this.populateSubMenu((IMenuManager)this.subMenu);
            if (this.traceSelections) {
                this.issueTraceMessage("*** INSIDE GETSUBMENU for " + this.actionLabel + ". populateMenuEachTime = " + this.populateMenuEachTime);
            }
        } else if (this.traceSelections) {
            this.issueTraceMessage("*** INSIDE GETSUBMENU for " + this.actionLabel + ". SUBMENU ALREADY CREATED. ");
        }
        return this.subMenu;
    }

    protected void createStandardGroups(IMenuManager menu) {
        if (!menu.isEmpty()) {
            return;
        }
    }

    public IAction[] getActions() {
        if (this.subMenu == null) {
            return EMPTY_ACTION_ARRAY;
        }
        IContributionItem[] items = this.subMenu.getItems();
        Vector<IAction> v = new Vector<IAction>();
        int idx = 0;
        while (idx < items.length) {
            if (items[idx] instanceof ActionContributionItem) {
                v.add(((ActionContributionItem)items[idx]).getAction());
            } else if (items[idx] instanceof SystemSubMenuManager) {
                SystemSubMenuManager menu = (SystemSubMenuManager)items[idx];
                v.add(menu.getParentCascadingAction());
            }
            ++idx;
        }
        IAction[] actions = new IAction[v.size()];
        int idx2 = 0;
        while (idx2 < v.size()) {
            actions[idx2] = (IAction)v.elementAt(idx2);
            ++idx2;
        }
        return actions;
    }

    protected SystemViewMenuListener createMnemonicsListener(boolean setMnemonicsOnlyOnce) {
        return new SystemViewMenuListener(setMnemonicsOnlyOnce);
    }

    public void setShell(Shell shell) {
        super.setShell(shell);
        if (!this.dontCascade) {
            this.cascadeShell();
        }
    }

    public void setSelection(ISelection selection) {
        super.setSelection(selection);
        if (!this.dontCascade) {
            this.cascadeSelection(selection);
        }
    }

    public void setViewer(Viewer v) {
        super.setViewer(v);
        if (!this.dontCascade) {
            this.cascadeViewer();
        }
    }

    public Shell getShell() {
        if (super.getShell(false) != null) {
            return super.getShell(false);
        }
        if (this.subMenu != null) {
            return this.subMenu.getShell();
        }
        return null;
    }

    public IStructuredSelection getSelection() {
        if (super.getSelection() != null) {
            return super.getSelection();
        }
        if (this.subMenu != null) {
            return this.subMenu.getSelection();
        }
        return null;
    }

    public Viewer getViewer() {
        if (super.getViewer() != null) {
            return super.getViewer();
        }
        if (this.subMenu != null) {
            return this.subMenu.getViewer();
        }
        return null;
    }

    public void setInputsFromSubMenuManager(Shell shell, Viewer v, ISelection selection) {
        this.dontCascade = true;
        super.setInputs(shell, v, selection);
        this.dontCascade = false;
    }

    public void setInputs(Shell shell, Viewer v, ISelection selection) {
        this.dontCascade = true;
        super.setInputs(shell, v, selection);
        this.dontCascade = false;
        if (this.traceSelections) {
            this.issueTraceMessage(" INSIDE SETINPUTS IN BASE ACTION CLASS");
        }
        this.cascadeAllInputs();
    }

    private void cascadeSelection(ISelection selection) {
        if (this.traceSelections) {
            this.issueTraceMessage("*** INSIDE CASCADESELECTION ***");
            this.issueTraceMessage("  subMenu = " + (Object)((Object)this.subMenu));
            this.issueTraceMessage("  selection = " + selection);
        }
        if (this.subMenu == null) {
            return;
        }
        this.subMenu.setSelection(selection);
    }

    private void cascadeShell() {
        if (this.subMenu == null) {
            return;
        }
        Shell shell = super.getShell(false);
        if (shell != null) {
            this.subMenu.setShell(shell);
        }
    }

    private void cascadeViewer() {
        if (this.subMenu == null) {
            return;
        }
        if (this.viewer != null) {
            this.subMenu.setViewer(this.viewer);
        }
    }

    protected void cascadeAllInputs() {
        if (this.subMenu == null) {
            return;
        }
        Shell shell = super.getShell(false);
        Viewer viewer = super.getViewer();
        IStructuredSelection selection = super.getSelection();
        this.subMenu.setInputs(shell, viewer, (ISelection)selection);
    }

    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
    }
}

