/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.ssh.shell;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.internal.services.ssh.ISshService;
import org.eclipse.rse.internal.services.ssh.ISshSessionProvider;
import org.eclipse.rse.internal.services.ssh.SshServiceResources;
import org.eclipse.rse.internal.services.ssh.shell.SshHostShell;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IShellService;

public class SshShellService
implements ISshService,
IShellService {
    private ISshSessionProvider fSessionProvider;

    public SshShellService(ISshSessionProvider sessionProvider) {
        this.fSessionProvider = sessionProvider;
    }

    public IHostShell launchShell(String initialWorkingDirectory, String[] environment, IProgressMonitor monitor) {
        String defaultEncoding = System.getProperty("file.encoding");
        return this.launchShell(initialWorkingDirectory, defaultEncoding, environment, monitor);
    }

    public IHostShell launchShell(String initialWorkingDirectory, String encoding, String[] environment, IProgressMonitor monitor) {
        SshHostShell hostShell = new SshHostShell(this.fSessionProvider, initialWorkingDirectory, ">", encoding, environment);
        return hostShell;
    }

    public IHostShell runCommand(String initialWorkingDirectory, String command, String[] environment, IProgressMonitor monitor) {
        String defaultEncoding = System.getProperty("file.encoding");
        return this.runCommand(initialWorkingDirectory, command, defaultEncoding, environment, monitor);
    }

    public IHostShell runCommand(String initialWorkingDirectory, String command, String encoding, String[] environment, IProgressMonitor monitor) {
        SshHostShell hostShell = new SshHostShell(this.fSessionProvider, initialWorkingDirectory, command, encoding, environment);
        return hostShell;
    }

    public String[] getHostEnvironment() {
        return new String[0];
    }

    public String getName() {
        return SshServiceResources.SshShellService_Name;
    }

    public String getDescription() {
        return SshServiceResources.SshShellService_Description;
    }

    public void initService(IProgressMonitor monitor) {
    }

    public void uninitService(IProgressMonitor monitor) {
    }

    public SystemMessage getMessage(String messageID) {
        return null;
    }
}

