/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.core.IRSECoreRegistry;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.IRSESystemTypeProvider;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.internal.core.RSESystemType;

public class RSECoreRegistry
implements IRSECoreRegistry {
    private static RSECoreRegistry instance = null;
    private boolean hasReadSystemTypes;
    private IRSESystemType[] systemTypes;
    private final Map accessedSystemTypeCache = new HashMap();
    private static final String ELEMENT_SYTEM_TYPE = "systemType";

    private RSECoreRegistry() {
    }

    public static final RSECoreRegistry getInstance() {
        if (instance == null) {
            instance = new RSECoreRegistry();
        }
        return instance;
    }

    public IRSESystemType[] getSystemTypes() {
        if (!this.hasReadSystemTypes) {
            this.systemTypes = this.readSystemTypes();
            this.hasReadSystemTypes = true;
        }
        return this.systemTypes;
    }

    public IRSESystemType getSystemTypeById(String systemTypeId) {
        if (systemTypeId != null) {
            IRSESystemType systemType = (IRSESystemType)this.accessedSystemTypeCache.get(systemTypeId);
            if (systemType == null) {
                IRSESystemType[] types = this.getSystemTypes();
                int i = 0;
                while (i < types.length && systemType == null) {
                    if (types[i].getId().equals(systemTypeId)) {
                        systemType = types[i];
                    }
                    ++i;
                }
                if (systemType != null) {
                    this.accessedSystemTypeCache.put(systemTypeId, systemType);
                }
            }
            return systemType;
        }
        return null;
    }

    public IRSESystemType getSystemType(String name) {
        if (name != null) {
            IRSESystemType systemType = (IRSESystemType)this.accessedSystemTypeCache.get(name);
            if (systemType == null) {
                IRSESystemType[] types = this.getSystemTypes();
                int i = 0;
                while (i < types.length && systemType == null) {
                    if (types[i].getName().equals(name)) {
                        systemType = types[i];
                    }
                    ++i;
                }
                if (systemType != null) {
                    this.accessedSystemTypeCache.put(name, systemType);
                }
            }
            return systemType;
        }
        return null;
    }

    private IRSESystemType[] readSystemTypes() {
        String message;
        IConfigurationElement element;
        LinkedList<IRSESystemType> types = new LinkedList<IRSESystemType>();
        ArrayList<String> typeIds = new ArrayList<String>();
        this.accessedSystemTypeCache.clear();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor("org.eclipse.rse.core", "systemTypes");
        int i = 0;
        while (i < elements.length) {
            element = elements[i];
            if (element.getName().equals(ELEMENT_SYTEM_TYPE)) {
                RSESystemType type = new RSESystemType(element);
                if (!typeIds.contains(type.getId())) {
                    types.add(type);
                    typeIds.add(type.getId());
                    this.accessedSystemTypeCache.put(type.getId(), type);
                    this.accessedSystemTypeCache.put(type.getName(), type);
                    message = "Successfully registered RSE system type ''{0}'' (id = ''{1}'').";
                    message = MessageFormat.format(message, type.getLabel(), type.getId());
                    RSECorePlugin.getDefault().getLogger().logInfo(message);
                } else {
                    message = "RSE system type contribution skipped. Non-unique system type id (plugin: {0}, id: {1}).";
                    message = MessageFormat.format(message, element.getContributor().getName(), type.getId());
                    RSECorePlugin.getDefault().getLogger().logWarning(message);
                }
            }
            ++i;
        }
        elements = registry.getConfigurationElementsFor("org.eclipse.rse.core", "systemTypeProviders");
        i = 0;
        while (i < elements.length) {
            element = elements[i];
            try {
                IRSESystemType[] typesForRegistration;
                Object provider = element.createExecutableExtension("class");
                if (provider instanceof IRSESystemTypeProvider && (typesForRegistration = ((IRSESystemTypeProvider)provider).getSystemTypesForRegistration()) != null) {
                    int j = 0;
                    while (j < typesForRegistration.length) {
                        String message2;
                        IRSESystemType type = typesForRegistration[j];
                        if (!typeIds.contains(type.getId())) {
                            types.add(type);
                            typeIds.add(type.getId());
                            this.accessedSystemTypeCache.put(type.getId(), type);
                            this.accessedSystemTypeCache.put(type.getName(), type);
                            message2 = "Successfully registered RSE system type ''{0}'' (id = ''{1}'').";
                            message2 = MessageFormat.format(message2, type.getLabel(), type.getId());
                            RSECorePlugin.getDefault().getLogger().logInfo(message2);
                        } else {
                            message2 = "RSE system type contribution skipped. Non-unique system type id (plugin: {0}, id: {1}).";
                            message2 = MessageFormat.format(message2, element.getContributor().getName(), type.getId());
                            RSECorePlugin.getDefault().getLogger().logWarning(message2);
                        }
                        ++j;
                    }
                }
            }
            catch (CoreException e) {
                message = "RSE system types provider failed creation (plugin: {0}, id: {1}).";
                message = MessageFormat.format(message, element.getContributor().getName(), element.getDeclaringExtension().getSimpleIdentifier());
                RSECorePlugin.getDefault().getLogger().logError(message, e);
            }
            ++i;
        }
        return types.toArray(new IRSESystemType[types.size()]);
    }
}

