/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.core.model.ISystemViewInputProvider;
import org.eclipse.rse.core.model.SystemMessageObject;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.ui.view.SystemView;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.model.ISystemShellProvider;
import org.eclipse.rse.ui.operations.SystemDeferredTreeContentManager;
import org.eclipse.rse.ui.view.IContextObject;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.PendingUpdateAdapter;

public class SystemViewLabelAndContentProvider
extends LabelProvider
implements ITreeContentProvider,
ILabelProvider,
ITableLabelProvider {
    private static final Object[] NO_OBJECTS = new Object[0];
    protected Viewer viewer;
    private boolean filesOnly;
    private boolean foldersOnly;
    private String filterString = null;
    private Hashtable resolvedChildrenPerFolder = null;
    private boolean _enableDeferredQueries = true;
    private SystemDeferredTreeContentManager manager;
    private Map imageTable = new Hashtable(40);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public SystemViewLabelAndContentProvider() {
    }

    public SystemViewLabelAndContentProvider(boolean foldersOnly, boolean filesOnly) {
        this();
        this.foldersOnly = foldersOnly;
        this.filesOnly = filesOnly;
    }

    public void setFilterString(String filterString) {
        this.filterString = filterString;
        this.flushCache();
    }

    public String getFilterString() {
        return this.filterString;
    }

    public void flushCache() {
        this.resolvedChildrenPerFolder = null;
    }

    public Viewer getViewer() {
        return this.viewer;
    }

    public void dispose() {
        Collection imageValues;
        Object obj;
        if (this.viewer != null && (obj = this.viewer.getInput()) != null && !(obj instanceof IWorkspace)) {
            boolean cfr_ignored_0 = obj instanceof IContainer;
        }
        if (this.imageTable != null && (imageValues = this.imageTable.values()) != null) {
            Iterator images = imageValues.iterator();
            if (images != null) {
                while (images.hasNext()) {
                    ((Image)images.next()).dispose();
                }
            }
            this.imageTable = null;
        }
    }

    protected ISystemViewElementAdapter getViewAdapter(Object o) {
        if (o instanceof IContextObject) {
            o = ((IContextObject)o).getModelObject();
        }
        ISystemViewElementAdapter adapter = null;
        if (o == null) {
            SystemBasePlugin.logWarning("ERROR: null passed to getAdapter in SystemViewLabelAndContentProvider");
        } else {
            if (o instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)o;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                adapter = (ISystemViewElementAdapter)iAdaptable.getAdapter((Class)clazz);
            } else {
                IAdapterManager iAdapterManager = Platform.getAdapterManager();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                adapter = (ISystemViewElementAdapter)iAdapterManager.getAdapter(o, (Class)clazz);
            }
            if (adapter == null && !(o instanceof PendingUpdateAdapter)) {
                SystemBasePlugin.logWarning("ADAPTER IS NULL FOR ELEMENT OF TYPE: " + o.getClass().getName());
            }
        }
        if (adapter != null && this.viewer != null) {
            Shell shell = null;
            shell = this.viewer instanceof ISystemShellProvider ? ((ISystemShellProvider)this.viewer).getShell() : this.viewer.getControl().getShell();
            adapter.setShell(shell);
            adapter.setViewer(this.viewer);
            if (this.viewer.getInput() instanceof ISystemViewInputProvider) {
                ISystemViewInputProvider inputProvider = (ISystemViewInputProvider)this.viewer.getInput();
                adapter.setInput(inputProvider);
            }
        } else if (this.viewer == null) {
            SystemBasePlugin.logWarning("VIEWER IS NULL FOR SYSTEMVIEWLABELANDCONTENTPROVIDER");
        }
        return adapter;
    }

    public void cancelJobs(Object location) {
        if (this.manager != null) {
            this.manager.cancel(location);
        }
    }

    protected boolean supportsDeferredQueries() {
        return this._enableDeferredQueries;
    }

    public void setEnableDeferredQueries(boolean enable) {
        this._enableDeferredQueries = enable;
    }

    public Object[] getChildren(Object object) {
        ISystemViewElementAdapter adapter = this.getViewAdapter(object);
        Object element = object;
        if (object instanceof IContextObject) {
            element = ((IContextObject)object).getModelObject();
        }
        if (this.supportsDeferredQueries() && this.manager != null && adapter != null) {
            Object[] children;
            ISubSystem ss = null;
            ss = object instanceof IContextObject ? ((IContextObject)object).getSubSystem() : adapter.getSubSystem(object);
            if (ss != null && adapter.supportsDeferredQueries(ss) && (children = this.manager.getChildren(object, this.getViewer())) != null) {
                return children;
            }
        }
        if (adapter != null) {
            String expandToFilter;
            if (this.viewer instanceof SystemView && ((SystemView)this.viewer).getSystemViewPart() != null && adapter instanceof ISystemRemoteElementAdapter && (expandToFilter = ((SystemView)this.viewer).getExpandToFilter(element)) != null) {
                return adapter.getChildrenUsingExpandToFilter(element, expandToFilter);
            }
            Object[] children = null;
            if ((this.filesOnly || this.foldersOnly) && this.resolvedChildrenPerFolder != null && (children = (Object[])this.resolvedChildrenPerFolder.get(element)) != null) {
                return children;
            }
            children = object instanceof IContextObject ? adapter.getChildren((IContextObject)object, (IProgressMonitor)new NullProgressMonitor()) : adapter.getChildren((IAdaptable)object, (IProgressMonitor)new NullProgressMonitor());
            if (!(!this.filesOnly && !this.foldersOnly || children.length == 1 && children[0] instanceof SystemMessageObject)) {
                if (this.resolvedChildrenPerFolder == null) {
                    this.resolvedChildrenPerFolder = new Hashtable();
                }
                this.resolvedChildrenPerFolder.put(element, children);
            }
            return children;
        }
        return NO_OBJECTS;
    }

    public Object[] getElements(Object element) {
        return this.getChildren(element);
    }

    public Object getParent(Object element) {
        ISystemViewElementAdapter adapter = this.getViewAdapter(element);
        if (adapter != null) {
            return adapter.getParent(element);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        ISystemViewElementAdapter adapter = this.getViewAdapter(element);
        if (element instanceof IContextObject) {
            return adapter.hasChildren((IContextObject)element);
        }
        if (adapter != null) {
            return adapter.hasChildren((IAdaptable)element);
        }
        if (this.manager != null && this.manager.isDeferredAdapter(element)) {
            return this.manager.mayHaveChildren(element);
        }
        return false;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        if (!(newInput instanceof IWorkspace)) {
            boolean cfr_ignored_0 = newInput instanceof IContainer;
        }
        if (viewer instanceof AbstractTreeViewer) {
            this.manager = new SystemDeferredTreeContentManager(this, (AbstractTreeViewer)viewer);
        }
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return this.getImage(element);
    }

    public String getColumnText(Object element, int columnIndex) {
        return this.getText(element);
    }

    public Image getImage(Object element) {
        ISystemViewElementAdapter adapter = this.getViewAdapter(element);
        if (adapter == null) {
            return null;
        }
        ImageDescriptor descriptor = adapter.getImageDescriptor(element);
        if (descriptor == null) {
            return null;
        }
        Image image = (Image)this.imageTable.get(descriptor = this.decorateImage(descriptor, element));
        if (image == null) {
            image = descriptor.createImage();
            this.imageTable.put(descriptor, image);
        }
        return image;
    }

    public String getText(Object element) {
        ISystemViewElementAdapter adapter = this.getViewAdapter(element);
        if (adapter == null) {
            IWorkbenchAdapter wadapter;
            IAdaptable iAdaptable = (IAdaptable)element;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((wadapter = (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz)) == null) {
                return super.getText(element);
            }
            return wadapter.getLabel(element);
        }
        return this.decorateText(adapter.getText(element), element);
    }

    protected ImageDescriptor decorateImage(ImageDescriptor input, Object element) {
        return input;
    }

    protected String decorateText(String input, Object element) {
        return input;
    }
}

