/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.clientserver.archiveutils;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.rse.internal.services.clientserver.archiveutils.SystemArchiveUtil;
import org.eclipse.rse.internal.services.clientserver.archiveutils.TarEntry;
import org.eclipse.rse.internal.services.clientserver.archiveutils.TarFile;
import org.eclipse.rse.internal.services.clientserver.archiveutils.TarOutputStream;
import org.eclipse.rse.services.clientserver.ISystemFileTypes;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.clientserver.archiveutils.ISystemArchiveHandler;
import org.eclipse.rse.services.clientserver.archiveutils.VirtualChild;
import org.eclipse.rse.services.clientserver.java.BasicClassFileParser;
import org.eclipse.rse.services.clientserver.search.SystemSearchLineMatch;
import org.eclipse.rse.services.clientserver.search.SystemSearchStringMatchLocator;
import org.eclipse.rse.services.clientserver.search.SystemSearchStringMatcher;

public class SystemTarHandler
implements ISystemArchiveHandler {
    protected File file;
    protected long modTimeDuringCache;
    protected VirtualFileSystem vfs;

    public SystemTarHandler(File file) throws IOException {
        this.init(file);
        this.createCache();
        this.modTimeDuringCache = file.lastModified();
    }

    protected void init(File file) throws IOException {
        this.file = file;
    }

    protected void createCache() {
        TarFile tarFile = this.getTarFile();
        Enumeration entries = tarFile.entries();
        VirtualChild root = new VirtualChild(this);
        root.isDirectory = true;
        this.vfs = new VirtualFileSystem(root);
        while (entries.hasMoreElements()) {
            TarEntry entry = (TarEntry)entries.nextElement();
            VirtualChild child = this.getVirtualChild(entry);
            this.vfs.addEntry(child);
        }
    }

    protected TarFile getTarFile() {
        TarFile tarFile = null;
        try {
            tarFile = new TarFile(this.file);
        }
        catch (IOException iOException) {}
        return tarFile;
    }

    protected void updateCache() throws IOException {
        File newFile = new File(this.file.getAbsolutePath());
        long modTime = newFile.lastModified();
        if (modTime != this.modTimeDuringCache) {
            this.init(newFile);
            this.createCache();
            this.modTimeDuringCache = newFile.lastModified();
        }
    }

    public VirtualChild[] getVirtualChildrenList() {
        Vector<VirtualChild> v = new Vector<VirtualChild>();
        TarFile tarFile = this.getTarFile();
        Enumeration entries = tarFile.entries();
        while (entries.hasMoreElements()) {
            TarEntry entry = (TarEntry)entries.nextElement();
            VirtualChild child = new VirtualChild(this, entry.getName());
            child.isDirectory = entry.isDirectory();
            v.add(child);
        }
        int numOfChildren = v.size();
        VirtualChild[] children = new VirtualChild[numOfChildren];
        int i = 0;
        while (i < numOfChildren) {
            children[i] = (VirtualChild)v.get(i);
            ++i;
        }
        return children;
    }

    public VirtualChild[] getVirtualChildrenList(String parent) {
        parent = ArchiveHandlerManager.cleanUpVirtualPath(parent);
        Vector<VirtualChild> v = new Vector<VirtualChild>();
        TarFile tarFile = this.getTarFile();
        Enumeration entries = tarFile.entries();
        while (entries.hasMoreElements()) {
            TarEntry entry = (TarEntry)entries.nextElement();
            if (!entry.getName().startsWith(parent) || entry.getName().equals(String.valueOf(parent) + "/")) continue;
            VirtualChild child = new VirtualChild(this, entry.getName());
            child.isDirectory = entry.isDirectory();
            v.add(child);
        }
        int numOfChildren = v.size();
        VirtualChild[] children = new VirtualChild[numOfChildren];
        int i = 0;
        while (i < numOfChildren) {
            children[i] = (VirtualChild)v.get(i);
            ++i;
        }
        return children;
    }

    public VirtualChild[] getVirtualChildren(String fullVirtualName) {
        try {
            this.updateCache();
        }
        catch (IOException iOException) {
            return new VirtualChild[0];
        }
        fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
        return this.vfs.getChildren(fullVirtualName);
    }

    public VirtualChild[] getVirtualChildFolders(String fullVirtualName) {
        try {
            this.updateCache();
        }
        catch (IOException iOException) {
            return new VirtualChild[0];
        }
        fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
        return this.vfs.getChildrenFolders(fullVirtualName);
    }

    public VirtualChild getVirtualFile(String fullVirtualName) {
        if ((fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName)) == null || fullVirtualName.equals("")) {
            return new VirtualChild(this);
        }
        try {
            this.updateCache();
        }
        catch (IOException iOException) {
            return new VirtualChild(this, fullVirtualName);
        }
        VirtualChild entry = this.vfs.getEntry(fullVirtualName);
        if (entry == null) {
            entry = new VirtualChild(this, fullVirtualName);
        }
        return entry;
    }

    public boolean exists(String fullVirtualName) {
        if ((fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName)) == null || fullVirtualName.equals("")) {
            return false;
        }
        try {
            this.updateCache();
        }
        catch (IOException iOException) {
            return false;
        }
        VirtualChild child = this.vfs.getEntry(fullVirtualName);
        return child != null;
    }

    public File getArchive() {
        return this.file;
    }

    public long getTimeStampFor(String fullVirtualName) {
        fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
        TarEntry entry = this.getTarFile().getEntry(fullVirtualName);
        if (entry != null) {
            return entry.getModificationTime();
        }
        return this.file.lastModified();
    }

    public long getSizeFor(String fullVirtualName) {
        fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
        TarEntry entry = this.getTarFile().getEntry(fullVirtualName);
        if (entry != null) {
            return entry.getSize();
        }
        return 0L;
    }

    public boolean extractVirtualFile(String fullVirtualName, File destination) {
        OutputStream outStream;
        InputStream inStream;
        TarEntry entry;
        block26: {
            fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
            entry = this.getTarFile().getEntry(fullVirtualName);
            try {
                this.updateCache();
            }
            catch (IOException iOException) {
                return false;
            }
            if (entry.isDirectory()) {
                if (destination.exists()) {
                    destination.delete();
                }
                destination.mkdirs();
                destination.setLastModified(entry.getModificationTime());
                return true;
            }
            inStream = null;
            outStream = null;
            inStream = this.getTarFile().getInputStream(entry);
            if (inStream != null) break block26;
            destination.setLastModified(entry.getModificationTime());
            try {
                if (outStream != null) {
                    outStream.close();
                }
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException iOException) {}
            destination.setLastModified(entry.getModificationTime());
            return false;
        }
        try {
            try {
                outStream = new FileOutputStream(destination);
                byte[] buf = new byte[512];
                int numRead = inStream.read(buf);
                while (numRead > 0) {
                    outStream.write(buf, 0, numRead);
                    numRead = inStream.read(buf);
                }
            }
            catch (IOException iOException) {
                try {
                    if (outStream != null) {
                        outStream.close();
                    }
                    if (inStream != null) {
                        inStream.close();
                    }
                }
                catch (IOException iOException2) {}
                destination.setLastModified(entry.getModificationTime());
            }
        }
        catch (Throwable throwable) {
            try {
                if (outStream != null) {
                    outStream.close();
                }
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException iOException) {}
            destination.setLastModified(entry.getModificationTime());
            throw throwable;
        }
        try {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
        }
        catch (IOException iOException) {}
        destination.setLastModified(entry.getModificationTime());
        return true;
    }

    public boolean extractVirtualDirectory(String fullVirtualName, File destinationParent) {
        return this.extractVirtualDirectory(fullVirtualName, destinationParent, null);
    }

    public boolean extractVirtualDirectory(String fullVirtualName, File destinationParent, File destination) {
        if (!destinationParent.exists() ? !destinationParent.mkdirs() : !destinationParent.isDirectory()) {
            return false;
        }
        fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
        try {
            this.updateCache();
        }
        catch (IOException iOException) {
            return false;
        }
        VirtualChild dir = this.vfs.getEntry(fullVirtualName);
        if (dir == null || !dir.isDirectory) {
            return false;
        }
        if (destination == null) {
            destination = fullVirtualName.equals("") ? destinationParent : new File(destinationParent, dir.name);
        }
        File topDir = destination;
        String topDirPath = topDir.getAbsolutePath();
        if (!destination.equals(destinationParent)) {
            if (destination.isFile() && destination.exists()) {
                SystemArchiveUtil.delete(destination);
            }
            destination.mkdirs();
        }
        if (!topDir.exists() && !topDir.mkdirs()) {
            return false;
        }
        this.extractVirtualFile(fullVirtualName, topDir);
        VirtualChild[] children = this.vfs.getChildren(fullVirtualName);
        int i = 0;
        while (i < children.length) {
            VirtualChild tempChild = children[i];
            String childPath = String.valueOf(topDirPath) + File.separator + tempChild.name;
            File childFile = new File(childPath);
            if (tempChild.isDirectory) {
                this.extractVirtualDirectory(tempChild.fullName, childFile, null);
            } else {
                this.extractVirtualFile(tempChild.fullName, childFile);
            }
            ++i;
        }
        return true;
    }

    public boolean add(File file, String virtualPath, String name) {
        virtualPath = ArchiveHandlerManager.cleanUpVirtualPath(virtualPath);
        if (!file.isDirectory()) {
            if (this.exists(String.valueOf(virtualPath) + "/" + name)) {
                return this.replace(String.valueOf(virtualPath) + "/" + name, file, name);
            }
            File[] files = new File[]{file};
            String[] names = new String[]{name};
            return this.add(files, virtualPath, names);
        }
        Vector children = new Vector();
        this.listAllFiles(file, children);
        int numOfChildren = children.size();
        File[] sources = new File[numOfChildren + 1];
        String[] newNames = new String[numOfChildren + 1];
        int charsToTrim = file.getParentFile().getAbsolutePath().length() + 1;
        int i = 0;
        while (i < numOfChildren) {
            sources[i] = (File)children.get(i);
            newNames[i] = sources[i].getAbsolutePath().substring(charsToTrim);
            newNames[i] = newNames[i].replace('\\', '/');
            if (sources[i].isDirectory() && !newNames[i].endsWith("/")) {
                newNames[i] = String.valueOf(newNames[i]) + "/";
            }
            ++i;
        }
        sources[numOfChildren] = file;
        newNames[numOfChildren] = name;
        if (!newNames[numOfChildren].endsWith("/")) {
            newNames[numOfChildren] = String.valueOf(newNames[numOfChildren]) + "/";
        }
        return this.add(sources, virtualPath, newNames);
    }

    public void listAllFiles(File parent, Vector found) {
        File[] children = parent.listFiles();
        int i = 0;
        while (i < children.length) {
            if (children[i].isDirectory()) {
                this.listAllFiles(children[i], found);
            }
            found.add(children[i]);
            ++i;
        }
    }

    public boolean add(File[] files, String virtualPath, String[] names) {
        try {
            this.updateCache();
        }
        catch (IOException iOException) {
            return false;
        }
        virtualPath = ArchiveHandlerManager.cleanUpVirtualPath(virtualPath);
        int numFiles = files.length;
        int i = 0;
        while (i < numFiles) {
            if (!files[i].exists() || !files[i].canRead()) {
                return false;
            }
            if (this.exists(String.valueOf(virtualPath) + "/" + names[i])) {
                return this.replace(String.valueOf(virtualPath) + "/" + names[i], files[i], names[i]);
            }
            ++i;
        }
        try {
            File outFile = new File(String.valueOf(this.file.getAbsolutePath()) + "temp");
            TarOutputStream outStream = new TarOutputStream(new FileOutputStream(outFile));
            VirtualChild[] children = this.getVirtualChildrenList();
            if (children.length != 0) {
                this.createTar(children, outStream, (HashSet)null);
            }
            int i2 = 0;
            while (i2 < numFiles) {
                String childVirtualPath = String.valueOf(virtualPath) + "/" + names[i2];
                TarEntry newEntry = this.createTarEntry(files[i2], childVirtualPath);
                this.appendFile(files[i2], newEntry, outStream);
                VirtualChild temp = this.getVirtualChild(newEntry);
                this.vfs.addEntry(temp);
                ++i2;
            }
            outStream.close();
            this.replaceFile(outFile, false);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    protected void createTar(VirtualChild[] children, TarOutputStream outStream, HashSet omitChildren) throws IOException {
        if (omitChildren != null && children.length == omitChildren.size()) {
            return;
        }
        TarFile tarFile = this.getTarFile();
        int i = 0;
        while (i < children.length) {
            if (omitChildren == null || !omitChildren.contains(children[i].fullName)) {
                TarEntry nextEntry;
                if (children[i].isDirectory) {
                    nextEntry = tarFile.getEntry(String.valueOf(children[i].fullName) + "/");
                    outStream.putNextEntry(nextEntry);
                    outStream.closeEntry();
                } else {
                    nextEntry = tarFile.getEntry(children[i].fullName);
                    InputStream inStream = tarFile.getInputStream(nextEntry);
                    outStream.putNextEntry(nextEntry);
                    byte[] buf = new byte[512];
                    int numRead = inStream.read(buf);
                    while (numRead > 0) {
                        outStream.write(buf, 0, numRead);
                        numRead = inStream.read(buf);
                    }
                    inStream.close();
                    outStream.closeEntry();
                }
            }
            ++i;
        }
    }

    protected void appendFile(File file, TarEntry entry, TarOutputStream outStream) throws IOException {
        outStream.putNextEntry(entry);
        if (!file.isDirectory()) {
            BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(file));
            byte[] buf = new byte[512];
            int numRead = inStream.read(buf);
            while (numRead > 0) {
                outStream.write(buf, 0, numRead);
                numRead = inStream.read(buf);
            }
            inStream.close();
        }
        outStream.closeEntry();
    }

    protected TarEntry createTarEntry(File file, String virtualPath) {
        String fullName = virtualPath;
        if (file.isDirectory() && !fullName.endsWith("/")) {
            fullName = String.valueOf(fullName) + "/";
        }
        if (fullName.startsWith("/")) {
            fullName = fullName.substring(1);
        }
        TarEntry entry = new TarEntry(fullName);
        if (!file.isDirectory()) {
            long size = file.length();
            entry.setSize(size);
        } else {
            entry.setSize(0L);
        }
        long lastModified = file.lastModified();
        entry.setModificationTime(lastModified);
        String userName = System.getProperty("user.name");
        if (userName != null) {
            entry.setUserName(userName);
        }
        boolean canRead = file.canRead();
        boolean canWrite = file.canWrite();
        boolean canExecute = false;
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            sm = new SecurityManager();
        }
        try {
            FilePermission permission = new FilePermission(file.getAbsolutePath(), "execute");
            sm.checkPermission(permission);
            canExecute = true;
        }
        catch (SecurityException securityException) {
            canExecute = false;
        }
        entry.setUserMode(canRead, canWrite, canExecute);
        entry.calculateChecksum();
        return entry;
    }

    protected TarEntry changeTarEntry(TarEntry entry, File file, String virtualPath) {
        String fullName = virtualPath;
        if (file.isDirectory() && !fullName.endsWith("/")) {
            fullName = String.valueOf(fullName) + "/";
        }
        if (fullName.startsWith("/")) {
            fullName = fullName.substring(1);
        }
        entry.setName(fullName);
        if (!file.isDirectory()) {
            long size = file.length();
            entry.setSize(size);
        } else {
            entry.setSize(0L);
        }
        long lastModified = file.lastModified();
        entry.setModificationTime(lastModified);
        entry.calculateChecksum();
        return entry;
    }

    protected VirtualChild getVirtualChild(TarEntry entry) {
        VirtualChild child = new VirtualChild(this, entry.getName());
        child.isDirectory = entry.isDirectory();
        return child;
    }

    protected void replaceFile(File newFile, boolean updateCache) throws IOException {
        String name = this.file.getAbsolutePath();
        File tempFile = new File(String.valueOf(name) + ".old");
        this.file.renameTo(tempFile);
        newFile.renameTo(this.file);
        this.init(this.file);
        if (!updateCache) {
            this.modTimeDuringCache = this.file.lastModified();
        }
        this.updateCache();
        tempFile.delete();
    }

    public boolean replace(String fullVirtualName, File file, String name) {
        try {
            this.updateCache();
        }
        catch (IOException iOException) {
            return false;
        }
        if (!file.exists() && !file.canRead()) {
            return false;
        }
        if (!this.exists(fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName))) {
            return this.add(file, fullVirtualName, name);
        }
        try {
            File outFile = new File(String.valueOf(this.getArchive().getAbsolutePath()) + "temp");
            TarOutputStream outStream = new TarOutputStream(new FileOutputStream(outFile));
            VirtualChild[] children = this.getVirtualChildrenList();
            HashSet<String> omissions = new HashSet<String>();
            omissions.add(fullVirtualName);
            this.createTar(children, outStream, omissions);
            String parentVirtualPath = null;
            int i = fullVirtualName.lastIndexOf("/");
            parentVirtualPath = i == -1 ? "" : fullVirtualName.substring(0, i);
            String virtualPath = String.valueOf(parentVirtualPath) + "/" + name;
            TarFile tarFile = this.getTarFile();
            TarEntry entry = tarFile.getEntry(fullVirtualName);
            entry = this.changeTarEntry(entry, file, virtualPath);
            this.appendFile(file, entry, outStream);
            this.vfs.removeEntry(this.vfs.getEntry(fullVirtualName));
            VirtualChild temp = this.getVirtualChild(entry);
            this.vfs.addEntry(temp);
            outStream.close();
            this.replaceFile(outFile, false);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean delete(String fullVirtualName) {
        try {
            this.updateCache();
        }
        catch (IOException iOException) {
            return false;
        }
        fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
        VirtualChild child = this.getVirtualFile(fullVirtualName);
        VirtualChild[] omitArray = new VirtualChild[]{};
        if (!child.exists()) {
            return false;
        }
        if (child.isDirectory) {
            omitArray = this.getVirtualChildrenList(fullVirtualName);
        }
        try {
            File outFile = new File(String.valueOf(this.file.getAbsolutePath()) + "temp");
            TarOutputStream outStream = new TarOutputStream(new FileOutputStream(outFile));
            VirtualChild[] children = this.getVirtualChildrenList();
            HashSet<String> omissions = new HashSet<String>();
            omissions.add(child.fullName);
            int i = 0;
            while (i < omitArray.length) {
                omissions.add(omitArray[i].fullName);
                ++i;
            }
            this.createTar(children, outStream, omissions);
            this.vfs.removeEntry(child);
            outStream.close();
            this.replaceFile(outFile, false);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean rename(String fullVirtualName, String newName) {
        int i = (fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName)).lastIndexOf("/");
        if (i == -1) {
            return this.fullRename(fullVirtualName, newName);
        }
        String fullNewName = String.valueOf(fullVirtualName.substring(0, i + 1)) + newName;
        return this.fullRename(fullVirtualName, fullNewName);
    }

    public boolean move(String fullVirtualName, String destinationVirtualPath) {
        fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
        destinationVirtualPath = ArchiveHandlerManager.cleanUpVirtualPath(destinationVirtualPath);
        int i = fullVirtualName.lastIndexOf("/");
        if (i == -1) {
            return this.fullRename(fullVirtualName, String.valueOf(destinationVirtualPath) + "/" + fullVirtualName);
        }
        String name = fullVirtualName.substring(i);
        return this.fullRename(fullVirtualName, String.valueOf(destinationVirtualPath) + name);
    }

    public boolean fullRename(String fullVirtualName, String newFullVirtualName) {
        try {
            this.updateCache();
        }
        catch (IOException iOException) {
            return false;
        }
        fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
        newFullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(newFullVirtualName);
        VirtualChild child = this.getVirtualFile(fullVirtualName);
        if (!child.exists()) {
            return false;
        }
        try {
            File outFile = new File(String.valueOf(this.file.getAbsolutePath()) + "temp");
            TarOutputStream outStream = new TarOutputStream(new FileOutputStream(outFile));
            VirtualChild[] children = this.getVirtualChildrenList();
            HashMap<String, String> names = new HashMap<String, String>();
            if (child.isDirectory) {
                names.put(String.valueOf(fullVirtualName) + "/", String.valueOf(newFullVirtualName) + "/");
                VirtualChild[] childrenArray = this.getVirtualChildrenList(fullVirtualName);
                int i = 0;
                while (i < childrenArray.length) {
                    int j = fullVirtualName.length();
                    String suffix = childrenArray[i].fullName.substring(j);
                    String newName = String.valueOf(newFullVirtualName) + suffix;
                    if (childrenArray[i].isDirectory) {
                        names.put(String.valueOf(childrenArray[i].fullName) + "/", String.valueOf(newName) + "/");
                    } else {
                        names.put(childrenArray[i].fullName, newName);
                    }
                    ++i;
                }
            } else {
                names.put(fullVirtualName, newFullVirtualName);
            }
            this.createTar(children, outStream, names);
            outStream.close();
            this.replaceFile(outFile, true);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    protected void createTar(VirtualChild[] children, TarOutputStream outStream, HashMap renameMap) throws IOException {
        TarFile tarFile = this.getTarFile();
        int i = 0;
        while (i < children.length) {
            String oldPath;
            VirtualChild child = children[i];
            String newPath = oldPath = child.getArchiveStandardName();
            boolean needToRename = false;
            if (renameMap.containsKey(oldPath)) {
                newPath = (String)renameMap.get(oldPath);
                child.renameTo(newPath);
                needToRename = true;
            }
            TarEntry nextEntry = tarFile.getEntry(oldPath);
            if (children[i].isDirectory) {
                if (needToRename) {
                    nextEntry = this.changeTarEntryName(nextEntry, newPath);
                }
                outStream.putNextEntry(nextEntry);
                outStream.closeEntry();
            } else {
                InputStream inStream = tarFile.getInputStream(nextEntry);
                if (needToRename) {
                    nextEntry = this.changeTarEntryName(nextEntry, newPath);
                }
                outStream.putNextEntry(nextEntry);
                byte[] buf = new byte[512];
                int numRead = inStream.read(buf);
                while (numRead > 0) {
                    outStream.write(buf, 0, numRead);
                    numRead = inStream.read(buf);
                }
                inStream.close();
                outStream.closeEntry();
            }
            ++i;
        }
    }

    protected TarEntry changeTarEntryName(TarEntry entry, String newName) {
        entry.setName(newName);
        entry.calculateChecksum();
        return entry;
    }

    public File[] getFiles(String[] fullNames) {
        File[] files = new File[fullNames.length];
        int i = 0;
        while (i < fullNames.length) {
            String fullName = fullNames[i];
            int j = (fullName = ArchiveHandlerManager.cleanUpVirtualPath(fullName)).lastIndexOf("/");
            String name = j == -1 ? fullName : fullName.substring(j + 1);
            try {
                files[i] = File.createTempFile(name, "virtual");
                files[i].deleteOnExit();
                this.extractVirtualFile(fullNames[i], files[i]);
            }
            catch (IOException iOException) {
                return null;
            }
            ++i;
        }
        return files;
    }

    public boolean createFolder(String fullVirtualName) {
        fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
        fullVirtualName = String.valueOf(fullVirtualName) + "/";
        return this.createVirtualObject(fullVirtualName);
    }

    public boolean createFile(String fullVirtualName) {
        fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
        return this.createVirtualObject(fullVirtualName);
    }

    protected boolean createVirtualObject(String name) {
        try {
            this.updateCache();
        }
        catch (IOException iOException) {
            return false;
        }
        if (this.exists(name)) {
            return false;
        }
        try {
            File outFile = new File(String.valueOf(this.file.getAbsolutePath()) + "temp");
            TarOutputStream outStream = new TarOutputStream(new FileOutputStream(outFile));
            VirtualChild[] children = this.getVirtualChildrenList();
            if (children.length != 0) {
                this.createTar(children, outStream, (HashSet)null);
            }
            TarEntry newEntry = this.appendEmptyFile(outStream, name);
            VirtualChild temp = this.getVirtualChild(newEntry);
            this.vfs.addEntry(temp);
            outStream.close();
            this.replaceFile(outFile, false);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    protected TarEntry appendEmptyFile(TarOutputStream outStream, String name) throws IOException {
        TarEntry newEntry = new TarEntry(name);
        newEntry.setSize(0L);
        newEntry.setModificationTime(System.currentTimeMillis());
        String userName = System.getProperty("user.name");
        if (userName != null) {
            newEntry.setUserName(userName);
        }
        boolean canRead = this.file.canRead();
        boolean canWrite = this.file.canWrite();
        boolean canExecute = false;
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            sm = new SecurityManager();
        }
        try {
            FilePermission permission = new FilePermission(this.file.getAbsolutePath(), "execute");
            sm.checkPermission(permission);
            canExecute = true;
        }
        catch (SecurityException securityException) {
            canExecute = false;
        }
        newEntry.setUserMode(canRead, canWrite, canExecute);
        newEntry.calculateChecksum();
        outStream.putNextEntry(newEntry);
        outStream.closeEntry();
        return newEntry;
    }

    public String getStandardName(VirtualChild vc) {
        if (vc.isDirectory) {
            return String.valueOf(vc.fullName) + "/";
        }
        return vc.fullName;
    }

    public boolean create() {
        try {
            TarOutputStream outStream = new TarOutputStream(new FileOutputStream(this.file));
            outStream.close();
            this.createCache();
            this.modTimeDuringCache = this.file.lastModified();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public SystemSearchLineMatch[] search(String fullVirtualName, SystemSearchStringMatcher matcher) {
        if (matcher.isSearchStringEmpty() || matcher.isSearchStringAsterisk()) {
            return new SystemSearchLineMatch[0];
        }
        VirtualChild vc = this.getVirtualFile(fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName));
        if (!vc.exists() || vc.isDirectory) {
            return new SystemSearchLineMatch[0];
        }
        TarFile tarFile = this.getTarFile();
        TarEntry entry = tarFile.getEntry(fullVirtualName);
        InputStream is = null;
        try {
            is = tarFile.getInputStream(entry);
            if (is == null) {
                return new SystemSearchLineMatch[0];
            }
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader bufReader = new BufferedReader(isr);
            SystemSearchStringMatchLocator locator = new SystemSearchStringMatchLocator(bufReader, matcher);
            SystemSearchLineMatch[] matches = locator.locateMatches();
            if (matches == null) {
                return new SystemSearchLineMatch[0];
            }
            return matches;
        }
        catch (IOException iOException) {
            return new SystemSearchLineMatch[0];
        }
    }

    public boolean exists() {
        return true;
    }

    public String getCommentFor(String fullVirtualName) {
        return "";
    }

    public long getCompressedSizeFor(String fullVirtualName) {
        return this.getSizeFor(fullVirtualName);
    }

    public String getCompressionMethodFor(String fullVirtualName) {
        return "";
    }

    public String getArchiveComment() {
        return "";
    }

    public boolean add(File file, String virtualPath, String name, String encoding, ISystemFileTypes registry) {
        return this.add(file, virtualPath, name);
    }

    public boolean add(File file, String virtualPath, String name, String sourceEncoding, String targetEncoding, boolean isText) {
        return this.add(file, virtualPath, name);
    }

    public boolean add(File[] files, String virtualPath, String[] names, String[] sourceEncodings, String[] targetEncodings, boolean[] isTexts) {
        return this.add(files, virtualPath, names);
    }

    public boolean extractVirtualDirectory(String dir, File destinationParent, File destination, String sourceEncoding, boolean isText) {
        return this.extractVirtualDirectory(dir, destinationParent, destination);
    }

    public boolean extractVirtualDirectory(String dir, File destinationParent, String sourceEncoding, boolean isText) {
        return this.extractVirtualDirectory(dir, destinationParent);
    }

    public boolean extractVirtualFile(String fullVirtualName, File destination, String sourceEncoding, boolean isText) {
        return this.extractVirtualFile(fullVirtualName, destination);
    }

    public String getClassification(String fullVirtualName) {
        fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
        String type = "file";
        if (!fullVirtualName.endsWith(".class")) {
            return type;
        }
        TarEntry entry = this.getTarFile().getEntry(fullVirtualName);
        InputStream stream = null;
        BasicClassFileParser parser = null;
        boolean isExecutable = false;
        try {
            stream = this.getTarFile().getInputStream(entry);
            parser = new BasicClassFileParser(stream);
            parser.parse();
            isExecutable = parser.isExecutable();
        }
        catch (IOException iOException) {
            isExecutable = false;
        }
        if (isExecutable && parser != null) {
            type = "executable(java";
            String qualifiedClassName = parser.getQualifiedClassName();
            if (qualifiedClassName != null) {
                type = String.valueOf(type) + ":" + qualifiedClassName;
            }
            type = String.valueOf(type) + ")";
        }
        return type;
    }

    public boolean add(InputStream stream, String virtualPath, String name, String sourceEncoding, String targetEncoding, boolean isText) {
        return false;
    }

    public boolean add(File file, String virtualPath, String name, String sourceEncoding, String targetEncoding, ISystemFileTypes typeRegistery) {
        return false;
    }

    public boolean replace(String fullVirtualName, InputStream stream, String name, String sourceEncoding, String targetEncoding, boolean isText) {
        return false;
    }

    private class VirtualFileNode {
        private static final int MODE_ALL = 1;
        private static final int MODE_FILES_ONLY = 2;
        private static final int MODE_FOLDERS_ONLY = 3;
        private VirtualChild entry;
        private HashMap map;
        private boolean isDir;

        public VirtualFileNode(VirtualChild entry) {
            this.entry = entry;
            this.isDir = entry.isDirectory;
            this.map = new HashMap();
        }

        public VirtualChild getEntry() {
            return this.entry;
        }

        public boolean isDir() {
            return this.isDir;
        }

        public void addChild(String childName, VirtualFileNode child, boolean replace) {
            if (this.isDir) {
                if (replace) {
                    VirtualFileNode oldChild = this.getChild(childName);
                    if (oldChild != null && oldChild.isDir() && child.isDir()) {
                        Iterator iter = oldChild.getChildrenNames();
                        while (iter.hasNext()) {
                            String name = (String)iter.next();
                            VirtualFileNode grandChild = oldChild.getChild(name);
                            child.addChild(name, grandChild, true);
                        }
                    }
                    this.map.put(childName, child);
                } else {
                    boolean exists = this.childExists(childName);
                    if (!exists) {
                        this.map.put(childName, child);
                    }
                }
            }
        }

        public VirtualFileNode removeChild(String childName) {
            if (this.isDir) {
                return (VirtualFileNode)this.map.remove(childName);
            }
            return null;
        }

        public VirtualFileNode getChild(String childName) {
            if (this.isDir) {
                return (VirtualFileNode)this.map.get(childName);
            }
            return null;
        }

        public VirtualFileNode[] getChildren() {
            return this.getChildren(1);
        }

        public VirtualFileNode[] getChildrenFolders() {
            return this.getChildren(3);
        }

        public VirtualFileNode[] getChildren(int mode) {
            if (this.isDir) {
                if (mode == 1) {
                    int num = this.map.size();
                    VirtualFileNode[] children = new VirtualFileNode[num];
                    this.map.values().toArray(children);
                    return children;
                }
                Vector<VirtualFileNode> v = new Vector<VirtualFileNode>();
                Iterator iter = this.map.values().iterator();
                while (iter.hasNext()) {
                    VirtualFileNode node = (VirtualFileNode)iter.next();
                    boolean isDir = node.isDir();
                    if (mode == 2 && !isDir) {
                        v.add(node);
                        continue;
                    }
                    if (mode != 3 || !isDir) continue;
                    v.add(node);
                }
                VirtualFileNode[] children = new VirtualFileNode[v.size()];
                v.toArray(children);
                return children;
            }
            return new VirtualFileNode[0];
        }

        public boolean childExists(String childName) {
            if (this.isDir) {
                return this.map.containsKey(childName);
            }
            return false;
        }

        public Iterator getChildrenNames() {
            if (this.isDir) {
                return this.map.keySet().iterator();
            }
            return null;
        }
    }

    private class VirtualFileSystem {
        private VirtualFileNode rootNode;

        public VirtualFileSystem(VirtualChild root) {
            this.rootNode = new VirtualFileNode(root);
        }

        public void addEntry(VirtualChild entry) {
            this.addEntry(entry, true);
        }

        public void addEntry(VirtualChild entry, boolean replace) {
            String path = entry.fullName;
            VirtualFileNode parentNode = this.rootNode;
            int idx = path.indexOf("/");
            String name = path;
            String segPath = "";
            while (idx > 0) {
                name = path.substring(0, idx);
                path = path.substring(idx + 1);
                segPath = String.valueOf(segPath) + name + "/";
                boolean exists = parentNode.childExists(name);
                if (!exists) {
                    VirtualChild child = new VirtualChild(SystemTarHandler.this, segPath);
                    child.isDirectory = true;
                    parentNode.addChild(name, new VirtualFileNode(child), true);
                }
                parentNode = parentNode.getChild(name);
                idx = path.indexOf("/");
            }
            parentNode.addChild(path, new VirtualFileNode(entry), replace);
        }

        public VirtualChild removeEntry(VirtualChild entry) {
            return this.removeEntry(entry.fullName);
        }

        public VirtualChild removeEntry(String path) {
            if (path.charAt(path.length() - 1) == '/') {
                path = path.substring(0, path.length() - 1);
            }
            VirtualFileNode parent = this.getParentNode(path);
            String name = null;
            int idx = path.lastIndexOf(47);
            name = idx == -1 ? path : path.substring(idx + 1);
            VirtualFileNode removedChild = parent.removeChild(name);
            if (removedChild == null) {
                return null;
            }
            return removedChild.getEntry();
        }

        public VirtualChild getEntry(String path) {
            VirtualFileNode node = this.getNode(path);
            if (node == null) {
                return null;
            }
            return node.getEntry();
        }

        public VirtualChild[] getChildren(VirtualChild entry) {
            return this.getChildren(entry.fullName);
        }

        public VirtualChild[] getChildrenFolders(VirtualChild entry) {
            return this.getChildrenFolders(entry.fullName);
        }

        public VirtualChild[] getChildren(String path) {
            VirtualFileNode node = this.getNode(path);
            if (node == null) {
                return new VirtualChild[0];
            }
            VirtualFileNode[] childNodes = node.getChildren();
            VirtualChild[] children = new VirtualChild[childNodes.length];
            int i = 0;
            while (i < children.length) {
                children[i] = childNodes[i].getEntry();
                ++i;
            }
            return children;
        }

        public VirtualChild[] getChildrenFolders(String path) {
            VirtualFileNode node = this.getNode(path);
            VirtualFileNode[] childNodes = node.getChildrenFolders();
            VirtualChild[] children = new VirtualChild[childNodes.length];
            int i = 0;
            while (i < children.length) {
                children[i] = childNodes[i].getEntry();
                ++i;
            }
            return children;
        }

        public VirtualChild getParent(VirtualChild entry) {
            VirtualFileNode node = this.getParentNode(entry.fullName);
            if (node == null) {
                return null;
            }
            return node.getEntry();
        }

        private VirtualFileNode getParentNode(String path) {
            int idx;
            if (path.charAt(path.length() - 1) == '/') {
                path = path.substring(0, path.length() - 1);
            }
            if ((idx = path.lastIndexOf(47)) == -1) {
                return this.rootNode;
            }
            return this.getNode(path.substring(0, idx));
        }

        private VirtualFileNode getNode(String path) {
            if (path.equals("")) {
                return this.rootNode;
            }
            if (path.charAt(path.length() - 1) == '/') {
                path = path.substring(0, path.length() - 1);
            }
            int idx = 0;
            int jdx = 0;
            VirtualFileNode tempNode = this.rootNode;
            boolean done = false;
            while (true) {
                String tempName;
                if ((jdx = path.indexOf(47, idx)) == -1) {
                    jdx = path.length();
                    done = true;
                }
                if ((tempNode = tempNode.getChild(tempName = path.substring(idx, jdx))) == null) {
                    return null;
                }
                if (done) break;
                idx = jdx + 1;
            }
            return tempNode;
        }
    }
}

