/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.core.model;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSEPreferencesManager;
import org.eclipse.rse.core.model.Host;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.IRSEPersistableContainer;
import org.eclipse.rse.core.model.ISystemHostPool;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.RSEModelObject;
import org.eclipse.rse.internal.core.RSECoreMessages;
import org.eclipse.rse.internal.core.model.SystemProfileManager;

public class SystemHostPool
extends RSEModelObject
implements ISystemHostPool {
    protected static final String NAME_EDEFAULT;
    private static Hashtable pools;
    private static String CONNECTION_FILE_NAME;
    protected String name = NAME_EDEFAULT;
    private List connections = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.internal.core.model.SystemHostPool");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        NAME_EDEFAULT = null;
        pools = null;
        CONNECTION_FILE_NAME = "connection";
    }

    protected SystemHostPool() {
    }

    public static void reset() {
        pools = null;
    }

    public static ISystemHostPool getSystemHostPool(ISystemProfile profile) throws Exception {
        SystemHostPool pool;
        if (pools == null) {
            pools = new Hashtable();
        }
        if ((pool = (SystemHostPool)pools.get(profile)) == null) {
            pool = new SystemHostPool();
            pool.setName(profile.getName());
            try {
                pool.restore();
            }
            catch (Exception exception) {}
            pools.put(profile, pool);
        }
        return pool;
    }

    public ISystemProfile getSystemProfile() {
        return SystemProfileManager.getDefault().getSystemProfile(this.getName());
    }

    public void renameHostPool(String newName) {
        IHost[] connections = this.getHosts();
        String oldName = this.getName();
        int idx = 0;
        while (idx < connections.length) {
            connections[idx].renamingSystemProfile(oldName, newName);
            ++idx;
        }
        this.setName(newName);
    }

    public void printConnections() {
        List conns = this.getHostList();
        Iterator connsList = conns.iterator();
        if (!connsList.hasNext()) {
            System.out.println();
            System.out.println("No connections");
        }
        while (connsList.hasNext()) {
            System.out.println();
            IHost conn = (IHost)connsList.next();
            System.out.println("  AliasName.....: " + conn.getAliasName());
            System.out.println("  -----------------------------------------------------");
            System.out.println("  HostName......: " + conn.getHostName());
            System.out.println("  SystemType....: " + conn.getSystemType().getId());
            System.out.println("  Description...: " + conn.getDescription());
            System.out.println("  UserId........: " + conn.getDefaultUserId());
        }
    }

    public IHost createHost(IRSESystemType systemType, String aliasName, String hostName) throws Exception {
        return this.createHost(systemType, aliasName, hostName, null, null, 2);
    }

    public IHost createHost(IRSESystemType systemType, String aliasName, String hostName, String description) throws Exception {
        return this.createHost(systemType, aliasName, hostName, description, null, 2);
    }

    public IHost createHost(IRSESystemType systemType, String aliasName, String hostName, String description, String defaultUserId, int defaultUserIdLocation) throws Exception {
        boolean exists;
        IHost conn = null;
        boolean bl = exists = this.getHost(aliasName) != null;
        if (exists) {
            return null;
        }
        ISystemProfile profile = this.getSystemProfile();
        if (systemType != null) {
            conn = systemType.createNewHostInstance(profile);
        }
        if (conn == null) {
            conn = new Host(profile);
        }
        if (!$assertionsDisabled && conn == null) {
            throw new AssertionError();
        }
        this.addHost(conn);
        conn.setHostPool(this);
        conn.setAliasName(aliasName);
        conn.setSystemType(systemType);
        if (defaultUserId == null && defaultUserIdLocation == 2) {
            defaultUserId = conn.getDefaultUserId();
        }
        this.updateHost(conn, systemType, aliasName, hostName, description, defaultUserId, defaultUserIdLocation);
        return conn;
    }

    public void updateHost(IHost conn, IRSESystemType systemType, String aliasName, String hostName, String description, String defaultUserId, int defaultUserIdLocation) throws Exception {
        boolean aliasNameChanged;
        boolean bl = aliasNameChanged = !aliasName.equalsIgnoreCase(conn.getAliasName());
        if (aliasNameChanged) {
            this.renameHost(conn, aliasName);
        }
        conn.setSystemType(systemType);
        conn.setHostName(hostName);
        if (defaultUserIdLocation != 0) {
            if (defaultUserIdLocation != 2) {
                conn.setDefaultUserId(null);
                boolean forceToUpperCase = conn.getForceUserIdToUpperCase();
                if (forceToUpperCase && defaultUserId != null) {
                    defaultUserId = defaultUserId.toUpperCase();
                }
                if (defaultUserIdLocation == 3) {
                    RSEPreferencesManager.setDefaultUserId(systemType, defaultUserId);
                }
            } else {
                conn.setDefaultUserId(defaultUserId);
            }
        }
        conn.setDescription(description);
        this.commit(conn);
    }

    public IHost[] getHosts() {
        return this.getHostList().toArray(new IHost[this.connections.size()]);
    }

    protected void invalidateCache() {
        this.setDirty(true);
    }

    public IHost getHost(String aliasName) {
        IHost conn = null;
        IHost currconn = null;
        List conns = this.getHostList();
        Iterator i = conns.iterator();
        while (i.hasNext() && conn == null) {
            currconn = (IHost)i.next();
            if (!currconn.getAliasName().equalsIgnoreCase(aliasName)) continue;
            conn = currconn;
        }
        return conn;
    }

    public IHost getHost(int pos) {
        List conns = this.getHostList();
        if (pos < conns.size()) {
            return (IHost)conns.get(pos);
        }
        return null;
    }

    public int getHostPosition(IHost conn) {
        int position = -1;
        boolean match = false;
        List conns = this.getHostList();
        Iterator i = conns.iterator();
        int idx = 0;
        while (!match && i.hasNext()) {
            IHost currConn = (IHost)i.next();
            if (conn.equals(currConn)) {
                match = true;
                position = idx;
            }
            ++idx;
        }
        return position;
    }

    public int getHostCount() {
        List conns = this.getHostList();
        return conns.size();
    }

    public boolean addHost(IHost conn) {
        List hostList = this.getHostList();
        if (!hostList.contains(conn)) {
            hostList.add(conn);
        }
        conn.setHostPool(this);
        this.invalidateCache();
        return true;
    }

    public void deleteHost(IHost conn) {
        conn.deletingHost();
        this.getHostList().remove(conn);
        this.setDirty(true);
        conn.getSystemProfile().commit();
    }

    public void renameHost(IHost conn, String newName) throws Exception {
        conn.setAliasName(newName);
        this.invalidateCache();
        this.commit(conn);
    }

    public IHost cloneHost(ISystemHostPool targetPool, IHost conn, String aliasName) throws Exception {
        IHost copy = targetPool.createHost(conn.getSystemType(), aliasName, conn.getHostName(), conn.getDescription(), conn.getLocalDefaultUserId(), 2);
        return copy;
    }

    public void moveHosts(IHost[] hosts, int delta) {
        int index;
        final int m = delta > 0 ? -1 : 1;
        TreeSet<Integer> indices = new TreeSet<Integer>(new Comparator(){

            public int compare(Object o1, Object o2) {
                return m * ((Integer)o1).compareTo((Integer)o2);
            }
        });
        List hostList = this.getHostList();
        int i = 0;
        while (i < hosts.length) {
            IHost host = hosts[i];
            index = hostList.indexOf(host);
            if (index >= 0) {
                indices.add(new Integer(index));
            }
            ++i;
        }
        boolean moved = indices.size() > 0;
        Iterator z = indices.iterator();
        while (z.hasNext() && moved) {
            index = (Integer)z.next();
            moved &= this.moveHost(hostList, index, delta);
        }
        if (moved) {
            this.invalidateCache();
            this.commit();
        }
    }

    private boolean moveHost(List hostList, int oldPos, int delta) {
        int newPos;
        boolean moved = false;
        if (oldPos >= 0 && oldPos < hostList.size() && delta != 0 && (newPos = oldPos + delta) >= 0 && newPos < hostList.size()) {
            IHost host = (IHost)hostList.remove(oldPos);
            hostList.add(newPos, host);
            moved = true;
        }
        return moved;
    }

    public void orderHosts(String[] names) {
        List connList = this.getHostList();
        IHost[] conns = new IHost[names.length];
        int idx = 0;
        while (idx < conns.length) {
            conns[idx] = this.getHost(names[idx]);
            ++idx;
        }
        connList.clear();
        idx = 0;
        while (idx < conns.length) {
            connList.add(conns[idx]);
            ++idx;
        }
        this.invalidateCache();
    }

    protected static String getSaveFileName(IHost connection) {
        return null;
    }

    protected static String getRootSaveFileName(IHost connection) {
        return SystemHostPool.getRootSaveFileName(connection.getAliasName());
    }

    protected static String getRootSaveFileName(String connectionName) {
        String fileName = CONNECTION_FILE_NAME;
        return fileName;
    }

    public String toString() {
        if (this.getName() == null) {
            return this.toStringGen();
        }
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return RSECoreMessages.RESID_MODELOBJECTS_HOSTPOOL_DESCRIPTION;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public List getHostList() {
        if (this.connections == null) {
            this.connections = new ArrayList();
        }
        return this.connections;
    }

    public String toStringGen() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(')');
        return result.toString();
    }

    protected void restore() throws Exception {
    }

    protected IHost restore(String connectionName) throws Exception {
        return null;
    }

    public IRSEPersistableContainer getPersistableParent() {
        return null;
    }

    public IRSEPersistableContainer[] getPersistableChildren() {
        return IRSEPersistableContainer.NO_CHILDREN;
    }

    public boolean commit() {
        ISystemProfile profile = this.getSystemProfile();
        boolean result = profile.commit();
        return result;
    }

    public void commit(IHost connection) {
        this.commit();
    }
}

