/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.core.subsystems;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.SystemTypeMatcher;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.core.subsystems.ISubSystemConfigurationProxy;
import org.eclipse.rse.logging.Logger;
import org.osgi.framework.Bundle;

public class SubSystemConfigurationProxy
implements ISubSystemConfigurationProxy {
    private IConfigurationElement element = null;
    private String id;
    private String name;
    private String description;
    private String systemTypeIds;
    private IRSESystemType[] resolvedSystemTypes;
    private String vendor;
    private String category;
    private int priority;
    private ISubSystemConfiguration configuration = null;
    private boolean subSystemConfigurationInitialized = false;
    private final SystemTypeMatcher systemTypeMatcher;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.internal.core.subsystems.SubSystemConfigurationProxy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public SubSystemConfigurationProxy(IConfigurationElement element) {
        if (!$assertionsDisabled && element == null) {
            throw new AssertionError();
        }
        this.element = element;
        this.id = element.getAttribute("id");
        this.name = element.getAttribute("name").trim();
        this.description = element.getAttribute("description").trim();
        this.systemTypeIds = element.getAttribute("systemTypeIds");
        this.vendor = element.getAttribute("vendor");
        this.category = element.getAttribute("category");
        this.priority = Integer.MAX_VALUE;
        String priorityStr = element.getAttribute("priority");
        try {
            if (priorityStr != null) {
                this.priority = Integer.parseInt(priorityStr);
            }
        }
        catch (NumberFormatException e) {
            Logger logger = RSECorePlugin.getDefault().getLogger();
            logger.logError("Exception reading priority for subsystem configuration " + this.name + " defined in plugin " + element.getDeclaringExtension().getNamespaceIdentifier(), e);
        }
        if (this.vendor == null) {
            this.vendor = "Unknown";
        }
        if (this.category == null) {
            this.category = "Unknown";
        }
        this.systemTypeMatcher = new SystemTypeMatcher(this.getDeclaredSystemTypeIds());
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public Bundle getDeclaringBundle() {
        if (!$assertionsDisabled && this.element == null) {
            throw new AssertionError();
        }
        return Platform.getBundle((String)this.element.getDeclaringExtension().getNamespaceIdentifier());
    }

    public String getDeclaredSystemTypeIds() {
        return this.systemTypeIds;
    }

    public IRSESystemType[] getSystemTypes() {
        if (this.resolvedSystemTypes == null) {
            IRSESystemType[] systemTypes = RSECorePlugin.getTheCoreRegistry().getSystemTypes();
            if (this.supportsAllSystemTypes()) {
                this.resolvedSystemTypes = systemTypes;
            } else {
                ArrayList<IRSESystemType> systemTypesList = new ArrayList<IRSESystemType>(systemTypes.length);
                int i = 0;
                while (i < systemTypes.length) {
                    IRSESystemType systemType = systemTypes[i];
                    if ((this.isMatchingDeclaredSystemTypes(systemType) || systemType.getSubsystemConfigurationIds() != null && Arrays.asList(systemType.getSubsystemConfigurationIds()).contains(this.getId())) && !systemTypesList.contains(systemType)) {
                        systemTypesList.add(systemType);
                    }
                    ++i;
                }
                this.resolvedSystemTypes = systemTypesList.toArray(new IRSESystemType[systemTypesList.size()]);
            }
        }
        return this.resolvedSystemTypes;
    }

    protected boolean isMatchingDeclaredSystemTypes(IRSESystemType systemType) {
        return this.systemTypeMatcher.matches(systemType);
    }

    public boolean supportsAllSystemTypes() {
        return this.systemTypeMatcher.supportsAllSystemTypes();
    }

    public String getCategory() {
        return this.category;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean appliesToSystemType(IRSESystemType type) {
        if (!$assertionsDisabled && type == null) {
            throw new AssertionError();
        }
        if (this.systemTypeMatcher.supportsAllSystemTypes()) {
            return true;
        }
        return Arrays.asList(this.getSystemTypes()).contains(type);
    }

    public boolean isSubSystemConfigurationActive() {
        return this.configuration != null;
    }

    public ISubSystemConfiguration getSubSystemConfiguration() {
        if (!this.subSystemConfigurationInitialized && this.configuration == null) {
            try {
                Object executable = this.element.createExecutableExtension("class");
                if (executable instanceof ISubSystemConfiguration) {
                    this.configuration = (ISubSystemConfiguration)executable;
                    this.configuration.setSubSystemConfigurationProxy(this);
                }
            }
            catch (Exception exc) {
                Logger logger = RSECorePlugin.getDefault().getLogger();
                logger.logError("Unable to start subsystem factory " + this.id, exc);
            }
            this.restore();
            this.subSystemConfigurationInitialized = true;
        }
        return this.configuration;
    }

    public void reset() {
        if (this.configuration != null) {
            this.configuration.reset();
        }
    }

    public void restore() {
        try {
            this.configuration.getAllSystemFilterPoolManagers();
        }
        catch (Exception exc) {
            RSECorePlugin.getDefault().getLogger().logError("Error restoring subsystem for configuration " + this.getName(), exc);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof String) {
            return ((String)o).equals(this.id);
        }
        if (o instanceof SubSystemConfigurationProxy) {
            return ((SubSystemConfigurationProxy)o).getId().equals(this.id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return String.valueOf(this.id) + "." + this.name;
    }

    private URL getLocation(String fileName) {
        URL result = null;
        if (fileName != null) {
            URL path = this.getDeclaringBundle().getEntry("/");
            try {
                result = new URL(path, fileName);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return result;
    }

    public URL getImageLocation() {
        URL result = this.getLocation(this.element.getAttribute("icon"));
        return result;
    }

    public URL getLiveImageLocation() {
        URL result = this.getLocation(this.element.getAttribute("iconlive"));
        return result;
    }
}

