/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.actions;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.ui.ISystemDeleteTarget;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.actions.SystemBaseDialogAction;
import org.eclipse.rse.ui.dialogs.SystemDeleteDialog;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.model.SystemRemoteElementResourceSet;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.SystemAdapterHelpers;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SystemCommonDeleteAction
extends SystemBaseDialogAction {
    private String promptLabel;
    private List _setList;

    public SystemCommonDeleteAction(Shell parent, ISystemDeleteTarget deleteTarget) {
        super(SystemResources.ACTION_DELETE_LABEL, SystemResources.ACTION_DELETE_TOOLTIP, PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"), parent);
        this.setSelectionProvider(deleteTarget);
        this.allowOnMultipleSelection(true);
        this.setProcessAllSelections(true);
        this.setContextMenuGroup("group.reorganize");
        this.setHelp("org.eclipse.rse.ui.actn0021");
        this._setList = new Vector();
    }

    public SystemCommonDeleteAction(Shell parent) {
        this(parent, null);
    }

    public void setPromptLabel(String text) {
        this.promptLabel = text;
    }

    private ISystemDeleteTarget getDeleteTarget() {
        return (ISystemDeleteTarget)this.getSelectionProvider();
    }

    public boolean updateSelection(IStructuredSelection selection) {
        this._setList.clear();
        ISystemDeleteTarget deleteTarget = this.getDeleteTarget();
        if (deleteTarget == null) {
            return true;
        }
        return deleteTarget.showDelete() && this.getDeleteTarget().canDelete();
    }

    protected Dialog createDialog(Shell shell) {
        Object firstSelection = this.getFirstSelection();
        if (firstSelection != null) {
            SystemDeleteDialog dlg = new SystemDeleteDialog(shell);
            if (this.promptLabel != null) {
                dlg.setPromptLabel(this.promptLabel);
            }
            if (this.getRemoteAdapter(firstSelection) != null) {
                String warningMsg = null;
                String warningTip = null;
                warningMsg = SystemResources.RESID_DELETE_WARNING_LABEL;
                warningTip = SystemResources.RESID_DELETE_WARNING_TOOLTIP;
                dlg.setWarningMessage(warningMsg, warningTip);
            }
            return dlg;
        }
        return null;
    }

    protected Object getDialogValue(Dialog dlg) {
        ISystemDeleteTarget target;
        ISelection selection;
        if (!((SystemDeleteDialog)dlg).wasCancelled() && this.getDeleteTarget() != null && (selection = (target = this.getDeleteTarget()).getSelection()) instanceof IStructuredSelection) {
            Vector localSet = new Vector();
            IStructuredSelection ssel = (IStructuredSelection)selection;
            Iterator iter = ssel.iterator();
            while (iter.hasNext()) {
                Object object = iter.next();
                ISystemViewElementAdapter adapter = SystemAdapterHelpers.getViewAdapter(object);
                if (this.getRemoteAdapter(object) != null) {
                    ISubSystem subSystem = adapter.getSubSystem(object);
                    SystemRemoteElementResourceSet set = this.getSetFor(subSystem, adapter);
                    set.addResource(object);
                    continue;
                }
                localSet.add(object);
            }
            DeleteJob job = new DeleteJob(localSet, this._setList);
            job.schedule();
        }
        return null;
    }

    protected SystemRemoteElementResourceSet getSetFor(ISubSystem subSystem, ISystemViewElementAdapter adapter) {
        int i = 0;
        while (i < this._setList.size()) {
            SystemRemoteElementResourceSet set = (SystemRemoteElementResourceSet)((Object)this._setList.get(i));
            if (set.getViewAdapter() == adapter && set.getSubSystem() == subSystem) {
                return set;
            }
            ++i;
        }
        SystemRemoteElementResourceSet newSet = new SystemRemoteElementResourceSet(subSystem, adapter);
        this._setList.add(newSet);
        return newSet;
    }

    protected IRunnableContext getRunnableContext(Shell shell) {
        IRunnableContext irc = RSEUIPlugin.getTheSystemRegistryUI().getRunnableContext();
        if (irc != null) {
            return irc;
        }
        irc = new ProgressMonitorDialog(shell);
        RSEUIPlugin.getTheSystemRegistryUI().setRunnableContext(shell, irc);
        return irc;
    }

    protected ISystemRemoteElementAdapter getRemoteAdapter(Object o) {
        return SystemAdapterHelpers.getRemoteAdapter(o);
    }

    public class DeleteEventRunnable
    implements Runnable {
        private List _localDeletedResources;
        private List _remoteDeletedResources;

        public DeleteEventRunnable(List localDeletedResources, List remoteDeletedResources) {
            this._localDeletedResources = localDeletedResources;
            this._remoteDeletedResources = remoteDeletedResources;
        }

        public void run() {
            ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
            if (this._remoteDeletedResources.size() > 0) {
                sr.fireRemoteResourceChangeEvent(2, (Object)this._remoteDeletedResources, null, null, null);
            }
            if (this._localDeletedResources.size() > 0) {
                Object[] localDeleted = this._localDeletedResources.toArray();
                sr.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent(localDeleted, 60, null));
            }
        }
    }

    public class DeleteJob
    extends Job {
        private List _localResources;
        private List _remoteSets;

        public DeleteJob(List localResources, List remoteSets) {
            super(SystemResources.ACTION_DELETE_LABEL);
            this._localResources = localResources;
            this._remoteSets = remoteSets;
        }

        public IStatus run(IProgressMonitor monitor) {
            ISystemViewElementAdapter adapter;
            boolean ok = true;
            Vector localDeletedObjects = new Vector();
            Vector<Object> remoteDeletedObjects = new Vector<Object>();
            int l = 0;
            while (l < this._localResources.size() && ok) {
                Object element = this._localResources.get(l);
                adapter = SystemCommonDeleteAction.this.getViewAdapter(element);
                try {
                    ok = adapter.doDelete(SystemCommonDeleteAction.this.getShell(), element, monitor);
                    if (ok) {
                        localDeletedObjects.add(element);
                    }
                }
                catch (Exception e) {
                    SystemBasePlugin.logError(e.getMessage(), e);
                }
                ++l;
            }
            int r = 0;
            while (r < this._remoteSets.size() && ok) {
                SystemRemoteElementResourceSet set = (SystemRemoteElementResourceSet)((Object)this._remoteSets.get(r));
                adapter = set.getViewAdapter();
                try {
                    ok = adapter.doDeleteBatch(SystemCommonDeleteAction.this.getShell(), set.getResourceSet(), monitor);
                    if (ok) {
                        int i = 0;
                        while (i < set.size()) {
                            remoteDeletedObjects.add(set.get(i));
                            ++i;
                        }
                    }
                }
                catch (SystemMessageException e) {
                    SystemMessageDialog.displayMessage(e);
                }
                catch (Exception e) {
                    SystemMessageDialog.displayExceptionMessage(SystemCommonDeleteAction.this.getShell(), e);
                }
                ++r;
            }
            DeleteEventRunnable fireEvents = new DeleteEventRunnable(localDeletedObjects, remoteDeletedObjects);
            Display.getDefault().asyncExec((Runnable)fireEvents);
            if (ok) {
                return Status.OK_STATUS;
            }
            return Status.CANCEL_STATUS;
        }
    }
}

