/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.dstore.universal.miners.filesystem;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.model.DataStoreResources;
import org.eclipse.dstore.core.util.StringCompare;
import org.eclipse.rse.dstore.universal.miners.UniversalServerUtilities;
import org.eclipse.rse.internal.dstore.universal.miners.filesystem.FileClassifier;
import org.eclipse.rse.internal.dstore.universal.miners.filesystem.QueryThread;
import org.eclipse.rse.services.clientserver.archiveutils.AbsoluteVirtualPath;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.clientserver.archiveutils.VirtualChild;

public class ArchiveQueryThread
extends QueryThread {
    private DataElement _attributes;
    private boolean _caseSensitive;
    private boolean _foldersOnly;
    private boolean _showHidden;
    private boolean _isWindows;

    public ArchiveQueryThread(DataElement subject, DataElement attributes, boolean caseSensitive, boolean foldersOnly, boolean showHidden, boolean isWindows, DataElement status) {
        super(subject, status);
        this._attributes = attributes;
        this._foldersOnly = foldersOnly;
        this._caseSensitive = caseSensitive;
        this._showHidden = showHidden;
        this._isWindows = isWindows;
    }

    public void run() {
        this.doQueryAll();
        if (!this.isCancelled()) {
            this._isDone = true;
            this._dataStore.refresh(this._subject);
            this.statusDone(this._status);
        }
    }

    protected void doQueryAll() {
        File fileobj = null;
        try {
            String path;
            ArchiveHandlerManager mgr = ArchiveHandlerManager.getInstance();
            char separatorChar = File.separatorChar;
            if (ArchiveHandlerManager.isVirtual((String)this._subject.getAttribute(3))) {
                separatorChar = '/';
            }
            String rootPath = path = String.valueOf(this._subject.getAttribute(3)) + separatorChar + this._subject.getName();
            String virtualPath = "";
            VirtualChild[] children = null;
            if (this._subject.getType().equals("universal.ArchiveFileObject")) {
                fileobj = new File(rootPath);
                this._subject.setAttribute(4, this.setProperties(fileobj, true));
                children = this._foldersOnly ? mgr.getFolderContents(fileobj, "") : mgr.getContents(fileobj, "");
                if (this.isCancelled()) {
                    return;
                }
            } else if (this._subject.getType().equals("universal.VirtualFolderObject")) {
                AbsoluteVirtualPath avp = new AbsoluteVirtualPath(path);
                rootPath = avp.getContainingArchiveString();
                virtualPath = avp.getVirtualPart();
                fileobj = new File(rootPath);
                if (fileobj.exists() && mgr.getVirtualObject(path).exists()) {
                    children = this._foldersOnly ? mgr.getFolderContents(fileobj, virtualPath) : mgr.getContents(fileobj, virtualPath);
                    this._subject.setAttribute(4, this.setProperties(mgr.getVirtualObject(path)));
                    if (children == null || children.length == 0) {
                        this._dataStore.trace("problem with virtual:" + virtualPath);
                    }
                    if (this.isCancelled()) {
                        return;
                    }
                } else {
                    this._subject.setAttribute(0, "universal.FilterObject");
                    this._subject.setAttribute(4, this.setProperties(fileobj));
                    this._status.setAttribute(4, "failed with does not exist");
                    if (this._subject.getNestedSize() > 0) {
                        List nestedChildren = this._subject.getNestedData();
                        int i = nestedChildren.size() - 1;
                        while (i >= 0) {
                            this._dataStore.deleteObject(this._subject, (DataElement)nestedChildren.get(i));
                            --i;
                        }
                    }
                    this._dataStore.trace("problem with File:" + rootPath);
                }
            }
            this.createDataElement(this._dataStore, this._subject, children, "*", rootPath, virtualPath);
            if (!this.isCancelled()) {
                this._dataStore.refresh(this._subject);
                FileClassifier clsfy = this.getFileClassifier(this._subject);
                clsfy.start();
            }
            return;
        }
        catch (Exception exception) {
            if (fileobj != null) {
                try {
                    new FileReader(fileobj).read();
                }
                catch (IOException iOException) {
                    this._status.setAttribute(3, "RSEF5001");
                    this._status.setAttribute(4, "failed");
                    this._dataStore.refresh(this._subject);
                    this.statusDone(this._status);
                }
            }
            this._status.setAttribute(3, "RSEG1122");
            this._status.setAttribute(4, "failed");
            this.statusDone(this._status);
            return;
        }
    }

    protected FileClassifier getFileClassifier(DataElement subject) {
        return new FileClassifier(subject);
    }

    public DataElement statusDone(DataElement status) {
        status.setAttribute(2, DataStoreResources.model_done);
        this._dataStore.refresh(status);
        return status;
    }

    public void cancel() {
        this._isCancelled = true;
    }

    public boolean isCancelled() {
        return this._isCancelled;
    }

    public boolean isDone() {
        return this._isDone;
    }

    protected void createDataElement(DataStore ds, DataElement subject, VirtualChild[] list, String filter, String rootPath, String virtualPath) {
        HashMap<String, DataElement> filteredChildren = new HashMap<String, DataElement>();
        List children = subject.getNestedData();
        if (children != null) {
            int f = 0;
            while (f < children.size()) {
                if (this.isCancelled()) {
                    return;
                }
                DataElement child = (DataElement)children.get(f);
                String type = child.getType();
                if (type.equals("universal.VirtualFileObject") || type.equals("universal.VirtualFolderObject")) {
                    if (StringCompare.compare((String)filter, (String)child.getName(), (boolean)false)) {
                        filteredChildren.put(child.getName(), child);
                    }
                } else {
                    filteredChildren.put(child.getName(), child);
                }
                ++f;
            }
        }
        try {
            if (list != null) {
                boolean found = false;
                int j = 0;
                while (j < list.length) {
                    String newSource;
                    String oldSource;
                    String newValue;
                    String oldValue;
                    if (this.isCancelled()) {
                        return;
                    }
                    found = false;
                    DataElement previousElement = (DataElement)filteredChildren.get(list[j].name);
                    if (previousElement != null && !previousElement.isDeleted()) {
                        boolean isfile;
                        String type = previousElement.getType();
                        boolean bl = isfile = !list[j].isDirectory;
                        if (type.equals("universal.VirtualFileObject") || type.equals("universal.VirtualFolderObject") && !isfile) {
                            filteredChildren.remove(list[j].name);
                            found = true;
                        }
                    }
                    DataElement deObj = null;
                    VirtualChild child = list[j];
                    if (found) {
                        deObj = previousElement;
                    }
                    if (deObj == null) {
                        deObj = child.isDirectory ? this._dataStore.createObject(subject, "universal.VirtualFolderObject", child.name) : this._dataStore.createObject(subject, "universal.VirtualFileObject", child.name);
                    }
                    if (!(oldValue = deObj.getAttribute(3)).equals(newValue = String.valueOf(rootPath) + "#virtual#/" + virtualPath)) {
                        deObj.setAttribute(3, newValue);
                    }
                    if (!(oldSource = deObj.getAttribute(4)).startsWith(newSource = this.setProperties(child))) {
                        deObj.setAttribute(4, newSource);
                    }
                    ++j;
                }
            }
            Iterator myIterator = filteredChildren.keySet().iterator();
            while (myIterator.hasNext()) {
                ds.deleteObject(subject, (DataElement)filteredChildren.get(myIterator.next()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            UniversalServerUtilities.logError("UniversalFileSystemMiner", "createDataElement failed with exception - isFile ", e);
        }
    }

    public String setProperties(VirtualChild fileObj) {
        String version = "version_1";
        StringBuffer buffer = new StringBuffer(500);
        long date = fileObj.getTimeStamp();
        long size = fileObj.getSize();
        boolean hidden = false;
        boolean canWrite = fileObj.getContainingArchive().canWrite();
        boolean canRead = fileObj.getContainingArchive().canRead();
        String comment = fileObj.getComment();
        if (comment.equals("")) {
            comment = " ";
        }
        long compressedSize = fileObj.getCompressedSize();
        String compressionMethod = fileObj.getCompressionMethod();
        if (compressionMethod.equals("")) {
            compressionMethod = " ";
        }
        double compressionRatio = fileObj.getCompressionRatio();
        long expandedSize = size;
        buffer.append(version).append("|").append(date).append("|").append(size).append("|");
        buffer.append(hidden).append("|").append(canWrite).append("|").append(canRead);
        buffer.append("|");
        buffer.append(comment).append("|").append(compressedSize).append("|").append(compressionMethod).append("|");
        buffer.append(compressionRatio).append("|").append(expandedSize);
        return buffer.toString();
    }
}

