/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.subsystems.files;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.rse.core.model.ISystemResourceSet;
import org.eclipse.rse.core.model.SystemRemoteResourceSet;
import org.eclipse.rse.core.model.SystemWorkspaceResourceSet;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISystemDragDropAdapter;
import org.eclipse.rse.files.ui.resources.UniversalFileTransferUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.tests.RSETestsPlugin;
import org.eclipse.rse.tests.subsystems.files.FileServiceBaseTest;
import org.eclipse.rse.ui.RSEUIPlugin;

public class FileServiceArchiveTest
extends FileServiceBaseTest {
    protected String folderToCopyName1 = "RemoteSystemsConnections";
    protected String folderToCopyName2 = "6YLT5Xa";
    protected String folderToCopyName3 = "folderToCopy";
    protected String zipSourceFileName1 = "closedBefore.zip";
    protected String zipSourceFileName2 = "mynewzip.zip";
    protected String tarSourceFileName1 = "source.tar";
    protected String tarSourceFileName2 = "mynewtar.tar";
    protected String tarSourceFolderName1 = "META-INF";
    protected String tarSourceFolderName2 = "org";
    protected String tarSourceForOpenTest = "tarSourceForOpen.tar";
    protected String tarSourceForOpenFolderName1 = "META-INF";
    protected String tarSourceForOpenFolderName2 = "org";
    protected String fileContentString1 = "this is just some dummy content \n to a remote file \n to test an open operation";
    protected String ZIP_SOURCE_DIR = "";
    protected String TEST_DIR = "";
    protected String SYSTEM_TYPE_ID = "org.eclipse.rse.systemtype.local";
    protected String SYSTEM_ADDRESS = "";
    protected String SYSTEM_NAME = "";
    protected String USER_ID = "";
    protected String PASSWORD = "";
    static /* synthetic */ Class class$0;

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public void createSourceFolders() throws Exception {
        String tempPath = FileServiceArchiveTest.getWorkspace().getRoot().getLocation().append("temp").toString();
        IFileStore temp = this.createDir(tempPath, true);
        String content = this.getRandomString();
        IFileStore folderToCopy = temp.getChild(this.folderToCopyName3);
        this.createDir(folderToCopy, true);
        IFileStore aaaaaaaa = folderToCopy.getChild("aaaaaaaa");
        this.createDir(aaaaaaaa, true);
        IFileStore adsf = aaaaaaaa.getChild("adsf");
        content = this.getRandomString();
        this.createFile(adsf, content);
        IFileStore eclipse_SDK_3_3M6_win32_zip = aaaaaaaa.getChild("eclipse-SDK-3.3M6-win32.zip");
        this.createFile(eclipse_SDK_3_3M6_win32_zip, "");
        IFileStore epdcdump01_hex12 = aaaaaaaa.getChild("epdcdump01.hex12");
        content = this.getRandomString();
        this.createFile(epdcdump01_hex12, content);
        IFileStore epdcdump01_hex12aaaa = aaaaaaaa.getChild("epdcdump01.hex12aaaa");
        content = this.getRandomString();
        this.createFile(epdcdump01_hex12aaaa, content);
        IFileStore aaaab = folderToCopy.getChild("aaaab");
        this.createDir(aaaab, true);
        IFileStore features = aaaab.getChild("features");
        this.createDir(features, true);
        IFileStore dummyFile = features.getChild("dummy.txt");
        content = this.getRandomString();
        this.createFile(dummyFile, content);
        content = "this is just a simple content \n to a simple file \n to test a 'simple' copy";
        IFileStore epdcdump01_hex12a = aaaab.getChild("epdcdump01.hex12a");
        content = this.getRandomString();
        this.createFile(epdcdump01_hex12a, content);
        IFileStore epdcdump01_hex12a1 = folderToCopy.getChild("epdcdump01.hex12a");
        content = this.getRandomString();
        this.createFile(epdcdump01_hex12a1, content);
        IFileStore RSE_SDK_2_0RC1_zip = folderToCopy.getChild("RSE-SDK-2.0RC1.zip");
        content = this.getRandomString();
        this.createFile(RSE_SDK_2_0RC1_zip, content);
        IRemoteFile sourceFolderToCopy3 = this.localFss.getRemoteFileObject(String.valueOf(tempPath) + '\\' + this.folderToCopyName3, this.mon);
        IAdaptable iAdaptable = (IAdaptable)sourceFolderToCopy3;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISystemDragDropAdapter srcAdapter3 = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz);
        SystemRemoteResourceSet fromSet3 = new SystemRemoteResourceSet((ISubSystem)this.localFss, srcAdapter3);
        fromSet3.addResource((Object)sourceFolderToCopy3);
        ISystemResourceSet tempObjects3 = srcAdapter3.doDrag(fromSet3, this.mon);
        UniversalFileTransferUtility.copyWorkspaceResourcesToRemote((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects3), (IRemoteFile)this.tempDir, (IProgressMonitor)this.mon, (boolean)true);
        this.fss.resolveFilterString((Object)this.tempDir, null, this.mon);
        temp.delete(0, this.mon);
    }

    public void createSourceZipFiles() throws Exception {
        String tempPath = FileServiceArchiveTest.getWorkspace().getRoot().getLocation().append("temp").toString();
        IFileStore temp = this.createDir(tempPath, true);
        String content = this.getRandomString();
        IFileStore RemoteSystemsConnections = temp.getChild(this.folderToCopyName1);
        this.createDir(RemoteSystemsConnections, true);
        IFileStore Team = RemoteSystemsConnections.getChild("Team");
        this.createDir(Team, true);
        IFileStore Connections = Team.getChild("Connections");
        this.createDir(Connections, true);
        IFileStore dummyFile = Connections.getChild("dummy.txt");
        content = this.getRandomString();
        this.createFile(dummyFile, content);
        IFileStore Filters = Team.getChild("Filters");
        this.createDir(Filters, true);
        IFileStore ibm_cmds = Filters.getChild("ibm.cmds");
        this.createDir(ibm_cmds, true);
        IFileStore ibm_cmds400 = Filters.getChild("ibm.cmds400");
        this.createDir(ibm_cmds400, true);
        IFileStore filter_pool1 = ibm_cmds400.getChild("FilterPool_Team Filter Pool");
        this.createDir(filter_pool1, true);
        IFileStore filter_pool1_xml = filter_pool1.getChild("filterPool_Team Filter Pool.xmi");
        content = this.getRandomString();
        this.createFile(filter_pool1_xml, content);
        IFileStore ibm_cmdsIFS = Filters.getChild("ibm.cmdsIFS");
        this.createDir(ibm_cmdsIFS, true);
        IFileStore ibm_cmdsLocal = Filters.getChild("ibm.cmdsLocal");
        this.createDir(ibm_cmdsLocal, true);
        IFileStore ibm_files = Filters.getChild("ibm.files");
        this.createDir(ibm_files, true);
        IFileStore filter_pool2 = ibm_files.getChild("FilterPool_Team Filter Pool");
        this.createDir(filter_pool2, true);
        IFileStore filter_pool2_xml = filter_pool2.getChild("filterPool_Team Filter Pool.xmi");
        content = this.getRandomString();
        this.createFile(filter_pool2_xml, content);
        IFileStore ibm_files_aix = Filters.getChild("ibm.files.aix");
        this.createDir(ibm_files_aix, true);
        IFileStore filter_pool3 = ibm_files_aix.getChild("FilterPool_Team Filter Pool");
        this.createDir(filter_pool3, true);
        IFileStore filter_pool3_xml = filter_pool3.getChild("filterPool_Team Filter Pool.xmi");
        content = this.getRandomString();
        this.createFile(filter_pool3_xml, content);
        IFileStore ibm_iles_powerlinux = Filters.getChild("ibm.files.powerlinux");
        this.createDir(ibm_iles_powerlinux, true);
        IFileStore filter_pool4 = ibm_iles_powerlinux.getChild("FilterPool_Team Filter Pool");
        this.createDir(filter_pool4, true);
        IFileStore filter_pool4_xml = filter_pool4.getChild("filterPool_Team Filter Pool.xmi");
        content = this.getRandomString();
        this.createFile(filter_pool4_xml, content);
        IFileStore ibm_files400 = Filters.getChild("ibm.files400");
        this.createDir(ibm_files400, true);
        IFileStore filter_pool5 = ibm_files400.getChild("FilterPool_Team Filter Pool");
        this.createDir(filter_pool5, true);
        IFileStore filter_pool5_xml = filter_pool5.getChild("filterPool_Team Filter Pool.xmi");
        content = this.getRandomString();
        this.createFile(filter_pool5_xml, content);
        IFileStore ibm_filesLocal = Filters.getChild("ibm.filesLocal");
        this.createDir(ibm_filesLocal, true);
        IFileStore filter_pool6 = ibm_filesLocal.getChild("FilterPool_Team Filter Pool");
        this.createDir(filter_pool6, true);
        IFileStore filter_pool6_xml = filter_pool6.getChild("filterPool_Team Filter Pool.xmi");
        content = this.getRandomString();
        this.createFile(filter_pool6_xml, content);
        IFileStore ibm_filesIFS = Filters.getChild("ibm.filesIFS");
        this.createDir(ibm_filesIFS, true);
        IFileStore filter_pool7 = ibm_filesIFS.getChild("FilterPool_Team Filter Pool");
        this.createDir(filter_pool7, true);
        IFileStore filter_pool7_xml = filter_pool7.getChild("filterPool_Team Filter Pool.xmi");
        content = this.getRandomString();
        this.createFile(filter_pool7_xml, content);
        IFileStore ibm_filesWindows = Filters.getChild("ibm.filesWindows");
        this.createDir(ibm_filesWindows, true);
        IFileStore filter_pool8 = ibm_filesWindows.getChild("FilterPool_Team Filter Pool");
        this.createDir(filter_pool8, true);
        IFileStore filter_pool8_xml = filter_pool8.getChild("filterPool_Team Filter Pool.xmi");
        content = this.getRandomString();
        this.createFile(filter_pool8_xml, content);
        IFileStore ibm_jobs400 = Filters.getChild("ibm.jobs400");
        this.createDir(ibm_jobs400, true);
        IFileStore filter_pool9 = ibm_jobs400.getChild("FilterPool_Team Filter Pool");
        this.createDir(filter_pool9, true);
        IFileStore filter_pool9_xml = filter_pool9.getChild("filterPool_Team Filter Pool.xmi");
        content = this.getRandomString();
        this.createFile(filter_pool9_xml, content);
        IFileStore profile_xml = Team.getChild("profile.xmi");
        content = this.getRandomString();
        this.createFile(profile_xml, content);
        IFileStore TypeFilters = RemoteSystemsConnections.getChild("TypeFilters");
        this.createDir(TypeFilters, true);
        dummyFile = TypeFilters.getChild("dummy.txt");
        content = this.getRandomString();
        this.createFile(dummyFile, content);
        IFileStore xuanchentp = RemoteSystemsConnections.getChild("xuanchentp");
        this.createDir(xuanchentp, true);
        IFileStore Connections1 = xuanchentp.getChild("Connections");
        this.createDir(Connections1, true);
        dummyFile = Connections1.getChild("dummy.txt");
        content = this.getRandomString();
        this.createFile(dummyFile, content);
        IFileStore Filters1 = xuanchentp.getChild("Filters");
        this.createDir(Filters1, true);
        dummyFile = Filters1.getChild("dummy.txt");
        content = this.getRandomString();
        this.createFile(dummyFile, content);
        IFileStore profile_xml1 = xuanchentp.getChild("profile.xmi");
        content = this.getRandomString();
        this.createFile(profile_xml1, content);
        IFileStore compatibility = RemoteSystemsConnections.getChild(".compatibility");
        content = this.getRandomString();
        this.createFile(compatibility, content);
        IFileStore project = RemoteSystemsConnections.getChild(".project");
        this.createFile(project, content);
        IFileStore folder_6YLT5Xa = temp.getChild(this.folderToCopyName2);
        this.createDir(folder_6YLT5Xa, true);
        IFileStore folder_20070315a = folder_6YLT5Xa.getChild("20070315a");
        this.createDir(folder_20070315a, true);
        IFileStore QB5ROUTaadd = folder_20070315a.getChild("QB5ROUTaadd");
        content = this.getRandomString();
        this.createFile(QB5ROUTaadd, content);
        IFileStore folder_20070319 = folder_6YLT5Xa.getChild("20070319");
        this.createDir(folder_20070319, true);
        content = this.getRandomString();
        IFileStore QB5ROUTERa = folder_20070319.getChild("QB5ROUTERa");
        content = this.getRandomString();
        this.createFile(QB5ROUTERa, content);
        IFileStore folder_20070320a = folder_6YLT5Xa.getChild("20070320a");
        this.createDir(folder_20070320a, true);
        IFileStore QB5ROupdfasd = folder_20070320a.getChild("QB5ROupdfasd");
        content = this.getRandomString();
        this.createFile(QB5ROupdfasd, content);
        IFileStore folder_20070404a = folder_6YLT5Xa.getChild("20070404a");
        this.createDir(folder_20070404a, true);
        IFileStore qb5routeraad = folder_20070404a.getChild("qb5routeraad");
        content = this.getRandomString();
        this.createFile(qb5routeraad, content);
        IFileStore dummyFolder = folder_6YLT5Xa.getChild("dummyFolder");
        this.createDir(dummyFolder, true);
        IFileStore folder_20070404a1 = dummyFolder.getChild("20070404a");
        this.createDir(folder_20070404a1, true);
        IFileStore qb5routeraa = folder_20070404a1.getChild("qb5routeraa");
        content = this.getRandomString();
        this.createFile(qb5routeraa, content);
        IFileStore epdcdump01_hex12ab = dummyFolder.getChild("epdcdump01.hex12ab");
        content = this.getRandomString();
        this.createFile(epdcdump01_hex12ab, content);
        IRemoteFile sourceFolderToCopy1 = this.localFss.getRemoteFileObject(String.valueOf(tempPath) + '\\' + this.folderToCopyName1, this.mon);
        IAdaptable iAdaptable = (IAdaptable)sourceFolderToCopy1;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISystemDragDropAdapter srcAdapter1 = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz);
        SystemRemoteResourceSet fromSet = new SystemRemoteResourceSet((ISubSystem)this.localFss, srcAdapter1);
        fromSet.addResource((Object)sourceFolderToCopy1);
        ISystemResourceSet tempObjects1 = srcAdapter1.doDrag(fromSet, this.mon);
        UniversalFileTransferUtility.copyWorkspaceResourcesToRemote((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects1), (IRemoteFile)this.tempDir, (IProgressMonitor)this.mon, (boolean)true);
        IRemoteFile sourceFolderToCopy2 = this.localFss.getRemoteFileObject(String.valueOf(tempPath) + '\\' + this.folderToCopyName2, this.mon);
        IAdaptable iAdaptable2 = (IAdaptable)sourceFolderToCopy2;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISystemDragDropAdapter srcAdapter2 = (ISystemDragDropAdapter)iAdaptable2.getAdapter((Class)clazz2);
        SystemRemoteResourceSet fromSet2 = new SystemRemoteResourceSet((ISubSystem)this.localFss, srcAdapter2);
        fromSet2.addResource((Object)sourceFolderToCopy2);
        ISystemResourceSet tempObjects2 = srcAdapter2.doDrag(fromSet2, this.mon);
        UniversalFileTransferUtility.copyWorkspaceResourcesToRemote((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects2), (IRemoteFile)this.tempDir, (IProgressMonitor)this.mon, (boolean)true);
        IRemoteFile zipSource1 = this.createFileOrFolder(this.tempDir.getAbsolutePath(), this.zipSourceFileName1, false);
        FileServiceArchiveTest.assertNotNull((Object)zipSource1);
        IRemoteFile zipSourceFolder = (IRemoteFile)this.getChildFromFolder(this.tempDir, this.folderToCopyName1);
        this.fss.copy(zipSourceFolder, zipSource1, this.folderToCopyName1, this.mon);
        IRemoteFile zipSource2 = this.createFileOrFolder(this.tempDir.getAbsolutePath(), this.zipSourceFileName2, false);
        FileServiceArchiveTest.assertNotNull((Object)zipSource2);
        IRemoteFile zipSourceFolder2 = (IRemoteFile)this.getChildFromFolder(this.tempDir, this.folderToCopyName2);
        this.fss.copy(zipSourceFolder2, zipSource2, this.folderToCopyName2, this.mon);
        this.fss.resolveFilterString((Object)this.tempDir, null, this.mon);
        temp.delete(0, this.mon);
    }

    protected void createSuperTransferFolder(IFileStore temp) throws Exception {
        String content = this.getRandomString();
        IFileStore folderToCopy = temp.getChild(this.folderToCopyName3);
        this.createDir(folderToCopy, true);
        IFileStore aaaaaaaa = folderToCopy.getChild("aaaaaaaa");
        this.createDir(aaaaaaaa, true);
        IFileStore adsf = aaaaaaaa.getChild("adsf");
        content = this.getRandomString();
        this.createFile(adsf, content);
        IFileStore eclipse_SDK_3_3M6_win32_zip = aaaaaaaa.getChild("eclipse-SDK-3.3M6-win32.zip");
        this.createFile(eclipse_SDK_3_3M6_win32_zip, "");
        IFileStore epdcdump01_hex12 = aaaaaaaa.getChild("epdcdump01.hex12");
        content = this.getRandomString();
        this.createFile(epdcdump01_hex12, content);
        IFileStore epdcdump01_hex12aaaa = aaaaaaaa.getChild("epdcdump01.hex12aaaa");
        content = this.getRandomString();
        this.createFile(epdcdump01_hex12aaaa, content);
        IFileStore aaaab = folderToCopy.getChild("aaaab");
        this.createDir(aaaab, true);
        IFileStore features = aaaab.getChild("features");
        this.createDir(features, true);
        IFileStore dummyFile = features.getChild("dummy.txt");
        content = this.getRandomString();
        this.createFile(dummyFile, content);
        content = "this is just a simple content \n to a simple file \n to test a 'simple' copy";
        IFileStore epdcdump01_hex12a = aaaab.getChild("epdcdump01.hex12a");
        content = this.getRandomString();
        this.createFile(epdcdump01_hex12a, content);
        IFileStore epdcdump01_hex12a1 = folderToCopy.getChild("epdcdump01.hex12a");
        content = this.getRandomString();
        this.createFile(epdcdump01_hex12a1, content);
        IFileStore RSE_SDK_2_0RC1_zip = folderToCopy.getChild("RSE-SDK-2.0RC1.zip");
        content = this.getRandomString();
        this.createFile(RSE_SDK_2_0RC1_zip, content);
    }

    public void createTarSourceForOpen() throws Exception {
        String tempPath = FileServiceArchiveTest.getWorkspace().getRoot().getLocation().append("temp").toString();
        IFileStore temp = this.createDir(tempPath, true);
        String content = this.getRandomString();
        IFileStore META_INF = temp.getChild(this.tarSourceForOpenFolderName1);
        this.createDir(META_INF, true);
        IFileStore MANIFEST_MF = META_INF.getChild("MANIFEST.MF");
        content = this.fileContentString1;
        this.createFile(MANIFEST_MF, content);
        IFileStore org = temp.getChild("org");
        this.createDir(org, true);
        IFileStore eclipse = org.getChild("eclipse");
        this.createDir(eclipse, true);
        IFileStore dstore = eclipse.getChild("dstore");
        this.createDir(dstore, true);
        IFileStore core = dstore.getChild("core");
        this.createDir(core, true);
        IFileStore internal = dstore.getChild("internal");
        this.createDir(internal, true);
        IFileStore client = core.getChild("client");
        this.createDir(client, true);
        IFileStore java = core.getChild("java");
        this.createDir(java, true);
        IFileStore miners = core.getChild("miners");
        this.createDir(miners, true);
        IFileStore model = core.getChild("model");
        this.createDir(model, true);
        IFileStore server = core.getChild("server");
        this.createDir(server, true);
        IFileStore util = core.getChild("util");
        this.createDir(util, true);
        IFileStore Activator_java = core.getChild("Activator.java");
        content = this.fileContentString1;
        this.createFile(Activator_java, content);
        IFileStore ClientConnection_java = client.getChild("ClientConnection.java");
        content = this.getRandomString();
        this.createFile(ClientConnection_java, content);
        IFileStore ConnectionStatus_java = client.getChild("ConnectionStatus.java");
        content = this.fileContentString1;
        this.createFile(ConnectionStatus_java, content);
        IFileStore ClassByteStreamHandler$ReceiveClassInstanceThread_java = java.getChild("ClassByteStreamHandler$ReceiveClassInstanceThread.java");
        content = this.getRandomString();
        this.createFile(ClassByteStreamHandler$ReceiveClassInstanceThread_java, content);
        IFileStore Miner_java = miners.getChild("Miner.java");
        content = this.getRandomString();
        this.createFile(Miner_java, content);
        IFileStore MinerThread_java = miners.getChild("MinerThread.java");
        content = this.getRandomString();
        this.createFile(MinerThread_java, content);
        IFileStore ByteStreamHandler_java = model.getChild("ByteStreamHandler.java");
        content = this.getRandomString();
        this.createFile(ByteStreamHandler_java, content);
        IFileStore DE_java = model.getChild("DE.java");
        content = this.getRandomString();
        this.createFile(DE_java, content);
        IFileStore Handler_java = model.getChild("Handler.java");
        content = this.getRandomString();
        this.createFile(Handler_java, content);
        IFileStore Server_java = server.getChild("Server.java");
        content = this.getRandomString();
        this.createFile(Server_java, content);
        IFileStore StringCompare_java = util.getChild("StringCompare.java");
        content = this.fileContentString1;
        this.createFile(StringCompare_java, content);
        IFileStore core1 = internal.getChild("core");
        this.createDir(core1, true);
        IFileStore client1 = core1.getChild("client");
        this.createDir(client1, true);
        IFileStore model1 = core1.getChild("model");
        this.createDir(model1, true);
        IFileStore server1 = core1.getChild("server");
        this.createDir(server1, true);
        IFileStore util1 = core1.getChild("util");
        this.createDir(util1, true);
        IFileStore ClientConnection_java1 = client1.getChild("ClientConnection.java");
        content = this.getRandomString();
        this.createFile(ClientConnection_java1, content);
        IFileStore ConnectionStatus_java1 = client1.getChild("ConnectionStatus.java");
        content = this.getRandomString();
        this.createFile(ConnectionStatus_java1, content);
        IFileStore ByteStreamHandler_java1 = model1.getChild("ByteStreamHandler.java");
        content = this.getRandomString();
        this.createFile(ByteStreamHandler_java1, content);
        IFileStore DE_java1 = model1.getChild("DE.java");
        content = this.getRandomString();
        this.createFile(DE_java1, content);
        IFileStore Handler_java1 = model1.getChild("Handler.java");
        content = this.getRandomString();
        this.createFile(Handler_java1, content);
        IFileStore Server_java1 = server1.getChild("Server.java");
        content = this.getRandomString();
        this.createFile(Server_java1, content);
        IFileStore StringCompare_java1 = util1.getChild("StringCompare.java");
        content = this.getRandomString();
        this.createFile(StringCompare_java1, content);
        IRemoteFile META_INF_folder = this.localFss.getRemoteFileObject(String.valueOf(tempPath) + '\\' + this.tarSourceForOpenFolderName1, this.mon);
        FileServiceArchiveTest.assertNotNull((Object)META_INF_folder);
        IAdaptable iAdaptable = (IAdaptable)META_INF_folder;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISystemDragDropAdapter srcAdapter1 = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz);
        SystemRemoteResourceSet fromSet = new SystemRemoteResourceSet((ISubSystem)this.localFss, srcAdapter1);
        fromSet.addResource((Object)META_INF_folder);
        ISystemResourceSet tempObjects1 = srcAdapter1.doDrag(fromSet, this.mon);
        UniversalFileTransferUtility.copyWorkspaceResourcesToRemote((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects1), (IRemoteFile)this.tempDir, (IProgressMonitor)this.mon, (boolean)true);
        IRemoteFile org_folder = this.localFss.getRemoteFileObject(String.valueOf(tempPath) + '\\' + this.tarSourceForOpenFolderName2, this.mon);
        FileServiceArchiveTest.assertNotNull((Object)org_folder);
        IAdaptable iAdaptable2 = (IAdaptable)org_folder;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISystemDragDropAdapter srcAdapter2 = (ISystemDragDropAdapter)iAdaptable2.getAdapter((Class)clazz2);
        SystemRemoteResourceSet fromSet2 = new SystemRemoteResourceSet((ISubSystem)this.localFss, srcAdapter2);
        fromSet2.addResource((Object)org_folder);
        ISystemResourceSet tempObjects2 = srcAdapter2.doDrag(fromSet2, this.mon);
        UniversalFileTransferUtility.copyWorkspaceResourcesToRemote((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects2), (IRemoteFile)this.tempDir, (IProgressMonitor)this.mon, (boolean)true);
        IRemoteFile tarSource = this.createFileOrFolder(this.tempDir.getAbsolutePath(), this.tarSourceForOpenTest, false);
        FileServiceArchiveTest.assertNotNull((Object)tarSource);
        IRemoteFile tarSourceFolder1 = (IRemoteFile)this.getChildFromFolder(this.tempDir, this.tarSourceForOpenFolderName1);
        FileServiceArchiveTest.assertNotNull((Object)tarSourceFolder1);
        IRemoteFile tarSourceFolder2 = (IRemoteFile)this.getChildFromFolder(this.tempDir, this.tarSourceForOpenFolderName2);
        this.fss.copy(tarSourceFolder1, tarSource, this.tarSourceForOpenFolderName1, this.mon);
        this.fss.copy(tarSourceFolder2, tarSource, this.tarSourceForOpenFolderName2, this.mon);
        this.fss.resolveFilterString((Object)this.tempDir, null, this.mon);
        temp.delete(0, this.mon);
    }

    public void testCreateZipFile() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        String testName = "dummy.zip";
        IRemoteFile newArchiveFile = this.createFileOrFolder(this.tempDirPath, testName, false);
        FileServiceArchiveTest.assertNotNull((Object)newArchiveFile);
        FileServiceArchiveTest.assertTrue((boolean)newArchiveFile.exists());
        FileServiceArchiveTest.assertTrue((boolean)newArchiveFile.canRead());
        FileServiceArchiveTest.assertTrue((boolean)newArchiveFile.canWrite());
        FileServiceArchiveTest.assertEquals((String)newArchiveFile.getName(), (String)testName);
        String childName = "aaa.txt";
        IRemoteFile file1 = this.createFileOrFolder(newArchiveFile.getAbsolutePath(), childName, false);
        FileServiceArchiveTest.assertNotNull((Object)file1);
        childName = "bbb.txt";
        IRemoteFile file2 = this.createFileOrFolder(newArchiveFile.getAbsolutePath(), childName, false);
        FileServiceArchiveTest.assertNotNull((Object)file2);
        childName = "folder1";
        IRemoteFile folder1 = this.createFileOrFolder(newArchiveFile.getAbsolutePath(), childName, true);
        FileServiceArchiveTest.assertNotNull((Object)folder1);
        String[] namesToCheck = new String[]{"aaa.txt", "bbb.txt", "folder1"};
        int[] typesToCheck = new int[]{TYPE_FILE, TYPE_FILE, TYPE_FOLDER};
        this.checkFolderContents(newArchiveFile, namesToCheck, typesToCheck);
        String secondLevelChildName = "ccc.exe";
        IRemoteFile levelTwoChild1 = this.createFileOrFolder(folder1.getAbsolutePath(), secondLevelChildName, false);
        FileServiceArchiveTest.assertNotNull((Object)levelTwoChild1);
        secondLevelChildName = "ddd.bat";
        IRemoteFile levelTwoChild2 = this.createFileOrFolder(folder1.getAbsolutePath(), secondLevelChildName, false);
        FileServiceArchiveTest.assertNotNull((Object)levelTwoChild2);
        secondLevelChildName = "another Folder";
        IRemoteFile levelTwoChild3 = this.createFileOrFolder(folder1.getAbsolutePath(), secondLevelChildName, true);
        FileServiceArchiveTest.assertNotNull((Object)levelTwoChild3);
        String[] namesToCheck1 = new String[]{"ccc.exe", "ddd.bat", "another Folder"};
        int[] typesToCheck1 = new int[]{TYPE_FILE, TYPE_FILE, TYPE_FOLDER};
        this.checkFolderContents(folder1, namesToCheck1, typesToCheck1);
    }

    public void testRenameVirtualFile() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        String testName = "dummy.zip";
        IRemoteFile newArchiveFile = this.createFileOrFolder(this.tempDirPath, testName, false);
        String childName = "aaa.txt";
        IRemoteFile file1 = this.createFileOrFolder(newArchiveFile.getAbsolutePath(), childName, false);
        FileServiceArchiveTest.assertNotNull((Object)file1);
        childName = "bbb.txt";
        IRemoteFile file2 = this.createFileOrFolder(newArchiveFile.getAbsolutePath(), childName, false);
        FileServiceArchiveTest.assertNotNull((Object)file2);
        childName = "folder1";
        IRemoteFile folder1 = this.createFileOrFolder(newArchiveFile.getAbsolutePath(), childName, true);
        FileServiceArchiveTest.assertNotNull((Object)folder1);
        String[] levelOneNamesToCheck = new String[]{"aaa.txt", "bbb.txt", "folder1"};
        int[] levalOneTypesToCheck = new int[]{TYPE_FILE, TYPE_FILE, TYPE_FOLDER};
        this.checkFolderContents(newArchiveFile, levelOneNamesToCheck, levalOneTypesToCheck);
        String secondLevelChildName = "ccc.exe";
        IRemoteFile levelTwoChild1 = this.createFileOrFolder(folder1.getAbsolutePath(), secondLevelChildName, false);
        FileServiceArchiveTest.assertNotNull((Object)levelTwoChild1);
        secondLevelChildName = "ddd.bat";
        IRemoteFile levelTwoChild2 = this.createFileOrFolder(folder1.getAbsolutePath(), secondLevelChildName, false);
        FileServiceArchiveTest.assertNotNull((Object)levelTwoChild2);
        secondLevelChildName = "another Folder";
        IRemoteFile levelTwoChild3 = this.createFileOrFolder(folder1.getAbsolutePath(), secondLevelChildName, true);
        FileServiceArchiveTest.assertNotNull((Object)levelTwoChild3);
        String[] levelTwoNamesToCheck = new String[]{"ccc.exe", "ddd.bat", "another Folder"};
        int[] levalTwoTypesToCheck = new int[]{TYPE_FILE, TYPE_FILE, TYPE_FOLDER};
        this.checkFolderContents(folder1, levelTwoNamesToCheck, levalTwoTypesToCheck);
        IRemoteFile childToRename = (IRemoteFile)this.getChildFromFolder(newArchiveFile, "aaa.txt");
        this.fss.rename(childToRename, "aaa1.txt", this.mon);
        childToRename = (IRemoteFile)this.getChildFromFolder(newArchiveFile, "folder1");
        this.fss.rename(childToRename, "folder2", this.mon);
        String[] newLevelOneNamesToCheck = new String[]{"aaa1.txt", "bbb.txt", "folder2"};
        this.checkFolderContents(newArchiveFile, newLevelOneNamesToCheck, levalOneTypesToCheck);
        IRemoteFile thisFolder = (IRemoteFile)this.getChildFromFolder(newArchiveFile, "folder2");
        childToRename = (IRemoteFile)this.getChildFromFolder(thisFolder, "ddd.bat");
        this.fss.rename(childToRename, "ddd1.bat", this.mon);
        childToRename = (IRemoteFile)this.getChildFromFolder(thisFolder, "another Folder");
        this.fss.rename(childToRename, "some folder$", this.mon);
        String[] newLevelTwoNamesToCheck = new String[]{"ccc.exe", "ddd1.bat", "some folder$"};
        this.checkFolderContents(thisFolder, newLevelTwoNamesToCheck, levalTwoTypesToCheck);
    }

    public void testMoveVirtualFile() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createSourceZipFiles();
        String folderName = "folder1";
        IRemoteFile folder1 = this.createFileOrFolder(this.tempDirPath, folderName, true);
        FileServiceArchiveTest.assertNotNull((Object)folder1);
        String sourceZipFileName = this.zipSourceFileName1;
        IRemoteFile sourceZipFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceZipFileName);
        Object[] children = this.fss.resolveFilterString((Object)sourceZipFile, null, this.mon);
        IRemoteFile originalVirtualFolder = (IRemoteFile)children[0];
        String movedFolderName = originalVirtualFolder.getName();
        this.fss.move(originalVirtualFolder, folder1, movedFolderName, this.mon);
        Object movedVirtualFolder = this.getChildFromFolder(folder1, movedFolderName);
        FileServiceArchiveTest.assertNotNull((Object)movedVirtualFolder);
        String[] contents = new String[]{"Team", "TypeFilters", "xuanchentp", ".compatibility", ".project"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE, TYPE_FILE};
        this.checkFolderContents((IRemoteFile)movedVirtualFolder, contents, typesToCheck);
        children = this.fss.resolveFilterString((Object)sourceZipFile, null, this.mon);
        FileServiceArchiveTest.assertTrue((children.length == 0 ? 1 : 0) != 0);
    }

    public void testMoveVirtualFileLevelTwo() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createSourceZipFiles();
        String folderName = "folder1";
        IRemoteFile folder1 = this.createFileOrFolder(this.tempDirPath, folderName, true);
        FileServiceArchiveTest.assertNotNull((Object)folder1);
        String sourceZipFileName = this.zipSourceFileName1;
        IRemoteFile sourceZipFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceZipFileName);
        FileServiceArchiveTest.assertNotNull((Object)sourceZipFile);
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(sourceZipFile, this.folderToCopyName1);
        IRemoteFile secondLevelChild = (IRemoteFile)this.getChildFromFolder(firstLevelChild, "Team");
        String movedFolderName = secondLevelChild.getName();
        this.fss.move(secondLevelChild, folder1, movedFolderName, this.mon);
        Object movedVirtualFolder = this.getChildFromFolder(folder1, movedFolderName);
        FileServiceArchiveTest.assertNotNull((Object)movedVirtualFolder);
        String[] contents = new String[]{"Connections", "Filters", "profile.xmi"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE};
        this.checkFolderContents((IRemoteFile)movedVirtualFolder, contents, typesToCheck);
        Object originalVirtualFolder = this.getChildFromFolder(firstLevelChild, movedFolderName);
        FileServiceArchiveTest.assertNull((Object)originalVirtualFolder);
    }

    public void testMoveToArchiveFile() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createSourceZipFiles();
        this.createSourceFolders();
        String targetZipFileName = this.zipSourceFileName1;
        IRemoteFile targetZipFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, targetZipFileName);
        FileServiceArchiveTest.assertNotNull((Object)targetZipFile);
        String sourceFolderName = this.folderToCopyName3;
        IRemoteFile sourceFolder = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceFolderName);
        FileServiceArchiveTest.assertNotNull((Object)sourceFolder);
        this.fss.move(sourceFolder, targetZipFile, sourceFolder.getName(), this.mon);
        Object theMovedChild = this.getChildFromFolder(targetZipFile, sourceFolderName);
        FileServiceArchiveTest.assertNotNull((Object)theMovedChild);
        String[] childrenToCheck = new String[]{"aaaaaaaa", "aaaab", "epdcdump01.hex12a", "RSE-SDK-2.0RC1.zip"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE, TYPE_FILE};
        this.checkFolderContents((IRemoteFile)theMovedChild, childrenToCheck, typesToCheck);
        IRemoteFile tempDirRemoteFile = this.fss.getRemoteFileObject(this.tempDirPath, this.mon);
        Object originalSource = this.getChildFromFolder(tempDirRemoteFile, sourceFolderName);
        FileServiceArchiveTest.assertNull((Object)originalSource);
    }

    public void testMoveToVirtualFileLevelOne() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createSourceZipFiles();
        this.createSourceFolders();
        String targetZipFileName = this.zipSourceFileName1;
        IRemoteFile targetZipFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, targetZipFileName);
        FileServiceArchiveTest.assertNotNull((Object)targetZipFile);
        String sourceFolderName = this.folderToCopyName3;
        IRemoteFile sourceFolder = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceFolderName);
        FileServiceArchiveTest.assertNotNull((Object)sourceFolder);
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(targetZipFile, this.folderToCopyName1);
        this.fss.move(sourceFolder, firstLevelChild, sourceFolderName, this.mon);
        Object theMovedChild = this.getChildFromFolder(firstLevelChild, sourceFolderName);
        FileServiceArchiveTest.assertNotNull((Object)theMovedChild);
        String[] childrenToCheck = new String[]{"aaaaaaaa", "aaaab", "epdcdump01.hex12a", "RSE-SDK-2.0RC1.zip"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE, TYPE_FILE};
        this.checkFolderContents((IRemoteFile)theMovedChild, childrenToCheck, typesToCheck);
        IRemoteFile tempDirRemoteFile = this.fss.getRemoteFileObject(this.tempDirPath, this.mon);
        Object originalSource = this.getChildFromFolder(tempDirRemoteFile, sourceFolderName);
        FileServiceArchiveTest.assertNull((Object)originalSource);
    }

    public void testMoveToVirtualFileLevelTwo() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createSourceZipFiles();
        this.createSourceFolders();
        String targetZipFileName = this.zipSourceFileName1;
        IRemoteFile targetZipFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, targetZipFileName);
        FileServiceArchiveTest.assertTrue((targetZipFile != null ? 1 : 0) != 0);
        String sourceFolderName = this.folderToCopyName3;
        IRemoteFile sourceFolder = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceFolderName);
        FileServiceArchiveTest.assertTrue((sourceFolder != null ? 1 : 0) != 0);
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(targetZipFile, this.folderToCopyName1);
        IRemoteFile secondLevelChild = (IRemoteFile)this.getChildFromFolder(firstLevelChild, "Team");
        this.fss.move(sourceFolder, secondLevelChild, sourceFolder.getName(), this.mon);
        Object theMovedChild = this.getChildFromFolder(secondLevelChild, sourceFolderName);
        FileServiceArchiveTest.assertNotNull((Object)theMovedChild);
        String[] childrenToCheck = new String[]{"aaaaaaaa", "aaaab", "epdcdump01.hex12a", "RSE-SDK-2.0RC1.zip"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE, TYPE_FILE};
        this.checkFolderContents((IRemoteFile)theMovedChild, childrenToCheck, typesToCheck);
        IRemoteFile tempDirRemoteFile = this.fss.getRemoteFileObject(this.tempDirPath, this.mon);
        Object originalSource = this.getChildFromFolder(tempDirRemoteFile, sourceFolderName);
        FileServiceArchiveTest.assertNull((Object)originalSource);
    }

    public void testCopyVirtualFile() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createSourceZipFiles();
        String sourceZipFileName = this.zipSourceFileName1;
        IRemoteFile sourceZipFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceZipFileName);
        FileServiceArchiveTest.assertNotNull((Object)sourceZipFile);
        String folderName = "folder1";
        IRemoteFile folder1 = this.createFileOrFolder(this.tempDirPath, folderName, true);
        FileServiceArchiveTest.assertNotNull((Object)folder1);
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(sourceZipFile, this.folderToCopyName1);
        this.fss.copy(firstLevelChild, folder1, this.folderToCopyName1, this.mon);
        Object copiedVirtualFolder = this.getChildFromFolder(folder1, this.folderToCopyName1);
        FileServiceArchiveTest.assertNotNull((Object)copiedVirtualFolder);
        String[] contents = new String[]{"Team", "TypeFilters", "xuanchentp", ".compatibility", ".project"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE, TYPE_FILE};
        this.checkFolderContents((IRemoteFile)copiedVirtualFolder, contents, typesToCheck);
    }

    public void testCopyVirtualFileLevelTwo() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createSourceZipFiles();
        String sourceZipFileName = this.zipSourceFileName1;
        IRemoteFile sourceZipFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceZipFileName);
        FileServiceArchiveTest.assertNotNull((Object)sourceZipFile);
        String folderName = "folder1";
        IRemoteFile folder1 = this.createFileOrFolder(this.tempDirPath, folderName, true);
        FileServiceArchiveTest.assertNotNull((Object)folder1);
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(sourceZipFile, this.folderToCopyName1);
        IRemoteFile secondLevelChild = (IRemoteFile)this.getChildFromFolder(firstLevelChild, "Team");
        this.fss.copy(secondLevelChild, folder1, secondLevelChild.getName(), this.mon);
        Object copiedVirtualFolder = this.getChildFromFolder(folder1, secondLevelChild.getName());
        FileServiceArchiveTest.assertNotNull((Object)copiedVirtualFolder);
        String[] contents = new String[]{"Connections", "Filters", "profile.xmi"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE};
        this.checkFolderContents((IRemoteFile)copiedVirtualFolder, contents, typesToCheck);
    }

    public void testCopyToArchiveFile() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createSourceZipFiles();
        this.createSourceFolders();
        String targetZipFileName = this.zipSourceFileName1;
        IRemoteFile targetZipFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, targetZipFileName);
        FileServiceArchiveTest.assertNotNull((Object)targetZipFile);
        String sourceFolderName = this.folderToCopyName3;
        IRemoteFile sourceFolder = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceFolderName);
        FileServiceArchiveTest.assertNotNull((Object)sourceFolder);
        this.fss.copy(sourceFolder, targetZipFile, sourceFolder.getName(), this.mon);
        Object theCopiedChild = this.getChildFromFolder(targetZipFile, sourceFolderName);
        FileServiceArchiveTest.assertNotNull((Object)theCopiedChild);
        String[] childrenToCheck = new String[]{"aaaaaaaa", "aaaab", "epdcdump01.hex12a", "RSE-SDK-2.0RC1.zip"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE, TYPE_FILE};
        this.checkFolderContents((IRemoteFile)theCopiedChild, childrenToCheck, typesToCheck);
    }

    public void testCopyToVirtualFileLevelOne() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createSourceZipFiles();
        this.createSourceFolders();
        String targetZipFileName = this.zipSourceFileName1;
        IRemoteFile targetZipFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, targetZipFileName);
        FileServiceArchiveTest.assertNotNull((Object)targetZipFile);
        String sourceFolderName = this.folderToCopyName3;
        IRemoteFile sourceFolder = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceFolderName);
        FileServiceArchiveTest.assertNotNull((Object)sourceFolder);
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(targetZipFile, this.folderToCopyName1);
        this.fss.copy(sourceFolder, firstLevelChild, sourceFolder.getName(), this.mon);
        Object theCopiedChild = this.getChildFromFolder(firstLevelChild, sourceFolderName);
        FileServiceArchiveTest.assertNotNull((Object)theCopiedChild);
        String[] childrenToCheck = new String[]{"aaaaaaaa", "aaaab", "epdcdump01.hex12a", "RSE-SDK-2.0RC1.zip"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE, TYPE_FILE};
        this.checkFolderContents((IRemoteFile)theCopiedChild, childrenToCheck, typesToCheck);
    }

    public void testCopyToVirtualFileLevelTwo() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createSourceZipFiles();
        this.createSourceFolders();
        String zipTargetFileName = this.zipSourceFileName1;
        IRemoteFile targetZipFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, zipTargetFileName);
        FileServiceArchiveTest.assertNotNull((Object)targetZipFile);
        String sourceFolderName = this.folderToCopyName3;
        IRemoteFile sourceFolder = (IRemoteFile)this.getChildFromFolder(this.tempDir, this.folderToCopyName3);
        FileServiceArchiveTest.assertNotNull((Object)sourceFolder);
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(targetZipFile, this.folderToCopyName1);
        IRemoteFile secondLevelChild = (IRemoteFile)this.getChildFromFolder(firstLevelChild, "TypeFilters");
        this.fss.copy(sourceFolder, secondLevelChild, sourceFolder.getName(), this.mon);
        Object theCopiedChild = this.getChildFromFolder(secondLevelChild, sourceFolderName);
        FileServiceArchiveTest.assertNotNull((Object)theCopiedChild);
        String[] childrenToCheck = new String[]{"aaaaaaaa", "aaaab", "epdcdump01.hex12a", "RSE-SDK-2.0RC1.zip"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE, TYPE_FILE};
        this.checkFolderContents((IRemoteFile)theCopiedChild, childrenToCheck, typesToCheck);
    }

    public void testCopyBatchToArchiveFile() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createSourceZipFiles();
        this.createSourceFolders();
        String zipTargetFileName = this.zipSourceFileName1;
        IRemoteFile targetZipFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, zipTargetFileName);
        FileServiceArchiveTest.assertNotNull((Object)targetZipFile);
        String sourceFolderName = this.folderToCopyName3;
        IRemoteFile sourceFolder = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceFolderName);
        FileServiceArchiveTest.assertNotNull((Object)sourceFolder);
        IRemoteFile[] sourceFiles = new IRemoteFile[3];
        String childToCopyName1 = "aaaaaaaa";
        sourceFiles[0] = (IRemoteFile)this.getChildFromFolder(sourceFolder, childToCopyName1);
        String childToCopyName2 = "aaaab";
        sourceFiles[1] = (IRemoteFile)this.getChildFromFolder(sourceFolder, childToCopyName2);
        String childToCopyName3 = "epdcdump01.hex12a";
        sourceFiles[2] = (IRemoteFile)this.getChildFromFolder(sourceFolder, childToCopyName3);
        this.fss.copyBatch(sourceFiles, targetZipFile, this.mon);
        Object theCopiedChild = this.getChildFromFolder(targetZipFile, childToCopyName1);
        FileServiceArchiveTest.assertNotNull((Object)theCopiedChild);
        String[] childrenToCheck1 = new String[]{"adsf", "eclipse-SDK-3.3M6-win32.zip", "epdcdump01.hex12", "epdcdump01.hex12aaaa"};
        int[] typesToCheck1 = new int[]{TYPE_FILE, TYPE_FILE, TYPE_FILE, TYPE_FILE};
        this.checkFolderContents((IRemoteFile)theCopiedChild, childrenToCheck1, typesToCheck1);
        theCopiedChild = this.getChildFromFolder(targetZipFile, childToCopyName2);
        FileServiceArchiveTest.assertNotNull((Object)theCopiedChild);
        String[] childrenToCheck2 = new String[]{"features"};
        int[] typesToCheck2 = new int[]{TYPE_FOLDER};
        this.checkFolderContents((IRemoteFile)theCopiedChild, childrenToCheck2, typesToCheck2);
        theCopiedChild = this.getChildFromFolder(targetZipFile, childToCopyName3);
        FileServiceArchiveTest.assertNotNull((Object)theCopiedChild);
        FileServiceArchiveTest.assertTrue((!((IRemoteFile)theCopiedChild).isDirectory() ? 1 : 0) != 0);
    }

    public void testCopyBatchToVirtualFileLevelOne() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createSourceZipFiles();
        this.createSourceFolders();
        String zipTargetFileName = this.zipSourceFileName1;
        IRemoteFile targetZipFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, zipTargetFileName);
        FileServiceArchiveTest.assertNotNull((Object)targetZipFile);
        String sourceFolderName = this.folderToCopyName3;
        IRemoteFile sourceFolder = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceFolderName);
        FileServiceArchiveTest.assertNotNull((Object)sourceFolder);
        Object[] childrenOfTargetZipFile = this.fss.resolveFilterString((Object)targetZipFile, null, this.mon);
        IRemoteFile[] sourceFiles = new IRemoteFile[]{sourceFolder};
        this.fss.copyBatch(sourceFiles, (IRemoteFile)childrenOfTargetZipFile[0], this.mon);
        Object theCopiedChild = this.getChildFromFolder((IRemoteFile)childrenOfTargetZipFile[0], sourceFolderName);
        FileServiceArchiveTest.assertNotNull((Object)theCopiedChild);
        String[] childrenToCheck = new String[]{"aaaaaaaa", "aaaab", "epdcdump01.hex12a", "RSE-SDK-2.0RC1.zip"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE, TYPE_FILE};
        this.checkFolderContents((IRemoteFile)theCopiedChild, childrenToCheck, typesToCheck);
    }

    public void testCopyBatchToVirtualFileLevelTwo() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createSourceZipFiles();
        this.createSourceFolders();
        String zipTargetFileName = this.zipSourceFileName1;
        IRemoteFile targetZipFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, zipTargetFileName);
        FileServiceArchiveTest.assertNotNull((Object)targetZipFile);
        String sourceFolderName = this.folderToCopyName3;
        IRemoteFile sourceFolder = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceFolderName);
        FileServiceArchiveTest.assertNotNull((Object)sourceFolder);
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(targetZipFile, this.folderToCopyName1);
        IRemoteFile secondLevelChild = (IRemoteFile)this.getChildFromFolder(firstLevelChild, "TypeFilters");
        IRemoteFile[] sourceFiles = new IRemoteFile[3];
        String childToCopyName1 = "aaaaaaaa";
        sourceFiles[0] = (IRemoteFile)this.getChildFromFolder(sourceFolder, childToCopyName1);
        String childToCopyName2 = "aaaab";
        sourceFiles[1] = (IRemoteFile)this.getChildFromFolder(sourceFolder, childToCopyName2);
        String childToCopyName3 = "epdcdump01.hex12a";
        sourceFiles[2] = (IRemoteFile)this.getChildFromFolder(sourceFolder, childToCopyName3);
        this.fss.copyBatch(sourceFiles, secondLevelChild, this.mon);
        Object theCopiedChild = this.getChildFromFolder(secondLevelChild, childToCopyName1);
        FileServiceArchiveTest.assertNotNull((Object)theCopiedChild);
        String[] childrenToCheck1 = new String[]{"adsf", "eclipse-SDK-3.3M6-win32.zip", "epdcdump01.hex12", "epdcdump01.hex12aaaa"};
        int[] typesToCheck1 = new int[]{TYPE_FILE, TYPE_FILE, TYPE_FILE, TYPE_FILE};
        this.checkFolderContents((IRemoteFile)theCopiedChild, childrenToCheck1, typesToCheck1);
        theCopiedChild = this.getChildFromFolder(secondLevelChild, childToCopyName2);
        FileServiceArchiveTest.assertNotNull((Object)theCopiedChild);
        String[] childrenToCheck2 = new String[]{"features"};
        int[] typesToCheck2 = new int[]{TYPE_FOLDER};
        this.checkFolderContents((IRemoteFile)theCopiedChild, childrenToCheck2, typesToCheck2);
        theCopiedChild = this.getChildFromFolder(secondLevelChild, childToCopyName3);
        FileServiceArchiveTest.assertNotNull((Object)theCopiedChild);
        FileServiceArchiveTest.assertTrue((!((IRemoteFile)theCopiedChild).isDirectory() ? 1 : 0) != 0);
    }

    public void testCopyBatchVirtualFile() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createSourceZipFiles();
        String sourceFileName = this.zipSourceFileName1;
        IRemoteFile sourceZipFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceFileName);
        FileServiceArchiveTest.assertNotNull((Object)sourceZipFile);
        String folderName = "folder1";
        IRemoteFile folder1 = this.createFileOrFolder(this.tempDirPath, folderName, true);
        FileServiceArchiveTest.assertNotNull((Object)folder1);
        Object[] children = this.fss.resolveFilterString((Object)sourceZipFile, null, this.mon);
        IRemoteFile[] sourceFiles = new IRemoteFile[3];
        String childToCopyName1 = "Team";
        sourceFiles[0] = (IRemoteFile)this.getChildFromFolder((IRemoteFile)children[0], childToCopyName1);
        FileServiceArchiveTest.assertNotNull((Object)sourceFiles[0]);
        String childToCopyName2 = "xuanchentp";
        sourceFiles[1] = (IRemoteFile)this.getChildFromFolder((IRemoteFile)children[0], childToCopyName2);
        FileServiceArchiveTest.assertNotNull((Object)sourceFiles[1]);
        String childToCopyName3 = ".compatibility";
        sourceFiles[2] = (IRemoteFile)this.getChildFromFolder((IRemoteFile)children[0], childToCopyName3);
        FileServiceArchiveTest.assertNotNull((Object)sourceFiles[2]);
        this.fss.copyBatch(sourceFiles, folder1, this.mon);
        Object copiedVirtualFolder = this.getChildFromFolder(folder1, childToCopyName1);
        FileServiceArchiveTest.assertNotNull((Object)copiedVirtualFolder);
        String[] contents1 = new String[]{"Connections", "Filters", "profile.xmi"};
        int[] typesToCheck1 = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE};
        this.checkFolderContents((IRemoteFile)copiedVirtualFolder, contents1, typesToCheck1);
        copiedVirtualFolder = this.getChildFromFolder(folder1, childToCopyName2);
        FileServiceArchiveTest.assertNotNull((Object)copiedVirtualFolder);
        String[] contents2 = new String[]{"Connections", "Filters", "profile.xmi"};
        int[] typesToCheck2 = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE};
        this.checkFolderContents((IRemoteFile)copiedVirtualFolder, contents2, typesToCheck2);
        Object copiedVirtualFile = this.getChildFromFolder(folder1, childToCopyName3);
        FileServiceArchiveTest.assertNotNull((Object)copiedVirtualFile);
        FileServiceArchiveTest.assertTrue((!((IRemoteFile)copiedVirtualFile).isDirectory() ? 1 : 0) != 0);
    }

    public void testCopyBatchVirtualFileLevelTwo() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createSourceZipFiles();
        String sourceFileName = this.zipSourceFileName1;
        IRemoteFile sourceZipFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceFileName);
        FileServiceArchiveTest.assertNotNull((Object)sourceZipFile);
        String folderName = "folder1";
        IRemoteFile folder1 = this.createFileOrFolder(this.tempDirPath, folderName, true);
        FileServiceArchiveTest.assertNotNull((Object)folder1);
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(sourceZipFile, this.folderToCopyName1);
        IRemoteFile secondLevelChild = (IRemoteFile)this.getChildFromFolder(firstLevelChild, "Team");
        IRemoteFile[] sourceFiles = new IRemoteFile[]{secondLevelChild};
        this.fss.copyBatch(sourceFiles, folder1, this.mon);
        Object copiedVirtualFolder = this.getChildFromFolder(folder1, secondLevelChild.getName());
        FileServiceArchiveTest.assertNotNull((Object)copiedVirtualFolder);
        String[] contents = new String[]{"Connections", "Filters", "profile.xmi"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE};
        this.checkFolderContents((IRemoteFile)copiedVirtualFolder, contents, typesToCheck);
    }

    public void testCopyVirtualBatchToArchiveFile() throws Exception {
        IRemoteFile virtualFolderToCopy;
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createSourceZipFiles();
        String zipTargetFileName = this.zipSourceFileName1;
        IRemoteFile targetZipFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, zipTargetFileName);
        FileServiceArchiveTest.assertNotNull((Object)targetZipFile);
        String sourcefileName = this.zipSourceFileName2;
        IRemoteFile sourceFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourcefileName);
        FileServiceArchiveTest.assertNotNull((Object)sourceFile);
        IRemoteFile[] sourceFiles = new IRemoteFile[1];
        String virutalFolderToCopyName = "6YLT5Xa";
        sourceFiles[0] = virtualFolderToCopy = (IRemoteFile)this.getChildFromFolder(sourceFile, virutalFolderToCopyName);
        this.fss.copyBatch(sourceFiles, targetZipFile, this.mon);
        Object theCopiedChild = this.getChildFromFolder(targetZipFile, virutalFolderToCopyName);
        FileServiceArchiveTest.assertNotNull((Object)theCopiedChild);
        String[] childrenToCheck = new String[]{"20070315a", "20070319", "20070320a", "20070404a", "dummyFolder"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FOLDER, TYPE_FOLDER, TYPE_FOLDER};
        this.checkFolderContents((IRemoteFile)theCopiedChild, childrenToCheck, typesToCheck);
    }

    public void testCopyVirtualBatchToVirtualFileLevelOne() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createSourceZipFiles();
        String zipTargetFileName = this.zipSourceFileName1;
        IRemoteFile targetZipFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, zipTargetFileName);
        FileServiceArchiveTest.assertNotNull((Object)targetZipFile);
        String sourcefileName = this.zipSourceFileName2;
        IRemoteFile sourceFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourcefileName);
        FileServiceArchiveTest.assertNotNull((Object)sourceFile);
        Object[] childrenOfTargetZipFile = this.fss.resolveFilterString((Object)targetZipFile, null, this.mon);
        IRemoteFile[] sourceFiles = new IRemoteFile[3];
        String parentOfVirutalFolderToCopyName = "6YLT5Xa";
        IRemoteFile parentOfVirtualFolderToCopy = (IRemoteFile)this.getChildFromFolder(sourceFile, parentOfVirutalFolderToCopyName);
        String virtualChildToCopyName1 = "20070315a";
        String virtualChildToCopyName2 = "20070319";
        String virtualChildToCopyName3 = "dummyFolder";
        sourceFiles[0] = (IRemoteFile)this.getChildFromFolder(parentOfVirtualFolderToCopy, virtualChildToCopyName1);
        FileServiceArchiveTest.assertNotNull((Object)sourceFiles[0]);
        sourceFiles[1] = (IRemoteFile)this.getChildFromFolder(parentOfVirtualFolderToCopy, virtualChildToCopyName2);
        FileServiceArchiveTest.assertNotNull((Object)sourceFiles[1]);
        sourceFiles[2] = (IRemoteFile)this.getChildFromFolder(parentOfVirtualFolderToCopy, virtualChildToCopyName3);
        FileServiceArchiveTest.assertNotNull((Object)sourceFiles[2]);
        this.fss.copyBatch(sourceFiles, (IRemoteFile)childrenOfTargetZipFile[0], this.mon);
        Object theCopiedChild = this.getChildFromFolder((IRemoteFile)childrenOfTargetZipFile[0], virtualChildToCopyName1);
        FileServiceArchiveTest.assertNotNull((Object)theCopiedChild);
        String[] childrenToCheck1 = new String[]{"QB5ROUTaadd"};
        int[] typesToCheck1 = new int[]{TYPE_FILE};
        this.checkFolderContents((IRemoteFile)theCopiedChild, childrenToCheck1, typesToCheck1);
        theCopiedChild = this.getChildFromFolder((IRemoteFile)childrenOfTargetZipFile[0], virtualChildToCopyName2);
        FileServiceArchiveTest.assertNotNull((Object)theCopiedChild);
        String[] childrenToCheck2 = new String[]{"QB5ROUTERa"};
        int[] typesToCheck2 = new int[]{TYPE_FILE};
        this.checkFolderContents((IRemoteFile)theCopiedChild, childrenToCheck2, typesToCheck2);
        theCopiedChild = this.getChildFromFolder((IRemoteFile)childrenOfTargetZipFile[0], virtualChildToCopyName3);
        FileServiceArchiveTest.assertNotNull((Object)theCopiedChild);
        String[] childrenToCheck3 = new String[]{"20070404a", "epdcdump01.hex12ab"};
        int[] typesToCheck3 = new int[]{TYPE_FOLDER, TYPE_FILE};
        this.checkFolderContents((IRemoteFile)theCopiedChild, childrenToCheck3, typesToCheck3);
    }

    public void testCopyVirtualBatchToVirtualFileLevelTwo() throws Exception {
        IRemoteFile virtualFolderToCopy;
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createSourceZipFiles();
        String zipTargetFileName = this.zipSourceFileName1;
        IRemoteFile targetZipFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, zipTargetFileName);
        FileServiceArchiveTest.assertNotNull((Object)targetZipFile);
        String sourcefileName = this.zipSourceFileName2;
        IRemoteFile sourceFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourcefileName);
        FileServiceArchiveTest.assertNotNull((Object)sourceFile);
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(targetZipFile, this.folderToCopyName1);
        IRemoteFile secondLevelChild = (IRemoteFile)this.getChildFromFolder(firstLevelChild, "TypeFilters");
        IRemoteFile[] sourceFiles = new IRemoteFile[1];
        String parentOfVirutalFolderToCopyName = "6YLT5Xa";
        IRemoteFile parentOfVirtualFolderToCopy = (IRemoteFile)this.getChildFromFolder(sourceFile, parentOfVirutalFolderToCopyName);
        String virtualFolderToCopyName = "dummyFolder";
        sourceFiles[0] = virtualFolderToCopy = (IRemoteFile)this.getChildFromFolder(parentOfVirtualFolderToCopy, virtualFolderToCopyName);
        this.fss.copyBatch(sourceFiles, secondLevelChild, this.mon);
        Object theCopiedChild = this.getChildFromFolder(parentOfVirtualFolderToCopy, virtualFolderToCopyName);
        FileServiceArchiveTest.assertNotNull((Object)theCopiedChild);
        String[] childrenToCheck = new String[]{"20070404a", "epdcdump01.hex12ab"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FILE};
        this.checkFolderContents((IRemoteFile)theCopiedChild, childrenToCheck, typesToCheck);
    }

    public void createSourceTarFiles() throws Exception {
        String tempPath = FileServiceArchiveTest.getWorkspace().getRoot().getLocation().append("temp").toString();
        IFileStore temp = this.createDir(tempPath, true);
        String content = this.getRandomString();
        IFileStore META_INF = temp.getChild(this.tarSourceFolderName1);
        this.createDir(META_INF, true);
        IFileStore MANIFEST_MF = META_INF.getChild("MANIFEST.MF");
        content = this.getRandomString();
        this.createFile(MANIFEST_MF, content);
        IFileStore org = temp.getChild(this.tarSourceFolderName2);
        this.createDir(org, true);
        IFileStore eclipse = org.getChild("eclipse");
        this.createDir(eclipse, true);
        IFileStore dstore = eclipse.getChild("dstore");
        this.createDir(dstore, true);
        IFileStore core = dstore.getChild("core");
        this.createDir(core, true);
        IFileStore internal = dstore.getChild("internal");
        this.createDir(internal, true);
        IFileStore client = core.getChild("client");
        this.createDir(client, true);
        IFileStore java = core.getChild("java");
        this.createDir(java, true);
        IFileStore miners = core.getChild("miners");
        this.createDir(miners, true);
        IFileStore model = core.getChild("model");
        this.createDir(model, true);
        IFileStore server = core.getChild("server");
        this.createDir(server, true);
        IFileStore util = core.getChild("util");
        this.createDir(util, true);
        IFileStore Activator_java = core.getChild("Activator.java");
        content = this.getRandomString();
        this.createFile(Activator_java, content);
        IFileStore ClientConnection_java = client.getChild("ClientConnection.java");
        content = this.getRandomString();
        this.createFile(ClientConnection_java, content);
        IFileStore ConnectionStatus_java = client.getChild("ConnectionStatus.java");
        content = this.getRandomString();
        this.createFile(ConnectionStatus_java, content);
        IFileStore ClassByteStreamHandler$ReceiveClassInstanceThread_java = java.getChild("ClassByteStreamHandler$ReceiveClassInstanceThread.java");
        content = this.getRandomString();
        this.createFile(ClassByteStreamHandler$ReceiveClassInstanceThread_java, content);
        IFileStore Miner_java = miners.getChild("Miner.java");
        content = this.getRandomString();
        this.createFile(Miner_java, content);
        IFileStore MinerThread_java = miners.getChild("MinerThread.java");
        content = this.getRandomString();
        this.createFile(MinerThread_java, content);
        IFileStore ByteStreamHandler_java = model.getChild("ByteStreamHandler.java");
        content = this.getRandomString();
        this.createFile(ByteStreamHandler_java, content);
        IFileStore DE_java = model.getChild("DE.java");
        content = this.getRandomString();
        this.createFile(DE_java, content);
        IFileStore Handler_java = model.getChild("Handler.java");
        content = this.getRandomString();
        this.createFile(Handler_java, content);
        IFileStore Server_java = server.getChild("Server.java");
        content = this.getRandomString();
        this.createFile(Server_java, content);
        IFileStore StringCompare_java = util.getChild("StringCompare.java");
        content = this.getRandomString();
        this.createFile(StringCompare_java, content);
        IFileStore core1 = internal.getChild("core");
        this.createDir(core1, true);
        IFileStore client1 = core1.getChild("client");
        this.createDir(client1, true);
        IFileStore model1 = core1.getChild("model");
        this.createDir(model1, true);
        IFileStore server1 = core1.getChild("server");
        this.createDir(server1, true);
        IFileStore util1 = core1.getChild("util");
        this.createDir(util1, true);
        IFileStore ClientConnection_java1 = client1.getChild("ClientConnection.java");
        content = this.getRandomString();
        this.createFile(ClientConnection_java1, content);
        IFileStore ConnectionStatus_java1 = client1.getChild("ConnectionStatus.java");
        content = this.getRandomString();
        this.createFile(ConnectionStatus_java1, content);
        IFileStore ByteStreamHandler_java1 = model1.getChild("ByteStreamHandler.java");
        content = this.getRandomString();
        this.createFile(ByteStreamHandler_java1, content);
        IFileStore DE_java1 = model1.getChild("DE.java");
        content = this.getRandomString();
        this.createFile(DE_java1, content);
        IFileStore Handler_java1 = model1.getChild("Handler.java");
        content = this.getRandomString();
        this.createFile(Handler_java1, content);
        IFileStore Server_java1 = server1.getChild("Server.java");
        content = this.getRandomString();
        this.createFile(Server_java1, content);
        IFileStore StringCompare_java1 = util1.getChild("StringCompare.java");
        content = this.getRandomString();
        this.createFile(StringCompare_java1, content);
        IRemoteFile META_INF_folder = this.localFss.getRemoteFileObject(String.valueOf(tempPath) + '\\' + this.tarSourceFolderName1, this.mon);
        FileServiceArchiveTest.assertNotNull((Object)META_INF_folder);
        IAdaptable iAdaptable = (IAdaptable)META_INF_folder;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISystemDragDropAdapter srcAdapter1 = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz);
        SystemRemoteResourceSet fromSet = new SystemRemoteResourceSet((ISubSystem)this.localFss, srcAdapter1);
        fromSet.addResource((Object)META_INF_folder);
        ISystemResourceSet tempObjects1 = srcAdapter1.doDrag(fromSet, this.mon);
        UniversalFileTransferUtility.copyWorkspaceResourcesToRemote((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects1), (IRemoteFile)this.tempDir, (IProgressMonitor)this.mon, (boolean)true);
        IRemoteFile org_folder = this.localFss.getRemoteFileObject(String.valueOf(tempPath) + '\\' + this.tarSourceFolderName2, this.mon);
        FileServiceArchiveTest.assertNotNull((Object)org_folder);
        IAdaptable iAdaptable2 = (IAdaptable)org_folder;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISystemDragDropAdapter srcAdapter2 = (ISystemDragDropAdapter)iAdaptable2.getAdapter((Class)clazz2);
        SystemRemoteResourceSet fromSet2 = new SystemRemoteResourceSet((ISubSystem)this.localFss, srcAdapter2);
        fromSet2.addResource((Object)org_folder);
        ISystemResourceSet tempObjects2 = srcAdapter2.doDrag(fromSet2, this.mon);
        UniversalFileTransferUtility.copyWorkspaceResourcesToRemote((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects2), (IRemoteFile)this.tempDir, (IProgressMonitor)this.mon, (boolean)true);
        IRemoteFile tarSource = this.createFileOrFolder(this.tempDir.getAbsolutePath(), this.tarSourceFileName1, false);
        FileServiceArchiveTest.assertNotNull((Object)tarSource);
        IRemoteFile tarSourceFolder1 = (IRemoteFile)this.getChildFromFolder(this.tempDir, this.tarSourceFolderName1);
        FileServiceArchiveTest.assertNotNull((Object)tarSourceFolder1);
        IRemoteFile tarSourceFolder2 = (IRemoteFile)this.getChildFromFolder(this.tempDir, this.tarSourceFolderName2);
        this.fss.copy(tarSourceFolder1, tarSource, this.tarSourceFolderName1, this.mon);
        this.fss.copy(tarSourceFolder2, tarSource, this.tarSourceFolderName2, this.mon);
    }

    public void testCreateTarFile() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        String testName = "dummy.tar";
        IRemoteFile newArchiveFile = this.createFileOrFolder(this.tempDirPath, testName, false);
        FileServiceArchiveTest.assertNotNull((Object)newArchiveFile);
        FileServiceArchiveTest.assertTrue((boolean)newArchiveFile.exists());
        FileServiceArchiveTest.assertTrue((boolean)newArchiveFile.canRead());
        FileServiceArchiveTest.assertTrue((boolean)newArchiveFile.canWrite());
        FileServiceArchiveTest.assertEquals((String)newArchiveFile.getName(), (String)testName);
        FileServiceArchiveTest.assertEquals((String)newArchiveFile.getParentPath(), (String)this.tempDirPath);
        String childName = "aaa.txt";
        IRemoteFile file1 = this.createFileOrFolder(newArchiveFile.getAbsolutePath(), childName, false);
        FileServiceArchiveTest.assertNotNull((Object)file1);
        childName = "bbb.txt";
        IRemoteFile file2 = this.createFileOrFolder(newArchiveFile.getAbsolutePath(), childName, false);
        FileServiceArchiveTest.assertNotNull((Object)file2);
        childName = "folder1";
        IRemoteFile folder1 = this.createFileOrFolder(newArchiveFile.getAbsolutePath(), childName, true);
        FileServiceArchiveTest.assertNotNull((Object)folder1);
        String[] namesToCheck = new String[]{"aaa.txt", "bbb.txt", "folder1"};
        int[] typesToCheck = new int[]{TYPE_FILE, TYPE_FILE, TYPE_FOLDER};
        this.checkFolderContents(newArchiveFile, namesToCheck, typesToCheck);
        String secondLevelChildName = "ccc.exe";
        IRemoteFile levelTwoChild1 = this.createFileOrFolder(folder1.getAbsolutePath(), secondLevelChildName, false);
        FileServiceArchiveTest.assertNotNull((Object)levelTwoChild1);
        secondLevelChildName = "ddd.bat";
        IRemoteFile levelTwoChild2 = this.createFileOrFolder(folder1.getAbsolutePath(), secondLevelChildName, false);
        FileServiceArchiveTest.assertNotNull((Object)levelTwoChild2);
        secondLevelChildName = "another Folder";
        IRemoteFile levelTwoChild3 = this.createFileOrFolder(folder1.getAbsolutePath(), secondLevelChildName, true);
        FileServiceArchiveTest.assertNotNull((Object)levelTwoChild3);
        String[] namesToCheck1 = new String[]{"ccc.exe", "ddd.bat", "another Folder"};
        int[] typesToCheck1 = new int[]{TYPE_FILE, TYPE_FILE, TYPE_FOLDER};
        this.checkFolderContents(folder1, namesToCheck1, typesToCheck1);
    }

    public void testCopyToTarArchiveFile() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createSourceTarFiles();
        this.createSourceFolders();
        String tarTargetFileName = this.tarSourceFileName1;
        IRemoteFile targetTarFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, tarTargetFileName);
        FileServiceArchiveTest.assertNotNull((Object)targetTarFile);
        String sourceFolderName = this.folderToCopyName3;
        IRemoteFile sourceFolder = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceFolderName);
        FileServiceArchiveTest.assertNotNull((Object)sourceFolder);
        this.fss.copy(sourceFolder, targetTarFile, sourceFolder.getName(), this.mon);
        Object theCopiedChild = this.getChildFromFolder(targetTarFile, sourceFolderName);
        FileServiceArchiveTest.assertNotNull((Object)theCopiedChild);
        String[] childrenToCheck = new String[]{"aaaaaaaa", "aaaab", "epdcdump01.hex12a", "RSE-SDK-2.0RC1.zip"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE, TYPE_FILE};
        this.checkFolderContents((IRemoteFile)theCopiedChild, childrenToCheck, typesToCheck);
    }

    public void testCopyToTarVirtualFileLevelOne() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createSourceTarFiles();
        this.createSourceFolders();
        String tarTargetFileName = this.tarSourceFileName1;
        IRemoteFile targetTarFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, tarTargetFileName);
        FileServiceArchiveTest.assertNotNull((Object)targetTarFile);
        String sourceFolderName = this.folderToCopyName3;
        IRemoteFile sourceFolder = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceFolderName);
        FileServiceArchiveTest.assertNotNull((Object)sourceFolder);
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(targetTarFile, "org");
        FileServiceArchiveTest.assertNotNull((Object)firstLevelChild);
        this.fss.copy(sourceFolder, firstLevelChild, sourceFolder.getName(), this.mon);
        Object theCopiedChild = this.getChildFromFolder(firstLevelChild, sourceFolderName);
        FileServiceArchiveTest.assertNotNull((Object)theCopiedChild);
        String[] childrenToCheck = new String[]{"aaaaaaaa", "aaaab", "epdcdump01.hex12a", "RSE-SDK-2.0RC1.zip"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE, TYPE_FILE};
        this.checkFolderContents((IRemoteFile)theCopiedChild, childrenToCheck, typesToCheck);
    }

    public void testCopyToTarVirtualFileLevelFour() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createSourceTarFiles();
        this.createSourceFolders();
        String tarTargetFileName = this.tarSourceFileName1;
        IRemoteFile targetTarFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, tarTargetFileName);
        FileServiceArchiveTest.assertNotNull((Object)targetTarFile);
        String sourceFolderName = this.folderToCopyName3;
        IRemoteFile sourceFolder = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceFolderName);
        FileServiceArchiveTest.assertNotNull((Object)sourceFolder);
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(targetTarFile, "org");
        FileServiceArchiveTest.assertNotNull((Object)firstLevelChild);
        IRemoteFile secondLevelChild = (IRemoteFile)this.getChildFromFolder(firstLevelChild, "eclipse");
        FileServiceArchiveTest.assertNotNull((Object)secondLevelChild);
        IRemoteFile thirdLevelChild = (IRemoteFile)this.getChildFromFolder(secondLevelChild, "dstore");
        FileServiceArchiveTest.assertNotNull((Object)thirdLevelChild);
        IRemoteFile fourLevelChild = (IRemoteFile)this.getChildFromFolder(thirdLevelChild, "core");
        FileServiceArchiveTest.assertNotNull((Object)fourLevelChild);
        this.fss.copy(sourceFolder, fourLevelChild, sourceFolder.getName(), this.mon);
        Object theCopiedChild = this.getChildFromFolder(fourLevelChild, sourceFolderName);
        FileServiceArchiveTest.assertNotNull((Object)theCopiedChild);
        String[] childrenToCheck = new String[]{"aaaaaaaa", "aaaab", "epdcdump01.hex12a", "RSE-SDK-2.0RC1.zip"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE, TYPE_FILE};
        this.checkFolderContents((IRemoteFile)theCopiedChild, childrenToCheck, typesToCheck);
    }

    public void testCopyTarVirtualFile() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createSourceTarFiles();
        String sourceFileName = this.tarSourceFileName1;
        IRemoteFile sourceTarFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceFileName);
        FileServiceArchiveTest.assertNotNull((Object)sourceTarFile);
        String folderName = "folder1";
        IRemoteFile folder1 = this.createFileOrFolder(this.tempDirPath, folderName, true);
        FileServiceArchiveTest.assertNotNull((Object)folder1);
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(sourceTarFile, this.tarSourceFolderName1);
        FileServiceArchiveTest.assertNotNull((Object)firstLevelChild);
        this.fss.copy(firstLevelChild, folder1, this.tarSourceFolderName1, this.mon);
        Object copiedVirtualFolder = this.getChildFromFolder(folder1, this.tarSourceFolderName1);
        FileServiceArchiveTest.assertNotNull((Object)copiedVirtualFolder);
        String[] contents = new String[]{"MANIFEST.MF"};
        int[] typesToCheck = new int[]{TYPE_FILE};
        this.checkFolderContents((IRemoteFile)copiedVirtualFolder, contents, typesToCheck);
    }

    public void testCopyTarVirtualFileLevelFour() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createSourceTarFiles();
        String sourceFileName = this.tarSourceFileName1;
        IRemoteFile sourceTarFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceFileName);
        FileServiceArchiveTest.assertNotNull((Object)sourceTarFile);
        String folderName = "folder1";
        IRemoteFile folder1 = this.createFileOrFolder(this.tempDirPath, folderName, true);
        FileServiceArchiveTest.assertNotNull((Object)folder1);
        String parentForDirectoryToCopyName = "org";
        IRemoteFile parentForDirectoryToCopy = (IRemoteFile)this.getChildFromFolder(sourceTarFile, parentForDirectoryToCopyName);
        FileServiceArchiveTest.assertNotNull((Object)parentForDirectoryToCopy);
        parentForDirectoryToCopyName = "eclipse";
        parentForDirectoryToCopy = (IRemoteFile)this.getChildFromFolder(parentForDirectoryToCopy, parentForDirectoryToCopyName);
        FileServiceArchiveTest.assertNotNull((Object)parentForDirectoryToCopy);
        parentForDirectoryToCopyName = "dstore";
        parentForDirectoryToCopy = (IRemoteFile)this.getChildFromFolder(parentForDirectoryToCopy, parentForDirectoryToCopyName);
        FileServiceArchiveTest.assertNotNull((Object)parentForDirectoryToCopy);
        String directoryToCopyName = "core";
        IRemoteFile directoryToCopy = (IRemoteFile)this.getChildFromFolder(parentForDirectoryToCopy, directoryToCopyName);
        FileServiceArchiveTest.assertNotNull((Object)directoryToCopy);
        this.fss.copy(directoryToCopy, folder1, directoryToCopyName, this.mon);
        Object copiedVirtualFolder = this.getChildFromFolder(folder1, directoryToCopyName);
        FileServiceArchiveTest.assertNotNull((Object)copiedVirtualFolder);
        String[] contents = new String[]{"client", "java", "miners", "model", "server", "util", "Activator.java"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FOLDER, TYPE_FOLDER, TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE};
        this.checkFolderContents((IRemoteFile)copiedVirtualFolder, contents, typesToCheck);
    }

    public void testMoveToTarArchiveFile() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createSourceTarFiles();
        this.createSourceFolders();
        String tarTargetFileName = this.tarSourceFileName1;
        IRemoteFile targetTarFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, tarTargetFileName);
        FileServiceArchiveTest.assertNotNull((Object)targetTarFile);
        String sourceFolderName = this.folderToCopyName3;
        IRemoteFile sourceFolder = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceFolderName);
        FileServiceArchiveTest.assertNotNull((Object)sourceFolder);
        this.fss.move(sourceFolder, targetTarFile, sourceFolder.getName(), this.mon);
        Object theMovedChild = this.getChildFromFolder(targetTarFile, sourceFolderName);
        FileServiceArchiveTest.assertNotNull((Object)theMovedChild);
        String[] childrenToCheck = new String[]{"aaaaaaaa", "aaaab", "epdcdump01.hex12a", "RSE-SDK-2.0RC1.zip"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE, TYPE_FILE};
        this.checkFolderContents((IRemoteFile)theMovedChild, childrenToCheck, typesToCheck);
        Object originalSource = this.getChildFromFolder(this.tempDir, sourceFolderName);
        FileServiceArchiveTest.assertNull((Object)originalSource);
    }

    public void testMoveToTarVirtualFileLevelOne() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createSourceTarFiles();
        this.createSourceFolders();
        String tarTargetFileName = this.tarSourceFileName1;
        IRemoteFile targetTarFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, tarTargetFileName);
        FileServiceArchiveTest.assertNotNull((Object)targetTarFile);
        String sourceFolderName = this.folderToCopyName3;
        IRemoteFile sourceFolder = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceFolderName);
        FileServiceArchiveTest.assertNotNull((Object)sourceFolder);
        Object[] childrenOfTargetZipFile = this.fss.resolveFilterString((Object)targetTarFile, null, this.mon);
        this.fss.move(sourceFolder, (IRemoteFile)childrenOfTargetZipFile[0], sourceFolderName, this.mon);
        Object theMovedChild = this.getChildFromFolder((IRemoteFile)childrenOfTargetZipFile[0], sourceFolderName);
        FileServiceArchiveTest.assertNotNull((Object)theMovedChild);
        String[] childrenToCheck = new String[]{"aaaaaaaa", "aaaab", "epdcdump01.hex12a", "RSE-SDK-2.0RC1.zip"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE, TYPE_FILE};
        this.checkFolderContents((IRemoteFile)theMovedChild, childrenToCheck, typesToCheck);
        Object originalSource = this.getChildFromFolder(this.tempDir, sourceFolderName);
        FileServiceArchiveTest.assertNull((Object)originalSource);
    }

    public void testMoveToVirtualFileLevelFour() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createSourceTarFiles();
        this.createSourceFolders();
        String tarTargetFileName = this.tarSourceFileName1;
        IRemoteFile targetTarFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, tarTargetFileName);
        FileServiceArchiveTest.assertNotNull((Object)targetTarFile);
        String sourceFolderName = this.folderToCopyName3;
        IRemoteFile sourceFolder = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceFolderName);
        FileServiceArchiveTest.assertNotNull((Object)sourceFolder);
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(targetTarFile, "org");
        FileServiceArchiveTest.assertNotNull((Object)firstLevelChild);
        IRemoteFile secondLevelChild = (IRemoteFile)this.getChildFromFolder(firstLevelChild, "eclipse");
        FileServiceArchiveTest.assertNotNull((Object)secondLevelChild);
        IRemoteFile thirdLevelChild = (IRemoteFile)this.getChildFromFolder(secondLevelChild, "dstore");
        FileServiceArchiveTest.assertNotNull((Object)thirdLevelChild);
        IRemoteFile fourLevelChild = (IRemoteFile)this.getChildFromFolder(thirdLevelChild, "core");
        FileServiceArchiveTest.assertNotNull((Object)fourLevelChild);
        this.fss.move(sourceFolder, fourLevelChild, sourceFolder.getName(), this.mon);
        Object theCopiedChild = this.getChildFromFolder(fourLevelChild, sourceFolderName);
        FileServiceArchiveTest.assertNotNull((Object)theCopiedChild);
        String[] childrenToCheck = new String[]{"aaaaaaaa", "aaaab", "epdcdump01.hex12a", "RSE-SDK-2.0RC1.zip"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE, TYPE_FILE};
        this.checkFolderContents((IRemoteFile)theCopiedChild, childrenToCheck, typesToCheck);
        Object originalSource = this.getChildFromFolder(this.tempDir, sourceFolderName);
        FileServiceArchiveTest.assertNull((Object)originalSource);
    }

    public void testMoveTarVirtualFile() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createSourceTarFiles();
        String sourceFileName = this.tarSourceFileName1;
        IRemoteFile sourceTarFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceFileName);
        FileServiceArchiveTest.assertNotNull((Object)sourceTarFile);
        String folderName = "folder1";
        IRemoteFile folder1 = this.createFileOrFolder(this.tempDirPath, folderName, true);
        FileServiceArchiveTest.assertNotNull((Object)folder1);
        String movedFolderName = this.tarSourceFolderName1;
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(sourceTarFile, this.tarSourceFolderName1);
        FileServiceArchiveTest.assertNotNull((Object)firstLevelChild);
        this.fss.move(firstLevelChild, folder1, movedFolderName, this.mon);
        Object movedVirtualFolder = this.getChildFromFolder(folder1, movedFolderName);
        FileServiceArchiveTest.assertNotNull((Object)movedVirtualFolder);
        String[] contents = new String[]{"MANIFEST.MF"};
        int[] typesToCheck = new int[]{TYPE_FILE};
        this.checkFolderContents((IRemoteFile)movedVirtualFolder, contents, typesToCheck);
        IRemoteFile tmp = (IRemoteFile)this.getChildFromFolder(sourceTarFile, this.tarSourceFolderName1);
        FileServiceArchiveTest.assertNull((Object)tmp);
    }

    public void testMoveTarVirtualFileLevelFour() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createSourceTarFiles();
        String sourceFileName = this.tarSourceFileName1;
        IRemoteFile sourceTarFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceFileName);
        FileServiceArchiveTest.assertNotNull((Object)sourceTarFile);
        String folderName = "folder1";
        IRemoteFile folder1 = this.createFileOrFolder(this.tempDirPath, folderName, true);
        FileServiceArchiveTest.assertNotNull((Object)folder1);
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(sourceTarFile, "org");
        FileServiceArchiveTest.assertNotNull((Object)firstLevelChild);
        IRemoteFile secondLevelChild = (IRemoteFile)this.getChildFromFolder(firstLevelChild, "eclipse");
        FileServiceArchiveTest.assertNotNull((Object)secondLevelChild);
        IRemoteFile thirdLevelChild = (IRemoteFile)this.getChildFromFolder(secondLevelChild, "dstore");
        FileServiceArchiveTest.assertNotNull((Object)thirdLevelChild);
        IRemoteFile fourthLevelChild = (IRemoteFile)this.getChildFromFolder(thirdLevelChild, "core");
        FileServiceArchiveTest.assertNotNull((Object)fourthLevelChild);
        String movedFolderName = fourthLevelChild.getName();
        this.fss.move(fourthLevelChild, folder1, movedFolderName, this.mon);
        Object copiedVirtualFolder = this.getChildFromFolder(folder1, movedFolderName);
        FileServiceArchiveTest.assertNotNull((Object)copiedVirtualFolder);
        String[] contents = new String[]{"client", "java", "miners", "model", "server", "util", "Activator.java"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FOLDER, TYPE_FOLDER, TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE};
        this.checkFolderContents((IRemoteFile)copiedVirtualFolder, contents, typesToCheck);
        Object result = this.getChildFromFolder(thirdLevelChild, movedFolderName);
        FileServiceArchiveTest.assertNull((Object)result);
    }

    public void testRenameTarVirtualFile() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        String testName = "source.tar";
        IRemoteFile newArchiveFile = this.createFileOrFolder(this.tempDirPath, testName, false);
        String childName = "aaa.txt";
        IRemoteFile file1 = this.createFileOrFolder(newArchiveFile.getAbsolutePath(), childName, false);
        FileServiceArchiveTest.assertNotNull((Object)file1);
        childName = "bbb.txt";
        IRemoteFile file2 = this.createFileOrFolder(newArchiveFile.getAbsolutePath(), childName, false);
        FileServiceArchiveTest.assertNotNull((Object)file2);
        childName = "folder1";
        IRemoteFile folder1 = this.createFileOrFolder(newArchiveFile.getAbsolutePath(), childName, true);
        FileServiceArchiveTest.assertNotNull((Object)folder1);
        String[] levelOneNamesToCheck = new String[]{"aaa.txt", "bbb.txt", "folder1"};
        int[] levalOneTypesToCheck = new int[]{TYPE_FILE, TYPE_FILE, TYPE_FOLDER};
        this.checkFolderContents(newArchiveFile, levelOneNamesToCheck, levalOneTypesToCheck);
        String secondLevelChildName = "ccc.exe";
        IRemoteFile levelTwoChild1 = this.createFileOrFolder(folder1.getAbsolutePath(), secondLevelChildName, false);
        FileServiceArchiveTest.assertNotNull((Object)levelTwoChild1);
        secondLevelChildName = "ddd.bat";
        IRemoteFile levelTwoChild2 = this.createFileOrFolder(folder1.getAbsolutePath(), secondLevelChildName, false);
        FileServiceArchiveTest.assertNotNull((Object)levelTwoChild2);
        secondLevelChildName = "another Folder";
        IRemoteFile levelTwoChild3 = this.createFileOrFolder(folder1.getAbsolutePath(), secondLevelChildName, true);
        FileServiceArchiveTest.assertNotNull((Object)levelTwoChild3);
        String[] levelTwoNamesToCheck = new String[]{"ccc.exe", "ddd.bat", "another Folder"};
        int[] levalTwoTypesToCheck = new int[]{TYPE_FILE, TYPE_FILE, TYPE_FOLDER};
        this.checkFolderContents(folder1, levelTwoNamesToCheck, levalTwoTypesToCheck);
        IRemoteFile childToRename = (IRemoteFile)this.getChildFromFolder(newArchiveFile, "aaa.txt");
        this.fss.rename(childToRename, "aaa1.txt", this.mon);
        childToRename = (IRemoteFile)this.getChildFromFolder(newArchiveFile, "folder1");
        this.fss.rename(childToRename, "folder2", this.mon);
        String[] newLevelOneNamesToCheck = new String[]{"aaa1.txt", "bbb.txt", "folder2"};
        this.checkFolderContents(newArchiveFile, newLevelOneNamesToCheck, levalOneTypesToCheck);
        IRemoteFile thisFolder = (IRemoteFile)this.getChildFromFolder(newArchiveFile, "folder2");
        childToRename = (IRemoteFile)this.getChildFromFolder(thisFolder, "ddd.bat");
        this.fss.rename(childToRename, "ddd1.bat", this.mon);
        childToRename = (IRemoteFile)this.getChildFromFolder(thisFolder, "another Folder");
        this.fss.rename(childToRename, "some folder$", this.mon);
        String[] newLevelTwoNamesToCheck = new String[]{"ccc.exe", "ddd1.bat", "some folder$"};
        this.checkFolderContents(thisFolder, newLevelTwoNamesToCheck, levalTwoTypesToCheck);
    }

    public void testDeleteTarVirtualFile() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createSourceTarFiles();
        String sourceFileName = this.tarSourceFileName1;
        IRemoteFile sourceTarFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceFileName);
        FileServiceArchiveTest.assertNotNull((Object)sourceTarFile);
        String parentForFileToDeleteName = "META-INF";
        IRemoteFile parentForFileToDelete = (IRemoteFile)this.getChildFromFolder(sourceTarFile, parentForFileToDeleteName);
        FileServiceArchiveTest.assertNotNull((Object)parentForFileToDelete);
        String deleteFileName = "MANIFEST.MF";
        IRemoteFile fileToToDelete = (IRemoteFile)this.getChildFromFolder(parentForFileToDelete, deleteFileName);
        FileServiceArchiveTest.assertNotNull((Object)fileToToDelete);
        this.fss.delete(fileToToDelete, this.mon);
        fileToToDelete = (IRemoteFile)this.getChildFromFolder(parentForFileToDelete, deleteFileName);
        FileServiceArchiveTest.assertNull((Object)fileToToDelete);
        String parentForDirectoryToDeleteName = "org";
        IRemoteFile parentForDirectoryToDelete = (IRemoteFile)this.getChildFromFolder(sourceTarFile, parentForDirectoryToDeleteName);
        FileServiceArchiveTest.assertNotNull((Object)parentForDirectoryToDelete);
        parentForDirectoryToDeleteName = "eclipse";
        parentForDirectoryToDelete = (IRemoteFile)this.getChildFromFolder(parentForDirectoryToDelete, parentForDirectoryToDeleteName);
        FileServiceArchiveTest.assertNotNull((Object)parentForDirectoryToDelete);
        parentForDirectoryToDeleteName = "dstore";
        parentForDirectoryToDelete = (IRemoteFile)this.getChildFromFolder(parentForDirectoryToDelete, parentForDirectoryToDeleteName);
        FileServiceArchiveTest.assertNotNull((Object)parentForDirectoryToDelete);
        parentForDirectoryToDeleteName = "core";
        parentForDirectoryToDelete = (IRemoteFile)this.getChildFromFolder(parentForDirectoryToDelete, parentForDirectoryToDeleteName);
        FileServiceArchiveTest.assertNotNull((Object)parentForDirectoryToDelete);
        String directoryToDeleteName = "java";
        IRemoteFile directoryToDelete = (IRemoteFile)this.getChildFromFolder(parentForDirectoryToDelete, directoryToDeleteName);
        this.fss.delete(directoryToDelete, this.mon);
        directoryToDelete = (IRemoteFile)this.getChildFromFolder(parentForDirectoryToDelete, directoryToDeleteName);
        String[] contents = new String[]{"client", "miners", "model", "server", "util", "Activator.java"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FOLDER, TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE};
        this.checkFolderContents(parentForDirectoryToDelete, contents, typesToCheck);
        directoryToDelete = (IRemoteFile)this.getChildFromFolder(parentForDirectoryToDelete, directoryToDeleteName);
        FileServiceArchiveTest.assertNull((Object)directoryToDelete);
        parentForFileToDelete = (IRemoteFile)this.getChildFromFolder(parentForDirectoryToDelete, "model");
        deleteFileName = "DE.java";
        fileToToDelete = (IRemoteFile)this.getChildFromFolder(parentForFileToDelete, deleteFileName);
        FileServiceArchiveTest.assertNotNull((Object)fileToToDelete);
        this.fss.delete(fileToToDelete, this.mon);
        fileToToDelete = (IRemoteFile)this.getChildFromFolder(parentForFileToDelete, deleteFileName);
        FileServiceArchiveTest.assertNull((Object)fileToToDelete);
    }

    public void testCopyBatchToTarArchiveFile() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createSourceTarFiles();
        this.createSourceFolders();
        String tarTargetFileName = this.tarSourceFileName1;
        IRemoteFile targetTarFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, tarTargetFileName);
        FileServiceArchiveTest.assertNotNull((Object)targetTarFile);
        String sourceFolderName = this.folderToCopyName3;
        IRemoteFile sourceFolder = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceFolderName);
        FileServiceArchiveTest.assertNotNull((Object)sourceFolder);
        IRemoteFile[] sourceFiles = new IRemoteFile[3];
        String childToCopyName1 = "aaaaaaaa";
        sourceFiles[0] = (IRemoteFile)this.getChildFromFolder(sourceFolder, childToCopyName1);
        String childToCopyName2 = "aaaab";
        sourceFiles[1] = (IRemoteFile)this.getChildFromFolder(sourceFolder, childToCopyName2);
        String childToCopyName3 = "epdcdump01.hex12a";
        sourceFiles[2] = (IRemoteFile)this.getChildFromFolder(sourceFolder, childToCopyName3);
        this.fss.copyBatch(sourceFiles, targetTarFile, this.mon);
        Object theCopiedChild = this.getChildFromFolder(targetTarFile, childToCopyName1);
        FileServiceArchiveTest.assertNotNull((Object)theCopiedChild);
        String[] childrenToCheck1 = new String[]{"adsf", "eclipse-SDK-3.3M6-win32.zip", "epdcdump01.hex12", "epdcdump01.hex12aaaa"};
        int[] typesToCheck1 = new int[]{TYPE_FILE, TYPE_FILE, TYPE_FILE, TYPE_FILE};
        this.checkFolderContents((IRemoteFile)theCopiedChild, childrenToCheck1, typesToCheck1);
        theCopiedChild = this.getChildFromFolder(targetTarFile, childToCopyName2);
        FileServiceArchiveTest.assertNotNull((Object)theCopiedChild);
        String[] childrenToCheck2 = new String[]{"features"};
        int[] typesToCheck2 = new int[]{TYPE_FOLDER};
        this.checkFolderContents((IRemoteFile)theCopiedChild, childrenToCheck2, typesToCheck2);
        theCopiedChild = this.getChildFromFolder(targetTarFile, childToCopyName3);
        FileServiceArchiveTest.assertNotNull((Object)theCopiedChild);
        FileServiceArchiveTest.assertTrue((!((IRemoteFile)theCopiedChild).isDirectory() ? 1 : 0) != 0);
    }

    public void testCopyBatchToTarVirtualFileLevelFour() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createSourceTarFiles();
        this.createSourceFolders();
        String tarTargetFileName = this.tarSourceFileName1;
        IRemoteFile targetTarFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, tarTargetFileName);
        FileServiceArchiveTest.assertNotNull((Object)targetTarFile);
        String sourceFolderName = this.folderToCopyName3;
        IRemoteFile sourceFolder = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceFolderName);
        FileServiceArchiveTest.assertNotNull((Object)sourceFolder);
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(targetTarFile, "org");
        FileServiceArchiveTest.assertNotNull((Object)firstLevelChild);
        IRemoteFile secondLevelChild = (IRemoteFile)this.getChildFromFolder(firstLevelChild, "eclipse");
        FileServiceArchiveTest.assertNotNull((Object)secondLevelChild);
        IRemoteFile thirdLevelChild = (IRemoteFile)this.getChildFromFolder(secondLevelChild, "dstore");
        FileServiceArchiveTest.assertNotNull((Object)thirdLevelChild);
        IRemoteFile fourthLevelChild = (IRemoteFile)this.getChildFromFolder(thirdLevelChild, "core");
        FileServiceArchiveTest.assertNotNull((Object)fourthLevelChild);
        IRemoteFile[] sourceFiles = new IRemoteFile[3];
        String childToCopyName1 = "aaaaaaaa";
        sourceFiles[0] = (IRemoteFile)this.getChildFromFolder(sourceFolder, childToCopyName1);
        String childToCopyName2 = "aaaab";
        sourceFiles[1] = (IRemoteFile)this.getChildFromFolder(sourceFolder, childToCopyName2);
        String childToCopyName3 = "epdcdump01.hex12a";
        sourceFiles[2] = (IRemoteFile)this.getChildFromFolder(sourceFolder, childToCopyName3);
        this.fss.copyBatch(sourceFiles, fourthLevelChild, this.mon);
        Object theCopiedChild = this.getChildFromFolder(fourthLevelChild, childToCopyName1);
        FileServiceArchiveTest.assertNotNull((Object)theCopiedChild);
        String[] childrenToCheck1 = new String[]{"adsf", "eclipse-SDK-3.3M6-win32.zip", "epdcdump01.hex12", "epdcdump01.hex12aaaa"};
        int[] typesToCheck1 = new int[]{TYPE_FILE, TYPE_FILE, TYPE_FILE, TYPE_FILE};
        this.checkFolderContents((IRemoteFile)theCopiedChild, childrenToCheck1, typesToCheck1);
        theCopiedChild = this.getChildFromFolder(fourthLevelChild, childToCopyName2);
        FileServiceArchiveTest.assertNotNull((Object)theCopiedChild);
        String[] childrenToCheck2 = new String[]{"features"};
        int[] typesToCheck2 = new int[]{TYPE_FOLDER};
        this.checkFolderContents((IRemoteFile)theCopiedChild, childrenToCheck2, typesToCheck2);
        theCopiedChild = this.getChildFromFolder(fourthLevelChild, childToCopyName3);
        FileServiceArchiveTest.assertNotNull((Object)theCopiedChild);
        FileServiceArchiveTest.assertTrue((!((IRemoteFile)theCopiedChild).isDirectory() ? 1 : 0) != 0);
    }

    public void testCopyBatchTarVirtualFileLevelFive() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createSourceTarFiles();
        String sourceFileName = this.tarSourceFileName1;
        IRemoteFile sourceTarFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceFileName);
        FileServiceArchiveTest.assertNotNull((Object)sourceTarFile);
        String folderName = "folder1";
        IRemoteFile folder1 = this.createFileOrFolder(this.tempDirPath, folderName, true);
        FileServiceArchiveTest.assertNotNull((Object)folder1);
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(sourceTarFile, "org");
        FileServiceArchiveTest.assertNotNull((Object)firstLevelChild);
        IRemoteFile secondLevelChild = (IRemoteFile)this.getChildFromFolder(firstLevelChild, "eclipse");
        FileServiceArchiveTest.assertNotNull((Object)secondLevelChild);
        IRemoteFile thirdLevelChild = (IRemoteFile)this.getChildFromFolder(secondLevelChild, "dstore");
        FileServiceArchiveTest.assertNotNull((Object)thirdLevelChild);
        IRemoteFile fourthLevelChild = (IRemoteFile)this.getChildFromFolder(thirdLevelChild, "core");
        FileServiceArchiveTest.assertNotNull((Object)fourthLevelChild);
        IRemoteFile[] fifLevelChildrenToCopy = new IRemoteFile[3];
        String firstToCopyName = "client";
        fifLevelChildrenToCopy[0] = (IRemoteFile)this.getChildFromFolder(fourthLevelChild, firstToCopyName);
        FileServiceArchiveTest.assertNotNull((Object)fifLevelChildrenToCopy[0]);
        String secondToCopyName = "miners";
        fifLevelChildrenToCopy[1] = (IRemoteFile)this.getChildFromFolder(fourthLevelChild, secondToCopyName);
        FileServiceArchiveTest.assertNotNull((Object)fifLevelChildrenToCopy[1]);
        String thirdToCopyName = "Activator.java";
        fifLevelChildrenToCopy[2] = (IRemoteFile)this.getChildFromFolder(fourthLevelChild, thirdToCopyName);
        FileServiceArchiveTest.assertNotNull((Object)fifLevelChildrenToCopy[2]);
        this.fss.copyBatch(fifLevelChildrenToCopy, folder1, this.mon);
        Object copiedVirtualFolder1 = this.getChildFromFolder(folder1, firstToCopyName);
        FileServiceArchiveTest.assertNotNull((Object)copiedVirtualFolder1);
        String[] contents1 = new String[]{"ClientConnection.java", "ConnectionStatus.java"};
        int[] typesToCheck1 = new int[]{TYPE_FILE, TYPE_FILE};
        this.checkFolderContents((IRemoteFile)copiedVirtualFolder1, contents1, typesToCheck1);
        Object copiedVirtualFolder2 = this.getChildFromFolder(folder1, secondToCopyName);
        FileServiceArchiveTest.assertNotNull((Object)copiedVirtualFolder2);
        String[] contents2 = new String[]{"Miner.java", "MinerThread.java"};
        int[] typesToCheck2 = new int[]{TYPE_FILE, TYPE_FILE};
        this.checkFolderContents((IRemoteFile)copiedVirtualFolder2, contents2, typesToCheck2);
        Object copiedVirtualFolder3 = this.getChildFromFolder(folder1, thirdToCopyName);
        FileServiceArchiveTest.assertNotNull((Object)copiedVirtualFolder3);
    }

    public void testSuperTransferLocalToRemote() throws Exception {
        String tempPath = FileServiceArchiveTest.getWorkspace().getRoot().getLocation().append("temp").toString();
        IFileStore temp = this.createDir(tempPath, true);
        this.createSuperTransferFolder(temp);
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        boolean preference_DOSUPERTRANSFER = store.getBoolean("org.eclipse.rse.subsystems.files.core.preferences.dosupertransfer");
        store.setValue("org.eclipse.rse.subsystems.files.core.preferences.dosupertransfer", true);
        IRemoteFile sourceFolderToCopy1 = this.localFss.getRemoteFileObject(String.valueOf(tempPath) + '\\' + this.folderToCopyName3, this.mon);
        IAdaptable iAdaptable = (IAdaptable)sourceFolderToCopy1;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISystemDragDropAdapter srcAdapter1 = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz);
        SystemRemoteResourceSet fromSet3 = new SystemRemoteResourceSet((ISubSystem)this.localFss, srcAdapter1);
        fromSet3.addResource((Object)sourceFolderToCopy1);
        ISystemResourceSet tempObjects3 = srcAdapter1.doDrag(fromSet3, this.mon);
        UniversalFileTransferUtility.copyWorkspaceResourcesToRemote((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects3), (IRemoteFile)this.tempDir, (IProgressMonitor)this.mon, (boolean)true);
        Object[] children = this.fss.resolveFilterString((Object)this.tempDir, null, this.mon);
        FileServiceArchiveTest.assertTrue((children.length == 1 ? 1 : 0) != 0);
        Object theCopiedFolder = this.getChildFromFolder(this.tempDir, this.folderToCopyName3);
        FileServiceArchiveTest.assertNotNull((Object)theCopiedFolder);
        String[] childrenToCheck = new String[]{"aaaaaaaa", "aaaab", "epdcdump01.hex12a", "RSE-SDK-2.0RC1.zip"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE, TYPE_FILE};
        this.checkFolderContents((IRemoteFile)theCopiedFolder, childrenToCheck, typesToCheck);
        store.setValue("org.eclipse.rse.subsystems.files.core.preferences.dosupertransfer", preference_DOSUPERTRANSFER);
        temp.delete(0, this.mon);
    }

    public void testOpenFileFromTarArchive() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createTarSourceForOpen();
        String tarTargetFileName = this.tarSourceForOpenTest;
        IRemoteFile targetTarFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, tarTargetFileName);
        FileServiceArchiveTest.assertNotNull((Object)targetTarFile);
        String fileContentToVerifyName1 = "MANIFEST.MF";
        IRemoteFile itsParentFolder = (IRemoteFile)this.getChildFromFolder(this.tempDir, this.tarSourceForOpenFolderName1);
        FileServiceArchiveTest.assertNotNull((Object)itsParentFolder);
        IRemoteFile thisVirtualFile = (IRemoteFile)this.getChildFromFolder(itsParentFolder, fileContentToVerifyName1);
        FileServiceArchiveTest.assertNotNull((Object)thisVirtualFile);
        String tempPath = FileServiceArchiveTest.getWorkspace().getRoot().getLocation().append("temp").toString();
        IFileStore temp = this.createDir(tempPath, true);
        String localPath = String.valueOf(tempPath) + "\\" + fileContentToVerifyName1;
        this.fss.download(thisVirtualFile, localPath, thisVirtualFile.getEncoding(), this.mon);
        IFileStore localFile = temp.getChild(fileContentToVerifyName1);
        boolean sameContent = this.compareContent(this.getContents(this.fileContentString1), localFile.openInputStream(0, null));
        FileServiceArchiveTest.assertTrue((boolean)sameContent);
        String fileContentToVerifyName2 = "Activator.java";
        itsParentFolder = (IRemoteFile)this.getChildFromFolder(this.tempDir, this.tarSourceForOpenFolderName2);
        FileServiceArchiveTest.assertNotNull((Object)itsParentFolder);
        itsParentFolder = (IRemoteFile)this.getChildFromFolder(itsParentFolder, "eclipse");
        FileServiceArchiveTest.assertNotNull((Object)itsParentFolder);
        itsParentFolder = (IRemoteFile)this.getChildFromFolder(itsParentFolder, "dstore");
        FileServiceArchiveTest.assertNotNull((Object)itsParentFolder);
        itsParentFolder = (IRemoteFile)this.getChildFromFolder(itsParentFolder, "core");
        FileServiceArchiveTest.assertNotNull((Object)itsParentFolder);
        thisVirtualFile = (IRemoteFile)this.getChildFromFolder(itsParentFolder, fileContentToVerifyName2);
        FileServiceArchiveTest.assertNotNull((Object)thisVirtualFile);
        localPath = String.valueOf(tempPath) + "\\" + fileContentToVerifyName2;
        this.fss.download(thisVirtualFile, localPath, thisVirtualFile.getEncoding(), this.mon);
        localFile = temp.getChild(fileContentToVerifyName2);
        sameContent = this.compareContent(this.getContents(this.fileContentString1), localFile.openInputStream(0, null));
        FileServiceArchiveTest.assertTrue((boolean)sameContent);
    }
}

