/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.ssh;

import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.ssh.ISshSettings;

public class SshSettings
implements ISshSettings {
    protected String fHost;
    protected String fUser;
    protected String fPassword;
    protected String fPort;
    protected String fTimeout;

    public String getHost() {
        return this.fHost;
    }

    public void setHost(String strHost) {
        this.fHost = strHost;
    }

    public String getSummary() {
        String settings = String.valueOf(this.getUser()) + '@' + this.getHost();
        if (this.getPort() != 22) {
            settings = String.valueOf(settings) + (58 + this.getPort());
        }
        return settings;
    }

    public void load(ISettingsStore store) {
        this.fHost = store.get("Host");
        this.fUser = store.get("User");
        this.fPort = store.get("Port");
        this.fTimeout = store.get("Timeout");
    }

    public void save(ISettingsStore store) {
        store.put("Host", this.fHost);
        store.put("User", this.fUser);
        store.put("Port", this.fPort);
        store.put("Timeout", this.fTimeout);
    }

    public int getTimeout() {
        try {
            return Integer.parseInt(this.fTimeout);
        }
        catch (NumberFormatException numberFormatException) {
            return 10;
        }
    }

    public String getTimeoutString() {
        return this.fTimeout;
    }

    public void setTimeout(String timeout) {
        this.fTimeout = timeout;
    }

    public String getUser() {
        return this.fUser;
    }

    public void setUser(String user) {
        this.fUser = user;
    }

    public int getPort() {
        try {
            return Integer.parseInt(this.fPort);
        }
        catch (NumberFormatException numberFormatException) {
            return 22;
        }
    }

    public String getPortString() {
        return this.fPort;
    }

    public void setPort(String port) {
        this.fPort = port;
    }

    public String getPassword() {
        return this.fPassword;
    }

    public void setPassword(String password) {
        this.fPassword = password;
    }
}

