/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.internal.services.Activator;

public class Mutex {
    private boolean fLocked = false;
    private List fWaitQueue = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForLock(IProgressMonitor monitor, long timeout) {
        boolean lockAcquired;
        block30: {
            if (Thread.interrupted()) {
                return false;
            }
            if (monitor != null && monitor.isCanceled()) {
                return false;
            }
            Thread myself = Thread.currentThread();
            List list = this.fWaitQueue;
            synchronized (list) {
                block28: {
                    if (this.fLocked) break block28;
                    this.fLocked = true;
                    return true;
                }
                this.fWaitQueue.add(myself);
                Activator.trace("Mutex: added " + myself + ", size=" + this.fWaitQueue.size());
            }
            lockAcquired = false;
            try {
                try {
                    long start = System.currentTimeMillis();
                    long timeLeft = timeout;
                    long pollTime = monitor != null ? 1000L : timeLeft;
                    long nextProgressUpdate = start + 500L;
                    boolean canceled = false;
                    while (timeLeft > 0L && !canceled && !lockAcquired) {
                        List list2 = this.fWaitQueue;
                        synchronized (list2) {
                            if (!this.fLocked && this.fWaitQueue.get(0) == myself) {
                                this.fWaitQueue.remove(0);
                                Activator.trace("Mutex: SUCCESS, removed " + myself + ", size=" + this.fWaitQueue.size());
                                this.fLocked = true;
                                lockAcquired = true;
                            } else {
                                this.fWaitQueue.wait(timeLeft > pollTime ? pollTime : timeLeft);
                                if (!this.fLocked && this.fWaitQueue.get(0) == myself) {
                                    this.fWaitQueue.remove(0);
                                    Activator.trace("Mutex: SUCCESS, removed " + myself + ", size=" + this.fWaitQueue.size());
                                    this.fLocked = true;
                                    lockAcquired = true;
                                }
                            }
                        }
                        if (lockAcquired) continue;
                        Activator.trace("Mutex: wakeup " + myself + " ?");
                        long curTime = System.currentTimeMillis();
                        timeLeft = start + timeout - curTime;
                        if (monitor == null || (canceled = monitor.isCanceled()) || curTime <= nextProgressUpdate) continue;
                        monitor.worked(1);
                        nextProgressUpdate += 1000L;
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (lockAcquired) break block30;
                    List list3 = this.fWaitQueue;
                    synchronized (list3) {
                        this.fWaitQueue.remove(myself);
                        Activator.trace("Mutex: FAIL, removed " + myself + ", size=" + this.fWaitQueue.size());
                        break block30;
                    }
                }
            }
            catch (Throwable throwable) {
                if (!lockAcquired) {
                    List list4 = this.fWaitQueue;
                    synchronized (list4) {
                        this.fWaitQueue.remove(myself);
                        Activator.trace("Mutex: FAIL, removed " + myself + ", size=" + this.fWaitQueue.size());
                    }
                }
                throw throwable;
            }
            if (!lockAcquired) {
                List list5 = this.fWaitQueue;
                synchronized (list5) {
                    this.fWaitQueue.remove(myself);
                    Activator.trace("Mutex: FAIL, removed " + myself + ", size=" + this.fWaitQueue.size());
                }
            }
        }
        return lockAcquired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        List list = this.fWaitQueue;
        synchronized (list) {
            this.fLocked = false;
            if (!this.fWaitQueue.isEmpty()) {
                Object nextOneInQueue = this.fWaitQueue.get(0);
                Activator.trace("Mutex: releasing " + nextOneInQueue);
                this.fWaitQueue.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocked() {
        List list = this.fWaitQueue;
        synchronized (list) {
            return this.fLocked;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptAll() {
        List list = this.fWaitQueue;
        synchronized (list) {
            Iterator it = this.fWaitQueue.iterator();
            while (it.hasNext()) {
                Thread aThread = (Thread)it.next();
                aThread.interrupt();
            }
        }
    }
}

