/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.actions;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.ui.ISystemRenameTarget;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.actions.SystemBaseDialogAction;
import org.eclipse.rse.ui.dialogs.SystemRenameDialog;
import org.eclipse.rse.ui.dialogs.SystemRenameSingleDialog;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.swt.widgets.Shell;

public class SystemCommonRenameAction
extends SystemBaseDialogAction {
    private ISystemRenameTarget renameTarget;
    private boolean copyCollisionMode = false;
    private String[] newNames;
    private ISystemValidator nameValidator;
    private String singleSelectionHelp;
    private String multiSelectionHelp;
    private String promptLabel;
    private String promptTip;
    private String verbiage;

    public SystemCommonRenameAction(Shell parent, ISystemRenameTarget target) {
        super(SystemResources.ACTION_RENAME_LABEL, SystemResources.ACTION_RENAME_TOOLTIP, RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.renameIcon"), parent);
        this.setSelectionProvider(target);
        this.allowOnMultipleSelection(true);
        this.setProcessAllSelections(true);
        this.renameTarget = target;
        this.setContextMenuGroup("group.reorganize");
        this.setHelp("org.eclipse.rse.ui.actn0018");
    }

    public SystemCommonRenameAction(Shell parent) {
        this(parent, null);
    }

    public void setDialogSingleSelectionHelp(String helpID) {
        this.singleSelectionHelp = helpID;
    }

    public void setDialogMultiSelectionHelp(String helpID) {
        this.multiSelectionHelp = helpID;
    }

    public void setSingleSelectPromptLabel(String label, String tooltip) {
        this.promptLabel = label;
        this.promptTip = tooltip;
    }

    public void setMultiSelectVerbiage(String verbiage) {
        this.verbiage = verbiage;
    }

    public void setNameValidator(ISystemValidator nameValidator) {
        this.nameValidator = nameValidator;
    }

    public void setCopyCollisionMode(boolean copyCollisionMode) {
        this.copyCollisionMode = copyCollisionMode;
    }

    public boolean getCopyCollisionMode() {
        return this.copyCollisionMode;
    }

    public boolean updateSelection(IStructuredSelection selection) {
        if (this.renameTarget == null) {
            return true;
        }
        return this.renameTarget.canRename();
    }

    protected Dialog createDialog(Shell parent) {
        IStructuredSelection sel = this.getSelection();
        if (sel != null && sel.size() > 1) {
            SystemRenameDialog dlg = new SystemRenameDialog(parent);
            if (this.nameValidator != null) {
                dlg.setNameValidator(this.nameValidator);
            }
            if (this.multiSelectionHelp != null) {
                dlg.setHelp(this.multiSelectionHelp);
            }
            if (this.verbiage != null) {
                dlg.setVerbiage(this.verbiage);
            }
            return dlg;
        }
        if (sel != null && sel.size() == 1) {
            SystemRenameSingleDialog dlg = new SystemRenameSingleDialog(parent);
            if (this.copyCollisionMode) {
                dlg.setCopyCollisionMode(this.copyCollisionMode);
            }
            if (this.nameValidator != null) {
                dlg.setNameValidator(this.nameValidator);
            }
            if (this.singleSelectionHelp != null) {
                dlg.setHelp(this.singleSelectionHelp);
            }
            if (this.promptLabel != null || this.promptTip != null) {
                dlg.setPromptLabel(this.promptLabel, this.promptTip);
            }
            return dlg;
        }
        return null;
    }

    protected Object getDialogValue(Dialog dlg) {
        this.newNames = null;
        if (dlg instanceof SystemRenameDialog) {
            SystemRenameDialog rnmDlg = (SystemRenameDialog)dlg;
            if (!rnmDlg.wasCancelled()) {
                this.newNames = rnmDlg.getNewNames();
                if (this.renameTarget != null) {
                    this.renameTarget.doRename(this.newNames);
                }
            }
        } else {
            SystemRenameSingleDialog rnmDlg = (SystemRenameSingleDialog)dlg;
            if (!rnmDlg.wasCancelled()) {
                String name = rnmDlg.getNewName();
                this.newNames = new String[1];
                this.newNames[0] = name;
                if (this.renameTarget != null) {
                    this.renameTarget.doRename(this.newNames);
                }
            }
        }
        return null;
    }

    public String[] getNewNames() {
        return this.newNames;
    }
}

