/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view.team;

import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.internal.ui.view.SystemViewResources;
import org.eclipse.rse.internal.ui.view.team.SystemTeamViewCategoryNode;
import org.eclipse.rse.internal.ui.view.team.SystemTeamViewSubSystemConfigurationNode;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.rse.ui.view.AbstractSystemViewAdapter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class SystemTeamViewCategoryAdapter
extends AbstractSystemViewAdapter {
    private boolean actionsCreated = false;
    private static PropertyDescriptor[] propertyDescriptorArray = null;

    public void addActions(SystemMenuManager menu, IStructuredSelection selection, Shell shell, String menuGroup) {
        if (!this.actionsCreated) {
            this.createActions();
        }
    }

    private void createActions() {
        this.actionsCreated = true;
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        SystemTeamViewCategoryNode category = (SystemTeamViewCategoryNode)element;
        return category.getImageDescriptor();
    }

    public String getText(Object element) {
        SystemTeamViewCategoryNode category = (SystemTeamViewCategoryNode)element;
        return category.getLabel();
    }

    public String getName(Object element) {
        SystemTeamViewCategoryNode category = (SystemTeamViewCategoryNode)element;
        return category.getLabel();
    }

    public String getAbsoluteName(Object element) {
        SystemTeamViewCategoryNode category = (SystemTeamViewCategoryNode)element;
        return category.getProfile() + "." + category.getLabel();
    }

    public String getType(Object element) {
        return SystemViewResources.RESID_PROPERTY_TEAM_CATEGORY_TYPE_VALUE;
    }

    public String getStatusLineText(Object element) {
        SystemTeamViewCategoryNode category = (SystemTeamViewCategoryNode)element;
        return String.valueOf(SystemResources.RESID_TEAMVIEW_CATEGORY_VALUE) + ": " + category.getLabel() + " - " + category.getDescription();
    }

    public Object getParent(Object element) {
        SystemTeamViewCategoryNode category = (SystemTeamViewCategoryNode)element;
        return category.getProfile();
    }

    public Object[] getChildren(IAdaptable element, IProgressMonitor monitor) {
        SystemTeamViewCategoryNode category = (SystemTeamViewCategoryNode)element;
        ISystemProfile profile = category.getProfile();
        String categoryType = category.getMementoHandle();
        if (categoryType.equals("conns")) {
            return profile.getHosts();
        }
        return this.createSubSystemConfigurationNodes(profile, category);
    }

    private SystemTeamViewSubSystemConfigurationNode[] createSubSystemConfigurationNodes(ISystemProfile profile, SystemTeamViewCategoryNode category) {
        SystemTeamViewSubSystemConfigurationNode[] nodes = null;
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        ISubSystemConfiguration[] factories = sr.getSubSystemConfigurations();
        if (factories != null) {
            Vector<SystemTeamViewSubSystemConfigurationNode> v = new Vector<SystemTeamViewSubSystemConfigurationNode>();
            String categoryType = category.getMementoHandle();
            int idx = 0;
            while (idx < factories.length) {
                boolean createNode = false;
                ISubSystemConfiguration ssf = factories[idx];
                if (categoryType.equals("pools")) {
                    createNode = ssf.supportsFilters() && profile.getFilterPools(ssf).length > 0;
                } else if (categoryType.equals("actions")) {
                    createNode = ssf.supportsUserDefinedActions();
                } else if (categoryType.equals("cmds")) {
                    createNode = ssf.supportsCompileActions();
                } else if (categoryType.equals("targets")) {
                    createNode = ssf.supportsTargets();
                }
                if (createNode) {
                    v.addElement(new SystemTeamViewSubSystemConfigurationNode(profile, category, factories[idx]));
                }
                ++idx;
            }
            nodes = new SystemTeamViewSubSystemConfigurationNode[v.size()];
            idx = 0;
            while (idx < nodes.length) {
                nodes[idx] = (SystemTeamViewSubSystemConfigurationNode)v.elementAt(idx);
                ++idx;
            }
        }
        return nodes;
    }

    public boolean hasChildren(IAdaptable element) {
        return true;
    }

    protected IPropertyDescriptor[] internalGetPropertyDescriptors() {
        return propertyDescriptorArray;
    }

    public Object internalGetPropertyValue(Object key) {
        return null;
    }

    public String getMementoHandle(Object element) {
        SystemTeamViewCategoryNode category = (SystemTeamViewCategoryNode)element;
        return category.getMementoHandle();
    }

    public String getMementoHandleKey(Object element) {
        SystemTeamViewCategoryNode category = (SystemTeamViewCategoryNode)element;
        return String.valueOf(category.getProfile().getName()) + "." + category.getLabel();
    }

    public boolean isRemote(Object element) {
        return false;
    }
}

