/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.widgets;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.SystemRemoteObjectMatcher;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.SystemFilterSimple;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.ISystemViewInputProvider;
import org.eclipse.rse.core.subsystems.ISystemRemoteObjectMatchProvider;
import org.eclipse.rse.files.ui.ISystemAddFileListener;
import org.eclipse.rse.internal.subsystems.files.core.SystemFileResources;
import org.eclipse.rse.internal.ui.view.SystemPropertySheetForm;
import org.eclipse.rse.internal.ui.view.SystemSelectRemoteObjectAPIProviderImpl;
import org.eclipse.rse.internal.ui.view.SystemViewForm;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileFilterString;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystemConfiguration;
import org.eclipse.rse.subsystems.files.core.util.SystemRemoteFileMatcher;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.validators.IValidatorRemoteSelection;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.SystemAdapterHelpers;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SystemSelectRemoteFileOrFolderForm
implements ISelectionChangedListener {
    protected static final int PROMPT_WIDTH = 400;
    protected Label verbiageLabel;
    protected Label spacer1;
    protected Label spacer2;
    protected Text nameEntryValue;
    protected SystemViewForm tree;
    protected SystemPropertySheetForm ps;
    protected ISystemMessageLine msgLine;
    protected Composite outerParent;
    protected Composite ps_composite;
    protected ISystemRegistry sr = null;
    protected String verbiage = null;
    protected String treeTip = null;
    protected String locationPrompt = "";
    protected String fileTypes;
    protected boolean fileMode;
    protected boolean valid = true;
    protected boolean filesOnlyMode;
    protected boolean showRootFilter = true;
    protected boolean alwaysEnableOK = false;
    protected boolean multipleSelectionMode;
    protected boolean allowForMultipleParents = false;
    protected boolean showPropertySheet = false;
    protected boolean showLocationPrompt = false;
    protected boolean allowFolderSelection = true;
    protected SystemRemoteObjectMatcher objectMatcher = null;
    protected ISystemAddFileListener addButtonCallback = null;
    protected Vector listeners = new Vector();
    protected IValidatorRemoteSelection selectionValidator;
    protected Object[] outputObjects = null;
    protected IHost outputConnection = null;
    protected SystemSelectRemoteObjectAPIProviderImpl inputProvider = null;
    protected ISystemFilter preSelectFilter;
    protected String preSelectFilterChild;
    protected boolean preSelectRoot;
    protected boolean initDone;
    protected boolean contentsCreated;
    protected Object caller;
    protected boolean callerInstanceOfWizardPage;
    protected boolean callerInstanceOfSystemPromptDialog;
    protected int autoExpandDepth = 0;
    protected Object previousSelection = null;
    protected List viewerFilters = new ArrayList();

    public SystemSelectRemoteFileOrFolderForm(ISystemMessageLine msgLine, Object caller, boolean fileMode) {
        this.msgLine = msgLine;
        this.caller = caller;
        this.fileMode = fileMode;
        this.callerInstanceOfWizardPage = caller instanceof WizardPage;
        this.callerInstanceOfSystemPromptDialog = caller instanceof SystemPromptDialog;
        this.sr = RSECorePlugin.getTheSystemRegistry();
        this.verbiage = fileMode ? SystemFileResources.RESID_SELECTFILE_VERBIAGE : SystemFileResources.RESID_SELECTDIRECTORY_VERBIAGE;
        this.treeTip = fileMode ? SystemFileResources.RESID_SELECTFILE_SELECT_TOOLTIP : SystemFileResources.RESID_SELECTDIRECTORY_SELECT_TOOLTIP;
        this.inputProvider = this.getInputProvider();
        String initialFilterString = "*";
        this.inputProvider.setFilterString(fileMode ? initialFilterString : String.valueOf(initialFilterString) + " /nf");
        this.objectMatcher = fileMode ? SystemRemoteFileMatcher.getFileOnlyMatcher() : SystemRemoteFileMatcher.getFolderOnlyMatcher();
    }

    protected SystemSelectRemoteObjectAPIProviderImpl getInputProvider() {
        if (this.inputProvider == null) {
            this.inputProvider = new SystemSelectRemoteObjectAPIProviderImpl(null, "files", true, null);
        }
        return this.inputProvider;
    }

    public void setAllowForMultipleParents(boolean flag) {
        this.allowForMultipleParents = flag;
    }

    public void setSystemConnection(IHost conn) {
        this.inputProvider.setSystemConnection(conn, true);
    }

    public void setDefaultConnection(IHost conn) {
        this.inputProvider.setSystemConnection(conn, false);
    }

    public void setShowNewConnectionPrompt(boolean show) {
        this.inputProvider.setShowNewConnectionPrompt(show);
    }

    public void setSystemTypes(IRSESystemType[] systemTypes) {
        this.inputProvider.setSystemTypes(systemTypes);
    }

    public void setMessage(String message) {
        this.verbiage = message;
        if (this.verbiageLabel != null) {
            this.verbiageLabel.setText(message);
        }
    }

    public void setSelectionTreeToolTipText(String tip) {
        this.treeTip = tip;
        if (this.tree != null) {
            this.tree.setToolTipText(tip);
        }
    }

    public void setRootFolder(IHost connection, String folderAbsolutePath) {
        int filterCount;
        this.setSystemConnection(connection);
        this.setShowNewConnectionPrompt(false);
        this.setAutoExpandDepth(1);
        IRemoteFileSubSystem ss = RemoteFileUtility.getFileSubSystem((IHost)connection);
        IRemoteFileSubSystemConfiguration ssf = ss.getParentRemoteFileSubSystemConfiguration();
        RemoteFileFilterString rffs = new RemoteFileFilterString(ssf);
        rffs.setShowFiles(this.fileMode);
        rffs.setShowSubDirs(!this.fileMode || !this.filesOnlyMode);
        if (this.fileTypes != null) {
            rffs.setFile(this.fileTypes);
        }
        String filterName = null;
        SystemFilterSimple filter = null;
        int n = filterCount = this.showRootFilter ? 2 : 1;
        if (this.preSelectRoot) {
            filterCount = 1;
        }
        ISystemFilter[] filters = new ISystemFilter[filterCount];
        int idx = 0;
        if (this.showRootFilter) {
            filterName = ssf.isUnixStyle() ? (!this.preSelectRoot ? (this.fileMode ? SystemFileResources.RESID_FILTER_ROOTFILES : SystemFileResources.RESID_FILTER_ROOTFOLDERS) : SystemFileResources.RESID_FILTER_ROOTS) : (this.fileMode ? SystemFileResources.RESID_FILTER_DRIVES : SystemFileResources.RESID_FILTER_DRIVES);
            filter = new SystemFilterSimple(filterName);
            filter.setParent((Object)ss);
            filter.setFilterString(rffs.toString());
            filters[idx++] = filter;
            if (this.preSelectRoot) {
                this.preSelectFilter = filter;
                this.preSelectFilterChild = folderAbsolutePath;
            }
        }
        if (!this.preSelectRoot) {
            rffs.setPath(folderAbsolutePath);
            filter = new SystemFilterSimple(rffs.toStringNoSwitches());
            filter.setParent((Object)ss);
            filter.setFilterString(rffs.toString());
            filters[idx] = filter;
            this.preSelectFilter = filter;
        }
        this.inputProvider.setFilterString(null);
        this.inputProvider.setQuickFilters(filters);
    }

    public void setRootFolder(IRemoteFile rootFolder) {
        this.setRootFolder(rootFolder.getSystemConnection(), rootFolder.getAbsolutePath());
    }

    public void setPreSelection(IRemoteFile selection) {
        SystemBasePlugin.logInfo((String)("given: '" + selection.getAbsolutePath() + "'"));
        IRemoteFile parentFolder = selection.getParentRemoteFile();
        if (parentFolder != null) {
            SystemBasePlugin.logInfo((String)("parent of given: '" + parentFolder.getAbsolutePath() + "'"));
        } else {
            SystemBasePlugin.logInfo((String)"parent of given is null");
        }
        if (parentFolder != null && selection.getAbsolutePath().equals("/") && parentFolder.getAbsolutePath() != null && parentFolder.getAbsolutePath().equals("/")) {
            parentFolder = null;
        }
        if (parentFolder != null) {
            IRemoteFileSubSystemConfiguration ssf = selection.getParentRemoteFileSubSystem().getParentRemoteFileSubSystemConfiguration();
            boolean isUnix = ssf.isUnixStyle();
            if (isUnix) {
                this.setRestrictFolders(parentFolder.isRoot());
            }
            this.setRootFolder(parentFolder);
            this.preSelectFilterChild = selection.getName();
        } else {
            SystemBasePlugin.logInfo((String)"preSelectRoot is true");
            this.preSelectRoot = true;
            this.setRestrictFolders(false);
            this.setRootFolder(selection);
        }
        this.inputProvider.setPreSelectFilterChild(this.preSelectFilterChild);
    }

    public void setFileTypes(String[] fileTypes) {
        String fts = null;
        if (fileTypes != null) {
            fts = RemoteFileFilterString.getTypesString((String[])fileTypes);
        }
        this.setFileTypes(fts);
    }

    public void setFileTypes(String fileTypes) {
        this.fileTypes = fileTypes;
        this.inputProvider.setFilterString("/" + fileTypes);
    }

    public void setAutoExpandDepth(int depth) {
        this.autoExpandDepth = depth + 1;
    }

    public void setRestrictFolders(boolean restrict) {
        this.showRootFilter = !restrict;
    }

    public void enableAddMode(ISystemAddFileListener caller) {
        this.addButtonCallback = caller;
    }

    public void setShowPropertySheet(boolean show) {
        this.showPropertySheet = show;
    }

    public void setMultipleSelectionMode(boolean multiple) {
        this.multipleSelectionMode = multiple;
        if (multiple) {
            this.objectMatcher = null;
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener l) {
        if (this.tree != null) {
            this.tree.addSelectionChangedListener(l);
        } else {
            this.listeners.addElement(l);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener l) {
        if (this.tree != null) {
            this.tree.removeSelectionChangedListener(l);
        } else {
            this.listeners.removeElement(l);
        }
    }

    public void setSelectionValidator(IValidatorRemoteSelection selectionValidator) {
        this.selectionValidator = selectionValidator;
    }

    public Object getSelectedObject() {
        if (this.outputObjects != null && this.outputObjects.length >= 1) {
            return this.outputObjects[0];
        }
        return null;
    }

    public Object[] getSelectedObjects() {
        return this.outputObjects;
    }

    public IHost getSelectedConnection() {
        return this.outputConnection;
    }

    public SystemViewForm getSystemViewForm() {
        return this.tree;
    }

    public boolean getMultipleSelectionMode() {
        return this.multipleSelectionMode;
    }

    public void setMessageLine(ISystemMessageLine msgLine) {
        this.msgLine = msgLine;
    }

    public Control getInitialFocusControl() {
        return this.tree.getTreeControl();
    }

    public boolean toggleShowPropertySheet(Shell shell, Control contents) {
        ISelection s;
        Point windowSize = shell.getSize();
        Point oldSize = contents.computeSize(-1, -1);
        if (this.showPropertySheet) {
            this.ps.dispose();
            this.spacer1.dispose();
            this.spacer2.dispose();
            this.ps_composite.dispose();
            this.ps = null;
            this.spacer2 = null;
            this.spacer1 = null;
            this.ps_composite = null;
            ((GridLayout)this.outerParent.getLayout()).numColumns = 1;
        } else {
            ((GridLayout)this.outerParent.getLayout()).numColumns = 2;
            this.createPropertySheet(this.outerParent, shell);
        }
        Point newSize = contents.computeSize(-1, -1);
        shell.setSize(new Point(windowSize.x + (newSize.x - oldSize.x), windowSize.y));
        if (this.ps != null && (s = this.tree.getSelection()) != null) {
            this.ps.selectionChanged(s);
        }
        this.showPropertySheet = !this.showPropertySheet;
        return this.showPropertySheet;
    }

    private void createPropertySheet(Composite outerParent, Shell shell) {
        this.ps_composite = SystemWidgetHelpers.createFlushComposite((Composite)outerParent, (int)1);
        ((GridData)this.ps_composite.getLayoutData()).grabExcessVerticalSpace = true;
        ((GridData)this.ps_composite.getLayoutData()).verticalAlignment = 4;
        this.spacer1 = SystemWidgetHelpers.createLabel((Composite)this.ps_composite, (String)"", (int)1);
        this.spacer2 = SystemWidgetHelpers.createLabel((Composite)this.ps_composite, (String)"", (int)1);
        this.ps = new SystemPropertySheetForm(shell, this.ps_composite, 2048, this.msgLine);
    }

    public void dispose() {
        if (this.tree != null) {
            this.tree.removeSelectionChangedListener((ISelectionChangedListener)this);
            int i = 0;
            while (i < this.listeners.size()) {
                this.tree.removeSelectionChangedListener((ISelectionChangedListener)this.listeners.get(i));
                ++i;
            }
        }
    }

    public Control createContents(Shell shell, Composite parent) {
        this.contentsCreated = true;
        this.outerParent = parent;
        this.outerParent = SystemWidgetHelpers.createComposite((Composite)parent, (int)(this.showPropertySheet ? 2 : 1));
        int gridColumns = 2;
        Composite composite_prompts = SystemWidgetHelpers.createFlushComposite((Composite)this.outerParent, (int)gridColumns);
        if (this.showPropertySheet) {
            this.createPropertySheet(this.outerParent, shell);
        }
        this.verbiageLabel = SystemWidgetHelpers.createVerbiage((Composite)composite_prompts, (String)this.verbiage, (int)gridColumns, (boolean)false, (int)400);
        SystemWidgetHelpers.createLabel((Composite)composite_prompts, (String)"", (int)gridColumns);
        if (this.showLocationPrompt) {
            SystemWidgetHelpers.createLabel((Composite)composite_prompts, (String)this.locationPrompt, (int)gridColumns);
        }
        Composite nameComposite = composite_prompts;
        int nameSpan = gridColumns;
        this.nameEntryValue = SystemWidgetHelpers.createReadonlyTextField((Composite)nameComposite);
        ((GridData)this.nameEntryValue.getLayoutData()).horizontalSpan = nameSpan;
        ViewerFilter[] initViewerFilters = null;
        if (this.viewerFilters == null) {
            initViewerFilters = new ViewerFilter[]{};
        } else {
            initViewerFilters = new ViewerFilter[this.viewerFilters.size()];
            Iterator iter = this.viewerFilters.iterator();
            int idx = 0;
            while (iter.hasNext()) {
                ViewerFilter filter;
                initViewerFilters[idx] = filter = (ViewerFilter)iter.next();
                ++idx;
            }
        }
        this.tree = new SystemViewForm(shell, composite_prompts, 0, (ISystemViewInputProvider)this.inputProvider, !this.multipleSelectionMode, this.msgLine, gridColumns, 1, initViewerFilters);
        if (this.treeTip != null && this.autoExpandDepth != 0) {
            this.tree.getSystemView().setAutoExpandLevel(this.autoExpandDepth);
            this.tree.reset((ISystemViewInputProvider)this.inputProvider);
        }
        if (!this.initDone) {
            this.doInitializeFields();
        }
        this.tree.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.listeners.size() > 0) {
            int idx = 0;
            while (idx < this.listeners.size()) {
                this.tree.addSelectionChangedListener((ISelectionChangedListener)this.listeners.elementAt(idx));
                ++idx;
            }
        }
        if (this.preSelectFilter != null) {
            this.tree.select((Object)this.preSelectFilter, true);
            Object preSelectFilterChildObject = this.inputProvider.getPreSelectFilterChildObject();
            if (preSelectFilterChildObject != null) {
                this.tree.select(preSelectFilterChildObject, false);
            }
        }
        return composite_prompts;
    }

    public boolean verify() {
        this.msgLine.clearErrorMessage();
        this.outputConnection = this.internalGetConnection();
        return true;
    }

    protected IHost internalGetConnection() {
        Object parent = this.tree.getSystemView().getRootParent();
        if (parent instanceof IHost) {
            return (IHost)parent;
        }
        return null;
    }

    protected void setNameText(String text) {
        this.nameEntryValue.setText(text);
    }

    private String getNameText() {
        return this.nameEntryValue.getText();
    }

    private void doInitializeFields() {
        this.setPageComplete();
        this.initDone = true;
    }

    private ISystemRemoteElementAdapter getRemoteAdapter(Object o) {
        return SystemAdapterHelpers.getRemoteAdapter((Object)o);
    }

    public void selectionChanged(SelectionChangedEvent e) {
        ISystemRemoteElementAdapter remoteAdapter;
        this.valid = true;
        ISelection selection = e.getSelection();
        if (this.ps != null) {
            this.ps.selectionChanged(selection);
        }
        this.outputObjects = null;
        int selectionSize = ((IStructuredSelection)selection).size();
        if (selectionSize > 1 && !this.tree.sameParent() && !this.allowForMultipleParents) {
            this.clearErrorMessage();
            this.setNameText("");
            this.setPageComplete();
            return;
        }
        Object errMsg = null;
        Object selectedObject = this.getFirstSelection(selection);
        if (selectedObject == this.previousSelection && selectionSize == 1) {
            this.outputObjects = this.getSelections(selection);
            return;
        }
        this.clearErrorMessage();
        this.setNameText("");
        this.setPageComplete();
        this.previousSelection = selectedObject;
        if (selectedObject != null && (remoteAdapter = this.getRemoteAdapter(selectedObject)) != null) {
            this.setNameTextFromSelection(selection, selectedObject, remoteAdapter);
            this.outputConnection = this.internalGetConnection();
            if (this.addButtonCallback != null && selectedObject instanceof IRemoteFile) {
                errMsg = this.addButtonCallback.okToEnableAddButton(this.outputConnection, (IRemoteFile[])this.getSelections(selection));
                if (errMsg != null) {
                    if (errMsg instanceof String) {
                        this.setErrorMessage((String)errMsg);
                    } else {
                        this.setErrorMessage((SystemMessage)errMsg);
                    }
                }
            } else if (this.objectMatcher == null || this.objectMatcher.appliesTo((ISystemRemoteObjectMatchProvider)remoteAdapter, selectedObject)) {
                SystemMessage selectionMsg = null;
                if (this.selectionValidator != null) {
                    selectionMsg = this.selectionValidator.isValid(this.outputConnection, this.getSelections(selection), this.getRemoteAdapters(selection));
                }
                if (selectionMsg != null) {
                    this.valid = false;
                    this.setErrorMessage(selectionMsg);
                    this.setPageComplete();
                }
            } else if (this.fileMode && !this.allowFolderSelection && remoteAdapter.getRemoteType(selectedObject).equals("folder")) {
                this.valid = false;
                this.setPageComplete();
            }
        }
    }

    protected ISystemRemoteElementAdapter[] getRemoteAdapters(ISelection selection) {
        Object[] selectedObjects = this.getSelections(selection);
        ISystemRemoteElementAdapter[] adapters = new ISystemRemoteElementAdapter[selectedObjects.length];
        int idx = 0;
        while (idx < adapters.length) {
            adapters[idx] = this.getRemoteAdapter(selectedObjects[idx]);
            ++idx;
        }
        return adapters;
    }

    private void setNameTextFromSelection(ISelection selection, Object selectedObject, ISystemRemoteElementAdapter remoteAdapter) {
        this.setNameText(remoteAdapter.getAbsoluteName(selectedObject));
        this.outputObjects = this.getSelections(selection);
        this.setPageComplete();
    }

    protected Object getFirstSelection(ISelection selection) {
        IStructuredSelection sSelection = (IStructuredSelection)selection;
        if (sSelection != null) {
            Iterator selectionIterator = sSelection.iterator();
            if (selectionIterator.hasNext()) {
                return selectionIterator.next();
            }
            return null;
        }
        return null;
    }

    protected Object[] getSelections(ISelection selection) {
        IStructuredSelection sSelection = (IStructuredSelection)selection;
        if (sSelection != null) {
            Object[] selectedObjects = new Object[sSelection.size()];
            Iterator selectionIterator = sSelection.iterator();
            int idx = 0;
            while (selectionIterator.hasNext()) {
                selectedObjects[idx++] = selectionIterator.next();
            }
            return selectedObjects;
        }
        return null;
    }

    public boolean isPageComplete() {
        return this.getNameText().length() > 0 && this.valid;
    }

    public void setPageComplete() {
        if (this.callerInstanceOfWizardPage) {
            ((WizardPage)this.caller).setPageComplete(this.isPageComplete());
        } else if (this.callerInstanceOfSystemPromptDialog) {
            ((SystemPromptDialog)this.caller).setPageComplete(this.isPageComplete());
        }
    }

    protected void clearErrorMessage() {
        if (this.msgLine != null) {
            this.msgLine.clearErrorMessage();
        }
    }

    protected void setErrorMessage(String msg) {
        if (this.msgLine != null) {
            if (msg != null) {
                this.msgLine.setErrorMessage(msg);
            } else {
                this.msgLine.clearErrorMessage();
            }
        }
    }

    protected void setErrorMessage(SystemMessage msg) {
        if (this.msgLine != null) {
            if (msg != null) {
                this.msgLine.setErrorMessage(msg);
            } else {
                this.msgLine.clearErrorMessage();
            }
        }
    }

    protected Shell getShell() {
        if (this.callerInstanceOfWizardPage) {
            return ((WizardPage)this.caller).getShell();
        }
        if (this.callerInstanceOfSystemPromptDialog) {
            return ((SystemPromptDialog)this.caller).getShell();
        }
        return null;
    }

    public void setShowLocationPrompt(boolean show) {
        this.showLocationPrompt = show;
    }

    public void setLocationPrompt(String prompt) {
        this.locationPrompt = prompt;
    }

    public void addViewerFilter(ViewerFilter filter) {
        this.viewerFilters.add(filter);
    }

    public void setAllowFolderSelection(boolean allow) {
        this.allowFolderSelection = allow;
    }
}

