/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.IRSEPersistableContainer;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemProfileManager;
import org.eclipse.rse.core.model.RSEModelObject;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.internal.core.RSECoreMessages;
import org.eclipse.rse.persistence.IRSEPersistenceProvider;

public class SystemProfile
extends RSEModelObject
implements ISystemProfile,
IAdaptable {
    private ISystemProfileManager mgr = null;
    private IRSEPersistenceProvider provider = null;
    private boolean isActive = true;
    private String name = null;
    private boolean defaultPrivate = false;

    protected SystemProfile() {
    }

    public SystemProfile(String name, boolean isActive) {
        this.name = name;
        this.isActive = isActive;
    }

    public void setProfileManager(ISystemProfileManager mgr) {
        this.mgr = mgr;
    }

    public ISystemProfileManager getProfileManager() {
        return this.mgr;
    }

    public IHost createHost(IRSESystemType systemType, String connectionName, String hostName, String description) throws Exception {
        return RSECorePlugin.getTheSystemRegistry().createHost(this.getName(), systemType, connectionName, hostName, description);
    }

    public IHost[] getHosts() {
        return RSECorePlugin.getTheSystemRegistry().getHostsByProfile(this);
    }

    public ISystemFilterPool[] getFilterPools() {
        ISubSystemConfiguration[] ssFactories = RSECorePlugin.getTheSystemRegistry().getSubSystemConfigurations();
        Vector<ISystemFilterPool> poolsVector = new Vector<ISystemFilterPool>();
        int idx = 0;
        while (idx < ssFactories.length) {
            ISystemFilterPoolManager poolMgr = ssFactories[idx].getFilterPoolManager(this);
            ISystemFilterPool[] pools = poolMgr.getSystemFilterPools();
            int ydx = 0;
            while (ydx < pools.length) {
                poolsVector.add(pools[ydx]);
                ++ydx;
            }
            ++idx;
        }
        ISystemFilterPool[] allPools = new ISystemFilterPool[poolsVector.size()];
        poolsVector.toArray(allPools);
        return allPools;
    }

    public ISystemFilterPool[] getFilterPools(ISubSystemConfiguration ssf) {
        ISystemFilterPoolManager poolMgr = ssf.getFilterPoolManager(this);
        return poolMgr.getSystemFilterPools();
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean active) {
        this.isActive = active;
        this.setDirty(true);
    }

    public Object getAdapter(Class adapterType) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    public String toString() {
        String result = this.getName();
        if (result == null) {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.append("Profile(name: ");
            buf.append(this.name);
            buf.append(", defaultPrivate: ");
            buf.append(this.defaultPrivate);
            buf.append(')');
            result = buf.toString();
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return RSECoreMessages.RESID_MODELOBJECTS_PROFILE_DESCRIPTION;
    }

    public void setName(String newName) {
        this.name = newName;
        this.setDirty(true);
    }

    public boolean isDefaultPrivate() {
        return this.defaultPrivate;
    }

    public void setDefaultPrivate(boolean newDefaultPrivate) {
        this.defaultPrivate = newDefaultPrivate;
        this.setDirty(true);
    }

    public boolean commit() {
        boolean result = false;
        if (!RSECorePlugin.getThePersistenceManager().isBusy()) {
            result = RSECorePlugin.getThePersistenceManager().commitProfile(this, 5000L);
        }
        return result;
    }

    public IRSEPersistableContainer getPersistableParent() {
        return null;
    }

    public IRSEPersistableContainer[] getPersistableChildren() {
        ArrayList<Object> children = new ArrayList<Object>(10);
        children.addAll(Arrays.asList(this.getFilterPools()));
        children.addAll(Arrays.asList(this.getHosts()));
        children.addAll(Arrays.asList(this.getPropertySets()));
        IRSEPersistableContainer[] result = new IRSEPersistableContainer[children.size()];
        children.toArray(result);
        return result;
    }

    public IRSEPersistenceProvider getPersistenceProvider() {
        return this.provider;
    }

    public void setPersistenceProvider(IRSEPersistenceProvider provider) {
        this.provider = provider;
    }
}

