/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.persistence;

import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.PropertySet;
import org.eclipse.rse.persistence.IRSEPersistenceManager;
import org.eclipse.rse.tests.core.RSECoreTestCase;
import org.eclipse.rse.ui.RSEUIPlugin;

public class PersistenceTest
extends RSECoreTestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testPersistenceManagerStartup() {
        IRSEPersistenceManager m = RSECorePlugin.getThePersistenceManager();
        int i = 0;
        while (i < 5) {
            if (m.isRestoreComplete()) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            ++i;
        }
        PersistenceTest.assertTrue((String)"Restore not complete", (boolean)m.isRestoreComplete());
    }

    public void testProfilePersistence() {
        ISystemProfile p;
        ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
        try {
            registry.createSystemProfile("bogus", true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.reload();
        ISystemProfile[] profiles = registry.getSystemProfileManager().getSystemProfiles();
        PersistenceTest.assertEquals((int)3, (int)profiles.length);
        boolean found = false;
        int i = 0;
        while (i < profiles.length && !found) {
            p = profiles[i];
            found = p.isDefaultPrivate();
            ++i;
        }
        PersistenceTest.assertTrue((String)"Default private profile not found", (boolean)found);
        found = false;
        i = 0;
        while (i < profiles.length && !found) {
            p = profiles[i];
            found = p.getName().equals("Team");
            ++i;
        }
        PersistenceTest.assertTrue((String)"Team profile not found", (boolean)found);
        found = false;
        i = 0;
        while (i < profiles.length && !found) {
            p = profiles[i];
            found = p.getName().equals("bogus");
            ++i;
        }
        PersistenceTest.assertTrue((String)"bogus profile not found", (boolean)found);
        ISystemProfile bogus = registry.getSystemProfile("bogus");
        PersistenceTest.assertNotNull((Object)bogus);
        PersistenceTest.assertFalse((boolean)bogus.isDefaultPrivate());
        PersistenceTest.assertTrue((boolean)bogus.isActive());
        IPropertySet[] pSets = bogus.getPropertySets();
        PersistenceTest.assertNotNull((Object)pSets);
        PersistenceTest.assertEquals((int)0, (int)pSets.length);
        PropertySet bogusProperties = new PropertySet("bogus_properties");
        bogusProperties.addProperty("bp1", "1");
        bogusProperties.addProperty("bp2", "2");
        bogus.addPropertySet((IPropertySet)bogusProperties);
        bogus.commit();
        this.reload();
        bogus = registry.getSystemProfile("bogus");
        PersistenceTest.assertNotNull((Object)bogus);
        PersistenceTest.assertFalse((boolean)bogus.isDefaultPrivate());
        PersistenceTest.assertTrue((boolean)bogus.isActive());
        pSets = bogus.getPropertySets();
        PersistenceTest.assertNotNull((Object)pSets);
        PersistenceTest.assertEquals((int)1, (int)pSets.length);
        bogusProperties = bogus.getPropertySet("bogus_properties");
        PersistenceTest.assertNotNull((Object)bogusProperties);
        PersistenceTest.assertEquals((String)"1", (String)bogusProperties.getProperty("bp1").getValue());
        PersistenceTest.assertEquals((String)"2", (String)bogusProperties.getProperty("bp2").getValue());
        try {
            registry.deleteSystemProfile(bogus);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.reload();
    }

    public void testHostPersistence() {
        ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
        try {
            registry.createSystemProfile("bogus", true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ISystemProfile profile = registry.getSystemProfile("bogus");
        PersistenceTest.assertNotNull((Object)profile);
        try {
            IRSESystemType linuxType = RSECorePlugin.getTheCoreRegistry().getSystemTypeById("org.eclipse.rse.systemtype.linux");
            registry.createHost("bogus", linuxType, "myhost", "myhost.mynet.mycompany.net", null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        IHost host = registry.getHost(profile, "myhost");
        PersistenceTest.assertNotNull((Object)host);
        host.setDescription("description");
        PropertySet props = new PropertySet("host_props");
        props.addProperty("bp1", "1");
        props.addProperty("bp2", "2");
        host.addPropertySet((IPropertySet)props);
        host.commit();
        this.reload();
        profile = registry.getSystemProfile("bogus");
        PersistenceTest.assertNotNull((Object)profile);
        host = registry.getHost(profile, "myhost");
        PersistenceTest.assertNotNull((Object)host);
        props = host.getPropertySet("host_props");
        PersistenceTest.assertNotNull((Object)props);
        PersistenceTest.assertEquals((String)"1", (String)props.getProperty("bp1").getValue());
        PersistenceTest.assertEquals((String)"2", (String)props.getProperty("bp2").getValue());
    }

    private void reload() {
        IRSEPersistenceManager persistenceManager = RSECorePlugin.getThePersistenceManager();
        IJobManager jobManager = Job.getJobManager();
        try {
            jobManager.join((Object)persistenceManager, null);
        }
        catch (OperationCanceledException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        RSEUIPlugin.getDefault().restart();
    }
}

