/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.subsystems.files;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.IFileServiceSubSystem;
import org.eclipse.rse.tests.RSETestsPlugin;
import org.eclipse.rse.tests.core.connection.RSEBaseConnectionTestCase;

public class FileServiceTest
extends RSEBaseConnectionTestCase {
    private IFileServiceSubSystem fss;
    private IFileService fs;
    private File tempDir;
    private String tempDirPath;
    private IProgressMonitor mon = new NullProgressMonitor();
    static /* synthetic */ Class class$0;

    public void setUp() throws Exception {
        super.setUp();
        IHost localHost = this.getLocalSystemConnection();
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.services.files.IFileService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISubSystem[] ss = sr.getServiceSubSystems(localHost, (Class)clazz);
        int i = 0;
        while (i < ss.length) {
            if (ss[i] instanceof IFileServiceSubSystem) {
                this.fss = (IFileServiceSubSystem)ss[i];
                this.fs = this.fss.getFileService();
            }
            ++i;
        }
        try {
            this.tempDir = File.createTempFile("rsetest", "dir");
            FileServiceTest.assertTrue((boolean)this.tempDir.delete());
            FileServiceTest.assertTrue((boolean)this.tempDir.mkdir());
            this.tempDirPath = this.tempDir.getAbsolutePath();
        }
        catch (IOException iOException) {
            FileServiceTest.assertTrue((String)"Exception creating temp dir", (boolean)false);
        }
    }

    public void tearDown() throws Exception {
        try {
            this.fs.delete(this.tempDir.getParent(), this.tempDir.getName(), this.mon);
        }
        catch (SystemMessageException msg) {
            System.err.println("Exception on tearDown: " + msg.getLocalizedMessage());
        }
        super.tearDown();
    }

    public boolean isWindows() {
        return this.fss.getHost().getSystemType().isWindows();
    }

    public String getTestFileName() {
        if (!this.isWindows()) {
            return "a !@#${a}\"' fi\tle\b\\%^&*()?_ =[]~+-'`;:,.|<>";
        }
        return "a !@#${a}'` file%^&()_ =[]~+-;,.";
    }

    public void testCaseSensitive() {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCaseSensitive")) {
            return;
        }
        if (this.isWindows()) {
            FileServiceTest.assertFalse((boolean)this.fss.getSubSystemConfiguration().isCaseSensitive());
            FileServiceTest.assertFalse((boolean)this.fss.isCaseSensitive());
            FileServiceTest.assertFalse((boolean)this.fs.isCaseSensitive());
        } else {
            FileServiceTest.assertTrue((boolean)this.fss.getSubSystemConfiguration().isCaseSensitive());
            FileServiceTest.assertTrue((boolean)this.fss.isCaseSensitive());
            FileServiceTest.assertTrue((boolean)this.fs.isCaseSensitive());
        }
    }

    public void testCreateFile() throws SystemMessageException {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        String testName = this.getTestFileName();
        IHostFile hf = this.fs.createFile(this.tempDirPath, testName, this.mon);
        FileServiceTest.assertTrue((boolean)hf.exists());
        FileServiceTest.assertTrue((boolean)hf.canRead());
        FileServiceTest.assertTrue((boolean)hf.canWrite());
        FileServiceTest.assertEquals((String)hf.getName(), (String)testName);
        FileServiceTest.assertEquals((String)hf.getParentPath(), (String)this.tempDirPath);
        FileServiceTest.assertEquals((long)hf.getSize(), (long)0L);
        long modDate = hf.getModifiedDate();
        FileServiceTest.assertTrue((modDate > 0L ? 1 : 0) != 0);
        File theFile = new File(this.tempDir, testName);
        FileServiceTest.assertTrue((boolean)theFile.exists());
        FileServiceTest.assertTrue((modDate == theFile.lastModified() ? 1 : 0) != 0);
    }

    public void testCreateCaseSensitive() throws SystemMessageException {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateCaseSensitive")) {
            return;
        }
        String testName = this.getTestFileName();
        String testName2 = testName.toUpperCase();
        IHostFile hf = this.fs.createFile(this.tempDirPath, testName, this.mon);
        if (this.fss.isCaseSensitive()) {
            IHostFile hf2 = this.fs.getFile(this.tempDirPath, testName2, this.mon);
            FileServiceTest.assertFalse((boolean)hf2.exists());
            hf2 = this.fs.createFolder(this.tempDirPath, testName2, this.mon);
            FileServiceTest.assertTrue((boolean)hf2.exists());
            FileServiceTest.assertTrue((boolean)hf2.isDirectory());
            FileServiceTest.assertFalse((boolean)hf.equals(hf2));
        } else {
            IHostFile hf2 = this.fs.getFile(this.tempDirPath, testName2, this.mon);
            FileServiceTest.assertTrue((boolean)hf2.exists());
            try {
                hf2 = this.fs.createFolder(this.tempDirPath, testName2, this.mon);
            }
            catch (SystemMessageException e) {
                FileServiceTest.assertNotNull((Object)((Object)e));
            }
            FileServiceTest.assertTrue((boolean)hf2.exists());
            FileServiceTest.assertFalse((boolean)hf2.isDirectory());
            FileServiceTest.assertEquals((long)hf.getModifiedDate(), (long)hf2.getModifiedDate());
            FileServiceTest.assertEquals((long)hf.getSize(), (long)hf2.getSize());
            FileServiceTest.assertEquals((Object)new File(this.tempDirPath, testName), (Object)new File(this.tempDirPath, testName2));
            FileServiceTest.assertEquals((Object)hf, (Object)hf2);
        }
    }
}

