/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.clientserver.archiveutils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.eclipse.rse.internal.services.clientserver.archiveutils.SystemArchiveUtil;
import org.eclipse.rse.internal.services.clientserver.archiveutils.SystemUniversalZipEntry;
import org.eclipse.rse.services.clientserver.ISystemFileTypes;
import org.eclipse.rse.services.clientserver.SystemEncodingUtil;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.clientserver.archiveutils.ISystemArchiveHandler;
import org.eclipse.rse.services.clientserver.archiveutils.VirtualChild;
import org.eclipse.rse.services.clientserver.java.BasicClassFileParser;
import org.eclipse.rse.services.clientserver.search.SystemSearchLineMatch;
import org.eclipse.rse.services.clientserver.search.SystemSearchStringMatchLocator;
import org.eclipse.rse.services.clientserver.search.SystemSearchStringMatcher;

public class SystemZipHandler
implements ISystemArchiveHandler {
    protected ZipFile _zipfile;
    protected HashMap _virtualFS;
    protected File _file;
    protected long _vfsLastModified;
    protected boolean _exists;

    public SystemZipHandler(File file) {
        this._file = file;
        this._vfsLastModified = this._file.lastModified();
        if (this.openZipFile()) {
            this.buildTree();
            this.closeZipFile();
            this._exists = true;
        } else {
            this._exists = false;
        }
    }

    protected void buildTree() {
        this._virtualFS = new HashMap();
        Enumeration<? extends ZipEntry> entries = this._zipfile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry next = entries.nextElement();
            this.fillBranch(next);
        }
    }

    protected void fillBranch(ZipEntry next) {
        VirtualChild nextChild;
        SystemUniversalZipEntry nextEntry;
        if (next.getName().equals("/")) {
            return;
        }
        if (!next.isDirectory()) {
            nextEntry = new SystemUniversalZipEntry(next);
            nextChild = new VirtualChild(this, nextEntry.getFullName());
        } else {
            nextEntry = new SystemUniversalZipEntry(next);
            nextChild = new VirtualChild(this, nextEntry.getFullName());
            nextChild.isDirectory = true;
            if (!this._virtualFS.containsKey(nextChild.fullName)) {
                this._virtualFS.put(nextChild.fullName, new HashMap());
            }
        }
        if (!this._virtualFS.containsKey(nextChild.path)) {
            this.recursivePopulate(nextChild.path, nextChild);
        } else {
            HashMap hm = (HashMap)this._virtualFS.get(nextChild.path);
            hm.put(nextChild.name, nextChild);
        }
    }

    protected void recursivePopulate(String key, VirtualChild value) {
        if (this._virtualFS.containsKey(key)) {
            HashMap hm = (HashMap)this._virtualFS.get(key);
            hm.put(value.name, value);
            return;
        }
        HashMap<String, VirtualChild> newValue = new HashMap<String, VirtualChild>();
        newValue.put(value.name, value);
        this._virtualFS.put(key, newValue);
        if (key.equals("")) {
            return;
        }
        int i = key.lastIndexOf("/");
        if (i == -1) {
            VirtualChild nextValue = new VirtualChild(this, key);
            nextValue.isDirectory = true;
            this.recursivePopulate("", nextValue);
            return;
        }
        String newKey = key.substring(0, i);
        VirtualChild nextValue = new VirtualChild(this, key);
        nextValue.isDirectory = true;
        this.recursivePopulate(newKey, nextValue);
    }

    public VirtualChild[] getVirtualChildrenList() {
        return this.getVirtualChildrenList(true);
    }

    public VirtualChild[] getVirtualChildrenList(boolean closeZipFile) {
        if (!this._exists) {
            return new VirtualChild[0];
        }
        if (!this.updateVirtualFSIfNecessary()) {
            return new VirtualChild[0];
        }
        if (this.openZipFile()) {
            Vector<VirtualChild> children = new Vector<VirtualChild>();
            Enumeration<? extends ZipEntry> entries = this._zipfile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry next = entries.nextElement();
                SystemUniversalZipEntry nextEntry = new SystemUniversalZipEntry(next);
                VirtualChild nextChild = new VirtualChild(this, nextEntry.getFullName());
                nextChild.isDirectory = next.isDirectory();
                children.add(nextChild);
            }
            VirtualChild[] retVal = new VirtualChild[children.size()];
            int i = 0;
            while (i < children.size()) {
                retVal[i] = (VirtualChild)children.get(i);
                ++i;
            }
            if (closeZipFile) {
                this.closeZipFile();
            }
            return retVal;
        }
        return new VirtualChild[0];
    }

    public VirtualChild[] getVirtualChildrenList(String parent) {
        return this.getVirtualChildrenList(parent, true);
    }

    public VirtualChild[] getVirtualChildrenList(String parent, boolean closeZipFile) {
        if (!this._exists) {
            return new VirtualChild[0];
        }
        if (!this.updateVirtualFSIfNecessary()) {
            return new VirtualChild[0];
        }
        if (this.openZipFile()) {
            parent = ArchiveHandlerManager.cleanUpVirtualPath(parent);
            Vector<VirtualChild> children = new Vector<VirtualChild>();
            Enumeration<? extends ZipEntry> entries = this._zipfile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry next = entries.nextElement();
                String nextName = ArchiveHandlerManager.cleanUpVirtualPath(next.getName());
                if (!nextName.startsWith(parent) || nextName.equals(String.valueOf(parent) + "/")) continue;
                SystemUniversalZipEntry nextEntry = new SystemUniversalZipEntry(next);
                VirtualChild nextChild = new VirtualChild(this, nextEntry.getFullName());
                nextChild.isDirectory = next.isDirectory();
                children.add(nextChild);
            }
            VirtualChild[] retVal = new VirtualChild[children.size()];
            int i = 0;
            while (i < children.size()) {
                retVal[i] = (VirtualChild)children.get(i);
                ++i;
            }
            if (closeZipFile) {
                this.closeZipFile();
            }
            return retVal;
        }
        return new VirtualChild[0];
    }

    public VirtualChild[] getVirtualChildren(String fullVirtualName) {
        if (!this._exists) {
            return null;
        }
        if (!this.updateVirtualFSIfNecessary()) {
            return null;
        }
        fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
        VirtualChild[] values = null;
        if (this._virtualFS.containsKey(fullVirtualName)) {
            HashMap hm = (HashMap)this._virtualFS.get(fullVirtualName);
            Object[] valueArray = hm.values().toArray();
            values = new VirtualChild[hm.size()];
            int i = 0;
            while (i < hm.size()) {
                values[i] = (VirtualChild)valueArray[i];
                ++i;
            }
        }
        return values;
    }

    public VirtualChild[] getVirtualChildFolders(String fullVirtualName) {
        if (!this._exists) {
            return null;
        }
        if (!this.updateVirtualFSIfNecessary()) {
            return null;
        }
        fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
        Vector<Object> folders = new Vector<Object>();
        VirtualChild[] values = null;
        if (this._virtualFS.containsKey(fullVirtualName)) {
            HashMap hm = (HashMap)this._virtualFS.get(fullVirtualName);
            Object[] valueArray = hm.values().toArray();
            int i = 0;
            while (i < hm.size()) {
                if (((VirtualChild)valueArray[i]).isDirectory) {
                    folders.add(valueArray[i]);
                }
                ++i;
            }
            values = new VirtualChild[folders.size()];
            i = 0;
            while (i < folders.size()) {
                values[i] = (VirtualChild)folders.get(i);
                ++i;
            }
        }
        return values;
    }

    public VirtualChild getVirtualFile(String fullVirtualName) {
        String name;
        String path;
        if (!this._exists) {
            return new VirtualChild(this, fullVirtualName);
        }
        if (!this.updateVirtualFSIfNecessary()) {
            return new VirtualChild(this, fullVirtualName);
        }
        if ((fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName)) == "" || fullVirtualName == null) {
            return new VirtualChild(this);
        }
        int i = fullVirtualName.lastIndexOf("/");
        if (i == -1) {
            path = "";
            name = fullVirtualName;
        } else {
            path = fullVirtualName.substring(0, i);
            name = fullVirtualName.substring(i + 1);
        }
        HashMap hm = (HashMap)this._virtualFS.get(path);
        if (hm == null) {
            return new VirtualChild(this, fullVirtualName);
        }
        VirtualChild vc = (VirtualChild)hm.get(name);
        if (vc == null) {
            return new VirtualChild(this, fullVirtualName);
        }
        return vc;
    }

    public boolean exists(String fullVirtualName) {
        boolean keepOpen;
        if (!this._exists) {
            return false;
        }
        if ((fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName)) == "" || fullVirtualName == null) {
            return false;
        }
        if (this._vfsLastModified == this._file.lastModified()) {
            String name;
            String path;
            int i = fullVirtualName.lastIndexOf("/");
            if (i == -1) {
                path = "";
                name = fullVirtualName;
            } else {
                path = fullVirtualName.substring(0, i);
                name = fullVirtualName.substring(i + 1);
            }
            HashMap hm = (HashMap)this._virtualFS.get(path);
            if (hm == null) {
                return false;
            }
            return hm.get(name) != null;
        }
        boolean retval = false;
        boolean bl = keepOpen = this._zipfile != null;
        if (this.openZipFile()) {
            try {
                this.safeGetEntry(fullVirtualName);
                retval = true;
            }
            catch (IOException iOException) {
                try {
                    this.safeGetEntry(String.valueOf(fullVirtualName) + "/");
                    retval = true;
                }
                catch (IOException iOException2) {
                    retval = false;
                }
            }
            this.buildTree();
            this._vfsLastModified = this._file.lastModified();
            if (!keepOpen) {
                this.closeZipFile();
            }
            return retval;
        }
        System.out.println("Could not open the ZipFile " + this._file.toString());
        return false;
    }

    public File getArchive() {
        return this._file;
    }

    public long getTimeStampFor(String fullVirtualName) {
        return this.getTimeStampFor(fullVirtualName, true);
    }

    public long getTimeStampFor(String fullVirtualName, boolean closeZipFile) {
        if (!this._exists) {
            return 0L;
        }
        if (this.openZipFile()) {
            fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
            ZipEntry entry = null;
            try {
                entry = this.safeGetEntry(fullVirtualName);
            }
            catch (IOException iOException) {
                if (closeZipFile) {
                    this.closeZipFile();
                }
                return this._file.lastModified();
            }
            if (closeZipFile) {
                this.closeZipFile();
            }
            return entry.getTime();
        }
        return this._file.lastModified();
    }

    public long getSizeFor(String fullVirtualName) {
        return this.getSizeFor(fullVirtualName, true);
    }

    public long getSizeFor(String fullVirtualName, boolean closeZipFile) {
        if (!this._exists) {
            return 0L;
        }
        if (this.openZipFile()) {
            fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
            ZipEntry entry = null;
            try {
                entry = this.safeGetEntry(fullVirtualName);
            }
            catch (IOException iOException) {
                if (closeZipFile) {
                    this.closeZipFile();
                }
                return 0L;
            }
            if (closeZipFile) {
                this.closeZipFile();
            }
            return entry.getSize();
        }
        return 0L;
    }

    public boolean extractVirtualFile(String fullVirtualName, File destination) {
        return this.extractVirtualFile(fullVirtualName, destination, true, SystemEncodingUtil.ENCODING_UTF_8, false);
    }

    public boolean extractVirtualFile(String fullVirtualName, File destination, String sourceEncoding, boolean isText) {
        return this.extractVirtualFile(fullVirtualName, destination, true, sourceEncoding, isText);
    }

    public boolean extractVirtualFile(String fullVirtualName, File destination, boolean closeZipFile, String sourceEncoding, boolean isText) {
        if (!this._exists) {
            return false;
        }
        if (this.openZipFile()) {
            InputStream is;
            ZipEntry entry;
            block18: {
                block17: {
                    fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
                    entry = null;
                    entry = this.safeGetEntry(fullVirtualName);
                    if (!entry.isDirectory()) break block17;
                    destination.delete();
                    destination.mkdirs();
                    destination.setLastModified(entry.getTime());
                    if (closeZipFile) {
                        this.closeZipFile();
                    }
                    return true;
                }
                is = this._zipfile.getInputStream(entry);
                if (is != null) break block18;
                destination.setLastModified(entry.getTime());
                if (closeZipFile) {
                    this.closeZipFile();
                }
                return true;
            }
            try {
                BufferedInputStream reader = new BufferedInputStream(is);
                if (!destination.exists()) {
                    File parentFile = destination.getParentFile();
                    if (!parentFile.exists()) {
                        parentFile.mkdirs();
                    }
                    destination.createNewFile();
                }
                BufferedOutputStream writer = new BufferedOutputStream(new FileOutputStream(destination));
                byte[] buf = new byte[1024];
                int numRead = reader.read(buf);
                while (numRead > 0) {
                    if (isText) {
                        String bufString = new String(buf, 0, numRead, sourceEncoding);
                        byte[] convertedBuf = bufString.getBytes();
                        int newSize = convertedBuf.length;
                        writer.write(convertedBuf, 0, newSize);
                    } else {
                        writer.write(buf, 0, numRead);
                    }
                    numRead = reader.read(buf);
                }
                writer.close();
                reader.close();
            }
            catch (IOException e) {
                if (this._virtualFS.containsKey(fullVirtualName)) {
                    destination.delete();
                    destination.mkdirs();
                    destination.setLastModified(this._file.lastModified());
                    if (closeZipFile) {
                        this.closeZipFile();
                    }
                    return true;
                }
                System.out.println(e.getMessage());
                if (closeZipFile) {
                    this.closeZipFile();
                }
                return false;
            }
            destination.setLastModified(entry.getTime());
            if (closeZipFile) {
                this.closeZipFile();
            }
            return true;
        }
        return false;
    }

    public boolean extractVirtualDirectory(String dir, File destinationParent) {
        return this.extractVirtualDirectory(dir, destinationParent, null, SystemEncodingUtil.ENCODING_UTF_8, false);
    }

    public boolean extractVirtualDirectory(String dir, File destinationParent, String sourceEncoding, boolean isText) {
        return this.extractVirtualDirectory(dir, destinationParent, null, sourceEncoding, isText);
    }

    public boolean extractVirtualDirectory(String dir, File destinationParent, File destination) {
        return this.extractVirtualDirectory(dir, destinationParent, destination, SystemEncodingUtil.ENCODING_UTF_8, false);
    }

    public boolean extractVirtualDirectory(String dir, File destinationParent, File destination, String sourceEncoding, boolean isText) {
        String name;
        int charsToTrim;
        if (!this._exists) {
            return false;
        }
        if (!destinationParent.isDirectory()) {
            return false;
        }
        if (!this._virtualFS.containsKey(dir = ArchiveHandlerManager.cleanUpVirtualPath(dir))) {
            return false;
        }
        int j = dir.lastIndexOf("/");
        if (j == -1) {
            charsToTrim = 0;
            name = dir;
        } else {
            charsToTrim = dir.substring(0, j).length() + 1;
            name = dir.substring(j + 1);
        }
        if (destination == null) {
            destination = dir.equals("") ? destinationParent : new File(destinationParent, name);
        }
        if (destination != destinationParent) {
            if (destination.isFile() && destination.exists() && !SystemArchiveUtil.delete(destination)) {
                System.out.println("Could not overwrite directory " + destination);
                System.out.println("(Could not delete old directory)");
                return false;
            }
            if (!destination.exists() && !destination.mkdirs()) {
                System.out.println("Could not overwrite directory " + destination);
                System.out.println("(Could not create new directory)");
                return false;
            }
        }
        File topFile = destination;
        String topFilePath = topFile.getAbsolutePath().replace('\\', '/');
        String lastPortionOfDir = null;
        int lastSlashIndex = dir.lastIndexOf(47);
        lastPortionOfDir = -1 == lastSlashIndex ? dir : dir.substring(lastSlashIndex + 1);
        if (!topFilePath.endsWith(lastPortionOfDir)) {
            this.rename(dir, topFile.getName());
            dir = topFile.getName();
        }
        VirtualChild[] newChildren = this.getVirtualChildrenList(dir);
        this.extractVirtualFile(String.valueOf(dir) + '/', topFile, sourceEncoding, isText);
        int i = 0;
        while (i < newChildren.length) {
            String newName = newChildren[i].fullName.substring(charsToTrim);
            char separator = File.separatorChar;
            File nextFile = new File(destinationParent, newName = newName.replace('/', separator));
            if (!nextFile.exists()) {
                if (newChildren[i].isDirectory) {
                    if (!nextFile.mkdirs()) {
                        System.out.println("Could not create folder " + nextFile.toString());
                        return false;
                    }
                } else {
                    this.createFile(nextFile);
                }
                boolean success = false;
                success = newChildren[i].isDirectory ? this.extractVirtualFile(String.valueOf(newChildren[i].fullName) + '/', nextFile, sourceEncoding, isText) : this.extractVirtualFile(newChildren[i].fullName, nextFile, sourceEncoding, isText);
                if (!success) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    protected boolean createFile(File file) {
        try {
            if (!file.createNewFile()) {
                System.out.println("File already exists: " + file.toString());
                return false;
            }
            return true;
        }
        catch (IOException e) {
            if (!file.getParentFile().exists() && file.getParentFile().mkdirs()) {
                return this.createFile(file);
            }
            System.out.println("Could not create " + file.toString());
            System.out.println(e.getMessage());
            return false;
        }
    }

    public boolean add(File file, String virtualPath, String name) {
        return this.add(file, virtualPath, name, SystemEncodingUtil.ENCODING_UTF_8, SystemEncodingUtil.ENCODING_UTF_8, false);
    }

    public boolean add(InputStream stream, String virtualPath, String name, String sourceEncoding, String targetEncoding, boolean isText) {
        if (!this._exists) {
            return false;
        }
        if (this.exists(String.valueOf(virtualPath = ArchiveHandlerManager.cleanUpVirtualPath(virtualPath)) + "/" + name)) {
            return this.replace(String.valueOf(virtualPath) + "/" + name, stream, name, sourceEncoding, targetEncoding, isText);
        }
        if (this.openZipFile()) {
            virtualPath = ArchiveHandlerManager.cleanUpVirtualPath(virtualPath);
            try {
                File outputTempFile = new File(String.valueOf(this._file.getAbsolutePath()) + "temp");
                ZipOutputStream dest = new ZipOutputStream(new FileOutputStream(outputTempFile));
                dest.setMethod(8);
                VirtualChild[] vcList = this.getVirtualChildrenList(false);
                if (vcList.length != 1 || !vcList[0].fullName.equals("")) {
                    this.recreateZipDeleteEntries(vcList, dest, null);
                }
                ZipEntry newEntry = this.appendBytes(stream, dest, virtualPath, name, sourceEncoding, targetEncoding, isText);
                this.fillBranch(newEntry);
                dest.close();
                this.replaceOldZip(outputTempFile);
            }
            catch (IOException e) {
                System.out.println("Could not add a file.");
                System.out.println(e.getMessage());
                this.closeZipFile();
                return false;
            }
            this.closeZipFile();
            return true;
        }
        return false;
    }

    public boolean add(File[] files, String virtualPath, String[] names) {
        String[] encodings = new String[files.length];
        boolean[] isTexts = new boolean[files.length];
        int i = 0;
        while (i < files.length) {
            encodings[i] = SystemEncodingUtil.ENCODING_UTF_8;
            isTexts[i] = false;
            ++i;
        }
        return this.add(files, virtualPath, names, encodings, encodings, isTexts, true);
    }

    public boolean add(File[] files, String virtualPath, String[] names, String[] sourceEncodings, String[] targetEncodings, boolean[] isText) {
        return this.add(files, virtualPath, names, sourceEncodings, targetEncodings, isText, true);
    }

    public boolean add(File[] files, String virtualPath, String[] names, String[] sourceEncodings, String[] targetEncodings, boolean[] isText, boolean closeZipFile) {
        if (!this._exists) {
            return false;
        }
        if (this.openZipFile()) {
            virtualPath = ArchiveHandlerManager.cleanUpVirtualPath(virtualPath);
            int numFiles = files.length;
            int i = 0;
            while (i < numFiles) {
                if (!files[i].exists() || !files[i].canRead()) {
                    return false;
                }
                String fullVirtualName = SystemZipHandler.getFullVirtualName(virtualPath, names[i]);
                if (this.exists(fullVirtualName)) {
                    return this.replace(fullVirtualName, files[i], names[i]);
                }
                ++i;
            }
            try {
                File outputTempFile = new File(String.valueOf(this._file.getAbsolutePath()) + "temp");
                ZipOutputStream dest = new ZipOutputStream(new FileOutputStream(outputTempFile));
                dest.setMethod(8);
                VirtualChild[] vcList = this.getVirtualChildrenList(false);
                if (vcList.length != 1 || !vcList[0].fullName.equals("")) {
                    this.recreateZipDeleteEntries(vcList, dest, null);
                }
                int i2 = 0;
                while (i2 < numFiles) {
                    ZipEntry newEntry = this.appendFile(files[i2], dest, virtualPath, names[i2], sourceEncodings[i2], targetEncodings[i2], isText[i2]);
                    this.fillBranch(newEntry);
                    ++i2;
                }
                dest.close();
                this.replaceOldZip(outputTempFile);
            }
            catch (IOException e) {
                System.out.println("Could not add a file.");
                System.out.println(e.getMessage());
                if (closeZipFile) {
                    this.closeZipFile();
                }
                return false;
            }
            if (closeZipFile) {
                this.closeZipFile();
            }
            return true;
        }
        return false;
    }

    public static void listAllFiles(File parent, HashSet found) {
        File[] children = parent.listFiles();
        if (children == null) {
            found.remove(parent);
            return;
        }
        int i = 0;
        while (i < children.length) {
            if (!found.contains(children[i]) && children[i].canRead()) {
                found.add(children[i]);
                if (children[i].isDirectory()) {
                    SystemZipHandler.listAllFiles(children[i], found);
                }
            }
            ++i;
        }
    }

    protected void recreateZipDeleteEntries(VirtualChild[] vcList, ZipOutputStream dest, HashSet omitChildren) throws IOException {
        if (omitChildren != null && vcList.length == omitChildren.size()) {
            ZipEntry entry = new ZipEntry("/");
            dest.putNextEntry(entry);
            dest.closeEntry();
            return;
        }
        int i = 0;
        while (i < vcList.length) {
            if (omitChildren == null || !omitChildren.contains(vcList[i].fullName)) {
                ZipEntry nextEntry;
                if (vcList[i].isDirectory) {
                    nextEntry = this.safeGetEntry(String.valueOf(vcList[i].fullName) + "/");
                    dest.putNextEntry(nextEntry);
                    dest.closeEntry();
                } else {
                    nextEntry = this.safeGetEntry(vcList[i].fullName);
                    BufferedInputStream source = new BufferedInputStream(this._zipfile.getInputStream(nextEntry));
                    nextEntry.setCompressedSize(-1L);
                    dest.putNextEntry(nextEntry);
                    byte[] buf = new byte[1024];
                    int numRead = source.read(buf);
                    while (numRead > 0) {
                        dest.write(buf, 0, numRead);
                        numRead = source.read(buf);
                    }
                    dest.closeEntry();
                    source.close();
                }
            }
            ++i;
        }
    }

    protected void recreateZipRenameEntries(VirtualChild[] vcList, ZipOutputStream dest, HashMap names) throws IOException {
        int i = 0;
        while (i < vcList.length) {
            ZipEntry newEntry;
            ZipEntry nextEntry;
            if (names.containsKey(vcList[i].getArchiveStandardName())) {
                String oldName = vcList[i].getArchiveStandardName();
                String newName = (String)names.get(oldName);
                vcList[i].renameTo(newName);
                nextEntry = this.safeGetEntry(oldName);
                newEntry = this.createSafeZipEntry(newName);
                newEntry.setComment(nextEntry.getComment());
                newEntry.setExtra(nextEntry.getExtra());
                newEntry.setTime(nextEntry.getTime());
            } else {
                newEntry = nextEntry = this.safeGetEntry(vcList[i].getArchiveStandardName());
            }
            if (nextEntry.isDirectory()) {
                dest.putNextEntry(newEntry);
                dest.closeEntry();
            } else {
                BufferedInputStream source = new BufferedInputStream(this._zipfile.getInputStream(nextEntry));
                newEntry.setCompressedSize(-1L);
                dest.putNextEntry(newEntry);
                byte[] buf = new byte[1024];
                int numRead = source.read(buf);
                while (numRead > 0) {
                    dest.write(buf, 0, numRead);
                    numRead = source.read(buf);
                }
                dest.closeEntry();
                source.close();
            }
            ++i;
        }
    }

    protected ZipEntry appendFile(File file, ZipOutputStream dest, String virtualPath, String name, String sourceEncoding, String targetEncoding, boolean isText) throws IOException {
        ZipEntry newEntry;
        if (file.isDirectory()) {
            String fullName = String.valueOf(virtualPath) + "/" + name;
            if (!fullName.endsWith("/")) {
                fullName = String.valueOf(fullName) + "/";
            }
            newEntry = this.createSafeZipEntry(fullName);
        } else {
            newEntry = this.createSafeZipEntry(String.valueOf(virtualPath) + "/" + name);
        }
        newEntry.setTime(file.lastModified());
        dest.putNextEntry(newEntry);
        if (!file.isDirectory()) {
            BufferedInputStream source = new BufferedInputStream(new FileInputStream(file));
            byte[] buf = new byte[1024];
            int numRead = source.read(buf);
            long fileSize = file.length();
            long totalRead = 0L;
            while (numRead > 0 && totalRead < fileSize) {
                totalRead += (long)numRead;
                if (isText) {
                    String bufString = new String(buf, 0, numRead, sourceEncoding);
                    byte[] convertedBuf = bufString.getBytes(targetEncoding);
                    int newSize = convertedBuf.length;
                    dest.write(convertedBuf, 0, newSize);
                } else {
                    dest.write(buf, 0, numRead);
                }
                long maxRead = 1024L;
                long deltaLeft = fileSize - totalRead;
                numRead = deltaLeft > 1024L ? source.read(buf, 0, (int)maxRead) : source.read(buf, 0, (int)deltaLeft);
            }
            dest.closeEntry();
            source.close();
        }
        return newEntry;
    }

    protected ZipEntry appendBytes(InputStream stream, ZipOutputStream dest, String virtualPath, String name, String sourceEncoding, String targetEncoding, boolean isText) throws IOException {
        ZipEntry newEntry = this.createSafeZipEntry(String.valueOf(virtualPath) + "/" + name);
        dest.putNextEntry(newEntry);
        BufferedInputStream source = new BufferedInputStream(stream);
        byte[] buf = new byte[1024];
        int numRead = source.read(buf);
        long totalRead = 0L;
        while (numRead > 0 && source.available() > 0) {
            totalRead += (long)numRead;
            if (isText) {
                String bufString = new String(buf, 0, numRead, sourceEncoding);
                byte[] convertedBuf = bufString.getBytes(targetEncoding);
                int newSize = convertedBuf.length;
                dest.write(convertedBuf, 0, newSize);
            } else {
                dest.write(buf, 0, numRead);
            }
            long maxRead = 1024L;
            long deltaLeft = source.available();
            numRead = deltaLeft > 1024L ? source.read(buf, 0, (int)maxRead) : source.read(buf, 0, (int)deltaLeft);
        }
        dest.closeEntry();
        source.close();
        return newEntry;
    }

    protected void replaceOldZip(File outputTempFile) throws IOException {
        String oldName = this._file.getAbsolutePath();
        this._zipfile.close();
        File oldFile = new File(String.valueOf(oldName) + "old");
        System.out.println(this._file.renameTo(oldFile));
        System.out.println(outputTempFile.renameTo(this._file));
        this._vfsLastModified = this._file.lastModified();
        this._zipfile = new ZipFile(this._file);
        oldFile.delete();
    }

    public boolean delete(String fullVirtualName) {
        return this.delete(fullVirtualName, true);
    }

    public boolean delete(String fullVirtualName, boolean closeZipFile) {
        if (!this._exists) {
            return false;
        }
        if (this.openZipFile()) {
            fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
            VirtualChild vc = this.getVirtualFile(fullVirtualName);
            VirtualChild[] vcOmmit = new VirtualChild[1];
            if (!vc.exists()) {
                if (closeZipFile) {
                    this.closeZipFile();
                }
                return false;
            }
            if (vc.isDirectory) {
                vcOmmit = this.getVirtualChildrenList(fullVirtualName, false);
            }
            File outputTempFile = null;
            try {
                outputTempFile = new File(String.valueOf(this._file.getAbsolutePath()) + "temp");
                ZipOutputStream dest = new ZipOutputStream(new FileOutputStream(outputTempFile));
                dest.setMethod(8);
                VirtualChild[] vcList = this.getVirtualChildrenList(false);
                HashSet<String> omissions = new HashSet<String>();
                if (vc.isDirectory) {
                    int i = 0;
                    while (i < vcOmmit.length) {
                        omissions.add(vcOmmit[i].fullName);
                        ++i;
                    }
                    try {
                        this.safeGetEntry(vc.fullName);
                        omissions.add(vc.fullName);
                    }
                    catch (IOException iOException) {}
                } else {
                    omissions.add(fullVirtualName);
                }
                this.recreateZipDeleteEntries(vcList, dest, omissions);
                dest.close();
                this.replaceOldZip(outputTempFile);
                HashMap hm = (HashMap)this._virtualFS.get(vc.path);
                hm.remove(vc.name);
                if (vc.isDirectory) {
                    this.delTree(vc);
                }
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
                System.out.println("Could not delete " + fullVirtualName);
                if (outputTempFile != null) {
                    outputTempFile.delete();
                }
                if (closeZipFile) {
                    this.closeZipFile();
                }
                return false;
            }
            if (closeZipFile) {
                this.closeZipFile();
            }
            return true;
        }
        return false;
    }

    protected void delTree(VirtualChild vc) {
        HashMap hm = (HashMap)this._virtualFS.get(vc.fullName);
        Object[] children = hm.values().toArray();
        int i = 0;
        while (i < children.length) {
            VirtualChild next = (VirtualChild)children[i];
            hm.remove(next.name);
            if (next.isDirectory) {
                this.delTree(next);
            }
            ++i;
        }
    }

    public boolean replace(String fullVirtualName, File file, String name) {
        return this.replace(fullVirtualName, file, name, true);
    }

    public boolean replace(String fullVirtualName, File file, String name, boolean closeZipFile) {
        if (!this._exists) {
            return false;
        }
        if (!file.exists() || !file.canRead()) {
            return false;
        }
        if (!this.exists(fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName))) {
            return this.add(file, fullVirtualName, name);
        }
        if (this.openZipFile()) {
            File outputTempFile = null;
            try {
                outputTempFile = new File(String.valueOf(this._file.getAbsolutePath()) + "temp");
                ZipOutputStream dest = new ZipOutputStream(new FileOutputStream(outputTempFile));
                dest.setMethod(8);
                VirtualChild[] vcList = this.getVirtualChildrenList(false);
                HashSet<String> omissions = new HashSet<String>();
                omissions.add(fullVirtualName);
                this.recreateZipDeleteEntries(vcList, dest, omissions);
                int i = fullVirtualName.lastIndexOf("/");
                String virtualPath = i == -1 ? "" : fullVirtualName.substring(0, i);
                this.appendFile(file, dest, virtualPath, name, SystemEncodingUtil.ENCODING_UTF_8, SystemEncodingUtil.ENCODING_UTF_8, false);
                dest.close();
                this.replaceOldZip(outputTempFile);
            }
            catch (IOException iOException) {
                System.out.println("Could not replace " + file.getName());
                if (outputTempFile != null) {
                    outputTempFile.delete();
                }
                if (closeZipFile) {
                    this.closeZipFile();
                }
                return false;
            }
            if (closeZipFile) {
                this.closeZipFile();
            }
            return true;
        }
        return false;
    }

    public boolean replace(String fullVirtualName, InputStream stream, String name, String sourceEncoding, String targetEncoding, boolean isText) {
        if (!this._exists) {
            return false;
        }
        if (!this.exists(fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName))) {
            return this.add(stream, fullVirtualName, name, sourceEncoding, targetEncoding, isText);
        }
        if (this.openZipFile()) {
            File outputTempFile = null;
            try {
                outputTempFile = new File(String.valueOf(this._file.getAbsolutePath()) + "temp");
                ZipOutputStream dest = new ZipOutputStream(new FileOutputStream(outputTempFile));
                dest.setMethod(8);
                VirtualChild[] vcList = this.getVirtualChildrenList(false);
                HashSet<String> omissions = new HashSet<String>();
                omissions.add(fullVirtualName);
                this.recreateZipDeleteEntries(vcList, dest, omissions);
                int i = fullVirtualName.lastIndexOf("/");
                String virtualPath = i == -1 ? "" : fullVirtualName.substring(0, i);
                this.appendBytes(stream, dest, virtualPath, name, sourceEncoding, targetEncoding, isText);
                dest.close();
                this.replaceOldZip(outputTempFile);
            }
            catch (IOException iOException) {
                System.out.println("Could not replace " + fullVirtualName);
                if (outputTempFile != null) {
                    outputTempFile.delete();
                }
                this.closeZipFile();
                return false;
            }
            this.closeZipFile();
            return true;
        }
        return false;
    }

    public boolean fullRename(String fullVirtualName, String newFullVirtualName) {
        return this.fullRename(fullVirtualName, newFullVirtualName, true);
    }

    public boolean fullRename(String fullVirtualName, String newFullVirtualName, boolean closeZipFile) {
        if (!this._exists) {
            return false;
        }
        fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
        newFullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(newFullVirtualName);
        VirtualChild vc = this.getVirtualFile(fullVirtualName);
        if (!vc.exists()) {
            System.out.println("The virtual file " + fullVirtualName + " does not exist.");
            return false;
        }
        if (this.openZipFile()) {
            File outputTempFile = null;
            try {
                outputTempFile = new File(String.valueOf(this._file.getAbsolutePath()) + "temp");
                ZipOutputStream dest = new ZipOutputStream(new FileOutputStream(outputTempFile));
                dest.setMethod(8);
                VirtualChild[] vcList = this.getVirtualChildrenList(false);
                HashMap<String, String> names = new HashMap<String, String>();
                if (vc.isDirectory) {
                    VirtualChild[] renameList = this.getVirtualChildrenList(fullVirtualName, false);
                    int i = 0;
                    while (i < renameList.length) {
                        int j = fullVirtualName.length();
                        String suffix = renameList[i].fullName.substring(j);
                        String newName = String.valueOf(newFullVirtualName) + suffix;
                        if (renameList[i].isDirectory) {
                            newName = String.valueOf(newName) + "/";
                            names.put(String.valueOf(renameList[i].fullName) + "/", newName);
                        } else {
                            names.put(renameList[i].fullName, newName);
                        }
                        ++i;
                    }
                    try {
                        this.safeGetEntry(fullVirtualName);
                        names.put(String.valueOf(fullVirtualName) + "/", String.valueOf(newFullVirtualName) + "/");
                    }
                    catch (IOException iOException) {}
                } else {
                    names.put(fullVirtualName, newFullVirtualName);
                }
                this.recreateZipRenameEntries(vcList, dest, names);
                dest.close();
                this.replaceOldZip(outputTempFile);
                this.buildTree();
            }
            catch (IOException iOException) {
                System.out.println("Could not rename " + fullVirtualName);
                if (outputTempFile != null) {
                    outputTempFile.delete();
                }
                if (closeZipFile) {
                    this.closeZipFile();
                }
                return false;
            }
            if (closeZipFile) {
                this.closeZipFile();
            }
            return true;
        }
        return false;
    }

    public boolean move(String fullVirtualName, String destinationVirtualPath) {
        fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
        destinationVirtualPath = ArchiveHandlerManager.cleanUpVirtualPath(destinationVirtualPath);
        int i = fullVirtualName.lastIndexOf("/");
        if (i == -1) {
            return this.fullRename(fullVirtualName, String.valueOf(destinationVirtualPath) + "/" + fullVirtualName);
        }
        String name = fullVirtualName.substring(i);
        return this.fullRename(fullVirtualName, String.valueOf(destinationVirtualPath) + name);
    }

    public boolean rename(String fullVirtualName, String newName) {
        int i = (fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName)).lastIndexOf("/");
        if (i == -1) {
            return this.fullRename(fullVirtualName, newName);
        }
        String fullNewName = String.valueOf(fullVirtualName.substring(0, i + 1)) + newName;
        return this.fullRename(fullVirtualName, fullNewName);
    }

    public File[] getFiles(String[] fullNames) {
        if (!this._exists) {
            return new File[0];
        }
        File[] files = new File[fullNames.length];
        int i = 0;
        while (i < fullNames.length) {
            String fullName = fullNames[i];
            int j = (fullName = ArchiveHandlerManager.cleanUpVirtualPath(fullName)).lastIndexOf("/");
            String name = j == -1 ? fullName : fullName.substring(j + 1);
            try {
                files[i] = File.createTempFile(name, "virtual");
                files[i].deleteOnExit();
                this.extractVirtualFile(fullNames[i], files[i]);
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
                System.out.println("Could not extract virtual file: " + fullNames[i]);
                return null;
            }
            ++i;
        }
        return files;
    }

    public boolean createFolder(String name) {
        name = ArchiveHandlerManager.cleanUpVirtualPath(name);
        name = String.valueOf(name) + "/";
        return this.createVirtualObject(name, true);
    }

    public boolean createFile(String name) {
        name = ArchiveHandlerManager.cleanUpVirtualPath(name);
        return this.createVirtualObject(name, true);
    }

    protected boolean createVirtualObject(String name, boolean closeZipFile) {
        if (!this._exists) {
            return false;
        }
        if (this.exists(name)) {
            return false;
        }
        if (this.openZipFile()) {
            try {
                File outputTempFile = new File(String.valueOf(this._file.getAbsolutePath()) + "temp");
                ZipOutputStream dest = new ZipOutputStream(new FileOutputStream(outputTempFile));
                dest.setMethod(8);
                VirtualChild[] vcList = this.getVirtualChildrenList(false);
                if (vcList.length != 1 || !vcList[0].fullName.equals("")) {
                    this.recreateZipDeleteEntries(vcList, dest, null);
                }
                ZipEntry newEntry = this.appendEmptyFile(dest, name);
                this.fillBranch(newEntry);
                dest.close();
                this.replaceOldZip(outputTempFile);
            }
            catch (IOException e) {
                System.out.println("Could not add a file.");
                System.out.println(e.getMessage());
                if (closeZipFile) {
                    this.closeZipFile();
                }
                return false;
            }
            if (closeZipFile) {
                this.closeZipFile();
            }
            return true;
        }
        return false;
    }

    protected ZipEntry appendEmptyFile(ZipOutputStream dest, String name) throws IOException {
        boolean isDirectory = name.endsWith("/");
        ZipEntry newEntry = this.createSafeZipEntry(name);
        dest.putNextEntry(newEntry);
        if (!isDirectory) {
            dest.write(new byte[0], 0, 0);
            dest.closeEntry();
        }
        return newEntry;
    }

    protected ZipEntry createSafeZipEntry(String name) {
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        return new ZipEntry(name);
    }

    public String getStandardName(VirtualChild vc) {
        if (vc.isDirectory) {
            return String.valueOf(vc.fullName) + "/";
        }
        return vc.fullName;
    }

    protected boolean openZipFile() {
        if (this._zipfile != null) {
            this.closeZipFile();
        }
        try {
            this._zipfile = new ZipFile(this._file);
        }
        catch (IOException e) {
            System.out.println("Could not open zipfile: " + this._file);
            System.out.println(e.getMessage());
            return false;
        }
        return true;
    }

    protected boolean closeZipFile() {
        try {
            this._zipfile.close();
        }
        catch (IOException e) {
            System.out.println("Could not close zipfile: " + this._file);
            System.out.println(e.getMessage());
            return false;
        }
        return true;
    }

    protected boolean updateVirtualFSIfNecessary() {
        if (this._vfsLastModified != this._file.lastModified()) {
            if (this.openZipFile()) {
                this.buildTree();
                this._vfsLastModified = this._file.lastModified();
                this.closeZipFile();
                return true;
            }
            return false;
        }
        return true;
    }

    protected ZipEntry safeGetEntry(String name) throws IOException {
        ZipEntry entry = this._zipfile.getEntry(name);
        if (entry == null) {
            entry = this._zipfile.getEntry("/" + name);
        }
        if (entry == null) {
            throw new IOException("SystemZipHandler.safeGetEntry(): The ZipEntry " + name + " cannot be found in " + this._file.toString());
        }
        return entry;
    }

    public boolean create() {
        block3: {
            try {
                ZipOutputStream dest = new ZipOutputStream(new FileOutputStream(this._file));
                dest.setMethod(8);
                VirtualChild[] vcList = new VirtualChild[]{};
                HashSet omissions = new HashSet();
                this.recreateZipDeleteEntries(vcList, dest, omissions);
                dest.close();
                if (this.openZipFile()) {
                    this.buildTree();
                    this.closeZipFile();
                    break block3;
                }
                return false;
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
                return false;
            }
        }
        this._exists = true;
        return true;
    }

    public SystemSearchLineMatch[] search(String fullVirtualName, SystemSearchStringMatcher matcher) {
        if (matcher.isSearchStringEmpty() || matcher.isSearchStringAsterisk()) {
            return new SystemSearchLineMatch[0];
        }
        VirtualChild vc = this.getVirtualFile(fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName));
        if (!vc.exists() || vc.isDirectory) {
            return new SystemSearchLineMatch[0];
        }
        if (this.openZipFile()) {
            ZipEntry entry = null;
            SystemSearchLineMatch[] matches = null;
            try {
                entry = this.safeGetEntry(fullVirtualName);
                InputStream is = this._zipfile.getInputStream(entry);
                if (is == null) {
                    return new SystemSearchLineMatch[0];
                }
                InputStreamReader isr = new InputStreamReader(is);
                BufferedReader bufReader = new BufferedReader(isr);
                SystemSearchStringMatchLocator locator = new SystemSearchStringMatchLocator(bufReader, matcher);
                matches = locator.locateMatches();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
            this.closeZipFile();
            if (matches == null) {
                return new SystemSearchLineMatch[0];
            }
            return matches;
        }
        return new SystemSearchLineMatch[0];
    }

    public boolean exists() {
        return this._exists;
    }

    public String getCommentFor(String fullVirtualName) {
        return this.getCommentFor(fullVirtualName, true);
    }

    public String getCommentFor(String fullVirtualName, boolean closeZipFile) {
        if (!this._exists) {
            return "";
        }
        if (this.openZipFile()) {
            String comment;
            fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
            ZipEntry entry = null;
            try {
                entry = this.safeGetEntry(fullVirtualName);
            }
            catch (IOException iOException) {
                if (closeZipFile) {
                    this.closeZipFile();
                }
                return "";
            }
            if (closeZipFile) {
                this.closeZipFile();
            }
            if ((comment = entry.getComment()) == null) {
                return "";
            }
            return comment;
        }
        return "";
    }

    public long getCompressedSizeFor(String fullVirtualName) {
        return this.getCompressedSizeFor(fullVirtualName, true);
    }

    public long getCompressedSizeFor(String fullVirtualName, boolean closeZipFile) {
        if (!this._exists) {
            return 0L;
        }
        if (this.openZipFile()) {
            fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
            ZipEntry entry = null;
            try {
                entry = this.safeGetEntry(fullVirtualName);
            }
            catch (IOException iOException) {
                if (closeZipFile) {
                    this.closeZipFile();
                }
                return 0L;
            }
            if (closeZipFile) {
                this.closeZipFile();
            }
            return entry.getCompressedSize();
        }
        return 0L;
    }

    public String getCompressionMethodFor(String fullVirtualName) {
        return this.getCompressionMethodFor(fullVirtualName, true);
    }

    public String getCompressionMethodFor(String fullVirtualName, boolean closeZipFile) {
        if (!this._exists) {
            return "";
        }
        if (this.openZipFile()) {
            fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
            ZipEntry entry = null;
            try {
                entry = this.safeGetEntry(fullVirtualName);
            }
            catch (IOException iOException) {
                if (closeZipFile) {
                    this.closeZipFile();
                }
                return "";
            }
            if (closeZipFile) {
                this.closeZipFile();
            }
            return new Integer(entry.getMethod()).toString();
        }
        return "";
    }

    public String getArchiveComment() {
        return "";
    }

    public String getClassification(String fullVirtualName) {
        return this.getClassification(fullVirtualName, true);
    }

    public String getClassification(String fullVirtualName, boolean closeZipFile) {
        String type = "file";
        if (!this._exists) {
            return type;
        }
        if (!(fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName)).endsWith(".class")) {
            return type;
        }
        BasicClassFileParser parser = null;
        boolean isExecutable = false;
        if (this.openZipFile()) {
            InputStream stream = null;
            try {
                ZipEntry entry = this.safeGetEntry(fullVirtualName);
                stream = this._zipfile.getInputStream(entry);
                parser = new BasicClassFileParser(stream);
                parser.parse();
                isExecutable = parser.isExecutable();
                if (closeZipFile) {
                    this.closeZipFile();
                }
            }
            catch (IOException iOException) {
                if (closeZipFile) {
                    this.closeZipFile();
                }
                return type;
            }
        }
        if (isExecutable && parser != null) {
            type = "executable(java";
            String qualifiedClassName = parser.getQualifiedClassName();
            if (qualifiedClassName != null) {
                type = String.valueOf(type) + ":" + qualifiedClassName;
            }
            type = String.valueOf(type) + ")";
        }
        return type;
    }

    public boolean add(File file, String virtualPath, String name, String sourceEncoding, String targetEncoding, ISystemFileTypes registry) {
        if (!this._exists) {
            return false;
        }
        virtualPath = ArchiveHandlerManager.cleanUpVirtualPath(virtualPath);
        if (!file.isDirectory()) {
            if (this.exists(String.valueOf(virtualPath) + "/" + name)) {
                return this.replace(String.valueOf(virtualPath) + "/" + name, file, name);
            }
            File[] files = new File[]{file};
            String[] names = new String[]{name};
            String[] sourceEncodings = new String[]{sourceEncoding};
            String[] targetEncodings = new String[]{targetEncoding};
            boolean[] isTexts = new boolean[]{registry.isText(file)};
            return this.add(files, virtualPath, names, sourceEncodings, targetEncodings, isTexts);
        }
        HashSet children = new HashSet();
        SystemZipHandler.listAllFiles(file, children);
        File[] sources = new File[children.size() + 1];
        String[] newNames = new String[children.size() + 1];
        Object[] kids = children.toArray();
        String[] sourceEncodings = new String[children.size() + 1];
        String[] targetEncodings = new String[children.size() + 1];
        boolean[] isTexts = new boolean[children.size() + 1];
        int charsToTrim = file.getParentFile().getAbsolutePath().length() + 1;
        if (file.getParentFile().getAbsolutePath().endsWith(File.separator)) {
            --charsToTrim;
        }
        int i = 0;
        while (i < children.size()) {
            sources[i] = (File)kids[i];
            newNames[i] = sources[i].getAbsolutePath().substring(charsToTrim);
            newNames[i] = newNames[i].replace('\\', '/');
            if (sources[i].isDirectory() && !newNames[i].endsWith("/")) {
                newNames[i] = String.valueOf(newNames[i]) + "/";
            }
            sourceEncodings[i] = sourceEncoding;
            targetEncodings[i] = targetEncoding;
            isTexts[i] = registry.isText(sources[i]);
            ++i;
        }
        sources[children.size()] = file;
        newNames[children.size()] = name;
        sourceEncodings[children.size()] = sourceEncoding;
        targetEncodings[children.size()] = targetEncoding;
        isTexts[children.size()] = registry.isText(file);
        if (!newNames[children.size()].endsWith("/")) {
            newNames[children.size()] = String.valueOf(newNames[children.size()]) + "/";
        }
        return this.add(sources, virtualPath, newNames, sourceEncodings, targetEncodings, isTexts);
    }

    public boolean add(File file, String virtualPath, String name, String sourceEncoding, String targetEncoding, boolean isText) {
        if (!this._exists) {
            return false;
        }
        virtualPath = ArchiveHandlerManager.cleanUpVirtualPath(virtualPath);
        if (!file.isDirectory()) {
            String fullVirtualName = SystemZipHandler.getFullVirtualName(virtualPath, name);
            if (this.exists(fullVirtualName)) {
                return this.replace(fullVirtualName, file, name);
            }
            File[] files = new File[]{file};
            String[] names = new String[]{name};
            String[] sourceEncodings = new String[]{sourceEncoding};
            String[] targetEncodings = new String[]{targetEncoding};
            boolean[] isTexts = new boolean[]{isText};
            return this.add(files, virtualPath, names, sourceEncodings, targetEncodings, isTexts);
        }
        HashSet children = new HashSet();
        SystemZipHandler.listAllFiles(file, children);
        File[] sources = new File[children.size() + 1];
        String[] newNames = new String[children.size() + 1];
        Object[] kids = children.toArray();
        String[] sourceEncodings = new String[children.size() + 1];
        String[] targetEncodings = new String[children.size() + 1];
        boolean[] isTexts = new boolean[children.size() + 1];
        int charsToTrim = file.getParentFile().getAbsolutePath().length() + 1;
        if (file.getParentFile().getAbsolutePath().endsWith(File.separator)) {
            --charsToTrim;
        }
        int i = 0;
        while (i < children.size()) {
            sources[i] = (File)kids[i];
            newNames[i] = sources[i].getAbsolutePath().substring(charsToTrim);
            newNames[i] = newNames[i].replace('\\', '/');
            if (sources[i].isDirectory() && !newNames[i].endsWith("/")) {
                newNames[i] = String.valueOf(newNames[i]) + "/";
            }
            sourceEncodings[i] = sourceEncoding;
            targetEncodings[i] = targetEncoding;
            isTexts[i] = isText;
            ++i;
        }
        sources[children.size()] = file;
        newNames[children.size()] = name;
        sourceEncodings[children.size()] = sourceEncoding;
        targetEncodings[children.size()] = targetEncoding;
        isTexts[children.size()] = isText;
        if (!newNames[children.size()].endsWith("/")) {
            newNames[children.size()] = String.valueOf(newNames[children.size()]) + "/";
        }
        return this.add(sources, virtualPath, newNames, sourceEncodings, targetEncodings, isTexts);
    }

    private static String getFullVirtualName(String virtualPath, String name) {
        String fullVirtualName = null;
        fullVirtualName = virtualPath == null || virtualPath.length() == 0 ? name : String.valueOf(virtualPath) + "/" + name;
        return fullVirtualName;
    }
}

