/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view.team;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.internal.ui.view.team.SystemTeamViewCategoryNode;
import org.eclipse.rse.ui.subsystems.ISubSystemConfigurationAdapter;

public class SystemTeamViewSubSystemConfigurationNode
implements IAdaptable {
    private String mementoHandle;
    private ISystemProfile profile;
    private ISubSystemConfiguration ssf;
    private SystemTeamViewCategoryNode parentCategory;
    private String name = null;
    static /* synthetic */ Class class$0;

    public SystemTeamViewSubSystemConfigurationNode(ISystemProfile profile, SystemTeamViewCategoryNode parentCategory, ISubSystemConfiguration ssf) {
        this.profile = profile;
        this.ssf = ssf;
        this.parentCategory = parentCategory;
    }

    public Object getAdapter(Class adapterType) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    public boolean equals(Object o) {
        if (o instanceof SystemTeamViewSubSystemConfigurationNode) {
            SystemTeamViewSubSystemConfigurationNode other = (SystemTeamViewSubSystemConfigurationNode)o;
            return this.ssf == other.getSubSystemConfiguration() && this.parentCategory == other.getParentCategory() && this.profile == other.getProfile();
        }
        return super.equals(o);
    }

    public ImageDescriptor getImageDescriptor() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.ui.subsystems.ISubSystemConfigurationAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISubSystemConfigurationAdapter adapter = (ISubSystemConfigurationAdapter)this.ssf.getAdapter((Class)clazz);
        return adapter.getImage(this.ssf);
    }

    public String getLabel() {
        if (this.name == null) {
            StringBuffer buf = new StringBuffer();
            buf.append(this.ssf.getName());
            buf.append(" (");
            if (this.ssf.getSubSystemConfigurationProxy().supportsAllSystemTypes()) {
                buf.append(SystemResources.TERM_ALL);
            } else {
                IRSESystemType[] types = this.ssf.getSystemTypes();
                int idx = 0;
                while (idx < types.length) {
                    if (idx > 0) {
                        buf.append(", ");
                    }
                    buf.append(types[idx].getLabel());
                    ++idx;
                }
            }
            buf.append(")");
            this.name = buf.toString();
        }
        return this.name;
    }

    public String toString() {
        return this.getLabel();
    }

    public ISystemProfile getProfile() {
        return this.profile;
    }

    public void setProfile(ISystemProfile profile) {
        this.profile = profile;
    }

    public String getMementoHandle() {
        return this.mementoHandle;
    }

    public void setMementoHandle(String string) {
        this.mementoHandle = string;
    }

    public ISubSystemConfiguration getSubSystemConfiguration() {
        return this.ssf;
    }

    public void setSubSystemConfiguration(ISubSystemConfiguration factory) {
        this.ssf = factory;
    }

    public SystemTeamViewCategoryNode getParentCategory() {
        return this.parentCategory;
    }

    public void setParentCategory(SystemTeamViewCategoryNode node) {
        this.parentCategory = node;
    }
}

