/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jsch.core.IJSchService;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.Logger;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.tm.internal.terminal.ssh.Activator;
import org.eclipse.tm.internal.terminal.ssh.KeyboardInteractiveDialog;
import org.eclipse.tm.internal.terminal.ssh.SshConnector;
import org.eclipse.tm.internal.terminal.ssh.SshMessages;
import org.eclipse.tm.internal.terminal.ssh.UserValidationDialog;

class SshConnection
extends Thread {
    private static int fgNo;
    private final ITerminalControl fControl;
    private final SshConnector fConn;
    private Channel fChannel;

    protected SshConnection(SshConnector conn, ITerminalControl control) {
        super("SshConnection-" + fgNo++);
        this.fControl = control;
        this.fConn = conn;
        this.fControl.setState(TerminalState.CONNECTING);
    }

    protected Session createSession(String username, String password, String hostname, int port, UserInfo wrapperUI, IProgressMonitor monitor) throws JSchException {
        IJSchService service = Activator.getDefault().getJSchService();
        if (service == null) {
            return null;
        }
        Session session = service.createSession(hostname, port, username);
        session.setTimeout(0);
        if (password != null) {
            session.setPassword(password);
        }
        session.setUserInfo(wrapperUI);
        return session;
    }

    static void shutdown() {
    }

    public void run() {
        try {
            int nTimeout = this.fConn.getTelnetSettings().getTimeout() * 1000;
            String host = this.fConn.getTelnetSettings().getHost();
            String user = this.fConn.getTelnetSettings().getUser();
            String password = this.fConn.getTelnetSettings().getPassword();
            int port = this.fConn.getTelnetSettings().getPort();
            MyUserInfo ui = new MyUserInfo(null, user, password);
            Session session = this.createSession(user, password, host, port, ui, (IProgressMonitor)new NullProgressMonitor());
            session.connect(nTimeout);
            ChannelShell channel = (ChannelShell)session.openChannel("shell");
            channel.setPtyType("ansi");
            channel.connect();
            this.fConn.setInputStream(channel.getInputStream());
            this.fConn.setOutputStream(channel.getOutputStream());
            this.fConn.setChannel(channel);
            this.fControl.setState(TerminalState.CONNECTED);
            try {
                this.readDataForever(this.fConn.getInputStream());
            }
            catch (InterruptedIOException interruptedIOException) {}
            this.fControl.setState(TerminalState.CLOSED);
        }
        catch (JSchException e) {
            if (e.toString().indexOf("Auth cancel") < 0) {
                this.connectFailed(e.getMessage(), e.getMessage());
            }
        }
        catch (IOException e) {
            this.connectFailed(e.getMessage(), e.getMessage());
        }
    }

    synchronized void setChannel(Channel channel) {
        this.fChannel = channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnect() {
        this.interrupt();
        SshConnection sshConnection = this;
        synchronized (sshConnection) {
            if (this.fChannel != null) {
                this.fChannel.disconnect();
                this.fChannel = null;
            }
        }
    }

    private void readDataForever(InputStream in) throws IOException {
        int n;
        byte[] bytes = new byte[32768];
        while ((n = in.read(bytes)) != -1) {
            this.fControl.getRemoteToTerminalOutputStream().write(bytes, 0, n);
        }
    }

    protected static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    private void connectFailed(String terminalText, String msg) {
        Logger.log((String)terminalText);
        this.fControl.displayTextInTerminal(terminalText);
        this.fControl.setState(TerminalState.CLOSED);
        this.fControl.setMsg(msg);
    }

    private static class MyUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        private final String fConnectionId;
        private final String fUser;
        private String fPassword;
        private String fPassphrase;
        private int fAttemptCount;

        public MyUserInfo(String connectionId, String user, String password) {
            this.fConnectionId = connectionId;
            this.fUser = user;
            this.fPassword = password;
        }

        public String getPassword() {
            return this.fPassword;
        }

        public boolean promptYesNo(String str) {
            boolean[] retval = new boolean[1];
            Display.getDefault().syncExec(new Runnable(this, retval, str){
                final /* synthetic */ MyUserInfo this$1;
                private final /* synthetic */ boolean[] val$retval;
                private final /* synthetic */ String val$str;
                {
                    this.this$1 = myUserInfo;
                    this.val$retval = blArray;
                    this.val$str = string;
                }

                public void run() {
                    this.val$retval[0] = MessageDialog.openQuestion(null, (String)SshMessages.WARNING, (String)this.val$str);
                }
            });
            return retval[0];
        }

        private String promptSecret(String message) {
            String[] retval = new String[1];
            SshConnection.getStandardDisplay().syncExec(new Runnable(this, message, retval){
                final /* synthetic */ MyUserInfo this$1;
                private final /* synthetic */ String val$message;
                private final /* synthetic */ String[] val$retval;
                {
                    this.this$1 = myUserInfo;
                    this.val$message = string;
                    this.val$retval = stringArray;
                }

                public void run() {
                    UserValidationDialog uvd = new UserValidationDialog(null, MyUserInfo.access$0(this.this$1), MyUserInfo.access$1(this.this$1), this.val$message);
                    uvd.setUsernameMutable(false);
                    this.val$retval[0] = uvd.open() == 0 ? uvd.getPassword() : null;
                }
            });
            return retval[0];
        }

        public String getPassphrase() {
            return this.fPassphrase;
        }

        public boolean promptPassphrase(String message) {
            this.fPassphrase = this.promptSecret(message);
            return this.fPassphrase != null;
        }

        public boolean promptPassword(String message) {
            String _password = this.promptSecret(message);
            if (_password != null) {
                this.fPassword = _password;
                return true;
            }
            return false;
        }

        public void showMessage(String message) {
            Display.getDefault().syncExec(new Runnable(this, message){
                final /* synthetic */ MyUserInfo this$1;
                private final /* synthetic */ String val$message;
                {
                    this.this$1 = myUserInfo;
                    this.val$message = string;
                }

                public void run() {
                    MessageDialog.openInformation(null, (String)SshMessages.INFO, (String)this.val$message);
                }
            });
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            String[] result;
            block6: {
                if (prompt.length == 0) {
                    return new String[0];
                }
                try {
                    if (this.fAttemptCount == 0 && this.fPassword != null && prompt.length == 1 && prompt[0].trim().equalsIgnoreCase("password:")) {
                        ++this.fAttemptCount;
                        return new String[]{this.fPassword};
                    }
                    String[][] finResult = new String[1][];
                    SshConnection.getStandardDisplay().syncExec(new Runnable(this, destination, name, instruction, prompt, echo, finResult){
                        final /* synthetic */ MyUserInfo this$1;
                        private final /* synthetic */ String val$destination;
                        private final /* synthetic */ String val$name;
                        private final /* synthetic */ String val$instruction;
                        private final /* synthetic */ String[] val$prompt;
                        private final /* synthetic */ boolean[] val$echo;
                        private final /* synthetic */ String[][] val$finResult;
                        {
                            this.this$1 = myUserInfo;
                            this.val$destination = string;
                            this.val$name = string2;
                            this.val$instruction = string3;
                            this.val$prompt = stringArray;
                            this.val$echo = blArray;
                            this.val$finResult = stringArray2;
                        }

                        public void run() {
                            KeyboardInteractiveDialog dialog = new KeyboardInteractiveDialog(null, MyUserInfo.access$0(this.this$1), this.val$destination, this.val$name, this.val$instruction, this.val$prompt, this.val$echo);
                            dialog.open();
                            this.val$finResult[0] = dialog.getResult();
                        }
                    });
                    result = finResult[0];
                    if (result != null) break block6;
                    return null;
                }
                catch (OperationCanceledException operationCanceledException) {
                    return null;
                }
            }
            if (result.length == 1 && prompt.length == 1 && prompt[0].trim().equalsIgnoreCase("password:")) {
                this.fPassword = result[0];
            }
            ++this.fAttemptCount;
            return result;
        }

        public void aboutToConnect() {
            this.fAttemptCount = 0;
        }

        public void connectionMade() {
            this.fAttemptCount = 0;
        }

        static /* synthetic */ String access$0(MyUserInfo myUserInfo) {
            return myUserInfo.fConnectionId;
        }

        static /* synthetic */ String access$1(MyUserInfo myUserInfo) {
            return myUserInfo.fUser;
        }
    }
}

