/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.emulator;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tm.internal.terminal.control.ICommandInputField;
import org.eclipse.tm.internal.terminal.control.ITerminalListener;
import org.eclipse.tm.internal.terminal.control.ITerminalViewControl;
import org.eclipse.tm.internal.terminal.control.impl.ITerminalControlForText;
import org.eclipse.tm.internal.terminal.control.impl.TerminalMessages;
import org.eclipse.tm.internal.terminal.control.impl.TerminalPlugin;
import org.eclipse.tm.internal.terminal.emulator.VT100Emulator;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnectorInfo;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.Logger;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.tm.internal.terminal.textcanvas.PipedInputStream;
import org.eclipse.tm.internal.terminal.textcanvas.PollingTextCanvasModel;
import org.eclipse.tm.internal.terminal.textcanvas.TextCanvas;
import org.eclipse.tm.internal.terminal.textcanvas.TextLineRenderer;
import org.eclipse.tm.terminal.model.ITerminalTextData;
import org.eclipse.tm.terminal.model.ITerminalTextDataSnapshot;
import org.eclipse.tm.terminal.model.TerminalTextDataFactory;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.keys.IBindingService;

public class VT100TerminalControl
implements ITerminalControlForText,
ITerminalControl,
ITerminalViewControl {
    protected static final String[] LINE_DELIMITERS = new String[]{"\n"};
    private final VT100Emulator fTerminalText;
    private Display fDisplay;
    private TextCanvas fCtlText;
    private Composite fWndParent;
    private Clipboard fClipboard;
    private KeyListener fKeyHandler;
    private final ITerminalListener fTerminalListener;
    private String fMsg = "";
    private FocusListener fFocusListener;
    private ITerminalConnectorInfo fConnectorInfo;
    private final ITerminalConnectorInfo[] fConnectors;
    PipedInputStream fInputStream;
    private ICommandInputField fCommandInputField;
    private volatile TerminalState fState;
    private final ITerminalTextData fTerminalModel;
    private volatile Job fJob;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public VT100TerminalControl(ITerminalListener target, Composite wndParent, ITerminalConnectorInfo[] connectors) {
        this.fConnectors = connectors;
        this.fTerminalListener = target;
        this.fTerminalModel = TerminalTextDataFactory.makeTerminalTextData();
        this.fTerminalModel.setMaxHeight(1000);
        this.fInputStream = new PipedInputStream(8192);
        this.fTerminalText = new VT100Emulator(this.fTerminalModel, this, this.fInputStream);
        this.setupTerminal(wndParent);
    }

    public ITerminalConnectorInfo[] getConnectors() {
        return this.fConnectors;
    }

    public void copy() {
        this.getCtlText().copy();
    }

    public void paste() {
        TextTransfer textTransfer = TextTransfer.getInstance();
        String strText = (String)this.fClipboard.getContents((Transfer)textTransfer);
        this.pasteString(strText);
    }

    public boolean pasteString(String strText) {
        if (!this.isConnected()) {
            return false;
        }
        if (strText == null) {
            return false;
        }
        int i = 0;
        while (i < strText.length()) {
            this.sendChar(strText.charAt(i), false);
            ++i;
        }
        return true;
    }

    public void selectAll() {
        this.getCtlText().selectAll();
    }

    public void sendKey(char character) {
        Event event = new Event();
        event.widget = this.getCtlText();
        event.character = character;
        event.keyCode = 0;
        event.stateMask = 0;
        event.doit = true;
        KeyEvent keyEvent = new KeyEvent(event);
        this.fKeyHandler.keyPressed(keyEvent);
    }

    public void clearTerminal() {
        this.getTerminalText().clearTerminal();
    }

    public Clipboard getClipboard() {
        return this.fClipboard;
    }

    public String getSelection() {
        String txt = this.fCtlText.getSelectionText();
        if (txt == null) {
            txt = "";
        }
        return txt;
    }

    public void setFocus() {
        this.getCtlText().setFocus();
    }

    public boolean isEmpty() {
        return this.getCtlText().isEmpty();
    }

    public boolean isDisposed() {
        return this.getCtlText().isDisposed();
    }

    public boolean isConnected() {
        return this.fState == TerminalState.CONNECTED;
    }

    public void disposeTerminal() {
        Logger.log("entered.");
        this.disconnectTerminal();
        this.fClipboard.dispose();
        this.getTerminalText().dispose();
    }

    public void connectTerminal() {
        Logger.log("entered.");
        if (this.getTerminalConnector() == null) {
            return;
        }
        this.fTerminalText.resetState();
        if (this.fConnectorInfo.getInitializationErrorMessage() != null) {
            this.showErrorMessage(NLS.bind((String)TerminalMessages.CannotConnectTo, (Object)this.fConnectorInfo.getName(), (Object)this.fConnectorInfo.getInitializationErrorMessage()));
            return;
        }
        this.getTerminalConnector().connect(this);
        this.setMsg("");
        this.waitForConnect();
    }

    private ITerminalConnector getTerminalConnector() {
        if (this.fConnectorInfo == null) {
            return null;
        }
        return this.fConnectorInfo.getConnector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectTerminal() {
        Job job;
        Logger.log("entered.");
        if (this.getState() == TerminalState.CLOSED) {
            return;
        }
        if (this.getTerminalConnector() != null) {
            this.getTerminalConnector().disconnect();
        }
        VT100TerminalControl vT100TerminalControl = this;
        synchronized (vT100TerminalControl) {
            job = this.fJob;
            this.fJob = null;
        }
        if (job != null) {
            job.cancel();
        }
    }

    private void waitForConnect() {
        Logger.log("entered.");
        while (this.getState() == TerminalState.CONNECTING) {
            if (this.fDisplay.readAndDispatch()) continue;
            this.fDisplay.sleep();
        }
        if (!this.getMsg().equals("")) {
            this.showErrorMessage(this.getMsg());
            this.disconnectTerminal();
            return;
        }
        this.getCtlText().setFocus();
        this.startReaderJob();
    }

    private synchronized void startReaderJob() {
        if (this.fJob == null) {
            this.fJob = new Job("Terminal data reader"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected IStatus run(IProgressMonitor monitor) {
                    IStatus status = Status.OK_STATUS;
                    block12: while (true) {
                        try {
                            while (VT100TerminalControl.this.fInputStream.available() == 0 && !monitor.isCanceled()) {
                                try {
                                    VT100TerminalControl.this.fInputStream.waitForAvailable(500L);
                                    continue block12;
                                }
                                catch (InterruptedException interruptedException) {
                                    Thread.currentThread().interrupt();
                                }
                            }
                            if (monitor.isCanceled()) {
                                status = Status.CANCEL_STATUS;
                                break;
                            }
                            try {
                                VT100TerminalControl.this.fTerminalText.processText();
                            }
                            catch (Exception e) {
                                VT100TerminalControl.this.disconnectTerminal();
                                status = new Status(4, "org.eclipse.tm.terminal", e.getLocalizedMessage(), (Throwable)e);
                                break;
                            }
                        }
                        catch (Throwable throwable) {
                            VT100TerminalControl vT100TerminalControl = VT100TerminalControl.this;
                            synchronized (vT100TerminalControl) {
                                if (VT100TerminalControl.this.fJob == this) {
                                    VT100TerminalControl.this.fJob = null;
                                }
                            }
                            throw throwable;
                        }
                    }
                    VT100TerminalControl vT100TerminalControl = VT100TerminalControl.this;
                    synchronized (vT100TerminalControl) {
                        if (VT100TerminalControl.this.fJob == this) {
                            VT100TerminalControl.this.fJob = null;
                        }
                    }
                    return status;
                }
            };
            this.fJob.setSystem(true);
            this.fJob.schedule();
        }
    }

    private void showErrorMessage(String message) {
        String strTitle = TerminalMessages.TerminalError;
        MessageDialog.openError((Shell)this.getShell(), (String)strTitle, (String)message);
    }

    protected void sendString(String string) {
        try {
            this.getOutputStream().write(string.getBytes());
            this.getOutputStream().flush();
        }
        catch (SocketException socketException) {
            this.displayTextInTerminal(socketException.getMessage());
            String strMsg = String.valueOf(TerminalMessages.SocketError) + "!\n" + socketException.getMessage();
            this.showErrorMessage(strMsg);
            Logger.logException(socketException);
            this.disconnectTerminal();
        }
        catch (IOException ioException) {
            this.showErrorMessage(String.valueOf(TerminalMessages.IOError) + "!\n" + ioException.getMessage());
            Logger.logException(ioException);
            this.disconnectTerminal();
        }
    }

    public Shell getShell() {
        return this.getCtlText().getShell();
    }

    protected void sendChar(char chKey, boolean altKeyPressed) {
        try {
            char byteToSend = chKey;
            OutputStream os = this.getOutputStream();
            if (os == null) {
                Logger.log("NOT sending '" + byteToSend + "' because no longer connected");
            } else {
                if (altKeyPressed) {
                    Logger.log("sending ESC + '" + byteToSend + "'");
                    this.getOutputStream().write(27);
                    this.getOutputStream().write(byteToSend);
                } else {
                    Logger.log("sending '" + byteToSend + "'");
                    this.getOutputStream().write(byteToSend);
                }
                this.getOutputStream().flush();
            }
        }
        catch (SocketException socketException) {
            Logger.logException(socketException);
            this.displayTextInTerminal(socketException.getMessage());
            String strMsg = String.valueOf(TerminalMessages.SocketError) + "!\n" + socketException.getMessage();
            this.showErrorMessage(strMsg);
            Logger.logException(socketException);
            this.disconnectTerminal();
        }
        catch (IOException ioException) {
            Logger.logException(ioException);
            this.displayTextInTerminal(ioException.getMessage());
            String strMsg = String.valueOf(TerminalMessages.IOError) + "!\n" + ioException.getMessage();
            this.showErrorMessage(strMsg);
            Logger.logException(ioException);
            this.disconnectTerminal();
        }
    }

    public void setupTerminal(Composite parent) {
        this.fState = TerminalState.CLOSED;
        this.setupControls(parent);
        this.setupListeners();
        this.setupHelp(this.fWndParent, "org.eclipse.tm.terminal.terminal_view");
    }

    public void setFont(Font font) {
        this.getCtlText().setFont(font);
        if (this.fCommandInputField != null) {
            this.fCommandInputField.setFont(font);
        }
        this.fCtlText.onFontChange();
        this.getTerminalText().fontChanged();
    }

    public Font getFont() {
        return this.getCtlText().getFont();
    }

    public Control getControl() {
        return this.fCtlText;
    }

    protected void setupControls(Composite parent) {
        this.fWndParent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.fWndParent.setLayout((Layout)layout);
        ITerminalTextDataSnapshot snapshot = this.fTerminalModel.makeSnapshot();
        snapshot.updateSnapshot(false);
        PollingTextCanvasModel canvasModel = new PollingTextCanvasModel(snapshot);
        this.fCtlText = new TextCanvas(this.fWndParent, canvasModel, 0, new TextLineRenderer(this.fCtlText, canvasModel));
        this.fCtlText.setLayoutData(new GridData(1808));
        this.fCtlText.setLayoutData(new GridData(4, 4, true, true));
        this.fCtlText.addResizeHandler(new TextCanvas.ResizeListener(){

            public void sizeChanged(int lines, int columns) {
                VT100TerminalControl.this.fTerminalText.setDimensions(lines, columns);
            }
        });
        this.fDisplay = this.getCtlText().getDisplay();
        this.fClipboard = new Clipboard(this.fDisplay);
        this.setFont(JFaceResources.getTextFont());
    }

    protected void setupListeners() {
        this.fKeyHandler = new TerminalKeyHandler();
        this.fFocusListener = new TerminalFocusListener();
        this.getCtlText().addKeyListener(this.fKeyHandler);
        this.getCtlText().addFocusListener(this.fFocusListener);
    }

    protected void setupHelp(Composite parent, String id) {
        Control[] children = parent.getChildren();
        int nIndex = 0;
        while (nIndex < children.length) {
            if (children[nIndex] instanceof Composite) {
                this.setupHelp((Composite)children[nIndex], id);
            }
            ++nIndex;
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, id);
    }

    public void displayTextInTerminal(String text) {
        this.writeToTerminal("\r\n" + text + "\r\n");
    }

    private void writeToTerminal(String text) {
        try {
            this.getRemoteToTerminalOutputStream().write(text.getBytes("ISO-8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public OutputStream getRemoteToTerminalOutputStream() {
        return this.fInputStream.getOutputStream();
    }

    protected boolean isLogCharEnabled() {
        return TerminalPlugin.isOptionEnabled("org.eclipse.tm.terminal/debug/log/char");
    }

    protected boolean isLogBufferSizeEnabled() {
        return TerminalPlugin.isOptionEnabled("org.eclipse.tm.terminal/debug/log/buffer/size");
    }

    public OutputStream getOutputStream() {
        if (this.getTerminalConnector() != null) {
            return this.getTerminalConnector().getOutputStream();
        }
        return null;
    }

    public void setMsg(String msg) {
        this.fMsg = msg;
    }

    public String getMsg() {
        return this.fMsg;
    }

    protected TextCanvas getCtlText() {
        return this.fCtlText;
    }

    public VT100Emulator getTerminalText() {
        return this.fTerminalText;
    }

    public ITerminalConnectorInfo getTerminalConnectorInfo() {
        return this.fConnectorInfo;
    }

    public void setTerminalTitle(String title) {
        this.fTerminalListener.setTerminalTitle(title);
    }

    public TerminalState getState() {
        return this.fState;
    }

    public void setState(TerminalState state) {
        this.fState = state;
        this.fTerminalListener.setState(state);
    }

    public String getSettingsSummary() {
        if (this.getTerminalConnector() != null) {
            return this.getTerminalConnector().getSettingsSummary();
        }
        return "";
    }

    public void setConnector(ITerminalConnectorInfo connector) {
        this.fConnectorInfo = connector;
    }

    public ICommandInputField getCommandInputField() {
        return this.fCommandInputField;
    }

    public void setCommandInputField(ICommandInputField inputField) {
        if (this.fCommandInputField != null) {
            this.fCommandInputField.dispose();
        }
        this.fCommandInputField = inputField;
        if (this.fCommandInputField != null) {
            this.fCommandInputField.createControl(this.fWndParent, this);
        }
        if (this.fWndParent.isVisible()) {
            this.fWndParent.layout(true);
        }
    }

    public int getBufferLineLimit() {
        return this.fTerminalModel.getMaxHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBufferLineLimit(int bufferLineLimit) {
        if (bufferLineLimit <= 0) {
            return;
        }
        ITerminalTextData iTerminalTextData = this.fTerminalModel;
        synchronized (iTerminalTextData) {
            if (this.fTerminalModel.getHeight() > bufferLineLimit) {
                this.fTerminalModel.setDimensions(bufferLineLimit, this.fTerminalModel.getWidth());
            }
            this.fTerminalModel.setMaxHeight(bufferLineLimit);
        }
    }

    public boolean isScrollLock() {
        return this.fCtlText.isScrollLock();
    }

    public void setScrollLock(boolean on) {
        this.fCtlText.setScrollLock(on);
    }

    public void setInvertedColors(boolean invert) {
        this.fCtlText.setInvertedColors(invert);
    }

    protected class TerminalFocusListener
    implements FocusListener {
        private IContextActivation contextActivation = null;

        protected TerminalFocusListener() {
        }

        public void focusGained(FocusEvent event) {
            IWorkbench iWorkbench = PlatformUI.getWorkbench();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.keys.IBindingService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IBindingService bindingService = (IBindingService)iWorkbench.getAdapter((Class)clazz);
            bindingService.setKeyFilterEnabled(false);
            IWorkbench iWorkbench2 = PlatformUI.getWorkbench();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.ui.contexts.IContextService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IContextService contextService = (IContextService)iWorkbench2.getAdapter((Class)clazz2);
            this.contextActivation = contextService.activateContext("org.eclipse.tm.terminal.TerminalContext");
        }

        public void focusLost(FocusEvent event) {
            IWorkbench iWorkbench = PlatformUI.getWorkbench();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.keys.IBindingService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IBindingService bindingService = (IBindingService)iWorkbench.getAdapter((Class)clazz);
            bindingService.setKeyFilterEnabled(true);
            IWorkbench iWorkbench2 = PlatformUI.getWorkbench();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.ui.contexts.IContextService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IContextService contextService = (IContextService)iWorkbench2.getAdapter((Class)clazz2);
            contextService.deactivateContext(this.contextActivation);
        }
    }

    protected class TerminalKeyHandler
    extends KeyAdapter {
        protected TerminalKeyHandler() {
        }

        public void keyPressed(KeyEvent event) {
            boolean altKeyPressed;
            if (VT100TerminalControl.this.getState() == TerminalState.CONNECTING) {
                return;
            }
            event.doit = false;
            char character = event.character;
            if (VT100TerminalControl.this.fState == TerminalState.CLOSED) {
                if (character == '\r') {
                    VT100TerminalControl.this.connectTerminal();
                    return;
                }
                return;
            }
            if (character == '\u0000' && event.keyCode != 50) {
                switch (event.keyCode) {
                    case 0x1000001: {
                        VT100TerminalControl.this.sendString("\u001b[A");
                        break;
                    }
                    case 0x1000002: {
                        VT100TerminalControl.this.sendString("\u001b[B");
                        break;
                    }
                    case 0x1000003: {
                        VT100TerminalControl.this.sendString("\u001b[D");
                        break;
                    }
                    case 0x1000004: {
                        VT100TerminalControl.this.sendString("\u001b[C");
                        break;
                    }
                    case 0x1000005: {
                        VT100TerminalControl.this.sendString("\u001b[I");
                        break;
                    }
                    case 0x1000006: {
                        VT100TerminalControl.this.sendString("\u001b[G");
                        break;
                    }
                    case 0x1000007: {
                        VT100TerminalControl.this.sendString("\u001b[H");
                        break;
                    }
                    case 0x1000008: {
                        VT100TerminalControl.this.sendString("\u001b[F");
                        break;
                    }
                    case 0x100000A: {
                        VT100TerminalControl.this.sendString("\u001b[M");
                        break;
                    }
                    case 0x100000B: {
                        VT100TerminalControl.this.sendString("\u001b[N");
                        break;
                    }
                    case 0x100000C: {
                        VT100TerminalControl.this.sendString("\u001b[O");
                        break;
                    }
                    case 0x100000D: {
                        VT100TerminalControl.this.sendString("\u001b[P");
                        break;
                    }
                    case 0x100000E: {
                        VT100TerminalControl.this.sendString("\u001b[Q");
                        break;
                    }
                    case 0x100000F: {
                        VT100TerminalControl.this.sendString("\u001b[R");
                        break;
                    }
                    case 0x1000010: {
                        VT100TerminalControl.this.sendString("\u001b[S");
                        break;
                    }
                    case 0x1000011: {
                        VT100TerminalControl.this.sendString("\u001b[T");
                        break;
                    }
                    case 0x1000012: {
                        VT100TerminalControl.this.sendString("\u001b[U");
                        break;
                    }
                    case 0x1000013: {
                        VT100TerminalControl.this.sendString("\u001b[V");
                        break;
                    }
                    case 0x1000014: {
                        VT100TerminalControl.this.sendString("\u001b[W");
                        break;
                    }
                    case 0x1000015: {
                        VT100TerminalControl.this.sendString("\u001b[X");
                        break;
                    }
                }
                return;
            }
            Logger.log("stateMask = " + event.stateMask);
            boolean bl = altKeyPressed = (event.stateMask & 0x10000) != 0 && (event.stateMask & 0x40000) == 0;
            if (!altKeyPressed && (event.stateMask & 0x40000) != 0 && character == ' ') {
                character = '\u0000';
            }
            VT100TerminalControl.this.sendChar(character, altKeyPressed);
            if (character == '\r' && VT100TerminalControl.this.getTerminalConnectorInfo() != null && VT100TerminalControl.this.isConnected() && VT100TerminalControl.this.getTerminalConnectorInfo().getConnector().isLocalEcho()) {
                VT100TerminalControl.this.sendChar('\n', false);
            }
            if (VT100TerminalControl.this.getTerminalConnectorInfo() == null || !VT100TerminalControl.this.getTerminalConnectorInfo().getConnector().isLocalEcho() || altKeyPressed || character >= '\u0001' && character < '\t' || character > '\t' && character < '\r' || character > '\r' && character <= '\u001f' || character == '\u007f') {
                return;
            }
            StringBuffer charBuffer = new StringBuffer();
            charBuffer.append(character);
            if (character == '\r') {
                charBuffer.append('\n');
            }
            VT100TerminalControl.this.writeToTerminal(charBuffer.toString());
        }
    }
}

