/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.textcanvas;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tm.terminal.model.Style;
import org.eclipse.tm.terminal.model.StyleColor;

public class StyleMap {
    private static final String BLACK = "black";
    private static final String WHITE = "white";
    private static final String GRAY = "gray";
    private static final String MAGENTA = "magenta";
    private static final String CYAN = "cyan";
    private static final String YELLOW = "yellow";
    private static final String BLUE = "blue";
    private static final String GREEN = "green";
    private static final String RED = "red";
    private static final String PREFIX = "org.eclipse.tm.internal.";
    String fFontName = "terminal.views.view.font.definition";
    Map fColorMap = new HashMap();
    Map fFontMap = new HashMap();
    private Point fCharSize;
    private Style fDefaultStyle;
    private boolean fInvertColors;

    StyleMap() {
        this.addColor(WHITE, 255, 255, 255);
        this.addColor(BLACK, 0, 0, 0);
        this.addColor(RED, 255, 128, 128);
        this.addColor(GREEN, 128, 255, 128);
        this.addColor(BLUE, 128, 128, 255);
        this.addColor(YELLOW, 255, 255, 0);
        this.addColor(CYAN, 0, 255, 255);
        this.addColor(MAGENTA, 255, 255, 0);
        this.addColor(GRAY, 128, 128, 128);
        this.fDefaultStyle = Style.getStyle(StyleColor.getStyleColor(BLACK), StyleColor.getStyleColor(WHITE));
        this.updateFont();
    }

    private void addColor(String name, int r, int g, int b) {
        String colorName = PREFIX + name;
        Color color = JFaceResources.getColorRegistry().get(colorName);
        if (color == null) {
            JFaceResources.getColorRegistry().put(colorName, new RGB(r, g, b));
            color = JFaceResources.getColorRegistry().get(colorName);
        }
        this.fColorMap.put(StyleColor.getStyleColor(name), color);
        this.fColorMap.put(StyleColor.getStyleColor(name.toUpperCase()), color);
    }

    public Color getColor(StyleColor colorName) {
        return (Color)this.fColorMap.get(colorName);
    }

    public Color getForegrondColor(Style style) {
        if ((style = this.defaultIfNull(style)).isReverse()) {
            return this.getColor(style.getBackground());
        }
        return this.getColor(style.getForground());
    }

    private Style defaultIfNull(Style style) {
        if (style == null) {
            style = this.fDefaultStyle;
        }
        return style;
    }

    public Color getBackgroundColor(Style style) {
        if ((style = this.defaultIfNull(style)).isReverse()) {
            return this.getColor(style.getForground());
        }
        return this.getColor(style.getBackground());
    }

    public void setInvertedColors(boolean invert) {
        if (invert == this.fInvertColors) {
            return;
        }
        this.fInvertColors = invert;
        this.swapColors(WHITE, BLACK);
        this.fDefaultStyle = Style.getStyle(StyleColor.getStyleColor(BLACK), StyleColor.getStyleColor(WHITE));
    }

    void swapColors(String n1, String n2) {
        this.swapColors2(n1, n2);
        this.swapColors2(n1.toUpperCase(), n2.toUpperCase());
    }

    void swapColors2(String n1, String n2) {
        Color c1 = this.getColor(StyleColor.getStyleColor(n1));
        Color c2 = this.getColor(StyleColor.getStyleColor(n2));
        this.fColorMap.put(StyleColor.getStyleColor(n1), c2);
        this.fColorMap.put(StyleColor.getStyleColor(n2), c1);
    }

    public Font getFont(Style style) {
        if ((style = this.defaultIfNull(style)).isBold()) {
            return JFaceResources.getFontRegistry().getBold(this.fFontName);
        }
        if (style.isUnderline()) {
            return JFaceResources.getFontRegistry().getItalic(this.fFontName);
        }
        return JFaceResources.getFontRegistry().get(this.fFontName);
    }

    public Font getFont() {
        return JFaceResources.getFontRegistry().get(this.fFontName);
    }

    public int getFontWidth() {
        return this.fCharSize.x;
    }

    public int getFontHeight() {
        return this.fCharSize.y;
    }

    public void updateFont() {
        Display display = Display.getCurrent();
        GC gc = new GC((Drawable)display);
        gc.setFont(this.getFont());
        this.fCharSize = gc.textExtent("W");
        gc.dispose();
    }
}

