/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.clientserver.archiveutils;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.eclipse.rse.services.clientserver.archiveutils.AbsoluteVirtualPath;
import org.eclipse.rse.services.clientserver.archiveutils.ISystemArchiveHandler;
import org.eclipse.rse.services.clientserver.archiveutils.VirtualChild;

public class ArchiveHandlerManager {
    public static final String VIRTUAL_SEPARATOR = "#virtual#/";
    public static final String VIRTUAL_CANONICAL_SEPARATOR = "#virtual#";
    protected static ArchiveHandlerManager _instance = new ArchiveHandlerManager();
    protected HashMap _handlers = new HashMap();
    protected HashMap _handlerTypes = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static ArchiveHandlerManager getInstance() {
        return _instance;
    }

    public VirtualChild[] getContents(File file, String virtualpath) throws IOException {
        ISystemArchiveHandler handler;
        if (virtualpath == null) {
            virtualpath = "";
        }
        if ((handler = this.getRegisteredHandler(file)) == null || !handler.exists()) {
            throw new IOException();
        }
        return handler.getVirtualChildren(virtualpath);
    }

    public VirtualChild[] getFolderContents(File file, String virtualpath) {
        ISystemArchiveHandler handler;
        if (virtualpath == null) {
            virtualpath = "";
        }
        if ((handler = this.getRegisteredHandler(file)) == null) {
            return null;
        }
        return handler.getVirtualChildFolders(virtualpath);
    }

    public boolean isArchive(File file) {
        if (this._handlers.containsKey(file)) {
            return true;
        }
        return this._handlerTypes.containsKey(this.getExtension(file));
    }

    public boolean isRegisteredArchive(String filename) {
        return this._handlerTypes.containsKey(this.getExtension(filename));
    }

    protected String getExtension(File file) {
        String filename = file.getName();
        int i = filename.lastIndexOf(".");
        if (i == -1) {
            return "";
        }
        return filename.substring(i + 1).toLowerCase();
    }

    protected String getExtension(String filename) {
        int i = filename.lastIndexOf(".");
        if (i == -1) {
            return "";
        }
        return filename.substring(i + 1).toLowerCase();
    }

    public VirtualChild getVirtualObject(String fullyQualifiedName) {
        String cleanName = ArchiveHandlerManager.cleanUpVirtualPath(fullyQualifiedName);
        AbsoluteVirtualPath avp = new AbsoluteVirtualPath(cleanName);
        if (!avp.isVirtual()) {
            return new VirtualChild("", new File(avp.getContainingArchiveString()));
        }
        String zipfile = avp.getContainingArchiveString();
        File file = new File(zipfile);
        ISystemArchiveHandler handler = this.getRegisteredHandler(file);
        if (handler == null) {
            return new VirtualChild(avp.getVirtualPart(), new File(avp.getContainingArchiveString()));
        }
        VirtualChild vc = handler.getVirtualFile(avp.getVirtualPart());
        return vc;
    }

    public ISystemArchiveHandler getRegisteredHandler(File file) {
        ISystemArchiveHandler handler = null;
        if (this._handlers.containsKey(file)) {
            handler = (ISystemArchiveHandler)this._handlers.get(file);
        }
        if (handler != null && handler.exists()) {
            return handler;
        }
        String ext = this.getExtension(file);
        if (!this._handlerTypes.containsKey(ext)) {
            return null;
        }
        Class handlerType = (Class)this._handlerTypes.get(ext);
        Constructor newHandlerType = this.getProperConstructor(handlerType);
        Object[] files = new Object[]{file};
        try {
            handler = (ISystemArchiveHandler)newHandlerType.newInstance(files);
        }
        catch (InvocationTargetException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            System.out.println("Could not instantiate handler for " + file.getName());
            return null;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.out.println("Could not instantiate handler for " + file.getName());
            return null;
        }
        this._handlers.put(file, handler);
        return handler;
    }

    public Constructor getProperConstructor(Class handlerType) {
        Constructor<?>[] constructors = handlerType.getConstructors();
        int i = 0;
        while (i < constructors.length) {
            if (constructors[i].getParameterTypes().length == 1) {
                Class<?> clazz = constructors[i].getParameterTypes()[0];
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("java.io.File");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.equals(clazz2)) {
                    return constructors[i];
                }
            }
            ++i;
        }
        return null;
    }

    public boolean setRegisteredHandler(String ext, Class handlerType) {
        if (!this.handlerHasProperConstructor(handlerType)) {
            System.out.println("Cannot register archive handler " + handlerType);
            System.out.println(handlerType + " does not contain a constructor whose signature is 'Constructor(File file)'");
            return false;
        }
        if (this.handlerImplementsISystemArchiveHandler(handlerType)) {
            if (this._handlerTypes.containsKey(ext)) {
                this._handlerTypes.remove(ext);
            }
            this._handlerTypes.put(ext, handlerType);
            return true;
        }
        System.out.println("Cannot register archive handler " + handlerType);
        System.out.println("Neither " + handlerType + ", nor any of its superclasses implements ISystemArchiveHandler.");
        return false;
    }

    protected boolean handlerHasProperConstructor(Class handlerType) {
        Constructor<?>[] constructors = handlerType.getConstructors();
        boolean ok = false;
        int i = 0;
        while (i < constructors.length) {
            if (constructors[i].getParameterTypes().length == 1) {
                Class<?> clazz = constructors[i].getParameterTypes()[0];
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("java.io.File");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.equals(clazz2)) {
                    ok = true;
                    break;
                }
            }
            ++i;
        }
        return ok;
    }

    protected boolean handlerImplementsISystemArchiveHandler(Class handlerType) {
        Class<?>[] interfaces = handlerType.getInterfaces();
        boolean okay = false;
        int i = 0;
        while (i < interfaces.length) {
            String string = interfaces[i].getName();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.rse.services.clientserver.archiveutils.ISystemArchiveHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (string.equals(clazz.getName())) {
                okay = true;
            }
            ++i;
        }
        if (!okay) {
            Class superclass = handlerType.getSuperclass();
            String string = superclass.getName();
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (string.equals(clazz.getName())) {
                return false;
            }
            return this.handlerImplementsISystemArchiveHandler(superclass);
        }
        return true;
    }

    public void disposeOfRegisteredHandlerFor(File file) {
        this._handlers.remove(file);
    }

    public static boolean isVirtual(String path) {
        return path.indexOf(VIRTUAL_CANONICAL_SEPARATOR) != -1;
    }

    public static String cleanUpVirtualPath(String fullVirtualName) {
        int j = fullVirtualName.indexOf(VIRTUAL_CANONICAL_SEPARATOR);
        if (j == -1 && fullVirtualName.indexOf(":") != -1) {
            return fullVirtualName;
        }
        String realPart = "";
        String newPath = fullVirtualName;
        if (j != -1) {
            try {
                realPart = String.valueOf(fullVirtualName.substring(0, j)) + VIRTUAL_SEPARATOR;
                newPath = j + VIRTUAL_SEPARATOR.length() < fullVirtualName.length() ? fullVirtualName.substring(j + VIRTUAL_SEPARATOR.length()) : "";
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        newPath = newPath.replace('\\', '/');
        int i = newPath.indexOf("//");
        while (i != -1) {
            newPath = String.valueOf(newPath.substring(0, i)) + newPath.substring(i + 1);
            i = newPath.indexOf("//");
        }
        if (j != -1 && newPath.startsWith("/")) {
            newPath = newPath.substring(1);
        }
        if (newPath.endsWith("/")) {
            newPath = newPath.substring(0, newPath.length() - 1);
        }
        return String.valueOf(realPart) + newPath;
    }

    public void dispose() {
        this._handlers.clear();
    }

    public boolean createEmptyArchive(File newFile) {
        if (!this.isRegisteredArchive(newFile.getName())) {
            System.out.println("Could not create new archive.");
            System.out.println(newFile + " is not a registered type of archive.");
            return false;
        }
        if (newFile.exists()) {
            if (!newFile.isFile()) {
                System.out.println("Could not create new archive.");
                System.out.println(newFile + " is not a file.");
                return false;
            }
            if (!newFile.delete()) {
                System.out.println("Could not create new archive.");
                System.out.println(newFile + " could not be deleted.");
                return false;
            }
        }
        try {
            if (!newFile.createNewFile()) {
                System.out.println("Could not create new archive.");
                System.out.println(newFile + " could not be created.");
                return false;
            }
        }
        catch (IOException e) {
            System.out.println("Could not create new archive.");
            System.out.println(e.getMessage());
            return false;
        }
        ISystemArchiveHandler handler = this.getRegisteredHandler(newFile);
        return handler.create();
    }

    public String[] getRegisteredExtensions() {
        Object[] exts = this._handlerTypes.keySet().toArray();
        String[] extensions = new String[exts.length];
        int i = 0;
        while (i < exts.length) {
            extensions[i] = (String)exts[i];
            ++i;
        }
        return extensions;
    }

    public String getComment(File archive) {
        ISystemArchiveHandler handler = this.getRegisteredHandler(archive);
        if (handler == null || !handler.exists()) {
            return "";
        }
        return handler.getArchiveComment();
    }

    public long getExpandedSize(File archive) {
        ISystemArchiveHandler handler = this.getRegisteredHandler(archive);
        if (handler == null || !handler.exists()) {
            return 0L;
        }
        VirtualChild[] allEntries = handler.getVirtualChildrenList();
        int total = 0;
        int i = 0;
        while (i < allEntries.length) {
            total = (int)((long)total + allEntries[i].getSize());
            ++i;
        }
        return total;
    }

    public String getClassification(File file, String virtualPath) {
        if (file == null || !file.exists()) {
            return null;
        }
        ISystemArchiveHandler handler = this.getRegisteredHandler(file);
        if (handler == null || !handler.exists()) {
            return null;
        }
        return handler.getClassification(virtualPath);
    }
}

