/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.files.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rse.internal.files.ui.actions.SystemEditFileAction;
import org.eclipse.rse.subsystems.files.core.SystemIFileProperties;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class SystemEditFileLineAction
extends SystemEditFileAction {
    protected IRemoteFile _remoteFile;
    protected int _line;
    protected int _charStart;
    protected int _charEnd;

    public SystemEditFileLineAction(String text, String tooltip, ImageDescriptor image, Shell parent, String editorId, IRemoteFile remoteFile, int line, int charStart, int charEnd) {
        super(text, tooltip, image, parent, editorId);
        this._line = line;
        this._remoteFile = remoteFile;
        this._charStart = charStart;
        this._charEnd = charEnd;
    }

    public void run() {
        this.process(this._remoteFile);
    }

    protected void process(IRemoteFile remoteFile) {
        super.process(remoteFile);
        this.handleGotoLine();
    }

    protected void handleGotoLine() {
        SystemEditFileLineAction.handleGotoLine(this._remoteFile, this._line, this._charStart, this._charEnd);
    }

    public static void handleGotoLine(IRemoteFile remoteFile, int line, int charStart, int charEnd) {
        if (line > 0) {
            IWorkbench desktop = PlatformUI.getWorkbench();
            IWorkbenchPage persp = desktop.getActiveWorkbenchWindow().getActivePage();
            IEditorPart editor = null;
            String fileName = remoteFile.getAbsolutePath();
            IEditorReference[] editors = persp.getEditorReferences();
            int i = 0;
            while (i < editors.length) {
                IFileEditorInput input;
                IFile efile;
                SystemIFileProperties properties;
                String comparePath;
                IEditorInput einput;
                IEditorReference ref = editors[i];
                IEditorPart editorp = ref.getEditor(false);
                if (editorp != null && (einput = editorp.getEditorInput()) instanceof IFileEditorInput && (comparePath = (properties = new SystemIFileProperties((IResource)(efile = (input = (IFileEditorInput)einput).getFile()))).getRemoteFilePath()) != null && comparePath.replace('\\', '/').equals(fileName.replace('\\', '/'))) {
                    editor = editorp;
                    persp.bringToTop((IWorkbenchPart)editor);
                    try {
                        IMarker marker = SystemEditFileLineAction.createMarker(efile, line, charStart, charEnd);
                        IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
                    }
                    catch (CoreException e) {
                        SystemBasePlugin.logError((String)"Error occured in handleGotoLine", (Throwable)e);
                    }
                }
                ++i;
            }
        }
    }

    protected static IMarker createMarker(IFile file, int line, int charStart, int charEnd) throws CoreException {
        IMarker marker = file.createMarker("org.eclipse.core.resources.textmarker");
        marker.setAttribute("lineNumber", line);
        marker.setAttribute("charStart", charStart);
        marker.setAttribute("charEnd", charEnd);
        return marker;
    }
}

