/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.ssh.files;

import java.io.File;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.files.IHostFile;

public class SftpHostFile
implements IHostFile {
    private String fName;
    private String fParentPath;
    private boolean fIsDirectory = false;
    private boolean fIsRoot = false;
    private boolean fIsArchive = false;
    private boolean fIsReadable = true;
    private boolean fIsWritable = true;
    private boolean fIsExecutable = false;
    private boolean fExists = true;
    private long fLastModified = 0L;
    private long fSize = 0L;
    private boolean fIsLink = false;
    private String fLinkTarget;
    private String[] fExtended = null;

    public SftpHostFile(String parentPath, String name, boolean isDirectory, boolean isRoot, boolean isLink, long lastModified, long size) {
        this.fParentPath = parentPath;
        this.fName = name;
        this.fIsDirectory = isDirectory;
        this.fIsRoot = isRoot;
        this.fLastModified = lastModified;
        this.fSize = size;
        this.fIsLink = isLink;
        this.fIsArchive = this.internalIsArchive();
    }

    public String getName() {
        return this.fName;
    }

    public boolean isHidden() {
        String name = this.getName();
        return name.charAt(0) == '.';
    }

    public String getParentPath() {
        return this.fParentPath;
    }

    public boolean isDirectory() {
        return this.fIsDirectory;
    }

    public boolean isFile() {
        return !this.fIsDirectory && !this.fIsRoot;
    }

    public boolean isRoot() {
        return this.fIsRoot;
    }

    public void setExists(boolean b) {
        this.fExists = b;
    }

    public boolean exists() {
        return this.fExists;
    }

    public String getAbsolutePath() {
        if (this.isRoot()) {
            return this.getName();
        }
        StringBuffer path = new StringBuffer(this.getParentPath());
        if (!this.fParentPath.endsWith("/")) {
            path.append('/');
        }
        path.append(this.getName());
        return path.toString();
    }

    public long getSize() {
        return this.fSize;
    }

    public long getModifiedDate() {
        return this.fLastModified;
    }

    public void renameTo(String newAbsolutePath) {
        int i = newAbsolutePath.lastIndexOf("/");
        if (i == -1) {
            this.fName = newAbsolutePath;
        } else {
            this.fParentPath = newAbsolutePath.substring(0, i);
            this.fName = newAbsolutePath.substring(i + 1);
        }
        this.fIsArchive = this.internalIsArchive();
    }

    protected boolean internalIsArchive() {
        return ArchiveHandlerManager.getInstance().isArchive(new File(this.getAbsolutePath())) && !ArchiveHandlerManager.isVirtual((String)this.getAbsolutePath());
    }

    public boolean isArchive() {
        return this.fIsArchive;
    }

    public boolean isLink() {
        return this.fIsLink;
    }

    public void setLinkTarget(String linkTarget) {
        this.fLinkTarget = linkTarget;
    }

    public String getLinkTarget() {
        return this.fLinkTarget;
    }

    public void setExtendedData(String[] extended) {
        this.fExtended = extended;
    }

    public String[] getExtendedData() {
        return this.fExtended;
    }

    public String getClassification() {
        String result;
        if (this.isLink()) {
            result = "symbolic link";
            if (this.fLinkTarget != null) {
                result = this.fLinkTarget.equals(":dangling link") ? "broken symbolic link to `unknown'" : (this.isDirectory() ? String.valueOf(result) + "(directory):" + this.fLinkTarget : (this.canExecute() ? String.valueOf(result) + "(executable):" + this.fLinkTarget : String.valueOf(result) + "(file):" + this.fLinkTarget));
            }
        } else {
            result = this.isFile() ? (this.canExecute() ? "executable" : "file") : (this.isDirectory() ? "directory" : "unknown");
        }
        return result;
    }

    public void setReadable(boolean b) {
        this.fIsReadable = b;
    }

    public void setWritable(boolean b) {
        this.fIsWritable = b;
    }

    public void setExecutable(boolean b) {
        this.fIsExecutable = b;
    }

    public boolean canRead() {
        return this.fIsReadable;
    }

    public boolean canWrite() {
        return this.fIsWritable;
    }

    public boolean canExecute() {
        return this.fIsExecutable;
    }
}

