/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.internal.core.server;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.internal.core.server.ServerAttributes;
import org.eclipse.dstore.internal.core.server.ServerCommandHandler;
import org.eclipse.dstore.internal.core.server.ServerReceiver;
import org.eclipse.dstore.internal.core.server.ServerSSLProperties;
import org.eclipse.dstore.internal.core.server.ServerUpdateHandler;
import org.eclipse.dstore.internal.core.util.ExternalLoader;
import org.eclipse.dstore.internal.core.util.Sender;
import org.eclipse.dstore.internal.core.util.ssl.DStoreSSLContext;

public class ConnectionEstablisher {
    private ServerSocket _serverSocket;
    private static boolean _continue;
    private ArrayList _receivers;
    private ServerCommandHandler _commandHandler;
    private ServerUpdateHandler _updateHandler;
    private ServerAttributes _serverAttributes = new ServerAttributes();
    private DataStore _dataStore;
    private int _maxConnections;
    private int _timeout;

    public ConnectionEstablisher() {
        String port = this._serverAttributes.getAttribute(5);
        this.setup(port, null, null);
    }

    public ConnectionEstablisher(String port) {
        this.setup(port, null, null);
    }

    public ConnectionEstablisher(String port, String timeout) {
        this.setup(port, timeout, null);
    }

    public ConnectionEstablisher(String port, String timeout, String ticket) {
        this.setup(port, timeout, ticket);
    }

    public void start() {
        this.run();
    }

    public DataStore getDataStore() {
        return this._dataStore;
    }

    public void finished(ServerReceiver receiver) {
        this._updateHandler.removeSenderWith(receiver.socket());
        this._receivers.remove(receiver);
        _continue = false;
        this._commandHandler.finish();
        this._updateHandler.finish();
        this._dataStore.finish();
        System.out.println("Server Finished");
        System.exit(0);
    }

    private void waitForConnections() {
        while (_continue) {
            try {
                Socket newSocket = this._serverSocket.accept();
                if (this._dataStore.usingSSL()) {
                    SSLSocket sslSocket = (SSLSocket)newSocket;
                    sslSocket.setUseClientMode(false);
                    sslSocket.setNeedClientAuth(false);
                    SSLSession session = sslSocket.getSession();
                    if (session == null) {
                        System.out.println("handshake failed");
                        sslSocket.close();
                        return;
                    }
                }
                this.doHandShake(newSocket);
                newSocket.setKeepAlive(true);
                ServerReceiver receiver = new ServerReceiver(newSocket, this);
                Sender sender = new Sender(newSocket, this._dataStore);
                this._receivers.add(receiver);
                this._updateHandler.addSender(sender);
                receiver.start();
                if (this._receivers.size() == 1) {
                    this._updateHandler.start();
                    this._commandHandler.start();
                }
                if (this._receivers.size() != this._maxConnections) continue;
                _continue = false;
                this._serverSocket.close();
            }
            catch (IOException ioe) {
                System.err.println("Connection error");
                System.err.println("Server: error initializing socket: " + ioe);
                _continue = false;
            }
        }
    }

    private ServerSocket createSocket(String portStr) throws UnknownHostException {
        String[] range;
        ServerSocket serverSocket = null;
        SSLContext sslContext = null;
        int port = 0;
        if (this._dataStore.usingSSL()) {
            String keyStoreFileName = this._dataStore.getKeyStoreLocation();
            String keyStorePassword = this._dataStore.getKeyStorePassword();
            try {
                sslContext = DStoreSSLContext.getServerSSLContext(keyStoreFileName, keyStorePassword);
            }
            catch (Exception exception) {}
        }
        if ((range = portStr.split("-")).length == 2) {
            int lPort = 0;
            int hPort = 0;
            try {
                lPort = Integer.parseInt(range[0]);
                hPort = Integer.parseInt(range[1]);
            }
            catch (Exception exception) {}
            int i = lPort;
            while (i < hPort) {
                try {
                    if (this._dataStore.usingSSL() && sslContext != null) {
                        try {
                            serverSocket = sslContext.getServerSocketFactory().createServerSocket(i);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        serverSocket = new ServerSocket(i);
                    }
                }
                catch (Exception e) {
                    this._dataStore.trace(e);
                }
                if (serverSocket != null && serverSocket.getLocalPort() > 0) {
                    return serverSocket;
                }
                ++i;
            }
        } else {
            port = Integer.parseInt(portStr);
            if (this._dataStore.usingSSL() && sslContext != null) {
                try {
                    serverSocket = sslContext.getServerSocketFactory().createServerSocket(port);
                }
                catch (Exception e) {
                    this._dataStore.trace(e);
                }
            } else {
                try {
                    serverSocket = new ServerSocket(port);
                }
                catch (Exception e) {
                    this._dataStore.trace(e);
                }
            }
        }
        return serverSocket;
    }

    private void setup(String portStr, String timeoutStr, String ticketStr) {
        this._maxConnections = 1;
        ArrayList<ExternalLoader> loaders = new ArrayList<ExternalLoader>();
        loaders.add(new ExternalLoader(this.getClass().getClassLoader(), "*"));
        this._commandHandler = new ServerCommandHandler(loaders);
        this._updateHandler = new ServerUpdateHandler();
        ServerSSLProperties sslProperties = new ServerSSLProperties();
        this._dataStore = new DataStore(this._serverAttributes, this._commandHandler, this._updateHandler, null);
        this._dataStore.setSSLProperties(sslProperties);
        DataElement ticket = this._dataStore.getTicket();
        ticket.setAttribute(2, ticketStr);
        this._updateHandler.setDataStore(this._dataStore);
        this._commandHandler.setDataStore(this._dataStore);
        this._receivers = new ArrayList();
        _continue = true;
        try {
            this._serverSocket = this.createSocket(portStr);
            if (this._serverSocket == null) {
                System.err.println("Error binding socket");
                _continue = false;
            } else {
                this._timeout = timeoutStr != null ? Integer.parseInt(timeoutStr) : 120000;
                if (this._timeout > 0) {
                    this._serverSocket.setSoTimeout(this._timeout);
                }
                System.err.println("Server Started Successfully");
                System.err.println(this._serverSocket.getLocalPort());
                try {
                    System.err.println("Server running on: " + InetAddress.getLocalHost().getHostName());
                }
                catch (UnknownHostException unknownHostException) {}
            }
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("Unknown host error");
            _continue = false;
        }
        catch (BindException bindException) {
            System.err.println("Error binding socket");
            _continue = false;
        }
        catch (IOException iOException) {
            System.err.println("General IO error creating socket");
            _continue = false;
        }
        catch (SecurityException securityException) {
            System.err.println("Security error creating socket");
            _continue = false;
        }
    }

    private void run() {
        this.waitForConnections();
    }

    private void doHandShake(Socket socket) {
        try {
            BufferedWriter bwriter = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF-8"));
            PrintWriter writer = new PrintWriter(bwriter);
            writer.println("DataStore.9.0.0");
            writer.flush();
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }
}

