/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.local.files;

import java.io.File;
import org.eclipse.rse.internal.services.local.files.LocalHostFile;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.clientserver.archiveutils.VirtualChild;

public class LocalVirtualHostFile
extends LocalHostFile {
    protected File _parentArchive;
    protected VirtualChild _child;

    public LocalVirtualHostFile(VirtualChild child) {
        super(child.getContainingArchive());
        this._child = child;
        this._parentArchive = this._child.getContainingArchive();
    }

    public String getName() {
        return this._child.name;
    }

    public String getParentPath() {
        return String.valueOf(this._parentArchive.getAbsolutePath()) + "#virtual#/" + this._child.path;
    }

    public boolean isDirectory() {
        return this._child.isDirectory;
    }

    public boolean isRoot() {
        return false;
    }

    public boolean isFile() {
        return !this._child.isDirectory;
    }

    public File getFile() {
        return this._parentArchive;
    }

    public boolean exists() {
        return this._child.exists();
    }

    public String getAbsolutePath() {
        return String.valueOf(this._child.getContainingArchive().getAbsolutePath()) + "#virtual#/" + this._child.fullName;
    }

    public VirtualChild getChild() {
        return this._child;
    }

    public boolean isHidden() {
        return false;
    }

    public boolean isArchive() {
        return false;
    }

    public void renameTo(String newAbsolutePath) {
        String newName = newAbsolutePath = ArchiveHandlerManager.cleanUpVirtualPath((String)newAbsolutePath);
        int i = newAbsolutePath.indexOf("#virtual#/");
        if (i != -1) {
            newName = newAbsolutePath.substring(i + "#virtual#/".length());
        }
        this._child.renameTo(newName);
    }
}

