/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.ssh.files;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Vector;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.internal.services.ssh.Activator;
import org.eclipse.rse.internal.services.ssh.ISshService;
import org.eclipse.rse.internal.services.ssh.ISshSessionProvider;
import org.eclipse.rse.internal.services.ssh.SshServiceResources;
import org.eclipse.rse.internal.services.ssh.files.SftpHostFile;
import org.eclipse.rse.services.Mutex;
import org.eclipse.rse.services.clientserver.FileTypeMatcher;
import org.eclipse.rse.services.clientserver.NamePatternMatcher;
import org.eclipse.rse.services.clientserver.PathUtility;
import org.eclipse.rse.services.clientserver.messages.IndicatorException;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.AbstractFileService;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.services.files.RemoteFileCancelledException;
import org.eclipse.rse.services.files.RemoteFileIOException;
import org.eclipse.rse.services.files.RemoteFileSecurityException;

public class SftpFileService
extends AbstractFileService
implements IFileService,
ISshService {
    private ISshSessionProvider fSessionProvider;
    private ChannelSftp fChannelSftp;
    private String fUserHome;
    private Mutex fDirChannelMutex = new Mutex();
    private long fDirChannelTimeout = 5000L;
    private String fControlEncoding = null;
    private static String defaultEncoding = new InputStreamReader(new ByteArrayInputStream(new byte[0])).getEncoding();
    private static Pattern quoteForJschPattern = Pattern.compile("[*?\\\\]");

    public SftpFileService(ISshSessionProvider sessionProvider) {
        this.fSessionProvider = sessionProvider;
    }

    public void setControlEncoding(String encoding) {
        this.fControlEncoding = encoding;
    }

    protected String recode(String s) throws SystemMessageException {
        if (this.fControlEncoding == null) {
            return s;
        }
        if (this.fControlEncoding.equals(defaultEncoding)) {
            return s;
        }
        try {
            byte[] bytes = s.getBytes(this.fControlEncoding);
            return new String(bytes);
        }
        catch (UnsupportedEncodingException e) {
            throw this.makeSystemMessageException(e);
        }
    }

    protected String recodeSafe(String s) throws SystemMessageException {
        try {
            String recoded = this.recode(s);
            byte[] bytes = recoded.getBytes(defaultEncoding);
            String decoded = this.decode(new String(bytes));
            if (!s.equals(decoded)) {
                int i = 0;
                int lmax = Math.min(s.length(), decoded.length());
                while (i < lmax && s.charAt(i) == decoded.charAt(i)) {
                    ++i;
                }
                char sbad = s.charAt(i);
                String msg = "Cannot express character '" + sbad + "'(0x" + Integer.toHexString(sbad) + ") with ";
                msg = this.fControlEncoding == null || this.fControlEncoding.equals(defaultEncoding) ? String.valueOf(msg) + "default encoding \"" + defaultEncoding + "\". " : String.valueOf(msg) + "encoding \"" + this.fControlEncoding + "\" over local default encoding \"" + defaultEncoding + "\". ";
                msg = String.valueOf(msg) + "Please specify a different encoding in host properties.";
                throw new UnsupportedEncodingException(msg);
            }
            return this.quoteForJsch(recoded);
        }
        catch (UnsupportedEncodingException e) {
            try {
                SystemMessage msg = new SystemMessage("RSE", "F", "9999", 'E', e.getMessage(), "");
                throw new SystemMessageException(msg);
            }
            catch (IndicatorException indicatorException) {
                throw this.makeSystemMessageException(e);
            }
        }
    }

    protected String decode(String s) throws SystemMessageException {
        if (this.fControlEncoding == null) {
            return s;
        }
        if (this.fControlEncoding.equals(defaultEncoding)) {
            return s;
        }
        try {
            byte[] bytes = s.getBytes();
            return new String(bytes, this.fControlEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw this.makeSystemMessageException(e);
        }
    }

    protected String quoteForJsch(String s) {
        if (quoteForJschPattern.matcher(s).find()) {
            StringBuffer buf = new StringBuffer(s.length() + 8);
            int i = 0;
            while (i < s.length()) {
                char c = s.charAt(i);
                if (c == '?' || c == '*') {
                    buf.append('\\');
                }
                buf.append(c);
                ++i;
            }
            s = buf.toString();
        }
        return s;
    }

    public String getName() {
        return SshServiceResources.SftpFileService_Name;
    }

    public String getDescription() {
        return SshServiceResources.SftpFileService_Description;
    }

    public void connect() throws SystemMessageException {
        Activator.trace("SftpFileService.connecting...");
        try {
            Session session = this.fSessionProvider.getSession();
            Channel channel = session.openChannel("sftp");
            channel.connect();
            this.fChannelSftp = (ChannelSftp)channel;
            this.setControlEncoding(this.fSessionProvider.getControlEncoding());
            this.fUserHome = this.decode(this.fChannelSftp.pwd());
            Activator.trace("SftpFileService.connected");
        }
        catch (Exception e) {
            Activator.trace("SftpFileService.connecting failed: " + e.toString());
            throw this.makeSystemMessageException(e);
        }
    }

    protected boolean checkSessionConnected() {
        Session session = this.fSessionProvider.getSession();
        if (session == null) {
            return false;
        }
        if (session.isConnected()) {
            return true;
        }
        this.fSessionProvider.handleSessionLost();
        return false;
    }

    protected ChannelSftp getChannel(String task) throws SystemMessageException {
        Activator.trace(task);
        if (this.fChannelSftp == null || !this.fChannelSftp.isConnected()) {
            Activator.trace(String.valueOf(task) + ": channel not connected: " + this.fChannelSftp);
            if (this.checkSessionConnected()) {
                this.connect();
            } else {
                throw this.makeSystemMessageException(new IOException(SshServiceResources.SftpFileService_Error_JschSessionLost));
            }
        }
        return this.fChannelSftp;
    }

    protected void progressTick(IProgressMonitor monitor, int ticks) throws RemoteFileCancelledException {
        if (monitor != null) {
            if (monitor.isCanceled()) {
                throw new RemoteFileCancelledException();
            }
            monitor.worked(ticks);
        }
    }

    public void disconnect() {
        Activator.trace("SftpFileService.disconnect");
        if (this.fChannelSftp != null && this.fChannelSftp.isConnected()) {
            this.fChannelSftp.disconnect();
        }
        this.fDirChannelMutex.interruptAll();
        this.fChannelSftp = null;
    }

    private SystemMessageException makeSystemMessageException(Exception e) {
        if (e instanceof SystemMessageException) {
            return (SystemMessageException)e;
        }
        if (e instanceof SftpException) {
            SftpException sftpe = (SftpException)e;
            Object messageException = sftpe.id == 3 ? new RemoteFileSecurityException(e) : new RemoteFileIOException(e);
            messageException.getSystemMessage().makeSubstitution((Object)("Sftp: " + sftpe.toString()));
            return messageException;
        }
        return new RemoteFileIOException(e);
    }

    protected String concat(String parentDir, String fileName) {
        StringBuffer path = new StringBuffer(parentDir);
        if (!parentDir.endsWith("/")) {
            path.append('/');
        }
        path.append(fileName);
        return path.toString();
    }

    public IHostFile getFile(String remoteParent, String fileName, IProgressMonitor monitor) throws SystemMessageException {
        SftpHostFile node;
        block9: {
            node = null;
            SftpATTRS attrs = null;
            String fullPath = this.concat(remoteParent, fileName);
            if (this.fDirChannelMutex.waitForLock(monitor, this.fDirChannelTimeout)) {
                try {
                    try {
                        attrs = this.getChannel("SftpFileService.getFile: " + fullPath).stat(this.recodeSafe(fullPath));
                        Activator.trace("SftpFileService.getFile <--");
                        node = this.makeHostFile(remoteParent, fileName, attrs);
                    }
                    catch (Exception e) {
                        Activator.trace("SftpFileService.getFile failed: " + e.toString());
                        if (!(e instanceof SftpException) || ((SftpException)e).id != 2) {
                            throw this.makeSystemMessageException(e);
                        }
                        this.fDirChannelMutex.release();
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    this.fDirChannelMutex.release();
                    throw throwable;
                }
                this.fDirChannelMutex.release();
            } else {
                throw new RemoteFileCancelledException();
            }
        }
        if (node == null) {
            node = new SftpHostFile(remoteParent, fileName, false, false, false, 0L, 0L);
            node.setExists(false);
        }
        return node;
    }

    public boolean isConnected() {
        try {
            return this.getChannel("SftpFileService.isConnected()").isConnected();
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected IHostFile[] internalFetch(String parentPath, String fileFilter, int fileType, IProgressMonitor monitor) throws SystemMessageException {
        ArrayList<SftpHostFile> results;
        block21: {
            if (fileFilter == null) {
                fileFilter = "*";
            }
            NamePatternMatcher filematcher = null;
            if (fileFilter.endsWith(",")) {
                String[] types = fileFilter.split(",");
                filematcher = new FileTypeMatcher(types, true);
            } else {
                filematcher = new NamePatternMatcher(fileFilter, true, true);
            }
            results = new ArrayList<SftpHostFile>();
            if (this.fDirChannelMutex.waitForLock(monitor, this.fDirChannelTimeout)) {
                boolean haveSubMonitor = false;
                try {
                    try {
                        Vector vv = this.getChannel("SftpFileService.internalFetch: " + parentPath).ls(this.recodeSafe(parentPath));
                        this.progressTick(monitor, 40);
                        if (vv.size() > 1 && monitor != null) {
                            monitor = new SubProgressMonitor(monitor, 40);
                            monitor.beginTask(null, vv.size());
                        }
                        int ii = 0;
                        while (ii < vv.size()) {
                            ChannelSftp.LsEntry lsEntry;
                            String fileName;
                            Object obj = vv.elementAt(ii);
                            if (obj instanceof ChannelSftp.LsEntry && !".".equals(fileName = this.decode((lsEntry = (ChannelSftp.LsEntry)obj).getFilename())) && !"..".equals(fileName) && (filematcher.matches(fileName) || lsEntry.getAttrs().isDir() && fileType != 2)) {
                                SftpHostFile node = this.makeHostFile(parentPath, fileName, lsEntry.getAttrs());
                                this.progressTick(monitor, 1);
                                if (this.isRightType(fileType, node)) {
                                    results.add(node);
                                }
                            }
                            ++ii;
                        }
                        Activator.trace("SftpFileService.internalFetch <--");
                    }
                    catch (Exception e) {
                        if (this.checkSessionConnected()) {
                            Activator.trace("SftpFileService.internalFetch failed: " + e.toString());
                            throw this.makeSystemMessageException(e);
                        }
                        this.fDirChannelMutex.release();
                        if (haveSubMonitor) {
                            monitor.done();
                        } else {
                            this.progressTick(monitor, 40);
                        }
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    this.fDirChannelMutex.release();
                    if (haveSubMonitor) {
                        monitor.done();
                    } else {
                        this.progressTick(monitor, 40);
                    }
                    throw throwable;
                }
                this.fDirChannelMutex.release();
                if (haveSubMonitor) {
                    monitor.done();
                } else {
                    this.progressTick(monitor, 40);
                }
            } else {
                throw new RemoteFileCancelledException();
            }
        }
        return results.toArray(new IHostFile[results.size()]);
    }

    private SftpHostFile makeHostFile(String parentPath, String fileName, SftpATTRS attrs) {
        String perms;
        String linkTarget;
        SftpATTRS attrsTarget;
        block13: {
            attrsTarget = attrs;
            linkTarget = null;
            if (attrs.isLink()) {
                try {
                    this.getChannel("makeHostFile.chdir").cd(this.recode(this.concat(parentPath, fileName)));
                    linkTarget = this.decode(this.getChannel("makeHostFile.pwd").pwd());
                    if (linkTarget != null && !linkTarget.equals(this.concat(parentPath, fileName))) {
                        attrsTarget = this.getChannel("SftpFileService.getFile").stat(this.recode(linkTarget));
                    } else {
                        linkTarget = null;
                    }
                }
                catch (Exception e) {
                    if (!(e instanceof SftpException) || ((SftpException)e).id != 2) break block13;
                    linkTarget = ":dangling link";
                }
            }
        }
        SftpHostFile node = new SftpHostFile(parentPath, fileName, attrsTarget.isDir(), false, attrs.isLink(), 1000L * (long)attrs.getMTime(), attrs.getSize());
        if (linkTarget != null) {
            node.setLinkTarget(linkTarget);
        }
        if ((perms = attrsTarget.getPermissionsString()).indexOf(114, 1) <= 0) {
            node.setReadable(false);
        }
        if (perms.indexOf(119, 1) <= 0) {
            node.setWritable(false);
        }
        if (node.isDirectory()) {
            if (perms.indexOf(120, 1) <= 0) {
                node.setWritable(false);
            }
        } else if (perms.indexOf(120, 1) > 0) {
            node.setExecutable(true);
        }
        if (attrs.getExtended() != null) {
            node.setExtendedData(attrs.getExtended());
        }
        return node;
    }

    public String getSeparator() {
        return "/";
    }

    public boolean upload(File localFile, String remoteParent, String remoteFile, boolean isBinary, String srcEncoding, String hostEncoding, IProgressMonitor monitor) throws SystemMessageException {
        String dst = remoteParent;
        if (remoteFile != null) {
            dst = this.concat(dst, remoteFile);
        }
        ChannelSftp channel = null;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            MyProgressMonitor sftpMonitor = new MyProgressMonitor(monitor);
            int mode = 0;
            dst = this.recodeSafe(dst);
            this.getChannel("SftpFileService.upload " + remoteFile);
            channel = (ChannelSftp)this.fSessionProvider.getSession().openChannel("sftp");
            channel.connect();
            channel.put(localFile.getAbsolutePath(), dst, (SftpProgressMonitor)sftpMonitor, mode);
            Activator.trace("SftpFileService.upload " + remoteFile + " ok");
            if (monitor.isCanceled()) {
                return false;
            }
            try {
                SftpATTRS attr = channel.stat(dst);
                attr.setACMODTIME(attr.getATime(), (int)(localFile.lastModified() / 1000L));
                channel.setStat(dst, attr);
                if (attr.getSize() != localFile.length()) {
                    throw this.makeSystemMessageException(new IOException(NLS.bind((String)SshServiceResources.SftpFileService_Error_upload_size, (Object)remoteFile)));
                }
            }
            catch (Exception e) {
                Activator.trace("SftpFileService.upload " + dst + " failed: " + e.toString());
                throw this.makeSystemMessageException(e);
            }
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
        }
        return true;
    }

    public boolean upload(InputStream stream, String remoteParent, String remoteFile, boolean isBinary, String hostEncoding, IProgressMonitor monitor) throws SystemMessageException {
        try {
            int readCount;
            BufferedInputStream bis = new BufferedInputStream(stream);
            File tempFile = File.createTempFile("sftp", "temp");
            FileOutputStream os = new FileOutputStream(tempFile);
            BufferedOutputStream bos = new BufferedOutputStream(os);
            byte[] buffer = new byte[1024];
            while ((readCount = bis.read(buffer)) > 0) {
                bos.write(buffer, 0, readCount);
            }
            bos.close();
            this.upload(tempFile, remoteParent, remoteFile, isBinary, "", hostEncoding, monitor);
        }
        catch (Exception e) {
            throw this.makeSystemMessageException(e);
        }
        return true;
    }

    public boolean download(String remoteParent, String remoteFile, File localFile, boolean isBinary, String hostEncoding, IProgressMonitor monitor) throws SystemMessageException {
        ChannelSftp channel = null;
        String remotePath = this.concat(remoteParent, remoteFile);
        try {
            File localParentFile;
            if (!localFile.exists() && !(localParentFile = localFile.getParentFile()).exists()) {
                localParentFile.mkdirs();
            }
            String remotePathRecoded = this.recode(remotePath);
            int mode = 0;
            MyProgressMonitor sftpMonitor = new MyProgressMonitor(monitor);
            this.getChannel("SftpFileService.download " + remoteFile);
            channel = (ChannelSftp)this.fSessionProvider.getSession().openChannel("sftp");
            channel.connect();
            channel.get(remotePathRecoded, localFile.getAbsolutePath(), (SftpProgressMonitor)sftpMonitor, mode);
            Activator.trace("SftpFileService.download " + remoteFile + " ok");
            if (monitor.isCanceled()) {
                return false;
            }
            try {
                SftpATTRS attr = channel.stat(remotePathRecoded);
                localFile.setLastModified(1000L * (long)attr.getMTime());
                if (attr.getSize() != localFile.length()) {
                    throw this.makeSystemMessageException(new IOException(NLS.bind((String)SshServiceResources.SftpFileService_Error_download_size, (Object)remoteFile)));
                }
            }
            catch (Exception e) {
                Activator.trace("SftpFileService.download " + remotePath + " failed: " + e.toString());
                throw this.makeSystemMessageException(e);
            }
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
        }
        return true;
    }

    public IHostFile getUserHome() {
        if (this.fUserHome != null) {
            int lastSlash = this.fUserHome.lastIndexOf(47);
            String name = this.fUserHome.substring(lastSlash + 1);
            String parent = this.fUserHome.substring(0, lastSlash);
            try {
                return this.getFile(parent, name, null);
            }
            catch (SystemMessageException systemMessageException) {
                return new SftpHostFile("", this.fUserHome, true, true, false, 0L, 0L);
            }
        }
        return null;
    }

    public IHostFile[] getRoots(IProgressMonitor monitor) {
        SftpHostFile root = new SftpHostFile("/", "/", true, true, false, 0L, 0L);
        return new IHostFile[]{root};
    }

    public IHostFile createFile(String remoteParent, String fileName, IProgressMonitor monitor) throws SystemMessageException {
        SftpHostFile result;
        block6: {
            result = null;
            String fullPath = this.concat(remoteParent, fileName);
            if (this.fDirChannelMutex.waitForLock(monitor, this.fDirChannelTimeout)) {
                try {
                    try {
                        String fullPathRecoded = this.recodeSafe(fullPath);
                        OutputStream os = this.getChannel("SftpFileService.createFile").put(fullPathRecoded);
                        os.close();
                        SftpATTRS attrs = this.getChannel("SftpFileService.createFile.stat").stat(fullPathRecoded);
                        result = this.makeHostFile(remoteParent, fileName, attrs);
                        Activator.trace("SftpFileService.createFile ok");
                        break block6;
                    }
                    catch (Exception e) {
                        Activator.trace("SftpFileService.createFile " + fullPath + " failed: " + e.toString());
                        throw this.makeSystemMessageException(e);
                    }
                }
                finally {
                    this.fDirChannelMutex.release();
                }
            }
            throw new RemoteFileCancelledException();
        }
        return result;
    }

    public IHostFile createFolder(String remoteParent, String folderName, IProgressMonitor monitor) throws SystemMessageException {
        SftpHostFile result;
        block6: {
            result = null;
            String fullPath = this.concat(remoteParent, folderName);
            if (this.fDirChannelMutex.waitForLock(monitor, this.fDirChannelTimeout)) {
                try {
                    try {
                        String fullPathRecoded = this.recodeSafe(fullPath);
                        this.getChannel("SftpFileService.createFolder").mkdir(fullPathRecoded);
                        SftpATTRS attrs = this.getChannel("SftpFileService.createFolder.stat").stat(fullPathRecoded);
                        result = this.makeHostFile(remoteParent, folderName, attrs);
                        Activator.trace("SftpFileService.createFolder ok");
                        break block6;
                    }
                    catch (Exception e) {
                        Activator.trace("SftpFileService.createFolder " + fullPath + " failed: " + e.toString());
                        throw this.makeSystemMessageException(e);
                    }
                }
                finally {
                    this.fDirChannelMutex.release();
                }
            }
            throw new RemoteFileCancelledException();
        }
        return result;
    }

    public boolean delete(String remoteParent, String fileName, IProgressMonitor monitor) throws SystemMessageException {
        boolean ok = false;
        String fullPath = this.concat(remoteParent, fileName);
        Activator.trace("SftpFileService.delete.waitForLock");
        if (this.fDirChannelMutex.waitForLock(monitor, this.fDirChannelTimeout)) {
            try {
                try {
                    String fullPathRecoded = this.recodeSafe(fullPath);
                    SftpATTRS attrs = null;
                    try {
                        attrs = this.getChannel("SftpFileService.delete").lstat(fullPathRecoded);
                    }
                    catch (SftpException e) {
                        if (e.id == 2) {
                            this.getChannel("SftpFileService.delete.rm").rm(fullPathRecoded);
                        }
                        throw e;
                    }
                    if (attrs == null) {
                        ok = true;
                    } else if (attrs.isDir()) {
                        try {
                            this.getChannel("SftpFileService.delete.rmdir").rmdir(fullPathRecoded);
                            ok = true;
                        }
                        catch (SftpException e) {
                            if (e.id == 4) {
                                String fullPathQuoted = PathUtility.enQuoteUnix((String)fullPathRecoded);
                                int rv = this.runCommand("rm -rf " + fullPathQuoted, monitor);
                                ok = rv == 0;
                            }
                            throw e;
                        }
                    } else {
                        this.getChannel("SftpFileService.delete.rm").rm(fullPathRecoded);
                        ok = true;
                    }
                    Activator.trace("SftpFileService.delete ok");
                }
                catch (Exception e) {
                    Activator.trace("SftpFileService.delete " + fullPath + " failed: " + e.toString());
                    throw this.makeSystemMessageException(e);
                }
            }
            finally {
                this.fDirChannelMutex.release();
            }
        }
        return ok;
    }

    public boolean rename(String remoteParent, String oldName, String newName, IProgressMonitor monitor) throws SystemMessageException {
        boolean ok = false;
        String fullPathOld = this.concat(remoteParent, oldName);
        String fullPathNew = this.concat(remoteParent, newName);
        if (this.fDirChannelMutex.waitForLock(monitor, this.fDirChannelTimeout)) {
            try {
                try {
                    this.getChannel("SftpFileService.rename").rename(this.recode(fullPathOld), this.recodeSafe(fullPathNew));
                    ok = true;
                    Activator.trace("SftpFileService.rename ok");
                }
                catch (Exception e) {
                    Activator.trace("SftpFileService.rename " + fullPathOld + " -> " + fullPathNew + " failed: " + e.toString());
                    throw this.makeSystemMessageException(e);
                }
            }
            finally {
                this.fDirChannelMutex.release();
            }
        }
        return ok;
    }

    public boolean rename(String remoteParent, String oldName, String newName, IHostFile oldFile, IProgressMonitor monitor) throws SystemMessageException {
        return this.rename(remoteParent, oldName, newName, monitor);
    }

    private boolean progressWorked(IProgressMonitor monitor, int work) {
        boolean cancelRequested = false;
        if (monitor != null) {
            monitor.worked(work);
            cancelRequested = monitor.isCanceled();
        }
        return cancelRequested;
    }

    /*
     * Unable to fully structure code
     */
    public int runCommand(String command, IProgressMonitor monitor) throws SystemMessageException {
        Activator.trace("SftpFileService.runCommand " + command);
        result = -1;
        if (monitor != null) {
            monitor.beginTask(command, 20);
        }
        channel = null;
        try {
            try {
                channel = this.fSessionProvider.getSession().openChannel("exec");
                ((ChannelExec)channel).setCommand(command);
                channel.setInputStream(null);
                err = new ByteArrayOutputStream();
                ((ChannelExec)channel).setErrStream((OutputStream)err);
                in = channel.getInputStream();
                channel.connect();
                tmp = new byte[1024];
                while (!channel.isClosed()) {
                    if (!this.progressWorked(monitor, 1)) ** GOTO lbl-1000
                    break;
                    while ((i = in.read(tmp, 0, 1024)) >= 0) lbl-1000:
                    // 2 sources

                    {
                        if (in.available() > 0) continue;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception v0) {}
                }
                result = channel.getExitStatus();
                if (result != 0) {
                    errorMsg = err.toString();
                    Activator.trace("SftpFileService.runCommand ok, error: " + result + ", " + errorMsg);
                    if (errorMsg.length() > 0) {
                        throw this.makeSystemMessageException(new IOException(errorMsg));
                    }
                } else {
                    Activator.trace("SftpFileService.runCommand ok, result: " + result);
                }
            }
            catch (Exception e) {
                Activator.trace(command);
                Activator.trace("SftpFileService.runCommand failed: " + e.toString());
                throw this.makeSystemMessageException(e);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
            if (channel != null) {
                channel.disconnect();
            }
        }
        return result;
    }

    public boolean move(String srcParent, String srcName, String tgtParent, String tgtName, IProgressMonitor monitor) throws SystemMessageException {
        Activator.trace("SftpFileService.move " + srcName);
        String fullPathOld = PathUtility.enQuoteUnix((String)this.recode(this.concat(srcParent, srcName)));
        String fullPathNew = PathUtility.enQuoteUnix((String)this.recodeSafe(this.concat(tgtParent, tgtName)));
        int rv = this.runCommand("mv " + fullPathOld + ' ' + fullPathNew, monitor);
        return rv == 0;
    }

    public boolean copy(String srcParent, String srcName, String tgtParent, String tgtName, IProgressMonitor monitor) throws SystemMessageException {
        Activator.trace("SftpFileService.copy " + srcName);
        String fullPathOld = PathUtility.enQuoteUnix((String)this.recode(this.concat(srcParent, srcName)));
        String fullPathNew = PathUtility.enQuoteUnix((String)this.recodeSafe(this.concat(tgtParent, tgtName)));
        int rv = this.runCommand("cp -Rp " + fullPathOld + ' ' + fullPathNew, monitor);
        return rv == 0;
    }

    public boolean copyBatch(String[] srcParents, String[] srcNames, String tgtParent, IProgressMonitor monitor) throws SystemMessageException {
        Activator.trace("SftpFileService.copyBatch " + srcNames);
        boolean ok = true;
        int i = 0;
        while (i < srcParents.length) {
            ok = ok && this.copy(srcParents[i], srcNames[i], tgtParent, srcNames[i], monitor);
            ++i;
        }
        return ok;
    }

    public void initService(IProgressMonitor monitor) {
        Activator.trace("SftpFileService.initService");
        try {
            this.connect();
        }
        catch (Exception exception) {}
    }

    public void uninitService(IProgressMonitor monitor) {
        Activator.trace("SftpFileService.uninitService");
        this.disconnect();
    }

    public boolean isCaseSensitive() {
        return true;
    }

    public boolean setLastModified(String parent, String name, long timestamp, IProgressMonitor monitor) throws SystemMessageException {
        boolean ok = false;
        String path = this.concat(parent, name);
        if (this.fDirChannelMutex.waitForLock(monitor, this.fDirChannelTimeout)) {
            try {
                try {
                    this.getChannel("SftpFileService.setLastModified").setMtime(this.recode(path), (int)(timestamp / 1000L));
                    ok = true;
                    Activator.trace("SftpFileService.setLastModified ok");
                }
                catch (Exception e) {
                    Activator.trace("SftpFileService.setLastModified " + path + " failed: " + e.toString());
                    throw this.makeSystemMessageException(e);
                }
            }
            finally {
                this.fDirChannelMutex.release();
            }
        }
        return ok;
    }

    public boolean setReadOnly(String parent, String name, boolean readOnly, IProgressMonitor monitor) throws SystemMessageException {
        boolean ok = false;
        String path = this.concat(parent, name);
        if (this.fDirChannelMutex.waitForLock(monitor, this.fDirChannelTimeout)) {
            try {
                try {
                    int permOld;
                    SftpATTRS attr = this.getChannel("SftpFileService.setReadOnly").stat(this.recode(path));
                    int permNew = permOld = attr.getPermissions();
                    permNew = readOnly ? (permNew &= 0xFFFFFF6D) : (permNew |= 0x80);
                    if (permNew != permOld) {
                        attr.setPERMISSIONS(permNew);
                        this.getChannel("SftpFileService.setReadOnly").setStat(this.recode(path), attr);
                        ok = true;
                        Activator.trace("SftpFileService.setReadOnly ok");
                    } else {
                        ok = true;
                        Activator.trace("SftpFileService.setReadOnly nothing-to-do");
                    }
                }
                catch (Exception e) {
                    Activator.trace("SftpFileService.setReadOnly " + path + " failed: " + e.toString());
                    throw this.makeSystemMessageException(e);
                }
            }
            finally {
                this.fDirChannelMutex.release();
            }
        }
        return ok;
    }

    public InputStream getInputStream(String remoteParent, String remoteFile, boolean isBinary, IProgressMonitor monitor) throws SystemMessageException {
        SftpBufferedInputStream stream = null;
        String remotePath = this.concat(remoteParent, remoteFile);
        try {
            String remotePathRecoded = this.recode(remotePath);
            this.getChannel("SftpFileService.getInputStream " + remoteFile);
            ChannelSftp channel = (ChannelSftp)this.fSessionProvider.getSession().openChannel("sftp");
            channel.connect();
            stream = new SftpBufferedInputStream(channel.get(remotePathRecoded), channel);
            Activator.trace("SftpFileService.getInputStream " + remoteFile + " ok");
        }
        catch (Exception e) {
            Activator.trace("SftpFileService.getInputStream " + remotePath + " failed: " + e.toString());
            throw this.makeSystemMessageException(e);
        }
        return stream;
    }

    public OutputStream getOutputStream(String remoteParent, String remoteFile, boolean isBinary, IProgressMonitor monitor) throws SystemMessageException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SftpBufferedOutputStream stream = null;
        String dst = remoteParent;
        if (remoteFile != null) {
            dst = this.concat(remoteParent, remoteFile);
        }
        try {
            MyProgressMonitor sftpMonitor = new MyProgressMonitor(monitor);
            int mode = 0;
            this.getChannel("SftpFileService.getOutputStream " + remoteFile);
            ChannelSftp channel = (ChannelSftp)this.fSessionProvider.getSession().openChannel("sftp");
            channel.connect();
            stream = new SftpBufferedOutputStream(channel.put(this.recodeSafe(dst), (SftpProgressMonitor)sftpMonitor, mode), channel);
            Activator.trace("SftpFileService.getOutputStream " + remoteFile + " ok");
        }
        catch (Exception e) {
            Activator.trace("SftpFileService.getOutputStream " + dst + " failed: " + e.toString());
            throw this.makeSystemMessageException(e);
        }
        if (monitor.isCanceled()) {
            throw new RemoteFileCancelledException();
        }
        return stream;
    }

    public static class MyProgressMonitor
    implements SftpProgressMonitor {
        private IProgressMonitor fMonitor;
        private double fWorkPercentFactor;
        private Long fMaxWorkKB;
        private long fWorkToDate;

        public MyProgressMonitor(IProgressMonitor monitor) {
            this.fMonitor = monitor;
        }

        public void init(int op, String src, String dest, long max) {
            String srcFile;
            this.fWorkPercentFactor = 1.0 / (double)max;
            this.fMaxWorkKB = new Long(max / 1024L);
            this.fWorkToDate = 0L;
            String desc = srcFile = new Path(src).lastSegment();
            this.fMonitor.beginTask(desc, (int)max);
        }

        public boolean count(long count) {
            this.fWorkToDate += count;
            Long workToDateKB = new Long(this.fWorkToDate / 1024L);
            Double workPercent = new Double(this.fWorkPercentFactor * (double)this.fWorkToDate);
            String subDesc = MessageFormat.format(SshServiceResources.SftpFileService_Msg_Progress, workToDateKB, this.fMaxWorkKB, workPercent);
            this.fMonitor.subTask(subDesc);
            this.fMonitor.worked((int)count);
            return !this.fMonitor.isCanceled();
        }

        public void end() {
            this.fMonitor.done();
        }
    }

    private static class SftpBufferedInputStream
    extends BufferedInputStream {
        private ChannelSftp channel;

        public SftpBufferedInputStream(InputStream in, ChannelSftp channel) {
            super(in);
            this.channel = channel;
        }

        public SftpBufferedInputStream(InputStream in, int size, ChannelSftp channel) {
            super(in, size);
            this.channel = channel;
        }

        public void close() throws IOException {
            super.close();
            this.channel.disconnect();
        }
    }

    private static class SftpBufferedOutputStream
    extends BufferedOutputStream {
        private ChannelSftp channel;

        public SftpBufferedOutputStream(OutputStream out, ChannelSftp channel) {
            super(out);
            this.channel = channel;
        }

        public SftpBufferedOutputStream(OutputStream out, int size, ChannelSftp channel) {
            super(out, size);
            this.channel = channel;
        }

        public void close() throws IOException {
            super.close();
            this.channel.disconnect();
        }
    }
}

