/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.subsystems.files.core;

import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.ui.view.SystemAbstractAPIProvider;
import org.eclipse.rse.subsystems.files.core.model.ISystemFileAPIProvider;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;

public class SystemFileAPIProviderImpl
extends SystemAbstractAPIProvider
implements ISystemFileAPIProvider {
    protected ISystemRegistry sr = null;
    protected boolean directoryMode = false;

    public SystemFileAPIProviderImpl(boolean directoryMode) {
        this.directoryMode = directoryMode;
        this.sr = RSECorePlugin.getTheSystemRegistry();
    }

    public boolean isDirectoriesOnly() {
        return this.directoryMode;
    }

    public Object[] getSystemViewRoots() {
        return this.getConnections();
    }

    public boolean hasSystemViewRoots() {
        return this.getConnectionCount() > 0;
    }

    public Object[] getConnectionChildren(IHost selectedConnection) {
        return this.sr.getConnectionChildren(selectedConnection);
    }

    public boolean hasConnectionChildren(IHost selectedConnection) {
        return this.sr.hasConnectionChildren(selectedConnection);
    }

    public IHost[] getConnections() {
        int connCount = this.getConnectionCount();
        IHost[] ourConns = new IHost[connCount];
        IHost[] allConns = this.sr.getHosts();
        int ourConnsIdx = 0;
        if (allConns != null) {
            int idx = 0;
            while (idx < allConns.length) {
                ISubSystem[] subsystems = this.sr.getSubSystems(allConns[idx]);
                if (subsystems != null) {
                    boolean match = false;
                    int jdx = 0;
                    while (!match && jdx < subsystems.length) {
                        if (subsystems[jdx] instanceof IRemoteFileSubSystem) {
                            ourConns[ourConnsIdx++] = allConns[idx];
                            match = true;
                        }
                        ++jdx;
                    }
                }
                ++idx;
            }
        }
        return ourConns;
    }

    public int getConnectionCount() {
        int count = 0;
        IHost[] allConns = this.sr.getHosts();
        if (allConns != null) {
            int idx = 0;
            while (idx < allConns.length) {
                ISubSystem[] subsystems = this.sr.getSubSystems(allConns[idx]);
                boolean match = false;
                if (subsystems != null) {
                    int jdx = 0;
                    while (!match && jdx < subsystems.length) {
                        if (subsystems[jdx] instanceof IRemoteFileSubSystem) {
                            match = true;
                        }
                        ++jdx;
                    }
                }
                if (match) {
                    ++count;
                }
                ++idx;
            }
        }
        return count;
    }
}

