/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.clientserver.archiveutils;

import java.io.File;
import java.io.IOException;
import org.eclipse.rse.services.clientserver.SystemEncodingUtil;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.clientserver.archiveutils.ISystemArchiveHandler;

public final class VirtualChild {
    public String fullName = "";
    public String name = "";
    public String path = "";
    public boolean isDirectory = false;
    protected ISystemArchiveHandler _handler;
    protected File _extractedFile;
    protected File _containingArchive;

    public VirtualChild(ISystemArchiveHandler handler) {
        this._handler = handler;
        this._extractedFile = null;
        this._containingArchive = null;
    }

    public VirtualChild(ISystemArchiveHandler handler, String fullVirtualName) {
        this(handler);
        this.renameTo(fullVirtualName);
    }

    public VirtualChild(String fullVirtualName, File containingArchive) {
        this(null);
        this.renameTo(fullVirtualName);
        this._containingArchive = containingArchive;
    }

    public ISystemArchiveHandler getHandler() {
        return this._handler;
    }

    public long getTimeStamp() {
        if (this._handler == null) {
            return 0L;
        }
        return this._handler.getTimeStampFor(this.fullName);
    }

    public long getSize() {
        if (this._handler == null) {
            return 0L;
        }
        return this._handler.getSizeFor(this.fullName);
    }

    public String getComment() {
        if (this._handler == null) {
            return "";
        }
        return this._handler.getCommentFor(this.fullName);
    }

    public long getCompressedSize() {
        if (this._handler == null) {
            return 0L;
        }
        return this._handler.getCompressedSizeFor(this.fullName);
    }

    public String getCompressionMethod() {
        if (this._handler == null) {
            return "";
        }
        return this._handler.getCompressionMethodFor(this.fullName);
    }

    public double getCompressionRatio() {
        if (this.getSize() == 0L) {
            return 1.0;
        }
        return ((double)this.getSize() - (double)this.getCompressedSize()) / (double)this.getSize();
    }

    public File getExtractedFile() {
        return this.getExtractedFile(SystemEncodingUtil.ENCODING_UTF_8, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File getExtractedFile(String sourceEncoding, boolean isText) {
        if (this._extractedFile == null || this._extractedFile.lastModified() != this.getTimeStamp()) {
            try {
                int i = this.name.lastIndexOf(".");
                String ext = "";
                if (i != -1) {
                    ext = this.name.substring(i + 1);
                }
                this._extractedFile = i < 3 ? File.createTempFile(String.valueOf(this.name) + "123", "virtual." + ext) : File.createTempFile(this.name, "virtual." + ext);
                this._extractedFile.deleteOnExit();
                if (this._handler == null) {
                    return this._extractedFile;
                }
                if (this.isDirectory) {
                    if (!(this._extractedFile.isDirectory() || this._extractedFile.delete() && this._extractedFile.mkdirs())) {
                        System.out.println("VirtualChild.getExtractedFile(): Could not create temp dir.");
                        return null;
                    }
                    this._handler.extractVirtualDirectory(this.fullName, this._extractedFile, sourceEncoding, isText);
                } else {
                    this._handler.extractVirtualFile(this.fullName, this._extractedFile, sourceEncoding, isText);
                }
            }
            catch (IOException e) {
                System.out.println("VirtualChild.getExtractedFile(): ");
                System.out.println(e.getMessage());
            }
        }
        if (this.isDirectory) {
            return new File(this._extractedFile, this.name);
        }
        return this._extractedFile;
    }

    public boolean getExtractedFile(File destination) {
        return this.getExtractedFile(destination, SystemEncodingUtil.ENCODING_UTF_8, false);
    }

    public boolean getExtractedFile(File destination, String sourceEncoding, boolean isText) {
        boolean success = true;
        if (this._handler == null) {
            return false;
        }
        if (this._extractedFile == null || this._extractedFile.lastModified() != this.getTimeStamp() || !destination.getAbsolutePath().equals(this._extractedFile.getAbsolutePath())) {
            success = this.isDirectory ? this._handler.extractVirtualDirectory(this.fullName, destination.getParentFile(), destination, sourceEncoding, isText) : this._handler.extractVirtualFile(this.fullName, destination, sourceEncoding, isText);
            this._extractedFile = destination;
        }
        return success;
    }

    public boolean exists() {
        if (this._handler == null) {
            return false;
        }
        return this._handler.exists(this.fullName);
    }

    public void renameTo(String newName) {
        this.fullName = newName = ArchiveHandlerManager.cleanUpVirtualPath(newName);
        int i = newName.lastIndexOf("/");
        if (i == -1) {
            this.name = newName;
            this.path = "";
        } else {
            this.name = newName.substring(i + 1);
            this.path = newName.substring(0, i);
        }
        this._extractedFile = null;
    }

    public String getArchiveStandardName() {
        if (this._handler == null) {
            return this.fullName;
        }
        return this._handler.getStandardName(this);
    }

    public File getContainingArchive() {
        if (this._handler == null) {
            return this._containingArchive;
        }
        return this._handler.getArchive();
    }
}

