/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.core.passwords;

import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.PasswordPersistenceManager;
import org.eclipse.rse.core.RSEPreferencesManager;
import org.eclipse.rse.core.model.SystemSignonInformation;
import org.eclipse.rse.internal.core.RSECoreRegistry;
import org.eclipse.rse.tests.core.RSECoreTestCase;

public class PasswordsTest
extends RSECoreTestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testAddRemove() {
        IRSESystemType systemType = RSECoreRegistry.getInstance().getSystemType("org.eclipse.rse.systemtype.unix");
        IRSESystemType defaultSystemType = PasswordPersistenceManager.DEFAULT_SYSTEM_TYPE;
        String hostAddress = "somesystem.mycompany.com";
        boolean deny = RSEPreferencesManager.getDenyPasswordSave((IRSESystemType)systemType, (String)hostAddress);
        PasswordsTest.assertFalse((String)"the initial value of this preference should be false", (boolean)deny);
        String password = "password";
        String userId = "me";
        SystemSignonInformation info = new SystemSignonInformation(hostAddress, userId, password, systemType);
        PasswordPersistenceManager ppm = PasswordPersistenceManager.getInstance();
        int result = ppm.add(info, true, true);
        PasswordsTest.assertEquals((String)"result of add was not what was expected", (int)0, (int)result);
        SystemSignonInformation returnedInfo = ppm.find(systemType, hostAddress, userId);
        PasswordsTest.assertEquals((String)"passwords are not equal", (String)password, (String)returnedInfo.getPassword());
        PasswordsTest.assertEquals((String)"system type not what was expected", (Object)systemType, (Object)returnedInfo.getSystemType());
        ppm.remove(systemType, hostAddress, userId);
        returnedInfo = ppm.find(systemType, hostAddress, userId, true);
        PasswordsTest.assertEquals((String)"passwords are not equal", (String)password, (String)returnedInfo.getPassword());
        PasswordsTest.assertEquals((String)"system type not what was expected", (Object)defaultSystemType, (Object)returnedInfo.getSystemType());
        returnedInfo = ppm.find(systemType, hostAddress, userId, false);
        PasswordsTest.assertNull((String)"signon info was found but should not be", (Object)returnedInfo);
        ppm.remove(defaultSystemType, hostAddress, userId);
        returnedInfo = ppm.find(systemType, hostAddress, userId, true);
        PasswordsTest.assertNull((String)"signon info was found but should not be", (Object)returnedInfo);
        returnedInfo = ppm.find(systemType, hostAddress, userId, false);
        PasswordsTest.assertNull((String)"signon info was found but should not be", (Object)returnedInfo);
        result = ppm.add(info, true, false);
        PasswordsTest.assertEquals((String)"result of add was not what was expected", (int)0, (int)result);
        returnedInfo = ppm.find(systemType, hostAddress, userId);
        PasswordsTest.assertEquals((String)"passwords are not equal", (String)password, (String)returnedInfo.getPassword());
        PasswordsTest.assertEquals((String)"system type not what was expected", (Object)systemType, (Object)returnedInfo.getSystemType());
        returnedInfo = ppm.find(defaultSystemType, hostAddress, userId);
        PasswordsTest.assertNull((String)"signon info was found but should not be", (Object)returnedInfo);
        ppm.remove(systemType, hostAddress, userId);
        returnedInfo = ppm.find(systemType, hostAddress, userId, true);
        PasswordsTest.assertNull((String)"signon info was found but should not be", (Object)returnedInfo);
        returnedInfo = ppm.find(systemType, hostAddress, userId, false);
        PasswordsTest.assertNull((String)"signon info was found but should not be", (Object)returnedInfo);
    }

    public void testSaveDenial() {
        IRSESystemType systemType = RSECoreRegistry.getInstance().getSystemType("org.eclipse.rse.systemtype.unix");
        String hostAddress = "somesystem.mycompany.com";
        boolean deny = RSEPreferencesManager.getDenyPasswordSave((IRSESystemType)systemType, (String)hostAddress);
        PasswordsTest.assertFalse((String)"the initial value of this preference should be false", (boolean)deny);
        String password = "password";
        String userId = "me";
        SystemSignonInformation info = new SystemSignonInformation(hostAddress, userId, password, systemType);
        PasswordPersistenceManager ppm = PasswordPersistenceManager.getInstance();
        int result = ppm.add(info, true, true);
        PasswordsTest.assertEquals((String)"result of add was not what was expected", (int)0, (int)result);
        SystemSignonInformation returnedInfo = ppm.find(systemType, hostAddress, userId);
        PasswordsTest.assertEquals((String)"passwords are not equal", (String)password, (String)returnedInfo.getPassword());
        PasswordsTest.assertEquals((String)"system type not what was expected", (Object)systemType, (Object)returnedInfo.getSystemType());
        RSEPreferencesManager.setDenyPasswordSave((IRSESystemType)systemType, (String)hostAddress, (boolean)true);
        returnedInfo = ppm.find(systemType, hostAddress, userId);
        PasswordsTest.assertNull((String)"signon info was found but should not be", (Object)returnedInfo);
        returnedInfo = ppm.find(systemType, hostAddress, userId, true);
        PasswordsTest.assertNull((String)"signon info was found but should not be", (Object)returnedInfo);
        returnedInfo = ppm.find(systemType, hostAddress, userId, false);
        PasswordsTest.assertNull((String)"signon info was found but should not be", (Object)returnedInfo);
        result = ppm.add(info, true, true);
        PasswordsTest.assertEquals((String)"result of add was not what was expected", (int)2, (int)result);
        returnedInfo = ppm.find(systemType, hostAddress, userId);
        PasswordsTest.assertNull((String)"signon info was found but should not be", (Object)returnedInfo);
        returnedInfo = ppm.find(systemType, hostAddress, userId, true);
        PasswordsTest.assertNull((String)"signon info was found but should not be", (Object)returnedInfo);
        returnedInfo = ppm.find(systemType, hostAddress, userId, false);
        PasswordsTest.assertNull((String)"signon info was found but should not be", (Object)returnedInfo);
    }
}

