/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.profiles;

import java.util.Arrays;
import java.util.List;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemProfileManager;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.tests.core.RSECoreTestCase;

public class ProfileTest
extends RSECoreTestCase {
    ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
    ISystemProfileManager manager = this.registry.getSystemProfileManager();
    ISystemProfile defaultProfile = this.manager.getDefaultPrivateSystemProfile();

    public ProfileTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testDefaultProfileMarking() {
        ProfileTest.assertNotNull((String)"default profile is null", (Object)this.defaultProfile);
        ProfileTest.assertTrue((String)"default profile is not active - 1", (boolean)this.defaultProfile.isActive());
        ProfileTest.assertTrue((String)"default profile is not marked as default", (boolean)this.defaultProfile.isDefaultPrivate());
    }

    public void testDefaultProfileActivation() {
        this.registry.setSystemProfileActive(this.defaultProfile, true);
        ProfileTest.assertTrue((String)"default profile is not active - 2", (boolean)this.defaultProfile.isActive());
        this.registry.setSystemProfileActive(this.defaultProfile, false);
        ProfileTest.assertTrue((String)"default profile is not active - 3", (boolean)this.defaultProfile.isActive());
    }

    public void testDefaultProfileRename() {
        try {
            ISystemProfile profile = this.registry.getSystemProfile("bogus");
            ProfileTest.assertNull((Object)profile);
            String oldName = this.defaultProfile.getName();
            this.registry.renameSystemProfile(this.defaultProfile, "bogus");
            ProfileTest.assertEquals((String)"bogus", (String)this.defaultProfile.getName());
            ProfileTest.assertSame((Object)this.defaultProfile, (Object)this.manager.getDefaultPrivateSystemProfile());
            profile = this.registry.getSystemProfile("bogus");
            ProfileTest.assertSame((Object)profile, (Object)this.manager.getDefaultPrivateSystemProfile());
            this.registry.renameSystemProfile(this.defaultProfile, oldName);
            ProfileTest.assertEquals((String)oldName, (String)this.defaultProfile.getName());
            ProfileTest.assertSame((Object)this.defaultProfile, (Object)this.manager.getDefaultPrivateSystemProfile());
            profile = this.registry.getSystemProfile(oldName);
            ProfileTest.assertSame((Object)profile, (Object)this.manager.getDefaultPrivateSystemProfile());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void testProfileActivation() {
        try {
            ISystemProfile profile = this.registry.getSystemProfile("bogus");
            ProfileTest.assertNull((Object)profile);
            profile = this.registry.createSystemProfile("bogus", true);
            ProfileTest.assertNotNull((Object)profile);
            ProfileTest.assertTrue((String)"profile is not active, but should be", (boolean)profile.isActive());
            this.registry.setSystemProfileActive(profile, false);
            ProfileTest.assertFalse((String)"profile is active, but should not be", (boolean)profile.isActive());
            this.registry.setSystemProfileActive(profile, true);
            ProfileTest.assertTrue((String)"profile is not active, but should be", (boolean)profile.isActive());
            this.registry.deleteSystemProfile(profile);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void testDefaultProfileDeletion() {
        try {
            this.registry.deleteSystemProfile(this.defaultProfile);
            List<ISystemProfile> profiles = Arrays.asList(this.manager.getSystemProfiles());
            ProfileTest.assertTrue((String)"default profile was deleted", (boolean)profiles.contains(this.defaultProfile));
            ProfileTest.assertTrue((String)"default profile is not registered with manager", (this.manager.getDefaultPrivateSystemProfile() == this.defaultProfile ? 1 : 0) != 0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void testProfileDeletion() {
        try {
            ISystemProfile profile = this.registry.getSystemProfile("bogus");
            ProfileTest.assertNull((Object)profile);
            profile = this.registry.createSystemProfile("bogus", true);
            ProfileTest.assertNotNull((Object)profile);
            this.registry.deleteSystemProfile(profile);
            List<ISystemProfile> profiles = Arrays.asList(this.manager.getSystemProfiles());
            ProfileTest.assertFalse((String)"profile was not deleted", (boolean)profiles.contains(profile));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

