/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.subsystems.files;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.SystemStartHere;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.IFileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.tests.subsystems.files.FileServiceBaseTest;
import org.eclipse.rse.tests.subsystems.files.FileServiceHelper;

public class CreateFileTestCase
extends FileServiceBaseTest {
    private IHost host;
    private String fileName = "a !@#${a}'%^&()_ =[]~+-'`;,.txt";
    private IRemoteFile tempDirectory = null;
    static /* synthetic */ Class class$0;

    public CreateFileTestCase(String name) {
        super(name);
    }

    private IRemoteFileSubSystem getRemoteFileSubSystem(IHost host) {
        IRemoteFileSubSystem fss = null;
        ISystemRegistry sr = SystemStartHere.getSystemRegistry();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.services.files.IFileService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISubSystem[] ss = sr.getServiceSubSystems(host, (Class)clazz);
        int i = 0;
        while (i < ss.length) {
            if (ss[i] instanceof FileServiceSubSystem) {
                fss = (IRemoteFileSubSystem)ss[i];
                return fss;
            }
            ++i;
        }
        return null;
    }

    public void testCreateFileFTP() throws Exception {
        this.host = this.getFTPHost();
        this.createFileAndAssertProperties();
    }

    public void testCreateFileLinux() throws Exception {
        this.host = this.getLinuxHost();
        this.createFileAndAssertProperties();
    }

    public void testCreateFileSSH() throws Exception {
        this.host = this.getSSHHost();
        this.createFileAndAssertProperties();
    }

    public void testCreateFileWindows() throws Exception {
        this.host = this.getWindowsHost();
        this.createFileAndAssertProperties();
    }

    public void createFileAndAssertProperties() throws Exception {
        String SYSTEM_TYPE = this.host.getSystemType().getLabel();
        FileServiceSubSystem inputFss = (FileServiceSubSystem)this.getRemoteFileSubSystem(this.host);
        inputFss.connect((IProgressMonitor)new NullProgressMonitor(), false);
        IRemoteFile homeDirectory = inputFss.getRemoteFileObject(".", (IProgressMonitor)new NullProgressMonitor());
        String baseFolderName = "rsetest";
        String homeFolderName = homeDirectory.getAbsolutePath();
        String testFolderName = FileServiceHelper.getRandomLocation((IFileServiceSubSystem)inputFss, homeFolderName, baseFolderName, (IProgressMonitor)new NullProgressMonitor());
        this.tempDirectory = this.createFileOrFolder((IFileServiceSubSystem)inputFss, homeFolderName, testFolderName, true);
        this.tempDirPath = this.tempDirectory.getAbsolutePath();
        IHostFile hostfile = inputFss.getFileService().createFile(this.tempDirPath, this.fileName, (IProgressMonitor)new NullProgressMonitor());
        CreateFileTestCase.assertTrue((String)(String.valueOf(SYSTEM_TYPE) + ": hostfile doesn't exist."), (boolean)hostfile.exists());
        CreateFileTestCase.assertTrue((String)(String.valueOf(SYSTEM_TYPE) + ": hostfile canRead returns false"), (boolean)hostfile.canRead());
        CreateFileTestCase.assertTrue((String)(String.valueOf(SYSTEM_TYPE) + ": hostfile canWrite returns false"), (boolean)hostfile.canWrite());
        CreateFileTestCase.assertEquals((String)(String.valueOf(SYSTEM_TYPE) + ": filename does not match."), (String)this.fileName, (String)hostfile.getName());
        CreateFileTestCase.assertEquals((String)(String.valueOf(SYSTEM_TYPE) + ": path's to file do not match."), (String)this.tempDirPath, (String)hostfile.getParentPath());
        CreateFileTestCase.assertEquals((String)(String.valueOf(SYSTEM_TYPE) + ": file size's do not match."), (long)0L, (long)hostfile.getSize());
        long modDate = hostfile.getModifiedDate();
        CreateFileTestCase.assertTrue((String)(String.valueOf(SYSTEM_TYPE) + ": modification date is not greater than 0."), (modDate > 0L ? 1 : 0) != 0);
        this.cleanup();
    }

    public void cleanup() throws Exception {
        if (this.host != null) {
            if (this.tempDirectory != null) {
                IRemoteFileSubSystem fss = this.getRemoteFileSubSystem(this.host);
                fss.delete(this.tempDirectory, (IProgressMonitor)new NullProgressMonitor());
                fss.disconnect();
                this.tempDirectory = null;
            }
            this.getConnectionManager().removeConnection(this.host.getSystemProfile().getName(), this.host.getName());
            this.host = null;
        }
    }

    public void tearDown() throws Exception {
        this.cleanup();
        super.tearDown();
    }
}

