/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.subsystems.files;

import java.io.File;
import java.lang.reflect.Method;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.IFileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.tests.RSETestsPlugin;
import org.eclipse.rse.tests.core.connection.RSEBaseConnectionTestCase;

public class FileServiceTest
extends RSEBaseConnectionTestCase {
    private String fPropertiesFileName;
    public static String fDefaultPropertiesFile = "local.properties";
    private IFileServiceSubSystem fss;
    private IFileService fs;
    private IRemoteFile fHomeDirectory;
    private IRemoteFile remoteTempDir;
    private String tempDirPath;
    private IProgressMonitor mon = new NullProgressMonitor();
    static /* synthetic */ Class class$0;

    public FileServiceTest(String name) {
        this(name, fDefaultPropertiesFile);
    }

    public FileServiceTest(String name, String propertiesFileName) {
        super(name);
        this.fPropertiesFileName = propertiesFileName;
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String baseName = clazz.getName();
        TestSuite suite = new TestSuite(baseName);
        String[] connTypes = new String[]{"local", "ssh", "ftpWindows", "ftp", "linux", "windows"};
        int i = 0;
        while (i < connTypes.length) {
            String suiteName = connTypes[i] == null ? "EFS" : connTypes[i];
            String propFileName = connTypes[i] == null ? null : String.valueOf(connTypes[i]) + "Connection.properties";
            TestSuite subSuite = new TestSuite(String.valueOf(baseName) + "." + suiteName);
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceTest");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Method[] m = clazz2.getMethods();
            int j = 0;
            while (j < m.length) {
                String testName = m[j].getName();
                if (testName.startsWith("test")) {
                    subSuite.addTest((Test)new FileServiceTest(testName, propFileName));
                }
                ++j;
            }
            suite.addTest((Test)subSuite);
            ++i;
        }
        return suite;
    }

    public void setUp() throws Exception {
        super.setUp();
        IHost host = this.getHost(this.fPropertiesFileName);
        this.fss = (IFileServiceSubSystem)RemoteFileUtility.getFileSubSystem((IHost)host);
        this.fs = this.fss.getFileService();
        this.fss.checkIsConnected(this.getDefaultProgressMonitor());
        this.fHomeDirectory = this.fss.getRemoteFileObject(".", this.getDefaultProgressMonitor());
        this.remoteTempDir = this.fss.getRemoteFileObject(this.fHomeDirectory, "rsetest" + System.currentTimeMillis(), this.getDefaultProgressMonitor());
        this.fss.createFolder(this.remoteTempDir, this.getDefaultProgressMonitor());
        this.tempDirPath = this.remoteTempDir.getAbsolutePath();
    }

    public void tearDown() throws Exception {
        this.fss.delete(this.remoteTempDir, this.getDefaultProgressMonitor());
        super.tearDown();
    }

    public boolean isWindows() {
        return this.fss.getHost().getSystemType().isWindows();
    }

    public String getTestFileName() {
        if (!this.isWindows()) {
            return "a !@#${a}\"' fi\tle\b\\%^&*()?_ =[]~+-'`;:,.|<>";
        }
        return "a !@#${a}'` file%^&()_ =[]~+-;.,";
    }

    public void testGetRootProperties() throws Exception {
        IHostFile[] roots = this.fs.getRoots((IProgressMonitor)new NullProgressMonitor());
        FileServiceTest.assertNotNull((Object)roots);
        FileServiceTest.assertTrue((roots.length > 0 ? 1 : 0) != 0);
        int i = 0;
        while (i < roots.length) {
            FileServiceTest.assertTrue((boolean)roots[i].isRoot());
            FileServiceTest.assertTrue((boolean)roots[i].exists());
            FileServiceTest.assertNull((Object)roots[i].getParentPath());
            String rootName = roots[i].getName();
            FileServiceTest.assertNotNull((Object)rootName);
            System.out.println(rootName);
            IHostFile newHf = this.fs.getFile(null, rootName, (IProgressMonitor)new NullProgressMonitor());
            FileServiceTest.assertTrue((boolean)newHf.isRoot());
            FileServiceTest.assertTrue((boolean)newHf.exists());
            FileServiceTest.assertEquals((String)newHf.getName(), (String)rootName);
            newHf = this.fs.getFile("", rootName, (IProgressMonitor)new NullProgressMonitor());
            FileServiceTest.assertTrue((boolean)newHf.isRoot());
            FileServiceTest.assertTrue((boolean)newHf.exists());
            FileServiceTest.assertEquals((String)newHf.getName(), (String)rootName);
            ++i;
        }
    }

    public void testCaseSensitive() {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCaseSensitive")) {
            return;
        }
        if (this.isWindows()) {
            FileServiceTest.assertFalse((boolean)this.fs.isCaseSensitive());
            FileServiceTest.assertFalse((boolean)this.fss.isCaseSensitive());
            FileServiceTest.assertFalse((boolean)this.fss.getSubSystemConfiguration().isCaseSensitive());
        } else {
            FileServiceTest.assertTrue((boolean)this.fs.isCaseSensitive());
            FileServiceTest.assertTrue((boolean)this.fss.isCaseSensitive());
            FileServiceTest.assertTrue((boolean)this.fss.getSubSystemConfiguration().isCaseSensitive());
        }
    }

    public void testCreateFile() throws SystemMessageException {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        String testName = this.getTestFileName();
        IHostFile hf = this.fs.createFile(this.tempDirPath, testName, this.mon);
        FileServiceTest.assertTrue((boolean)hf.exists());
        FileServiceTest.assertTrue((boolean)hf.canRead());
        FileServiceTest.assertTrue((boolean)hf.canWrite());
        FileServiceTest.assertEquals((String)hf.getName(), (String)testName);
        FileServiceTest.assertEquals((String)hf.getParentPath(), (String)this.tempDirPath);
        FileServiceTest.assertEquals((long)hf.getSize(), (long)0L);
        long modDate = hf.getModifiedDate();
        FileServiceTest.assertTrue((modDate > 0L ? 1 : 0) != 0);
        if (this.fss.getHost().getSystemType().isLocal()) {
            File theFile = new File(this.remoteTempDir.getAbsolutePath(), testName);
            FileServiceTest.assertTrue((boolean)theFile.exists());
            FileServiceTest.assertTrue((modDate == theFile.lastModified() ? 1 : 0) != 0);
        }
    }

    public void testCreateCaseSensitive() throws SystemMessageException {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateCaseSensitive")) {
            return;
        }
        String testName = this.getTestFileName();
        String testName2 = testName.toUpperCase();
        IHostFile hf = this.fs.createFile(this.tempDirPath, testName, this.mon);
        if (this.fss.isCaseSensitive()) {
            IHostFile hf2 = this.fs.getFile(this.tempDirPath, testName2, this.mon);
            FileServiceTest.assertFalse((boolean)hf2.exists());
            hf2 = this.fs.createFolder(this.tempDirPath, testName2, this.mon);
            FileServiceTest.assertTrue((boolean)hf2.exists());
            FileServiceTest.assertTrue((boolean)hf2.isDirectory());
            FileServiceTest.assertFalse((boolean)hf.equals(hf2));
        } else {
            IHostFile hf2 = this.fs.getFile(this.tempDirPath, testName2, this.mon);
            FileServiceTest.assertTrue((boolean)hf2.exists());
            try {
                hf2 = this.fs.createFolder(this.tempDirPath, testName2, this.mon);
            }
            catch (SystemMessageException e) {
                FileServiceTest.assertNotNull((Object)((Object)e));
            }
            FileServiceTest.assertTrue((boolean)hf2.exists());
            FileServiceTest.assertFalse((boolean)hf2.isDirectory());
            FileServiceTest.assertEquals((long)hf.getModifiedDate(), (long)hf2.getModifiedDate());
            FileServiceTest.assertEquals((long)hf.getSize(), (long)hf2.getSize());
            FileServiceTest.assertEquals((Object)new File(this.tempDirPath, testName), (Object)new File(this.tempDirPath, testName2));
            FileServiceTest.assertEquals((Object)hf, (Object)hf2);
        }
    }
}

