/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.ui.uda;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.SystemResourceManager;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.model.IPropertySetContainer;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.internal.useractions.ui.uda.ISystemXMLElementWrapperFactory;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDAResources;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDActionSubsystem;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDTreeViewNewItem;
import org.eclipse.rse.internal.useractions.ui.uda.SystemXMLElementWrapper;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class SystemUDBaseManager
implements IResourceChangeListener,
ISystemXMLElementWrapperFactory,
ITreeContentProvider {
    protected SystemUDActionSubsystem _udas;
    protected IFolder importCaseFolder;
    private SystemUDTreeViewNewItem[] newItemsPerDomain;
    private boolean ignoreMyResourceChange = false;
    private Hashtable udocsByProfile;
    private Hashtable hasChangedByProfile;
    private Hashtable dirPathByProfile;
    private IPropertySet udocNoProfile;
    private boolean hasChangedNoProfile = false;
    private Object[] dirPathNoProfile;
    private ISystemProfile currentlyActiveProfile;
    private IPropertySet currentNodeClone = null;
    private String currentNodeCloneID = "";
    private int currentNodeCloneDomain = -1;
    protected static final Object[] EMPTY_ARRAY = new Object[0];
    private static final String CURRENT_RELEASE_NAME = "2.0.0";
    static /* synthetic */ Class class$0;

    public SystemUDBaseManager(SystemUDActionSubsystem udas) {
        this._udas = udas;
        if (this.supportsProfiles()) {
            this.udocsByProfile = new Hashtable();
            this.hasChangedByProfile = new Hashtable();
            this.dirPathByProfile = new Hashtable();
        }
        this.addListener();
    }

    public SystemUDActionSubsystem getActionSubSystem() {
        return this._udas;
    }

    public Image getNewImage() {
        return RSEUIPlugin.getDefault().getImage("org.eclipse.rse.ui.newIcon");
    }

    public abstract String getTagName();

    public abstract SystemXMLElementWrapper createElementWrapper(IPropertySet var1, ISystemProfile var2, int var3);

    protected IWorkbenchAdapter getAdapter(Object o) {
        if (!(o instanceof IAdaptable)) {
            return null;
        }
        IAdaptable iAdaptable = (IAdaptable)o;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz);
    }

    public void dispose() {
        this.setCurrentProfile(null);
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof SystemUDTreeViewNewItem) {
            if (this.getActionSubSystem().supportsDomains()) {
                return !((SystemUDTreeViewNewItem)element).isExecutable();
            }
            return false;
        }
        if (element instanceof SystemXMLElementWrapper) {
            if (this.getActionSubSystem().supportsDomains()) {
                SystemXMLElementWrapper wrapper = (SystemXMLElementWrapper)element;
                if (!wrapper.isDomain()) {
                    return false;
                }
                IPropertySet[] childrenPropertySet = wrapper.getElement().getPropertySets();
                return childrenPropertySet != null && childrenPropertySet.length != 0;
            }
            return false;
        }
        if (element == null) {
            SystemBasePlugin.logError((String)"Unexpected null input to hasChildren!");
        } else {
            String message = "Unexpected input to hasChildren: " + element.getClass().getName();
            SystemBasePlugin.logError((String)message);
        }
        return false;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public abstract String getDocumentRootTagName();

    protected abstract boolean uppercaseName();

    public Vector getXMLWrappers(Vector children, int domain, ISystemProfile profile) {
        SystemXMLElementWrapper domainElement = null;
        if (this.getActionSubSystem().supportsDomains() && (domainElement = this.getDomainWrapper(profile, domain)) == null) {
            return children;
        }
        return this.getXMLWrappers(children, domainElement, profile);
    }

    public Vector getXMLWrappers(Vector children, Object parentOrDomain, ISystemProfile profile) {
        int domain = -1;
        IPropertySet parentElement = null;
        if (parentOrDomain instanceof SystemXMLElementWrapper) {
            parentElement = ((SystemXMLElementWrapper)parentOrDomain).getElement();
            domain = ((SystemXMLElementWrapper)parentOrDomain).getDomain();
        } else if (parentOrDomain instanceof IPropertySet) {
            parentElement = (IPropertySet)parentOrDomain;
        }
        children = SystemXMLElementWrapper.getChildren(children, parentElement, this.getDocument(profile), profile, this, domain);
        return children;
    }

    public boolean supportsProfiles() {
        return true;
    }

    private void addListener() {
    }

    protected ISubSystem getSubSystem() {
        if (this._udas != null) {
            return this._udas.getSubsystem();
        }
        return null;
    }

    protected ISubSystemConfiguration getSubSystemFactory() {
        if (this._udas != null) {
            return this._udas.getSubSystemFactory();
        }
        return null;
    }

    protected IPropertySet loadAndParseXMLFile(ISystemProfile profile) {
        String osType = this._udas.getOSType();
        String udaRootPropertySetName = "UserActoins." + osType + "." + this.getDocumentRootTagName();
        IPropertySet userDefinedActionPropertySet = profile.getPropertySet(udaRootPropertySetName);
        return userDefinedActionPropertySet;
    }

    public void warning(SAXParseException ex) {
        SystemBasePlugin.logWarning((String)("SystemAbstractUDdata: XML Warning: " + ex.toString()));
    }

    public void error(SAXParseException ex) {
        SystemBasePlugin.logError((String)("SystemAbstractUDdata: XML Error: " + ex.toString()), (Throwable)ex);
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        SystemBasePlugin.logError((String)("SystemAbstractUDdata: Fatal XML error: " + ex.toString()), (Throwable)ex);
        throw ex;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.ignoreMyResourceChange) {
            return;
        }
        if (1 != event.getType()) {
            return;
        }
        Object source = event.getSource();
        if (!(source instanceof IWorkspace)) {
            return;
        }
        IResourceDelta delta = event.getDelta();
        if (delta == null) {
            return;
        }
        if (this.supportsProfiles()) {
            ISystemProfile[] activeProfiles = this.getActiveSystemProfiles();
            int idx = 0;
            while (idx < activeProfiles.length) {
                ISystemProfile profile = activeProfiles[idx];
                this.searchDelta(profile, delta, 0);
                ++idx;
            }
        } else {
            this.searchDelta(null, delta, 0);
        }
    }

    private void searchDelta(ISystemProfile profile, IResourceDelta parent, int nestLevel) {
        Object[] dirPath = this.getProfileIndexedInstanceVariable_dirPath(profile);
        String target = (String)dirPath[nestLevel];
        IResourceDelta[] resdel = parent.getAffectedChildren(7);
        int i = 0;
        while (i < resdel.length) {
            IResource resource = resdel[i].getResource();
            if (resource != null && target.equals(resource.getName())) {
                if (++nestLevel < dirPath.length) {
                    this.searchDelta(profile, resdel[i], nestLevel);
                } else {
                    this.processResourceChangeHit(profile);
                }
                return;
            }
            ++i;
        }
    }

    private ISystemProfile[] getActiveSystemProfiles() {
        return RSECorePlugin.getTheSystemRegistry().getActiveSystemProfiles();
    }

    public void setCurrentProfile(ISystemProfile profile) {
        this.currentlyActiveProfile = profile;
    }

    public ISystemProfile getCurrentProfile() {
        return this.currentlyActiveProfile;
    }

    public SystemXMLElementWrapper[] primeDocument(ISystemProfile profile) {
        return null;
    }

    public IPropertySet getDocument(ISystemProfile profile) {
        IPropertySet doc = this.getProfileIndexedInstanceVariable_Document(profile);
        if (doc == null) {
            doc = this.loadUserData(profile);
            if (doc == null) {
                return doc;
            }
            this.setProfileIndexedInstanceVariable_Document(profile, doc);
        }
        return doc;
    }

    protected abstract boolean doMigration(ISystemProfile var1, String var2);

    public void setChanged(ISystemProfile profile) {
        this.dataChanged(profile);
        this.setProfileIndexedInstanceVariable_hasChanged(profile, true);
    }

    public void resetUserData(ISystemProfile profile) {
        if (!this.getProfileIndexedInstanceVariable_hasChanged(profile)) {
            this.setProfileIndexedInstanceVariable_Document(profile, this.loadUserData(profile));
        }
    }

    public void processResourceChangeHit(ISystemProfile profile) {
        this.setProfileIndexedInstanceVariable_Document(profile, null);
        this.dataChanged(profile);
    }

    protected void dataChanged(ISystemProfile profile) {
    }

    protected IPropertySet loadUserData(ISystemProfile profile) {
        this.dataChanged(profile);
        this.setProfileIndexedInstanceVariable_hasChanged(profile, false);
        String osType = this._udas.getOSType();
        String udaRootPropertySetName = "UserActoins." + osType + "." + this.getDocumentRootTagName();
        IPropertySet udaRootPropertySet = profile.getPropertySet(udaRootPropertySetName);
        udaRootPropertySet = udaRootPropertySet == null ? (profile.isDefaultPrivate() ? this.createAndPrimeDocument(profile) : profile.createPropertySet(udaRootPropertySetName)) : this.loadAndParseXMLFile(profile);
        return udaRootPropertySet;
    }

    protected IPropertySet createAndPrimeDocument(ISystemProfile profile) {
        SystemXMLElementWrapper[] primedElements = this.primeDocument(profile);
        if (primedElements != null) {
            int idx = 0;
            while (idx < primedElements.length) {
                SystemXMLElementWrapper newElement = primedElements[idx];
                newElement.setIBM(true);
                newElement.setUserChanged(true);
                ++idx;
            }
        }
        this.saveUserData(profile);
        String osType = this._udas.getOSType();
        String udaRootPropertySetName = "UserActoins." + osType + "." + this.getDocumentRootTagName();
        IPropertySet userDefinedActionPropertySet = profile.getPropertySet(udaRootPropertySetName);
        return userDefinedActionPropertySet;
    }

    public void saveUserData(ISystemProfile profile) {
        if (!this.getProfileIndexedInstanceVariable_hasChanged(profile)) {
            return;
        }
        profile.commit();
        this.ignoreMyResourceChange = false;
        SystemResourceManager.turnOnResourceEventListening();
    }

    public boolean moveElementDown(SystemXMLElementWrapper elementWrapper) {
        this.getDocument(elementWrapper.getProfile());
        IPropertySet element = elementWrapper.getElement();
        IPropertySetContainer parentElement = element.getContainer();
        IPropertySet[] allChildren = parentElement.getPropertySets();
        int i = 0;
        while (i < allChildren.length) {
            if (allChildren[i] == element && i < allChildren.length - 1) {
                allChildren[i] = allChildren[i + 1];
                allChildren[i + 1] = element;
            }
            ++i;
        }
        this.saveUserData(elementWrapper.getProfile());
        return true;
    }

    public boolean moveElementUp(SystemXMLElementWrapper elementWrapper) {
        this.getDocument(elementWrapper.getProfile());
        IPropertySet element = elementWrapper.getElement();
        IPropertySetContainer parentElement = element.getContainer();
        IPropertySet[] allChildren = parentElement.getPropertySets();
        int i = 0;
        while (i < allChildren.length) {
            if (allChildren[i] == element && i > 0) {
                allChildren[i] = allChildren[i - 1];
                allChildren[i - 1] = element;
            }
            ++i;
        }
        this.saveUserData(elementWrapper.getProfile());
        return true;
    }

    public boolean enablePaste(SystemXMLElementWrapper selectedElementWrapper, String id) {
        if (id == null) {
            return false;
        }
        int selectedElementDomain = selectedElementWrapper.getDomain();
        return id.equals(this.currentNodeCloneID) && selectedElementDomain == this.currentNodeCloneDomain;
    }

    public SystemXMLElementWrapper pasteClipboardCopy(SystemXMLElementWrapper selectedElementWrapper, String id) {
        this.getDocument(selectedElementWrapper.getProfile());
        IPropertySet selectedElement = selectedElementWrapper.getElement();
        SystemXMLElementWrapper pastedElementWrapper = null;
        try {
            IPropertySet parentElement = null;
            IPropertySet pastedElement = null;
            if (selectedElementWrapper.isDomain()) {
                parentElement = selectedElement;
                parentElement.addPropertySet(this.currentNodeClone);
                pastedElement = this.currentNodeClone;
            } else {
                parentElement = selectedElement.getContainer();
                parentElement.addPropertySet(this.currentNodeClone);
                pastedElement = this.currentNodeClone;
            }
            pastedElementWrapper = this.createElementWrapper(pastedElement, selectedElementWrapper.getProfile(), selectedElementWrapper.getDomain());
            pastedElementWrapper.setName(this.getUniqueCloneName(pastedElementWrapper));
            pastedElementWrapper.setIBM(false);
        }
        catch (Exception exc) {
            SystemBasePlugin.logError((String)"Error pasting user action/type", (Throwable)exc);
            return null;
        }
        this.saveUserData(selectedElementWrapper.getProfile());
        return pastedElementWrapper;
    }

    private String getUniqueCloneName(SystemXMLElementWrapper elementWrapper) {
        String newName = SystemUDAResources.RESID_UDA_COPY_NAME_1;
        newName = SystemMessage.sub((String)newName, (String)"%1", (String)elementWrapper.getName());
        Vector existingNames = this.getExistingNames(elementWrapper.getProfile(), elementWrapper.getDomain());
        boolean nameInUse = existingNames.indexOf(newName) >= 0;
        int nbr = 2;
        while (nameInUse) {
            newName = SystemUDAResources.RESID_UDA_COPY_NAME_N;
            newName = SystemMessage.sub((String)newName, (String)"%1", (String)elementWrapper.getName());
            nameInUse = existingNames.indexOf(newName = SystemMessage.sub((String)newName, (String)"%2", (String)Integer.toString(nbr))) >= 0;
            ++nbr;
        }
        return newName;
    }

    public Object[] getElements(Object element) {
        if (!this.supportsProfiles()) {
            return this.getElements((ISystemProfile)null, element);
        }
        ISystemProfile currProfile = this.getCurrentProfile();
        if (currProfile != null) {
            return this.getElements(currProfile, element);
        }
        return this.getElements(this.getActiveSystemProfiles(), element);
    }

    public Object[] getElements(ISystemProfile profile, Object element) {
        return this.getElements(new ISystemProfile[]{profile}, element);
    }

    public Object[] getElements(ISystemProfile[] profiles, Object input) {
        if (input != null && !(input instanceof String)) {
            return EMPTY_ARRAY;
        }
        Vector v = new Vector();
        int onlyDomain = this.getActionSubSystem().getSingleDomain(this);
        if (this.getActionSubSystem().supportsDomains() && onlyDomain == -1) {
            v.add(SystemUDTreeViewNewItem.getRootNewItem(this.isUserActionsManager(), this.getNewNodeLabel()));
            if (this.supportsProfiles()) {
                int idx = 0;
                while (idx < profiles.length) {
                    ISystemProfile profile = profiles[idx];
                    v = this.createExistingDomainElementWrappers(v, profile);
                    ++idx;
                }
            } else {
                v = this.createExistingDomainElementWrappers(v, null);
            }
        } else {
            IPropertySet parentDomainElement = null;
            if (onlyDomain == -1) {
                v.add(SystemUDTreeViewNewItem.getOnlyNewItem(this.isUserActionsManager(), this.getNewNodeLabel()));
            } else {
                v.add(SystemUDTreeViewNewItem.getOnlyNewItem(onlyDomain, this.isUserActionsManager(), this.getNewNodeLabel()));
            }
            if (this.supportsProfiles()) {
                int idx = 0;
                while (idx < profiles.length) {
                    ISystemProfile profile = profiles[idx];
                    if (onlyDomain != -1) {
                        parentDomainElement = this.findDomainElement(this.getDocument(profile), onlyDomain);
                    }
                    v = this.getXMLWrappers(v, parentDomainElement, profile);
                    ++idx;
                }
            } else {
                if (onlyDomain != -1) {
                    parentDomainElement = this.findDomainElement(this.getDocument(null), onlyDomain);
                }
                v = this.getXMLWrappers(v, parentDomainElement, null);
            }
        }
        return v.toArray();
    }

    protected String getNewNodeLabel() {
        return SystemUDAResources.ACTION_CASCADING_NEW_LABEL;
    }

    protected abstract boolean isUserActionsManager();

    public Object[] getChildren(Object element) {
        if (element instanceof SystemUDTreeViewNewItem) {
            if (!((SystemUDTreeViewNewItem)element).isExecutable()) {
                boolean isUserActionDialog = ((SystemUDTreeViewNewItem)element).isWorkWithActionsDialog();
                if (this.newItemsPerDomain == null) {
                    int nbrDomains = this.getActionSubSystem().getMaximumDomain() + 1;
                    this.newItemsPerDomain = new SystemUDTreeViewNewItem[nbrDomains];
                    int idx = 0;
                    while (idx < this.newItemsPerDomain.length) {
                        this.newItemsPerDomain[idx] = isUserActionDialog ? new SystemUDTreeViewNewItem(true, this.getActionSubSystem().mapDomainXlatedNewName(idx), idx, isUserActionDialog) : new SystemUDTreeViewNewItem(true, this.getActionSubSystem().mapDomainXlatedNewTypeName(idx), idx, isUserActionDialog);
                        ++idx;
                    }
                }
                return this.newItemsPerDomain;
            }
            return EMPTY_ARRAY;
        }
        if (!(element instanceof SystemXMLElementWrapper) || !((SystemXMLElementWrapper)element).isDomain()) {
            return EMPTY_ARRAY;
        }
        SystemXMLElementWrapper parent = (SystemXMLElementWrapper)element;
        Vector v = new Vector();
        ISystemProfile profile = parent.getProfile();
        this.getXMLWrappers(v, parent, profile);
        return v.toArray();
    }

    public IPropertySet findChildByName(ISystemProfile profile, String name, int domain) {
        IPropertySet xdoc = this.getDocument(profile);
        if (this.getActionSubSystem().supportsDomains() && domain >= 0) {
            IPropertySet domainElement = this.findDomainElement(xdoc, domain);
            return SystemXMLElementWrapper.findChildByName(domainElement, xdoc, this.getTagName(), name);
        }
        return SystemXMLElementWrapper.findChildByName(null, xdoc, this.getTagName(), name);
    }

    public SystemXMLElementWrapper findByName(ISystemProfile profile, String name, int domain) {
        IPropertySet element = this.findChildByName(profile, name, domain);
        if (element == null) {
            return null;
        }
        return this.createElementWrapper(element, profile, domain);
    }

    public Vector getExistingNames(ISystemProfile profile, int domain) {
        IPropertySet xdoc = this.getDocument(profile);
        if (this.getActionSubSystem().supportsDomains() && domain >= 0) {
            IPropertySet domainElement = this.findDomainElement(xdoc, domain);
            if (domainElement == null) {
                return new Vector();
            }
            return SystemXMLElementWrapper.getExistingNames(domainElement, xdoc, this.getTagName());
        }
        return SystemXMLElementWrapper.getExistingNames(null, xdoc, this.getTagName());
    }

    public SystemXMLElementWrapper addElement(ISystemProfile profile, int domain, String name) {
        String osType = this._udas.getOSType();
        String udaRootPropertySetName = "UserActoins." + osType + "." + this.getDocumentRootTagName();
        IPropertySet udaRootPropertySet = profile.getPropertySet(udaRootPropertySetName);
        if (udaRootPropertySet == null) {
            udaRootPropertySet = profile.createPropertySet(udaRootPropertySetName);
            udaRootPropertySet.addProperty("name", "User Action File Types");
            udaRootPropertySet.addProperty("release", CURRENT_RELEASE_NAME);
            udaRootPropertySet.addProperty("uda_root", this.getDocumentRootTagName());
        }
        IPropertySet child = null;
        if (this.getActionSubSystem().supportsDomains()) {
            IPropertySet se = this.findOrCreateDomainElement(udaRootPropertySet, domain);
            child = se.createPropertySet(name);
        } else {
            child = udaRootPropertySet.createPropertySet(name);
        }
        child.addProperty("name", this.uppercaseName() ? name.toUpperCase() : name);
        child.addProperty("type", this.getTagName());
        SystemXMLElementWrapper newElementWrapper = null;
        newElementWrapper = this.createElementWrapper(child, profile, domain);
        this.setChanged(profile);
        return newElementWrapper;
    }

    public void delete(ISystemProfile profile, SystemXMLElementWrapper elementWrapper) {
        elementWrapper.deleteElement();
        this.setChanged(profile);
    }

    private void setProfileIndexedInstanceVariable_Document(ISystemProfile profile, IPropertySet doc) {
        if (!this.supportsProfiles()) {
            this.udocNoProfile = doc;
        } else {
            this.udocsByProfile.put(profile, doc);
        }
    }

    private IPropertySet getProfileIndexedInstanceVariable_Document(ISystemProfile profile) {
        if (!this.supportsProfiles()) {
            return this.udocNoProfile;
        }
        return (IPropertySet)this.udocsByProfile.get(profile);
    }

    private void setProfileIndexedInstanceVariable_hasChanged(ISystemProfile profile, boolean hasChanged) {
        if (!this.supportsProfiles()) {
            this.hasChangedNoProfile = hasChanged;
        } else if (hasChanged) {
            this.hasChangedByProfile.put(profile, Boolean.TRUE);
        } else {
            this.hasChangedByProfile.put(profile, Boolean.FALSE);
        }
    }

    private boolean getProfileIndexedInstanceVariable_hasChanged(ISystemProfile profile) {
        if (!this.supportsProfiles()) {
            return this.hasChangedNoProfile;
        }
        Boolean b = (Boolean)this.hasChangedByProfile.get(profile);
        if (b == null) {
            return false;
        }
        return b == Boolean.TRUE;
    }

    private Object[] getProfileIndexedInstanceVariable_dirPath(ISystemProfile profile) {
        if (!this.supportsProfiles()) {
            return this.dirPathNoProfile;
        }
        return (Object[])this.dirPathByProfile.get(profile);
    }

    protected SystemXMLElementWrapper getDomainWrapper(ISystemProfile profile, int domain) {
        IPropertySet udaRootPropertySet = this.getDocument(profile);
        if (udaRootPropertySet == null) {
            return null;
        }
        IPropertySet element = this.findDomainElement(this.getDocument(profile), domain);
        if (element != null) {
            return this.createDomainElementWrapper(element, profile, domain);
        }
        return null;
    }

    protected Vector createExistingDomainElementWrappers(Vector v, ISystemProfile profile) {
        IPropertySet xdoc = this.getDocument(profile);
        IPropertySet[] subList = xdoc.getPropertySets();
        if (subList == null || subList.length == 0) {
            return v;
        }
        String[] domains = this.getActionSubSystem().getDomainNames();
        int subListLen = subList.length;
        int idx = 0;
        while (idx < domains.length) {
            IPropertySet match = null;
            int jdx = 0;
            while (match == null && jdx < subListLen) {
                IPropertySet currNode = subList[jdx];
                if (SystemUDBaseManager.isDomainElement(currNode, domains[idx])) {
                    match = currNode;
                }
                ++jdx;
            }
            if (match != null) {
                v.add(this.createDomainElementWrapper(match, profile, idx));
            }
            ++idx;
        }
        return v;
    }

    protected SystemXMLElementWrapper createDomainElementWrapper(IPropertySet xmlDomainElementToWrap, ISystemProfile profile, int domain) {
        return this.createElementWrapper(xmlDomainElementToWrap, profile, domain);
    }

    protected IPropertySet findDomainElement(IPropertySet xdoc, int domain) {
        return this.findOrCreateDomainElement(xdoc, domain, false);
    }

    protected IPropertySet findOrCreateDomainElement(IPropertySet xdoc, int domain) {
        return this.findOrCreateDomainElement(xdoc, domain, true);
    }

    protected IPropertySet findOrCreateDomainElement(IPropertySet xdoc, int domain, boolean create) {
        IPropertySet[] domainSets = xdoc.getPropertySets();
        String domainName = this.getActionSubSystem().mapDomainName(domain);
        IPropertySet domainElement = null;
        int i = 0;
        while (i < domainSets.length) {
            IPropertySet thisDomain = domainSets[i];
            if (thisDomain != null && SystemUDBaseManager.isDomainElement(thisDomain, domainName)) {
                domainElement = thisDomain;
            }
            ++i;
        }
        if (create && domainElement == null) {
            domainElement = this.createDomainElement(xdoc, domain);
        }
        return domainElement;
    }

    protected IPropertySet createDomainElement(IPropertySet xdoc, int domain) {
        IPropertySet element = xdoc.createPropertySet(this.getActionSubSystem().mapDomainXlatedName(domain));
        element.addProperty("DomainType", this.getActionSubSystem().mapDomainName(domain));
        element.addProperty("name", this.getActionSubSystem().mapDomainXlatedName(domain));
        element.addProperty("type", "Domain");
        return element;
    }

    public static boolean isDomainElement(IPropertySet element) {
        return element.getPropertyValue("type").equals("Domain");
    }

    public static boolean isDomainElement(IPropertySet element, String domainName) {
        return SystemUDBaseManager.isDomainElement(element) && SystemUDBaseManager.domainTypeEquals(element, domainName);
    }

    public static boolean domainTypeEquals(IPropertySet element, String domainName) {
        return element.getPropertyValue("DomainType").equals(domainName);
    }

    public static boolean inCurrentTree(IPropertySet n) {
        String udaRootType = n.getPropertyValue("uda_root");
        if (udaRootType != null && (udaRootType.equals("Actions") || udaRootType.equals("FileTypes"))) {
            return true;
        }
        IPropertySetContainer parent = n.getContainer();
        if (parent == null) {
            return false;
        }
        if (parent instanceof IPropertySet) {
            if (!SystemUDBaseManager.inCurrentTree((IPropertySet)parent)) {
                return false;
            }
        } else {
            return false;
        }
        IPropertySet[] siblings = parent.getPropertySets();
        int i = 0;
        while (i < siblings.length) {
            if (n == siblings[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

