/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.local;

import java.io.OutputStream;
import org.eclipse.cdt.utils.Platform;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tm.internal.terminal.local.ILocalTerminalSettings;
import org.eclipse.tm.internal.terminal.local.LocalTerminalMessages;
import org.eclipse.tm.internal.terminal.local.LocalTerminalOutputListener;
import org.eclipse.tm.internal.terminal.local.LocalTerminalOutputStream;
import org.eclipse.tm.internal.terminal.local.LocalTerminalSettings;
import org.eclipse.tm.internal.terminal.local.LocalTerminalSettingsPage;
import org.eclipse.tm.internal.terminal.local.LocalTerminalUtilities;
import org.eclipse.tm.internal.terminal.local.process.LocalTerminalProcess;
import org.eclipse.tm.internal.terminal.local.process.LocalTerminalProcessRegistry;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsPage;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.Logger;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.tm.internal.terminal.provisional.api.provider.TerminalConnectorImpl;

public class LocalTerminalConnector
extends TerminalConnectorImpl
implements IDebugEventSetListener {
    private static final String ATTR_CAPTURE_IN_CONSOLE = "org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON";
    private static final String ATTR_CAPTURE_OUTPUT = "org.eclipse.debug.core.capture_output";
    private static final String ATTR_PROCESS_FACTORY_ID = "process_factory_id";
    private LocalTerminalOutputStream terminalToLocalProcessStream;
    private LocalTerminalOutputListener outputListener;
    private LocalTerminalOutputListener errorListener;
    private ILocalTerminalSettings settings = new LocalTerminalSettings();
    private IStreamMonitor outputMonitor;
    private IStreamMonitor errorMonitor;
    private LocalTerminalProcess process;
    private ILaunch launch;
    private int lastHeight;
    private int lastWidth;

    public void initialize() throws Exception {
        super.initialize();
        if (!PTY.isSupported()) {
            String OS = Platform.getOS();
            String ARCH = Platform.getOSArch();
            String message = NLS.bind((String)LocalTerminalMessages.errorNoPTYSupport, (Object)OS, (Object)ARCH);
            Status status = new Status(2, "org.eclipse.tm.terminal.local", message);
            throw new CoreException((IStatus)status);
        }
    }

    public void load(ISettingsStore store) {
        this.settings.load(store);
    }

    public void save(ISettingsStore store) {
        this.settings.save(store);
    }

    public ISettingsPage makeSettingsPage() {
        return new LocalTerminalSettingsPage(this.settings);
    }

    public String getSettingsSummary() {
        return this.settings.getLaunchConfigurationName();
    }

    public boolean isLocalEcho() {
        return LocalTerminalUtilities.getLocalEcho(this.settings);
    }

    public OutputStream getTerminalToRemoteStream() {
        return this.terminalToLocalProcessStream;
    }

    public void connect(ITerminalControl control) {
        super.connect(control);
        control.setState(TerminalState.CONNECTING);
        ILaunchConfigurationWorkingCopy workingCopy = null;
        ILaunchConfiguration configuration = null;
        String configurationName = null;
        try {
            configurationName = this.settings.getLaunchConfigurationName();
            configuration = LocalTerminalUtilities.findLaunchConfiguration(configurationName);
        }
        catch (CoreException coreException) {
            Shell shell = Display.getDefault().getActiveShell();
            String title = LocalTerminalMessages.errorTitleCouldNotConnectToTerminal;
            String text = LocalTerminalMessages.errorLaunchConfigurationNoLongerExists;
            String message = NLS.bind((String)text, (Object)configurationName);
            Status status = new Status(4, "org.eclipse.tm.terminal.local", message);
            ErrorDialog.openError((Shell)shell, (String)title, null, (IStatus)status);
            control.setState(TerminalState.CLOSED);
            return;
        }
        try {
            String oldFactoryID = configuration.getAttribute(ATTR_PROCESS_FACTORY_ID, null);
            workingCopy = configuration.getWorkingCopy();
            workingCopy.setAttribute(ATTR_CAPTURE_OUTPUT, true);
            workingCopy.setAttribute(ATTR_CAPTURE_IN_CONSOLE, true);
            workingCopy.setAttribute(ATTR_PROCESS_FACTORY_ID, "org.eclipse.tm.terminal.localProcess.factory");
            configuration = workingCopy.doSave();
            try {
                this.launch = configuration.launch("run", null);
            }
            finally {
                workingCopy = configuration.getWorkingCopy();
                workingCopy.setAttribute(ATTR_PROCESS_FACTORY_ID, oldFactoryID);
                workingCopy.doSave();
            }
            this.process = LocalTerminalProcessRegistry.getFromLaunch(this.launch);
            IStreamsProxy streamsProxy = this.process.getStreamsProxy();
            this.terminalToLocalProcessStream = new LocalTerminalOutputStream((IProcess)this.process, this.settings);
            this.outputMonitor = streamsProxy.getOutputStreamMonitor();
            this.outputListener = new LocalTerminalOutputListener(control, this.settings);
            this.outputMonitor.addListener((IStreamListener)this.outputListener);
            this.outputListener.streamAppended(this.outputMonitor.getContents(), this.outputMonitor);
            this.errorMonitor = streamsProxy.getErrorStreamMonitor();
            this.errorListener = new LocalTerminalOutputListener(control, this.settings);
            this.errorMonitor.addListener((IStreamListener)this.errorListener);
            this.errorListener.streamAppended(this.errorMonitor.getContents(), this.errorMonitor);
            DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
            control.setState(TerminalState.CONNECTED);
        }
        catch (CoreException exception) {
            control.setState(TerminalState.CLOSED);
            Shell shell = LocalTerminalSettingsPage.getShell();
            ErrorDialog.openError((Shell)shell, null, null, (IStatus)exception.getStatus());
            Logger.logException((Exception)((Object)exception));
        }
    }

    public void doDisconnect() {
        try {
            this.removeAllListeners();
            LocalTerminalProcessRegistry.addProcessBackToFinishedLaunch(this.launch);
            if (this.launch != null && this.launch.canTerminate()) {
                this.launch.terminate();
            }
        }
        catch (DebugException couldNotTerminate) {
            Logger.logException((Exception)((Object)couldNotTerminate));
        }
    }

    public void setTerminalSize(int width, int height) {
        PTY pty = this.process.getPTY();
        if (pty != null && (width != this.lastWidth || height != this.lastHeight)) {
            pty.setTerminalSize(width, height);
            this.lastWidth = width;
            this.lastHeight = height;
        }
    }

    public void handleDebugEvents(DebugEvent[] event) {
        int numberOfEvents = event.length;
        int index = 0;
        while (index < numberOfEvents) {
            if (event[index].getSource().equals((Object)this.process) && event[index].getKind() == 8) {
                this.fControl.setState(TerminalState.CLOSED);
                this.removeAllListeners();
                return;
            }
            ++index;
        }
    }

    protected void removeAllListeners() {
        if (this.outputMonitor != null && this.outputListener != null) {
            this.outputMonitor.removeListener((IStreamListener)this.outputListener);
        }
        if (this.errorMonitor != null && this.errorListener != null) {
            this.errorMonitor.removeListener((IStreamListener)this.errorListener);
        }
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
    }
}

