/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.shells.dstore.model;

import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.rse.internal.services.dstore.shell.DStoreShellOutputReader;
import org.eclipse.rse.internal.subsystems.shells.servicesubsystem.OutputRefreshJob;
import org.eclipse.rse.internal.subsystems.shells.subsystems.RemoteError;
import org.eclipse.rse.internal.subsystems.shells.subsystems.RemoteOutput;
import org.eclipse.rse.services.dstore.shells.DStoreHostShell;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IHostShellChangeEvent;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCommandShell;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteOutput;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.ServiceCommandShell;

public class DStoreServiceCommandShell
extends ServiceCommandShell {
    public DStoreServiceCommandShell(IRemoteCmdSubSystem cmdSS, IHostShell hostShell) {
        super(cmdSS, hostShell);
    }

    public Object getContext() {
        DStoreHostShell shell = (DStoreHostShell)this.getHostShell();
        DStoreShellOutputReader reader = (DStoreShellOutputReader)shell.getStandardOutputReader();
        String workingDir = reader.getWorkingDirectory();
        if (workingDir != null && workingDir.length() > 0) {
            try {
                return this.getFileSubSystem().getRemoteFileObject(workingDir);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public void shellOutputChanged(IHostShellChangeEvent event) {
        Object[] lines = event.getLines();
        IRemoteOutput[] outputs = new IRemoteOutput[lines.length];
        int i = 0;
        while (i < lines.length) {
            DataElement line;
            Object output = null;
            Object lineObj = lines[i];
            if (lineObj instanceof DataElement && (line = (DataElement)lineObj) != null) {
                String type = line.getType();
                output = event.isError() ? new RemoteError((Object)this, type) : new RemoteOutput((Object)this, type);
                output.setText(line.getName());
                output.setAbsolutePath(line.getSource());
                this.addOutput(output);
                outputs[i] = output;
            }
            ++i;
        }
        if (this._lastRefreshJob == null || this._lastRefreshJob.isComplete()) {
            this._lastRefreshJob = new OutputRefreshJob((IRemoteCommandShell)this, outputs, false);
            this._lastRefreshJob.schedule();
        }
    }
}

