/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.logging;

import java.util.HashSet;
import java.util.Set;

public class LabelUtil {
    private static final String upperLetters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String lowerLetters = "abcdefghijklmnopqrstuvwxyz";
    private static final char lpar = '(';
    private static final char rpar = ')';
    private static final char trigger = '&';

    public static String assignMnemonic(String label, Set used) {
        Assignment temp;
        Assignment result = null;
        Character c = LabelUtil.findMnemonic(label);
        if (c != null) {
            used.add(c);
            return label;
        }
        result = LabelUtil.assignMnemonic(label, upperLetters, used);
        if (!result.hasMnemonic() && !(result = LabelUtil.assignMnemonic(label, lowerLetters, used)).hasMnemonic() && (temp = LabelUtil.assignMnemonic(upperLetters, upperLetters, used)).hasMnemonic()) {
            c = temp.getMnemonic();
            StringBuffer b = new StringBuffer(label.length() + 4);
            b.append(label);
            b.append('(');
            b.append('&');
            b.append(c);
            b.append(')');
            result = new Assignment(b.toString(), c);
        }
        if (result.hasMnemonic()) {
            Character mnemonic = result.getMnemonic();
            Character lower = new Character(Character.toLowerCase(mnemonic.charValue()));
            Character upper = new Character(Character.toUpperCase(mnemonic.charValue()));
            used.add(lower);
            used.add(upper);
        }
        return result.getLabel();
    }

    public static Set usedFromString(String s) {
        HashSet<Character> result = new HashSet<Character>();
        char[] characters = s.toLowerCase().toCharArray();
        int i = 0;
        while (i < characters.length) {
            result.add(new Character(characters[i]));
            ++i;
        }
        characters = s.toUpperCase().toCharArray();
        i = 0;
        while (i < characters.length) {
            result.add(new Character(characters[i]));
            ++i;
        }
        return result;
    }

    private static Assignment assignMnemonic(String label, String candidates, Set used) {
        char[] characters = label.toCharArray();
        Assignment result = new Assignment(label, null);
        int i = 0;
        while (i < characters.length && !result.hasMnemonic()) {
            Character c = new Character(characters[i]);
            if (!used.contains(c) && candidates.indexOf(c.charValue()) >= 0) {
                StringBuffer b = new StringBuffer(label.length() + 1);
                b.append(label.substring(0, i));
                b.append('&');
                b.append(label.substring(i));
                result = new Assignment(b.toString(), c);
            }
            ++i;
        }
        return result;
    }

    private static Character findMnemonic(String label) {
        Character result = null;
        int i = label.indexOf(38);
        if (i >= 0 && i < label.length() - 1) {
            result = new Character(label.charAt(i + 1));
        }
        return result;
    }

    private static class Assignment {
        private String label;
        private Character mnemonic;

        Assignment(String label, Character mnemonic) {
            this.label = label;
            this.mnemonic = mnemonic;
        }

        String getLabel() {
            return this.label;
        }

        Character getMnemonic() {
            return this.mnemonic;
        }

        boolean hasMnemonic() {
            return this.mnemonic != null;
        }
    }
}

