/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.logging;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class RemoteSystemLogListener
implements ILogListener,
IPropertyChangeListener {
    public static final String Copyright = "(C) Copyright IBM Corp. 2002, 2003.  All Rights Reserved.";
    private PrintWriter log = null;
    private File outputFile = null;
    private boolean log_to_stdout = false;
    private AbstractUIPlugin plugin = null;

    public RemoteSystemLogListener(AbstractUIPlugin plugin) {
        this.plugin = plugin;
        IPath path = plugin.getStateLocation().addTrailingSeparator().append(".log");
        this.outputFile = path.toFile();
        if (this.outputFile != null && this.outputFile.exists()) {
            this.outputFile.delete();
        }
        this.initialize();
    }

    private void initialize() {
        try {
            IPreferenceStore store = this.plugin.getPreferenceStore();
            String log_location = store.getString("log_location");
            if (log_location != null && log_location.equalsIgnoreCase("Log_To_StdOut")) {
                this.doLogToView();
            } else {
                this.doLogToFile();
            }
        }
        catch (Exception e) {
            this.log = null;
            System.err.println("Exception in RemoteSystemLogListener.initialize(): " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void doLogToView() {
        this.freeResources();
        this.log = new PrintWriter(System.out, true);
        this.log_to_stdout = true;
    }

    private void doLogToFile() throws Exception {
        this.freeResources();
        this.log = new PrintWriter((Writer)new BufferedWriter(new FileWriter(this.outputFile.toString(), true)), true);
        this.log_to_stdout = false;
    }

    public void logging(IStatus status) {
        if (this.log == null) {
            return;
        }
        String date = new Date().toString();
        this.log.println(date);
        int severity = status.getSeverity();
        if (severity == 4) {
            this.log.print("ERROR");
        } else if (severity == 2) {
            this.log.print("WARNING");
        } else if (severity == 1) {
            this.log.print("INFO");
        } else if (severity == 0) {
            this.log.print("DEBUG");
        }
        this.log.print(" ");
        this.log.print(status.getPlugin());
        this.log.print("  ");
        this.log.println(status.getMessage());
        if (status.getException() != null) {
            status.getException().printStackTrace(this.log);
        }
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                this.loggingChild(children[i]);
                ++i;
            }
        }
        this.log.println("--------------------------------------------");
    }

    public void logging(IStatus status, String plugin) {
        this.logging(status);
    }

    private void loggingChild(IStatus status) {
        if (this.log == null) {
            return;
        }
        status.getSeverity();
        this.log.print("\t\t");
        this.log.println(status.getMessage());
        if (status.getException() != null) {
            status.getException().printStackTrace(this.log);
        }
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                this.logging(children[i]);
                ++i;
            }
        }
    }

    public synchronized void propertyChange(PropertyChangeEvent event) {
        this.initialize();
    }

    public void freeResources() {
        if (this.log == null) {
            return;
        }
        if (this.log_to_stdout) {
            return;
        }
        this.log.flush();
        this.log.close();
        this.log = null;
    }
}

