/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.logging;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.rse.internal.logging.RemoteSystemLogListener;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;

public class Logger
implements IPropertyChangeListener {
    public static final String Copyright = "(C) Copyright IBM Corp. 2002, 2003.  All Rights Reserved.";
    public static final boolean DEBUG = false;
    private ILog systemsPluginLog = null;
    private RemoteSystemLogListener logListener = null;
    private String pluginId = null;
    AbstractUIPlugin systemPlugin = null;
    private int debug_level = 0;
    private boolean init_ok = true;

    protected Logger(AbstractUIPlugin systemPlugin) {
        this.systemPlugin = systemPlugin;
        this.pluginId = systemPlugin.getBundle().getSymbolicName();
        this.initialize();
    }

    private void initialize() {
        try {
            this.systemsPluginLog = this.systemPlugin.getLog();
            if (this.logListener == null) {
                this.logListener = new RemoteSystemLogListener(this.systemPlugin);
            }
            this.systemsPluginLog.addLogListener((ILogListener)this.logListener);
            IPreferenceStore store = this.systemPlugin.getPreferenceStore();
            this.debug_level = store.getInt("debug_level");
            this.systemPlugin.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
            this.systemPlugin.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.logListener);
        }
        catch (Exception e) {
            Bundle bundle = Platform.getBundle((String)"org.eclipse.core.runtime");
            Platform.getLog((Bundle)bundle).log((IStatus)new Status(4, "org.eclipse.rse.logging", 0, "could not create Logger for " + this.pluginId, (Throwable)e));
            this.init_ok = false;
        }
    }

    public synchronized void logDebugMessage(String className, String message) {
        if (this.init_ok && this.debug_level >= 3) {
            MultiStatus debugStatus = new MultiStatus(this.pluginId, 0, className, null);
            Status infoStatus = new Status(0, this.pluginId, 0, message, null);
            debugStatus.add((IStatus)infoStatus);
            this.systemsPluginLog.log((IStatus)debugStatus);
        }
    }

    public synchronized void logError(String message, Throwable ex) {
        if (this.init_ok && this.debug_level >= 0) {
            if (message == null) {
                message = "";
            }
            Status errorStatus = new Status(4, this.pluginId, 0, message, ex);
            this.systemsPluginLog.log((IStatus)errorStatus);
        }
    }

    public synchronized void logInfo(String message) {
        this.logInfo(message, null);
    }

    public synchronized void logInfo(String message, Throwable ex) {
        if (this.init_ok && this.debug_level >= 2) {
            if (message == null) {
                message = "";
            }
            Status infoStatus = new Status(1, this.pluginId, 0, message, ex);
            this.systemsPluginLog.log((IStatus)infoStatus);
        }
    }

    public synchronized void logWarning(String message) {
        this.logWarning(message, null);
    }

    public synchronized void logWarning(String message, Throwable ex) {
        if (this.init_ok && this.debug_level >= 1) {
            if (message == null) {
                message = "";
            }
            Status warningStatus = new Status(2, this.pluginId, 0, message, ex);
            this.systemsPluginLog.log((IStatus)warningStatus);
        }
    }

    public synchronized void setDebugLevel(int level) {
        this.debug_level = level;
    }

    public synchronized int getDebugLevel() {
        return this.debug_level;
    }

    public synchronized void freeResources() {
        this.logListener.freeResources();
    }

    public synchronized void propertyChange(PropertyChangeEvent event) {
        this.debug_level = this.systemPlugin.getPreferenceStore().getInt("debug_level");
    }
}

