/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.logging;

import java.net.URL;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.logging.Logger;
import org.eclipse.rse.logging.LoggerFactory;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class RemoteSystemsLoggingPlugin
extends AbstractUIPlugin {
    private static RemoteSystemsLoggingPlugin inst;
    private ResourceBundle resourceBundle;
    public static Logger out;

    static {
        out = null;
    }

    public RemoteSystemsLoggingPlugin() {
        if (inst == null) {
            inst = this;
        }
    }

    public static RemoteSystemsLoggingPlugin getDefault() {
        return inst;
    }

    public static String getResourceString(String key) {
        try {
            ResourceBundle bundle = RemoteSystemsLoggingPlugin.getDefault().getResourceBundle();
            return bundle.getString(key);
        }
        catch (Exception e) {
            out.logError("could not get resource string for: " + key, e);
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        if (this.resourceBundle == null) {
            try {
                Path path = new Path("$nl$/RemoteSystemsLogging.properties");
                URL url = Platform.find((Bundle)this.getBundle(), (IPath)path);
                this.resourceBundle = new PropertyResourceBundle(url.openStream());
            }
            catch (Exception exception) {
                this.resourceBundle = null;
                out.logInfo("RemoteSystemsLoggingPlugin - unable to log resourcebundle");
            }
        }
        return this.resourceBundle;
    }

    public void initializeDefaultPreferences() {
        this.getPreferenceStore().setDefault("debug_level", 0);
        this.getPreferenceStore().setDefault("log_location", "Log_To_File");
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        out = LoggerFactory.getInst(this);
        out.logInfo("loading RemoteSystemsLoggingPlugin class.");
    }

    public void stop(BundleContext context) throws Exception {
        LoggerFactory.freeInst(this);
        super.stop(context);
    }
}

