/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.logging.performance;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PerformanceLogger {
    public static final boolean _ENABLE_PERFORMANCE_LOGGING_IBM_INTERNAL_ = false;
    public static final int OPTION_GET_ALL = 1;
    public static final int OPTION_GET_FEATURE = 2;
    public static final int OPTION_GET_VERSION = 3;
    static final String ELEMENT_TASK = "Task";
    static final String ATTRIBUTE_NAME_TASKID = "CallerID";
    static final String DEFAULT_COMPONENT = "_PERFORMANCELOGGER_";
    static boolean ENABLE_PERFORMANCE_LOGGING = false;
    static long samplingTime = -1L;
    static boolean _initialized = false;
    static HashMap perfLogRegistry = new HashMap();

    private PerformanceLogger() {
        this.init();
    }

    public static void enablePerformanceLogging(boolean enable) {
        ENABLE_PERFORMANCE_LOGGING = enable;
    }

    public static boolean isPerformanceLoggingEnabled() {
        return ENABLE_PERFORMANCE_LOGGING;
    }

    public static String register(String comp_id) {
        return PerformanceLogger.register(comp_id, "", "");
    }

    public static String register(String feature, String version) {
        return PerformanceLogger.register(DEFAULT_COMPONENT, feature, version);
    }

    public static String register(String comp_id, String feature, String version) {
        if (comp_id == null || comp_id.length() == 0) {
            System.out.println("PerformanceLogger:register(): Cannot register null component id.");
            return comp_id;
        }
        if (perfLogRegistry.containsKey(comp_id)) {
            System.out.println("PerformanceLogger:register(): component \"" + comp_id + "\" already registered");
            return comp_id;
        }
        PerformanceLogger performanceLogger = new PerformanceLogger();
        performanceLogger.getClass();
        ComponentData compData = performanceLogger.new ComponentData(comp_id);
        Calendar time = Calendar.getInstance();
        compData.timeStamp = time.getTime().toString();
        String userID = System.getProperty("user.name");
        compData.XMLFileID = String.valueOf(comp_id) + "_" + userID + "_" + feature.replace(' ', '_') + "_" + version.replace(' ', '_') + "_perf." + compData.timeStamp.replace(' ', '_').replace(':', '_') + ".xml";
        compData.XMLFile = new File(compData.XMLFileID);
        compData.feature = feature;
        compData.version = version;
        PerformanceLogger.generateXMLFile(compData);
        compData.taskStack = new Stack();
        perfLogRegistry.put(comp_id, compData);
        _initialized = true;
        System.out.println("SystemPerformanceLogger: XML file created is \"" + compData.XMLFile.getAbsolutePath() + "\".");
        return comp_id;
    }

    public static void deRegister() {
        perfLogRegistry.remove(DEFAULT_COMPONENT);
        System.out.println("SystemPerformanceLogger: default component de-registered");
    }

    public static void deRegister(String key) {
        perfLogRegistry.remove(key);
        System.out.println("SystemPerformanceLogger: component \"" + key + "\" de-registered");
    }

    private void init() {
        if (samplingTime == -1L) {
            long startTime = System.currentTimeMillis();
            Double q = null;
            int i = 0;
            int n = 1000000;
            i = 0;
            while (i < n) {
                Double dd = new Double(n);
                Double dr = new Double(n + i);
                q = new Double(dd / dr);
                ++i;
            }
            double cfr_ignored_0 = q / (double)i;
            long stopTime = System.currentTimeMillis();
            samplingTime = stopTime - startTime;
            System.out.println("SystemPerformanceLogger::Normalization Elapsed time = " + samplingTime);
        }
    }

    public static long start() {
        if (!_initialized) {
            PerformanceLogger.register(DEFAULT_COMPONENT, "", "");
        }
        String methodPath = PerformanceLogger.getMethodName(true);
        return PerformanceLogger.start(DEFAULT_COMPONENT, methodPath);
    }

    public static long start(String comp_id) {
        String methodPath = PerformanceLogger.getMethodName(true);
        return PerformanceLogger.start(comp_id, methodPath);
    }

    public static long start(String comp_id, String call_id) {
        if (!perfLogRegistry.containsKey(comp_id)) {
            System.out.println("PerformanceLogger:start(): component \"" + comp_id + "\" not registered");
            return -1L;
        }
        ComponentData cd = (ComponentData)perfLogRegistry.get(comp_id);
        StartData td = new StartData();
        td.userID = call_id;
        td.startThread = Thread.currentThread().toString();
        td.startMethod = PerformanceLogger.getMethodName(false);
        try {
            Element root = cd.doc.getDocumentElement();
            Element task = cd.doc.createElement(ELEMENT_TASK);
            task.setAttribute(ATTRIBUTE_NAME_TASKID, td.userID);
            task.setAttribute("StartAt", td.startMethod);
            task.setAttribute("StartThread", td.startThread);
            td.node = task;
            if (cd.taskStack.isEmpty()) {
                root.appendChild(task);
            } else {
                StartData sd = (StartData)cd.taskStack.peek();
                sd.node.appendChild(task);
            }
        }
        catch (DOMException e) {
            System.out.println("PerformanceLogger::updateXMLFileatStart DOM Error:" + e.toString());
        }
        td.startTime = System.currentTimeMillis();
        cd.taskStack.push(td);
        return td.startTime;
    }

    public static long stop() {
        return PerformanceLogger.stop(DEFAULT_COMPONENT);
    }

    public static long stop(String comp_id) {
        long st = System.currentTimeMillis();
        ComponentData cd = (ComponentData)perfLogRegistry.get(comp_id);
        if (cd == null) {
            System.out.println("SystemPerformanceLogger::stop(): invalid registration key");
            return 0L;
        }
        StartData td = null;
        try {
            td = (StartData)cd.taskStack.pop();
            td.stopTime = st;
            td.stopThread = Thread.currentThread().toString();
            td.stopMethod = PerformanceLogger.getMethodName(false);
            PerformanceLogger.updateXMLFileAtStop(cd, td);
        }
        catch (EmptyStackException e) {
            System.out.println("SystemPerformanceLogger:: Probably too many stop() function calls. - " + e);
        }
        return td.stopTime;
    }

    private static void generateXMLFile(ComponentData cd) {
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(cd.XMLFile), "UTF8"));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = null;
            try {
                builder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {}
            DOMImplementation impl = builder.getDOMImplementation();
            cd.doc = impl.createDocument(null, "Benchmark", null);
            Element root = cd.doc.getDocumentElement();
            root.setAttribute("BenchmarkID", cd.XMLFileID);
            root.setAttribute("TimeStamp", cd.timeStamp);
            Element system = cd.doc.createElement("System");
            Element product = cd.doc.createElement("Product");
            product.setAttribute("Feature", cd.feature);
            product.setAttribute("Version", cd.version);
            root.appendChild(product);
            system.setAttribute("OSName", System.getProperty("os.name"));
            system.setAttribute("OSVersion", System.getProperty("os.version"));
            system.setAttribute("JavaVersion", System.getProperty("java.version"));
            system.setAttribute("JavaVMVersion", System.getProperty("java.vm.version"));
            system.setAttribute("JavaClassPath", System.getProperty("java.class.path"));
            system.setAttribute("JavaLibraryPath", System.getProperty("java.library.path"));
            root.appendChild(system);
            Element norm = cd.doc.createElement("_NORMALIZATION_VALUES");
            Long ems = new Long(samplingTime);
            norm.setAttribute("ElapsedTime", ems.toString());
            root.appendChild(norm);
            Comment cmt1 = cd.doc.createComment("Each Task element represents one start/stop timer operation");
            Comment cmt2 = cd.doc.createComment("Time recorded is in milliseconds");
            Comment cmt3 = cd.doc.createComment("NormalizedFactor is the performance indicator. A larger value than the previous run might indicate performance degradation.");
            root.appendChild(cmt1);
            root.appendChild(cmt2);
            root.appendChild(cmt3);
            try {
                DOMSource source = new DOMSource(cd.doc);
                StreamResult result = new StreamResult(writer);
                Transformer t = TransformerFactory.newInstance().newTransformer();
                t.setOutputProperty("indent", "yes");
                t.transform(source, result);
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
            }
            catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            }
            catch (TransformerException transformerException) {}
        }
        catch (IOException e) {
            System.out.println("PerformanceLogger::updateXML IO Error:" + e.toString());
        }
        catch (DOMException e) {
            System.out.println("PerformanceLogger::updateXML DOM Error:" + e.toString());
        }
    }

    private static void updateXMLFileAtStop(ComponentData cd, StartData td) {
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(cd.XMLFile), "UTF8"));
            cd.doc.getDocumentElement();
            Element task = td.node;
            Long ems = new Long(td.stopTime - td.startTime);
            Long sms = new Long(td.startTime);
            Long tms = new Long(td.stopTime);
            String normalizedFactor = "invalid";
            if (samplingTime > 0L) {
                Long sam = new Long(samplingTime);
                Double val = new Double(ems.doubleValue() / sam.doubleValue());
                normalizedFactor = val.toString();
            }
            task.setAttribute("ElapsedTime", ems.toString());
            task.setAttribute("NormalizedFactor", normalizedFactor);
            task.setAttribute("StartTime", sms.toString());
            task.setAttribute("StopTime", tms.toString());
            task.setAttribute("StartAt", td.startMethod);
            task.setAttribute("StartThread", td.startThread);
            task.setAttribute("StopAt", td.stopMethod);
            task.setAttribute("StopThread", td.stopThread);
            try {
                DOMSource source = new DOMSource(cd.doc);
                StreamResult result = new StreamResult(writer);
                Transformer t = TransformerFactory.newInstance().newTransformer();
                t.setOutputProperty("indent", "yes");
                t.transform(source, result);
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
            }
            catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            }
            catch (TransformerException transformerException) {}
        }
        catch (IOException e) {
            System.out.println("PerformanceLogger::updateXMLFileAtStop IO Error:" + e.toString());
        }
        catch (DOMException e) {
            System.out.println("PerformanceLogger::updateXMLFileAtStop DOM Error:" + e.toString());
        }
    }

    public static String getCurrentProductInfo(int req, String comp_id) {
        ComponentData cd = (ComponentData)perfLogRegistry.get(comp_id);
        if (cd == null) {
            System.out.println("PerformanceLogger::getCurrentProductInfo invalid comp_id");
            return null;
        }
        if (req == 2) {
            return cd.feature;
        }
        if (req == 3) {
            return cd.version;
        }
        return null;
    }

    public static String getXMLFileName(String comp_id) {
        ComponentData cd = (ComponentData)perfLogRegistry.get(comp_id);
        return cd.XMLFile.getAbsolutePath();
    }

    private static String getMethodName(boolean parsed) {
        String methodPath = null;
        Throwable e = new Throwable();
        StringWriter strwriter = new StringWriter(100);
        e.printStackTrace(new PrintWriter(strwriter));
        String stack = strwriter.toString();
        StringTokenizer tokenizer = new StringTokenizer(stack, "\r\n");
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            methodPath = tokenizer.nextToken();
            if (methodPath.indexOf("java.lang.Throwable") == -1 && methodPath.indexOf("logging.performance.PerformanceLogger") == -1) break;
            ++i;
        }
        methodPath = methodPath.substring(4);
        if (parsed) {
            try {
                i = methodPath.indexOf(40);
                if (i != -1) {
                    methodPath = methodPath.substring(0, i);
                }
                i = methodPath.lastIndexOf(46);
                String methodName = methodPath.substring(i + 1);
                String className = methodPath.substring(0, i);
                if ((i = className.lastIndexOf(46)) != -1) {
                    className = className.substring(i + 1);
                }
                methodPath = String.valueOf(className) + "." + methodName;
            }
            catch (IndexOutOfBoundsException ex) {
                System.out.println("PerformanceLogger:getMethodName exception" + ex.toString());
            }
        }
        return methodPath;
    }

    public static void listSystemProfile() {
        System.getProperty("java.version");
        System.out.println("java version : " + System.getProperty("java.version"));
        System.getProperty("java.vm.version");
        System.getProperty("java.class.version");
        System.getProperty("java.class.path");
        System.getProperty("java.library.path");
        System.getProperty("os.name");
        System.out.println("OS name : " + System.getProperty("os.name"));
        System.getProperty("os.version");
        System.out.println("OS version : " + System.getProperty("os.version"));
        System.getProperty("user.dir");
        System.out.println("working dir : " + System.getProperty("user.dir"));
        System.getProperty("home.dir");
        System.out.println("home dir : " + System.getProperty("home.dir"));
    }

    public static void main(String[] args) {
        int i = 0;
        if (PerformanceLogger.isPerformanceLoggingEnabled()) {
            PerformanceLogger.start();
        }
        i = 0;
        while (i < 1000000) {
            ++i;
        }
        if (PerformanceLogger.isPerformanceLoggingEnabled()) {
            PerformanceLogger.stop();
        }
        PerformanceLogger.enablePerformanceLogging(true);
        String key = PerformanceLogger.register("", "WDSC", "5120");
        key = PerformanceLogger.register("RSE", "WDSC", "5120");
        PerformanceLogger.deRegister("XXX");
        System.out.println("Product info : " + PerformanceLogger.getCurrentProductInfo(2, key) + " " + PerformanceLogger.getCurrentProductInfo(3, key));
        PerformanceLogger.start(key, "NOT_NESTED_1");
        i = 0;
        while (i < 1000000) {
            ++i;
        }
        PerformanceLogger.stop(key);
        PerformanceLogger.start(key, "NESTED_ONE");
        i = 0;
        while (i < 500) {
            ++i;
        }
        PerformanceLogger.start(key, "NESTED_ONE_CHILD");
        i = 0;
        while (i < 300) {
            ++i;
        }
        PerformanceLogger.stop(key);
        PerformanceLogger.stop(key);
        PerformanceLogger.start(key, "NOT_NESTED_2");
        i = 0;
        while (i < 2000000) {
            ++i;
        }
        PerformanceLogger.stop(key);
        PerformanceLogger.start(key, "NESTED_THREE");
        i = 0;
        while (i < 300) {
            ++i;
        }
        PerformanceLogger.start(key, "NESTED_TWO_CHILD1");
        PerformanceLogger.start(key, "NESTED_TWO_CHILD2");
        i = 0;
        while (i < 4000) {
            ++i;
        }
        PerformanceLogger.start(key, "NESTED_TWO_CHILD3");
        i = 0;
        while (i < 6000) {
            ++i;
        }
        PerformanceLogger.stop(key);
        PerformanceLogger.stop(key);
        PerformanceLogger.stop(key);
        PerformanceLogger.stop(key);
        PerformanceLogger.start("ABC");
        PerformanceLogger.start(key);
        i = 0;
        while (i < 3000000) {
            ++i;
        }
        PerformanceLogger.stop(key);
        key = PerformanceLogger.register(key);
        PerformanceLogger.deRegister(key);
        key = PerformanceLogger.register(key);
        String cfr_ignored_0 = "i = " + i;
    }

    static class StartData {
        long startTime = -1L;
        long stopTime = -1L;
        String userID = null;
        String startThread = null;
        String startMethod = null;
        String stopThread = null;
        String stopMethod = null;
        Element node = null;

        StartData() {
        }
    }

    class ComponentData {
        String component = null;
        String timeStamp = null;
        String feature = null;
        String version = null;
        String XMLFileID = null;
        File XMLFile = null;
        Document doc = null;
        Stack taskStack = new Stack();

        ComponentData(String comp_id) {
            this.component = comp_id;
        }
    }
}

