/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.files.core.subsystems;

import java.util.Vector;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.core.subsystems.SubSystemConfiguration;
import org.eclipse.rse.filters.ISystemFilter;
import org.eclipse.rse.filters.ISystemFilterContainer;
import org.eclipse.rse.filters.ISystemFilterPool;
import org.eclipse.rse.filters.ISystemFilterPoolManager;
import org.eclipse.rse.model.IHost;
import org.eclipse.rse.subsystems.files.core.SystemFileResources;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileFilterString;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystemConfiguration;
import org.eclipse.rse.subsystems.files.core.util.ValidatorFileFilterString;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.ValidatorFileName;
import org.eclipse.rse.ui.validators.ValidatorFolderName;
import org.eclipse.rse.ui.validators.ValidatorPathName;
import org.eclipse.rse.ui.wizards.ISystemNewConnectionWizardPage;

public abstract class RemoteFileSubSystemConfiguration
extends SubSystemConfiguration
implements IRemoteFileSubSystemConfiguration,
ISubSystemConfiguration {
    protected boolean unixStyle = false;
    protected String translatedType;
    static /* synthetic */ Class class$0;

    protected void setIsUnixStyle(boolean isUnixStyle) {
        this.unixStyle = isUnixStyle;
    }

    public boolean isUnixStyle() {
        return this.unixStyle;
    }

    public boolean isCaseSensitive() {
        return this.isUnixStyle();
    }

    public boolean supportsTargets() {
        return true;
    }

    public abstract boolean supportsServerLaunchProperties(IHost var1);

    public boolean supportsEnvironmentVariablesPropertyPage() {
        return true;
    }

    public boolean supportsSearch() {
        return true;
    }

    public ISystemValidator getPathValidator() {
        return new ValidatorPathName();
    }

    public ISystemValidator getFileFilterStringValidator() {
        return new ValidatorFileFilterString(this);
    }

    public ValidatorFileName getFileNameValidator() {
        return new ValidatorFileName();
    }

    public ValidatorFolderName getFolderNameValidator() {
        return new ValidatorFolderName();
    }

    public String getSeparator() {
        return this.unixStyle ? "/" : "\\";
    }

    public char getSeparatorChar() {
        return this.unixStyle ? (char)'/' : '\\';
    }

    public String getPathSeparator() {
        return this.unixStyle ? ":" : ";";
    }

    public char getPathSeparatorChar() {
        return this.unixStyle ? (char)':' : ';';
    }

    public String getLineSeparator() {
        if (this.isUnixStyle()) {
            return "\n";
        }
        return "\r\n";
    }

    public boolean supportsUserId() {
        return true;
    }

    public boolean supportsSubSystemConnect() {
        return true;
    }

    public boolean isPortEditable() {
        return true;
    }

    public boolean supportsCommands() {
        return false;
    }

    public boolean supportsProperties() {
        return false;
    }

    public boolean supportsFilters() {
        return true;
    }

    public boolean supportsDropInFilters() {
        return true;
    }

    public boolean providesCustomDropInFilters() {
        return true;
    }

    public boolean supportsNestedFilters() {
        return this.supportsFilters();
    }

    public boolean supportsUserDefinedActions() {
        return true;
    }

    public boolean supportsFileTypes() {
        return true;
    }

    public boolean supportsCompileActions() {
        return false;
    }

    protected ISystemFilterPool createDefaultFilterPool(ISystemFilterPoolManager mgr) {
        ISystemFilterPool pool = null;
        try {
            pool = mgr.createSystemFilterPool(RemoteFileSubSystemConfiguration.getDefaultFilterPoolName((String)mgr.getName(), (String)this.getId()), true);
            if (this.isUserPrivateProfile(mgr)) {
                Vector<String> filterStrings = new Vector<String>();
                filterStrings = new Vector();
                RemoteFileFilterString myHomeFilterString = new RemoteFileFilterString(this);
                myHomeFilterString.setPath(this.getSeparator());
                filterStrings.add("./*");
                ISystemFilter filter = mgr.createSystemFilter((ISystemFilterContainer)pool, SystemFileResources.RESID_FILTER_MYHOME, filterStrings);
                filter.setNonChangable(true);
                filter.setSingleFilterStringOnly(true);
                String name = null;
                String path = null;
                if (mgr.getName().equals("Team")) {
                    path = "/home";
                    name = SystemFileResources.RESID_FILTER_HOME;
                } else {
                    path = "/home";
                    name = SystemFileResources.RESID_FILTER_USERHOME;
                }
                filterStrings.clear();
                RemoteFileFilterString homeFilterString = new RemoteFileFilterString(this);
                homeFilterString.setPath(path);
                filterStrings.add(homeFilterString.toString());
                mgr.createSystemFilter((ISystemFilterContainer)pool, name, filterStrings);
                filterStrings = new Vector();
                RemoteFileFilterString rootFilesFilterString = new RemoteFileFilterString(this);
                rootFilesFilterString.setPath(this.getSeparator());
                filterStrings.add(rootFilesFilterString.toString());
                mgr.createSystemFilter((ISystemFilterContainer)pool, SystemFileResources.RESID_FILTER_ROOTFILES, filterStrings);
            }
        }
        catch (Exception exc) {
            SystemBasePlugin.logError((String)"Error creating default filter pool", (Throwable)exc);
        }
        return pool;
    }

    public String getTranslatedFilterTypeProperty(ISystemFilter selectedFilter) {
        if (this.translatedType == null) {
            this.translatedType = SystemFileResources.RESID_PROPERTY_FILE_FILTER_VALUE;
        }
        return this.translatedType;
    }

    public ISubSystem createSubSystemInternal(IHost conn) {
        return null;
    }

    protected void initializeSubSystem(ISubSystem ss, ISystemNewConnectionWizardPage[] yourNewConnectionWizardPages) {
        super.initializeSubSystem(ss, yourNewConnectionWizardPages);
    }

    public String getEditorProfileID() {
        return "universal";
    }

    public boolean isFactoryFor(Class subSystemType) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        boolean isFor = clazz.equals(subSystemType);
        return isFor;
    }
}

