/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui;

import java.util.Vector;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.files.ui.actions.SystemSelectFileTypesAction;
import org.eclipse.rse.files.ui.widgets.SystemFileWidgetHelpers;
import org.eclipse.rse.files.ui.widgets.SystemRemoteFolderCombo;
import org.eclipse.rse.filters.ISystemFilter;
import org.eclipse.rse.filters.ISystemFilterPoolManagerProvider;
import org.eclipse.rse.filters.ISystemFilterPoolReferenceManagerProvider;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.subsystems.files.core.SystemFileResources;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileFilterString;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystemConfiguration;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFileSubSystemConfiguration;
import org.eclipse.rse.subsystems.files.core.util.ValidatorFileFilterString;
import org.eclipse.rse.ui.ISystemMessages;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.actions.SystemTestFilterStringAction;
import org.eclipse.rse.ui.filters.SystemFilterStringEditPane;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.ValidatorPathName;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SystemFileFilterStringEditPane
extends SystemFilterStringEditPane
implements ISystemMessages {
    protected Button filesOnlyCheckBox;
    protected Button subsetByFileNameRadioButton;
    protected Button subsetByFileTypesRadioButton;
    protected Button selectTypesButton;
    protected Label labelFile;
    protected Label labelTypes;
    protected Text textFile;
    protected Text textTypes;
    protected SystemRemoteFolderCombo folderCombo;
    protected int filterFileLength = 256;
    protected int filterPathLength = 256;
    protected ISystemValidator pathValidator = new ValidatorPathName();
    protected ISystemValidator fileValidator;
    protected boolean caseSensitive = false;
    protected String[] inputFilterStrings;
    protected boolean noValidation = false;
    protected boolean callerInstanceOfWizardPage;
    protected boolean callerInstanceOfSystemPromptDialog;
    protected boolean skipUniquenessChecking;
    protected boolean calledFromVerify;
    protected boolean dontStealFocus;
    protected RemoteFileSubSystemConfiguration inputSubsystemFactory = null;
    protected SystemTestFilterStringAction testAction = null;
    protected SystemSelectFileTypesAction typesAction = null;

    public SystemFileFilterStringEditPane(Shell shell) {
        super(shell);
    }

    public void setSystemFilterPoolReferenceManagerProvider(ISystemFilterPoolReferenceManagerProvider provider) {
        super.setSystemFilterPoolReferenceManagerProvider(provider);
        if (provider != null) {
            this.caseSensitive = ((ISubSystem)provider).getSubSystemConfiguration().isCaseSensitive();
        }
    }

    public void setSystemFilterPoolManagerProvider(ISystemFilterPoolManagerProvider provider) {
        super.setSystemFilterPoolManagerProvider(provider);
        if (provider != null) {
            this.caseSensitive = ((ISubSystemConfiguration)provider).isCaseSensitive();
        }
    }

    public void setFilterFileLength(int max) {
        this.filterFileLength = max;
        if (this.textFile != null) {
            this.textFile.setTextLimit(max);
        }
    }

    public void setFilterPathLength(int max) {
        this.filterPathLength = max;
        if (this.folderCombo != null) {
            this.folderCombo.setTextLimit(max);
        }
    }

    public void setExistingStrings(String[] existingStrings, boolean caseSensitive) {
        this.inputFilterStrings = existingStrings;
        this.caseSensitive = caseSensitive;
    }

    public Control createContents(Composite parent) {
        int gridColumns = 2;
        Composite composite_prompts = SystemWidgetHelpers.createComposite((Composite)parent, (int)gridColumns);
        String historyKey = null;
        historyKey = this.refProvider != null ? String.valueOf(((ISubSystem)this.refProvider).getSubSystemConfiguration().getId()) + ".filterStringDialog" : "files.filterStringDialog";
        boolean readonly = false;
        this.folderCombo = SystemFileWidgetHelpers.createFolderCombo(composite_prompts, null, gridColumns, historyKey, readonly);
        this.folderCombo.setShowNewConnectionPrompt(false);
        SystemWidgetHelpers.setHelp((Control)this.folderCombo, (String)"org.eclipse.rse.ui.ffsd0001");
        SystemWidgetHelpers.createLabel((Composite)composite_prompts, (String)" ", (int)gridColumns);
        this.subsetByFileNameRadioButton = SystemWidgetHelpers.createRadioButton((Composite)composite_prompts, null, (String)SystemFileResources.RESID_FILEFILTERSTRING_BYFILENAME_LABEL, (String)SystemFileResources.RESID_FILEFILTERSTRING_BYFILENAME_TOOLTIP);
        SystemWidgetHelpers.setHelp((Control)this.subsetByFileNameRadioButton, (String)"org.eclipse.rse.ui.ffsd0002");
        this.updateGridData((Control)this.subsetByFileNameRadioButton, gridColumns);
        String indent = "       ";
        String temp = SystemWidgetHelpers.appendColon((String)SystemFileResources.RESID_FILEFILTERSTRING_FILE_LABEL);
        this.labelFile = SystemWidgetHelpers.createLabel((Composite)composite_prompts, (String)(String.valueOf(indent) + temp));
        this.labelFile.setToolTipText(SystemFileResources.RESID_FILEFILTERSTRING_FILE_TOOLTIP);
        this.textFile = SystemWidgetHelpers.createTextField((Composite)composite_prompts, null);
        this.textFile.setToolTipText(SystemFileResources.RESID_FILEFILTERSTRING_FILE_TOOLTIP);
        SystemWidgetHelpers.setHelp((Control)this.textFile, (String)"org.eclipse.rse.ui.ffsd0003");
        this.updateGridData((Control)this.textFile, gridColumns - 1);
        this.textFile.setText("*");
        this.subsetByFileTypesRadioButton = SystemWidgetHelpers.createRadioButton((Composite)composite_prompts, null, (String)SystemFileResources.RESID_FILEFILTERSTRING_BYFILETYPES_LABEL, (String)SystemFileResources.RESID_FILEFILTERSTRING_BYFILETYPES_TOOLTIP);
        SystemWidgetHelpers.setHelp((Control)this.subsetByFileTypesRadioButton, (String)"org.eclipse.rse.ui.ffsd0004");
        this.updateGridData((Control)this.subsetByFileTypesRadioButton, gridColumns);
        Composite typesGroup = SystemWidgetHelpers.createComposite((Composite)composite_prompts, (int)3);
        SystemWidgetHelpers.setHelp((Control)typesGroup, (String)"org.eclipse.rse.ui.ffsd0005");
        GridLayout layout = (GridLayout)typesGroup.getLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.updateGridData((Control)typesGroup, gridColumns);
        temp = SystemWidgetHelpers.appendColon((String)SystemFileResources.RESID_FILEFILTERSTRING_TYPES_LABEL);
        this.labelTypes = SystemWidgetHelpers.createLabel((Composite)typesGroup, (String)(String.valueOf(indent) + temp));
        this.labelTypes.setToolTipText(SystemFileResources.RESID_FILEFILTERSTRING_TYPES_TOOLTIP);
        this.textTypes = SystemWidgetHelpers.createReadonlyTextField((Composite)typesGroup);
        this.textTypes.setToolTipText(SystemFileResources.RESID_FILEFILTERSTRING_TYPES_TOOLTIP);
        this.updateGridData((Control)this.textTypes, 1);
        this.selectTypesButton = SystemWidgetHelpers.createPushButton((Composite)typesGroup, null, (String)SystemFileResources.RESID_FILEFILTERSTRING_SELECTTYPES_LABEL, (String)SystemFileResources.RESID_FILEFILTERSTRING_SELECTTYPES_TOOLTIP);
        GridData data = (GridData)this.selectTypesButton.getLayoutData();
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 4;
        SystemWidgetHelpers.createLabel((Composite)composite_prompts, (String)" ", (int)gridColumns);
        this.filesOnlyCheckBox = SystemWidgetHelpers.createCheckBox((Composite)composite_prompts, (int)gridColumns, null, (String)SystemFileResources.RESID_FILEFILTERSTRING_INCFILESONLY_LABEL, (String)SystemFileResources.RESID_FILEFILTERSTRING_INCFILESONLY_TOOLTIP);
        SystemWidgetHelpers.setHelp((Control)this.filesOnlyCheckBox, (String)"org.eclipse.rse.ui.ffsd0006");
        this.folderCombo.setFocus();
        if (this.refProvider != null) {
            this.inputSubsystemFactory = (RemoteFileSubSystemConfiguration)((ISubSystem)this.refProvider).getSubSystemConfiguration();
        } else if (this.provider != null) {
            this.inputSubsystemFactory = (RemoteFileSubSystemConfiguration)this.provider;
        }
        this.pathValidator = this.inputSubsystemFactory.getPathValidator();
        this.fileValidator = this.inputSubsystemFactory.getFileFilterStringValidator();
        if (this.refProvider != null) {
            this.folderCombo.setSystemConnection(((ISubSystem)this.refProvider).getHost());
        } else if (this.inputSubsystemFactory != null) {
            this.folderCombo.setSystemTypes(this.inputSubsystemFactory.getSystemTypes());
        }
        this.folderCombo.setSubSystem((IRemoteFileSubSystem)this.refProvider);
        this.folderCombo.setTextLimit(this.filterPathLength);
        this.textFile.setTextLimit(this.filterFileLength);
        this.resetFields();
        this.doInitializeFields();
        this.folderCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemFileFilterStringEditPane.this.validateFolderInput();
            }
        });
        this.textFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemFileFilterStringEditPane.this.validateFileInput();
            }
        });
        this.subsetByFileNameRadioButton.addSelectionListener((SelectionListener)this);
        this.subsetByFileTypesRadioButton.addSelectionListener((SelectionListener)this);
        this.selectTypesButton.addSelectionListener((SelectionListener)this);
        this.filesOnlyCheckBox.addSelectionListener((SelectionListener)this);
        return composite_prompts;
    }

    private void updateGridData(Control widget, int gridColumns) {
        GridData data = (GridData)widget.getLayoutData();
        data.horizontalSpan = gridColumns;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
    }

    public Control getInitialFocusControl() {
        return this.folderCombo.getCombo();
    }

    protected void doInitializeFields() {
        if (this.folderCombo == null) {
            return;
        }
        if (this.inputFilterString != null) {
            RemoteFileFilterString rffs = new RemoteFileFilterString((IRemoteFileSubSystemConfiguration)this.inputSubsystemFactory, this.inputFilterString);
            String defaultPath = rffs.getPath();
            this.folderCombo.setText(defaultPath == null ? "" : defaultPath);
            String defaultFile = rffs.getFile();
            this.textFile.setText(defaultFile == null ? "" : defaultFile);
            String defaultTypes = rffs.getTypesAsString();
            this.textTypes.setText(defaultTypes == null ? "" : defaultTypes);
            boolean defaultIncludeFilesOnly = rffs.getShowFiles() && !rffs.getShowSubDirs();
            boolean defaultSubsetByFileName = !rffs.getFilterByTypes();
            this.subsetByFileNameRadioButton.setSelection(defaultSubsetByFileName);
            this.subsetByFileTypesRadioButton.setSelection(!defaultSubsetByFileName);
            this.filesOnlyCheckBox.setSelection(defaultIncludeFilesOnly);
            this.enableFields(defaultSubsetByFileName);
        }
    }

    protected void resetFields() {
        if (this.folderCombo == null) {
            return;
        }
        this.folderCombo.setText("");
        this.textFile.setText("*");
        this.textTypes.setText("");
        this.subsetByFileNameRadioButton.setSelection(true);
        this.subsetByFileTypesRadioButton.setSelection(false);
        this.filesOnlyCheckBox.setSelection(false);
        this.enableFields(true);
    }

    protected boolean areFieldsComplete() {
        if (this.folderCombo == null) {
            return false;
        }
        boolean filterGiven = false;
        boolean subsetByFileName = false;
        String fileNameText = null;
        if (this.subsetByFileNameRadioButton.getSelection()) {
            fileNameText = this.textFile.getText().trim();
            filterGiven = fileNameText.length() > 0;
            subsetByFileName = true;
        } else {
            filterGiven = this.textTypes.getText().trim().length() > 0;
            subsetByFileName = false;
        }
        String folderText = this.folderCombo.getText().trim();
        if (this.inputSubsystemFactory != null) {
            if (this.inputSubsystemFactory.isUnixStyle()) {
                return folderText.length() > 0 && filterGiven;
            }
            if (folderText.length() == 0) {
                if (subsetByFileName) {
                    return fileNameText.equals("*");
                }
                return false;
            }
            return filterGiven;
        }
        return filterGiven;
    }

    private void enableFields(boolean byFileName) {
        this.labelTypes.setEnabled(!byFileName);
        this.selectTypesButton.setEnabled(!byFileName);
        this.labelFile.setEnabled(byFileName);
        this.textFile.setEnabled(byFileName);
    }

    protected SystemSelectFileTypesAction getSelectTypesAction() {
        if (this.typesAction == null) {
            this.typesAction = new SystemSelectFileTypesAction(this.selectTypesButton.getShell());
        }
        return this.typesAction;
    }

    public SystemMessage verify() {
        this.errorMessage = null;
        SystemRemoteFolderCombo controlInError = null;
        this.calledFromVerify = true;
        this.skipEventFiring = true;
        this.errorMessage = this.validateFolderInput();
        if (this.errorMessage != null) {
            controlInError = this.folderCombo;
        }
        if (this.errorMessage == null) {
            if (this.subsetByFileNameRadioButton.getSelection()) {
                this.errorMessage = this.validateFileInput();
            } else if (this.textTypes.getText().trim().length() == 0) {
                this.errorMessage = RSEUIPlugin.getPluginMessage((String)"RSEF1010");
            }
            controlInError = this.textFile;
        }
        if (this.errorMessage == null && this.inputFilterStrings != null && !this.skipUniquenessChecking) {
            boolean notUnique = false;
            String currFilterString = this.getFilterString();
            if (this.containsFilterString(currFilterString)) {
                notUnique = true;
            }
            if (notUnique) {
                this.errorMessage = RSEUIPlugin.getPluginMessage((String)"RSEF1007").makeSubstitution((Object)currFilterString);
            }
            controlInError = this.textFile;
        }
        if (this.errorMessage != null) {
            if (!this.dontStealFocus) {
                controlInError.setFocus();
            }
        } else {
            this.folderCombo.updateHistory(true);
        }
        this.calledFromVerify = false;
        this.skipEventFiring = false;
        this.fireChangeEvent(this.errorMessage);
        return this.errorMessage;
    }

    private boolean containsFilterString(String newString) {
        if (this.inputFilterStrings == null) {
            return false;
        }
        int idx = 0;
        while (idx < this.inputFilterStrings.length) {
            if (this.caseSensitive ? this.inputFilterStrings[idx].equals(newString) : this.inputFilterStrings[idx].equalsIgnoreCase(newString)) {
                return true;
            }
            ++idx;
        }
        return false;
    }

    protected SystemMessage validateFileInput() {
        if (this.noValidation || this.ignoreChanges) {
            return null;
        }
        this.errorMessage = null;
        if (this.fileValidator != null) {
            if (this.fileValidator instanceof ValidatorFileFilterString) {
                ValidatorFileFilterString fv = (ValidatorFileFilterString)this.fileValidator;
                fv.setIsFileName(true);
            }
            this.errorMessage = this.fileValidator.validate(this.textFile.getText().trim());
        }
        if (this.errorMessage == null) {
            this.errorMessage = this.validateFolderInput();
        } else {
            this.fireChangeEvent(this.errorMessage);
        }
        return this.errorMessage;
    }

    protected SystemMessage validateFolderInput() {
        if (this.noValidation || this.ignoreChanges) {
            return null;
        }
        this.errorMessage = null;
        String folderComboText = this.folderCombo.getText().trim();
        if (folderComboText.length() == 0) {
            if (this.inputSubsystemFactory != null) {
                if (this.inputSubsystemFactory.isUnixStyle()) {
                    this.errorMessage = this.pathValidator != null ? this.pathValidator.validate(folderComboText) : RSEUIPlugin.getPluginMessage((String)"RSEG1032");
                } else if (!this.subsetByFileNameRadioButton.getSelection() || !this.textFile.getText().trim().equals("*")) {
                    this.errorMessage = this.pathValidator != null ? this.pathValidator.validate(folderComboText) : RSEUIPlugin.getPluginMessage((String)"RSEG1032");
                }
            }
        } else if (this.pathValidator != null) {
            this.errorMessage = this.pathValidator.validate(folderComboText);
        }
        this.fireChangeEvent(this.errorMessage);
        return this.errorMessage;
    }

    public String getFilterString() {
        if (this.folderCombo == null) {
            return this.inputFilterString;
        }
        String folder = this.folderCombo.getText().trim();
        boolean subsetByFileName = this.subsetByFileNameRadioButton.getSelection();
        String file = null;
        file = subsetByFileName ? this.textFile.getText().trim() : this.textTypes.getText().trim();
        boolean showFilesOnly = this.filesOnlyCheckBox.getSelection();
        boolean showSubDirs = !showFilesOnly;
        boolean showFiles = true;
        RemoteFileFilterString rffs = new RemoteFileFilterString((IRemoteFileSubSystemConfiguration)this.inputSubsystemFactory, folder, file);
        rffs.setShowSubDirs(showSubDirs);
        rffs.setShowFiles(showFiles);
        return rffs.toString();
    }

    public void widgetSelected(SelectionEvent event) {
        Object src = event.getSource();
        this.dontStealFocus = true;
        if (src == this.filesOnlyCheckBox) {
            this.verify();
        } else if (src == this.subsetByFileNameRadioButton) {
            this.verify();
            this.enableFields(true);
            this.textFile.setFocus();
        } else if (src == this.subsetByFileTypesRadioButton) {
            this.verify();
            this.enableFields(false);
            this.selectTypesButton.setFocus();
        } else if (src == this.selectTypesButton) {
            SystemSelectFileTypesAction typesAction = this.getSelectTypesAction();
            String typesString = this.textTypes.getText().trim();
            typesAction.setTypes(typesString);
            typesAction.run();
            if (!typesAction.wasCancelled()) {
                typesString = typesAction.getTypesString();
                this.textTypes.setText(typesString);
                this.dontStealFocus = false;
                this.verify();
            }
        }
        this.dontStealFocus = false;
    }

    public void processTest(Shell shell) {
        if (this.refProvider == null) {
            SystemBasePlugin.logWarning((String)"Programming Error: input subsystem is not set");
            return;
        }
        this.skipUniquenessChecking = true;
        if (this.verify() == null) {
            SystemTestFilterStringAction testAction = new SystemTestFilterStringAction(this.getShell());
            testAction.setSubSystem((ISubSystem)this.refProvider);
            testAction.setFilterString(this.getFilterString());
            try {
                testAction.run();
            }
            catch (Exception exc) {
                SystemMessage msg = SystemMessageDialog.getExceptionMessage((Shell)this.getShell(), (Exception)exc);
                this.fireChangeEvent(msg);
            }
        }
        this.skipUniquenessChecking = false;
    }

    public static ValidatorFileFilterString getFileFilterStringValidator(ISystemFilter filter, String filterString) {
        Vector v = filter.getFilterStringsVector();
        if (filterString != null) {
            v.removeElement(filterString);
        }
        IRemoteFileSubSystemConfiguration ssFactory = (IRemoteFileSubSystemConfiguration)filter.getProvider();
        ValidatorFileFilterString validator = new ValidatorFileFilterString(ssFactory, v);
        return validator;
    }

    public static ValidatorFileFilterString getFileFilterStringValidator(IRemoteFileSubSystemConfiguration ssFactory) {
        return new ValidatorFileFilterString(ssFactory);
    }

    public boolean canSaveImplicitly() {
        if (this.newMode && this.inputSubsystemFactory != null && !this.inputSubsystemFactory.isUnixStyle()) {
            String folderComboText = this.folderCombo.getText().trim();
            if (folderComboText.length() == 0 && this.subsetByFileNameRadioButton.getSelection() && this.textFile.getText().trim().equals("*")) {
                return false;
            }
            return super.canSaveImplicitly();
        }
        return super.canSaveImplicitly();
    }
}

