/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.files.ui.FileResources;
import org.eclipse.rse.files.ui.resources.AddToArchiveDialog;
import org.eclipse.rse.model.IHost;
import org.eclipse.rse.model.ISystemRegistry;
import org.eclipse.rse.model.ISystemResourceChangeEvent;
import org.eclipse.rse.model.SystemResourceChangeEvent;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IVirtualRemoteFile;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.view.ISystemDragDropAdapter;
import org.eclipse.swt.widgets.Shell;

public class SystemAddToArchiveAction
extends SystemBaseAction {
    protected List _selected;
    protected Shell _parent;

    public SystemAddToArchiveAction(Shell parent) {
        super(FileResources.ACTION_ADDTOARCHIVE_LABEL, parent);
        this.setToolTipText(FileResources.ACTION_ADDTOARCHIVE_TOOLTIP);
        this._selected = new ArrayList();
        this._parent = parent;
        this.allowOnMultipleSelection(true);
        this.setHelp("org.eclipse.rse.ui.actn0122");
    }

    public SystemAddToArchiveAction(Shell parent, String label, String tooltip) {
        super(label, tooltip, parent);
        this._selected = new ArrayList();
        this._parent = parent;
        this.allowOnMultipleSelection(true);
        this.setHelp("org.eclipse.rse.ui.actn0122");
    }

    public void run() {
        boolean repeat = true;
        while (repeat) {
            boolean saveFullPathInfo;
            String relativeTo;
            IRemoteFileSubSystem destSS;
            IRemoteFile destinationArchive;
            block12: {
                SystemMessageDialog dlg;
                SystemMessage msg;
                IRemoteFile firstSelection = (IRemoteFile)this._selected.get(0);
                String title = FileResources.RESID_ADDTOARCHIVE_TITLE;
                String[] relativePaths = this.getRelativePaths();
                AddToArchiveDialog dialog = new AddToArchiveDialog(this.getShell(), title, relativePaths);
                if (dialog == null) {
                    return;
                }
                dialog.setNeedsProgressMonitor(false);
                dialog.setMessage(FileResources.RESID_ADDTOARCHIVE_PROMPT);
                dialog.setShowNewConnectionPrompt(true);
                dialog.setShowPropertySheet(true, false);
                dialog.setPreSelection(firstSelection);
                dialog.setBlockOnOpen(true);
                dialog.setShowLocationPrompt(true);
                dialog.setLocationPrompt(FileResources.RESID_ADDTOARCHIVE_LOCATION);
                dialog.setNameAndTypePrompt(FileResources.RESID_ADDTOARCHIVE_NAMEANDTYPE);
                dialog.open();
                boolean cancelled = false;
                if (dialog.wasCancelled()) {
                    cancelled = true;
                }
                destinationArchive = null;
                destSS = null;
                relativeTo = "";
                if (!cancelled) {
                    destinationArchive = (IRemoteFile)dialog.getOutputObject();
                    saveFullPathInfo = dialog.getSaveFullPathInfo();
                    if (saveFullPathInfo) {
                        relativeTo = dialog.getRelativePath();
                    }
                } else {
                    return;
                }
                destSS = destinationArchive.getParentRemoteFileSubSystem();
                if (destinationArchive == null) {
                    System.out.println("blah");
                }
                if (ArchiveHandlerManager.isVirtual((String)destinationArchive.getAbsolutePath())) {
                    msg = RSEUIPlugin.getPluginMessage((String)"RSEG1128");
                    dlg = new SystemMessageDialog(this.getShell(), msg);
                    dlg.open();
                    continue;
                }
                if (this.destinationInSource(destinationArchive)) {
                    msg = RSEUIPlugin.getPluginMessage((String)"RSEG1129");
                    dlg = new SystemMessageDialog(this.getShell(), msg);
                    dlg.open();
                    continue;
                }
                try {
                    if (destinationArchive.exists()) break block12;
                    destSS.createFile(destinationArchive);
                }
                catch (SystemMessageException e) {
                    dlg = new SystemMessageDialog(this.getShell(), e.getSystemMessage());
                    dlg.open();
                    continue;
                }
            }
            int i = 0;
            while (i < this._selected.size()) {
                IRemoteFile selection = (IRemoteFile)this._selected.get(i);
                this.addToArchive(selection, destinationArchive, saveFullPathInfo, relativeTo);
                ++i;
            }
            ISystemRegistry registry = RSEUIPlugin.getTheSystemRegistry();
            registry.fireRemoteResourceChangeEvent(1, (Object)destinationArchive, (Object)destinationArchive.getParentPath(), (ISubSystem)destSS, null, null);
            registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)destinationArchive, 82, (Object)destinationArchive.getParentPath()));
            repeat = false;
        }
    }

    public void addToArchive(IRemoteFile source, IRemoteFile destinationArchive, boolean saveFullPathInfo, String relativeTo) {
        String selectionPath;
        String destinationVirtualDirectory;
        int lastSlash;
        IRemoteFile destination = null;
        if (destinationArchive == null) {
            return;
        }
        if (!destinationArchive.getParentRemoteFileSubSystem().getParentRemoteFileSubSystemFactory().supportsArchiveManagement()) {
            return;
        }
        if (ArchiveHandlerManager.isVirtual((String)destinationArchive.getAbsolutePath())) {
            return;
        }
        if (this.destinationInSource(destinationArchive)) {
            return;
        }
        if (!destinationArchive.isArchive()) {
            return;
        }
        try {
            if (!destinationArchive.exists()) {
                destinationArchive.getParentRemoteFileSubSystem().createFile(destinationArchive);
            }
        }
        catch (SystemMessageException e) {
            SystemMessageDialog dlg = new SystemMessageDialog(this.getShell(), e.getSystemMessage());
            dlg.open();
            return;
        }
        if (saveFullPathInfo && (lastSlash = (destinationVirtualDirectory = (selectionPath = source.getAbsolutePath()).substring(relativeTo.length())).lastIndexOf(source.getSeparatorChar())) != -1) {
            destinationVirtualDirectory = destinationVirtualDirectory.substring(0, lastSlash);
            destinationVirtualDirectory = ArchiveHandlerManager.cleanUpVirtualPath((String)destinationVirtualDirectory);
            String newDestinationPath = String.valueOf(destinationArchive.getAbsolutePath()) + "#virtual#/" + destinationVirtualDirectory;
            try {
                destination = destinationArchive.getParentRemoteFileSubSystem().getRemoteFileObject(newDestinationPath);
                if (!destination.exists()) {
                    destinationArchive.getParentRemoteFileSubSystem().createFolders(destination);
                }
            }
            catch (SystemMessageException e) {
                SystemMessageDialog dlg = new SystemMessageDialog(this.getShell(), e.getSystemMessage());
                dlg.open();
                return;
            }
        }
        source.getParentRemoteFileSubSystem();
        IRunnableContext runnableContext = this.getRunnableContext(this._parent);
        CopyRunnable runnable = new CopyRunnable(source, destination);
        try {
            runnableContext.run(false, true, (IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
    }

    public boolean updateSelection(IStructuredSelection selection) {
        this._selected.clear();
        boolean enable = false;
        Iterator e = selection.iterator();
        while (e.hasNext()) {
            Object selected = e.next();
            if (selected != null && selected instanceof IRemoteFile) {
                IRemoteFile file = (IRemoteFile)selected;
                this._selected.add(file);
                enable = true;
                continue;
            }
            return false;
        }
        return enable;
    }

    protected IRunnableContext getRunnableContext(Shell shell) {
        IRunnableContext irc = RSEUIPlugin.getTheSystemRegistry().getRunnableContext();
        if (irc != null) {
            return irc;
        }
        return new ProgressMonitorDialog(shell);
    }

    protected boolean destinationInSource(IRemoteFile destination) {
        boolean insource = false;
        int i = 0;
        while (i < this._selected.size()) {
            if (this.isAncestorOf((IRemoteFile)this._selected.get(i), destination)) {
                insource = true;
                break;
            }
            ++i;
        }
        return insource;
    }

    protected boolean isAncestorOf(IRemoteFile ancestor, IRemoteFile descendant) {
        return ancestor.isAncestorOf(descendant);
    }

    protected String[] getRelativePaths() {
        IRemoteFile file = (IRemoteFile)this._selected.get(0);
        if (file instanceof IVirtualRemoteFile) {
            return null;
        }
        IHost con = file.getSystemConnection();
        String host = con.getHostName();
        String root = file.getRoot();
        String lowestCommonPath = file.getAbsolutePath();
        boolean caseSensitive = file.getParentRemoteFileSubSystem().isCaseSensitive();
        char separator = file.getSeparatorChar();
        int i = 1;
        while (i < this._selected.size()) {
            file = (IRemoteFile)this._selected.get(i);
            if (file instanceof IVirtualRemoteFile) {
                return null;
            }
            IHost nextCon = file.getSystemConnection();
            String nextHost = nextCon.getHostName();
            String nextRoot = file.getRoot();
            String nextPath = file.getAbsolutePath();
            if (!nextHost.equals(host) || !nextRoot.equals(root)) {
                return null;
            }
            lowestCommonPath = this.getLowestCommonPath(lowestCommonPath, nextPath, caseSensitive);
            ++i;
        }
        return this.getRelativePaths(lowestCommonPath, separator);
    }

    protected String[] getRelativePaths(String lcp, char separator) {
        Vector<String> relpaths = new Vector<String>();
        int i = lcp.length() - 1;
        while (i >= 0) {
            if (lcp.charAt(i) == separator) {
                relpaths.add(lcp.substring(0, i + 1));
            }
            --i;
        }
        String[] results = new String[relpaths.size()];
        int i2 = 0;
        while (i2 < relpaths.size()) {
            results[i2] = (String)relpaths.get(i2);
            ++i2;
        }
        return results;
    }

    protected String getLowestCommonPath(String str1, String str2, boolean caseSensitive) {
        int maxLength;
        int i = maxLength = Math.min(str1.length(), str2.length());
        while (i >= 0) {
            if (str1.regionMatches(!caseSensitive, 0, str2, 0, i)) {
                return str1.substring(0, i);
            }
            --i;
        }
        return "";
    }

    protected class CopyRunnable
    implements IRunnableWithProgress {
        private IRemoteFileSubSystem destSS;
        private IRemoteFileSubSystem sourceSS;
        private IRemoteFile selection;
        private IRemoteFile destination;
        static /* synthetic */ Class class$0;

        public CopyRunnable(IRemoteFile source, IRemoteFile dest) {
            this.destSS = dest.getParentRemoteFileSubSystem();
            this.sourceSS = source.getParentRemoteFileSubSystem();
            this.selection = source;
            this.destination = dest;
        }

        public void run(IProgressMonitor monitor) {
            try {
                IAdaptable iAdaptable = (IAdaptable)this.selection;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemDragDropAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                ISystemDragDropAdapter srcAdapter = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz);
                boolean sameSysType = this.sourceSS.getClass().equals(this.destSS.getClass());
                srcAdapter.doDrag((Object)this.selection, sameSysType, monitor);
                boolean sameSys = this.sourceSS == this.destSS;
                srcAdapter.doDrop((Object)this.selection, (Object)this.destination, sameSysType, sameSys, 0, monitor);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                System.out.println("SystemAddToArchiveAction: Could not drag and drop " + this.selection.getAbsolutePath());
            }
        }
    }
}

